/* +-------------------------------------------------------------------+ */
/* | Copyright 1992, 1993, David Koblas (koblas@netcom.com)            | */
/* | Copyright 1995, 1996 Torsten Martinsen (bullestock@dk-online.dk)  | */
/* |                                                                   | */
/* | Permission to use, copy, modify, and to distribute this software  | */
/* | and its documentation for any purpose is hereby granted without   | */
/* | fee, provided that the above copyright notice appear in all       | */
/* | copies and that both that copyright notice and this permission    | */
/* | notice appear in supporting documentation.  There is no           | */
/* | representations about the suitability of this software for        | */
/* | any purpose.  this software is provided "as is" without express   | */
/* | or implied warranty.                                              | */
/* |                                                                   | */
/* +-------------------------------------------------------------------+ */

/* $Id: operation.c,v 1.18 1997/08/13 19:45:28 torsten Exp $ 
##	operation = tool .  setOperation sets the current tool.
	This file is all about the tool ( main ) window. */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/cursorfont.h>
#include <xpm.h>
#include <stdio.h>
#ifndef NOSTDHDRS
#include <stdlib.h>
#include <unistd.h>
#endif

#include "xpaint.h"
#include "misc.h"
#include "menu.h"
#include "Paint.h"
#include "text.h"
#include "ops.h"
#include "graphic.h"
#include "image.h"
#include "operation.h"
#include "protocol.h"
#include "cutCopyPaste.h"

/* Pixmaps for toolbox icons */
#include "brushOp.xpm"
#include "eraseOp.xpm"
#include "sprayOp.xpm"
#include "pencilOp.xpm"
#include "dotPenOp.xpm"
#include "dynPenOp.xpm"
#include "lineOp.xpm"
#include "arcOp.xpm"
#include "fillOp.xpm"
#include "tfillOp.xpm"
#ifdef FEATURE_FRACTAL
#include "ffillOp.xpm"
#endif
#include "smearOp.xpm"
#include "textOp.xpm"
#include "selectOp.xpm"
#include "boxOp.xpm"
#include "rayOp.xpm"
#include "fboxOp.xpm"
#include "ovalOp.xpm"
#include "fovalOp.xpm"
#include "lassoOp.xpm"
#include "clineOp.xpm"
#include "polyOp.xpm"
#include "fpolyOp.xpm"
#include "freehandOp.xpm"
#include "ffreehandOp.xpm"
#include "selpolyOp.xpm"
#include "quillOp.xpm"                                        /*  2.51+quill  */

static void changeLineAction(Widget, XEvent *);
static void changeDynPencilAction(Widget, XEvent *);
static void changeSprayAction(Widget, XEvent *);
static void changeTFillAction(Widget, XEvent *);
static void changeBrushAction(Widget, XEvent *);
static void changeBrushParmAction(Widget, XEvent *);
static void changeFontAction(Widget, XEvent *);


static void 
setOperation(Widget w, XtPointer opArg, XtPointer junk2)
{
    OperationPair *op = (OperationPair *) opArg;
    OperationAddProc start;
    OperationRemoveProc stop;

    if (op == CurrentOp)
	return;

    start = op ? op->add : NULL;
    stop = CurrentOp ? CurrentOp->remove : NULL;

    GraphicSetOp((OperationRemoveProc) stop, (OperationAddProc) start);

    CurrentOp = op;        /* ##  one of many things preventing toolable regions   */
}

/*
**  The set line width callback pair
 */
static char currentLineWidth[10] = "1";

static void 
setWidth(Widget w, void *width)
{
    XtVaSetValues(w, XtNlineWidth, (int) width, NULL);
}

/* ## "GC" Graphic Context set function stuff, 
	by the dumbest means possible. These guys imitate the above,
	and are wrapped by a CB using GraphicAll, Like the above is. 

These get called via GraphicAll, which passes them   (cur->paint, data) 

static void 
setFunctionBlack(Widget w, void *funcVal)
{  XtVaSetValues(w, XtNfunction, funcVal, NULL); }

static void     
setFunctionAnd(Widget w, void *funcVal)           
{  XtVaSetValues(w, XtNfunction, 1, NULL); }        


static void     
setFunctionAndReverse(Widget w, void *funcVal)    
{  XtVaSetValues(w, XtNfunction, 2, NULL); }       

static void     
setFunctionCopy(Widget w, void *funcVal)             
{  XtVaSetValues(w, XtNfunction, 3, NULL); }            


static void       
setFunctionAndInverted(Widget w, void *funcVal)           
{  XtVaSetValues(w, XtNfunction, 4, NULL); }      

static void    
setFunctionXor(Widget w, void *funcVal)         
{  XtVaSetValues(w, XtNfunction, 6, NULL); }   

static void         
setFunctionOr(Widget w, void *funcVal)     
{  XtVaSetValues(w, XtNfunction, 7, NULL); }   

static void        
setFunctionNor(Widget w, void *funcVal)         
{  XtVaSetValues(w, XtNfunction, 8, NULL); }        

static void        
setFunctionEquiv(Widget w, void *funcVal)           
{  XtVaSetValues(w, XtNfunction, 9, NULL); }           

static void           
setFunctionInvert(Widget w, void *funcVal)              
{  XtVaSetValues(w, XtNfunction, 10, NULL); }     

static void      
setFunctionOrReverse(Widget w, void *funcVal)      
{  XtVaSetValues(w, XtNfunction, 11, NULL); }           

static void       
setFunctionCopyInverted(Widget w, void *funcVal)      
{  XtVaSetValues(w, XtNfunction, 12, NULL); }   

static void             
setFunctionOrInverted(Widget w, void *funcVal)                    
{  XtVaSetValues(w, XtNfunction, 13, NULL); }               

static void       
setFunctionNand(Widget w, void *funcVal)            
{  XtVaSetValues(w, XtNfunction, 14, NULL); }          

static void      
setFunctionWhite(Widget w, void *funcVal)       
{  XtVaSetValues(w, XtNfunction, 15, NULL); }         
*/

/* ## these guys all just set gcFunction, a global in Paint.h.
	Kinda spammy. should be one routine with an arg. */ 

static void
setFunctionCopyCB(Widget w, XtPointer junk, XtPointer junk2)              {
	gcFunction = 3;
	printf("global graphics function change to NORMAL COPY function");  
	printf(" %d\n", gcFunction); }

static void              
setFunctionBlackCB(Widget w, XtPointer junk, XtPointer junk2)        {    
	gcFunction = 0;
  	printf("global graphics function change to BLACK function");    
	printf(" %d\n", gcFunction); }   

static void        
setFunctionAndCB(Widget w, XtPointer junk, XtPointer junk2){    
        gcFunction = 1;        
	printf("global graphics function change to AND   function");   
        printf(" %d\n", gcFunction);               }            

static void 
setFunctionAndReverseCB(Widget w, XtPointer junk, XtPointer junk2){
	gcFunction = 2;
 	printf("global graphics function change to  AND-Reverse function");  
        printf(" %d\n", gcFunction);               } 


static void        
setFunctionAndInvertedCB(Widget w, XtPointer junk, XtPointer junk2)
{     
        gcFunction = 4;          
        printf("global graphics function change to AND-Inverted function");     
        printf(" %d\n", gcFunction);                               }

static void            
setFunctionXorCB(Widget w, XtPointer junk, XtPointer junk2)        {     
        gcFunction = 6;                    
        printf("global graphics function change to  XOR  function");       
        printf(", minterm %d\n", gcFunction);                      }   

static void          
setFunctionOrCB(Widget w, XtPointer junk, XtPointer junk2)        {     
        gcFunction = 7;          
        printf("global graphics function change to  OR  function");    
        printf(" %d\n", gcFunction);                               }   

static void          
setFunctionNorCB(Widget w, XtPointer junk, XtPointer junk2)        {      
        gcFunction = 8;         
        printf("global graphics function change to  NOR  function");         
        printf(", minterm %d\n", gcFunction);                       }    

static void      
setFunctionEquivCB(Widget w, XtPointer junk, XtPointer junk2)        {     
        gcFunction = 9;             
        printf("global graphics function change to  Equiv  function");        
        printf(", minterm %d\n", gcFunction);                        }      

static void         
setFunctionInvertCB(Widget w, XtPointer junk, XtPointer junk2)        {       
        gcFunction = 10;      
        printf("global graphics function change to  Invert  function");       
        printf(", minterm  %d\n", gcFunction);                        }     

static void     
setFunctionOrReverseCB(Widget w, XtPointer junk, XtPointer junk2)        {      
        gcFunction = 11;          
        printf("global graphics function change to  OR-Reverse  function");        
        printf(", minterm %d\n", gcFunction);                            }      

static void              
setFunctionCopyInvertedCB(Widget w, XtPointer junk, XtPointer junk2)
{         
        gcFunction = 12;
        printf("global graphics function change to  Copy-Inverted 
function");           
        printf(", minterm %d\n", gcFunction);
}       

static void         
setFunctionOrInvertedCB(Widget w, XtPointer junk, XtPointer junk2)        {      
        gcFunction = 13;
        printf("global graphics function change to OR-Inverted function");   
        printf(", minterm %d\n", gcFunction);          }

static void      
setFunctionNandCB(Widget w, XtPointer junk, XtPointer junk2)        {    
        gcFunction = 14;         
        printf("global graphics function change to NAND function");        
        printf(", minterm %d\n", gcFunction);           }                   

static void           
setFunctionWhiteCB(Widget w, XtPointer junk, XtPointer junk2)        {     
        gcFunction = 15;
        printf("global graphics function change to WHITE function");      
        printf(", minterm %d\n", gcFunction);            }





static void 
okLineCallback(Widget w, XtPointer junk, XtPointer infoArg)  {
    Arg arg;
    TextPromptInfo *info = (TextPromptInfo *) infoArg;
    int width = atoi(info->prompts[0].rstr);

    if (width < 1 || width > 1000) {
	Notice(w, "Invalid width, must be greater than zero and less than 1000");
	return;
    }
    sprintf(currentLineWidth, "%d", width);

    MenuCheckItem(w, True);

    if (width == 1)
	width = 0;
    GraphicAll(setWidth, (void *) width);
    XtSetArg(arg, XtNlineWidth, width);
    OperationAddArg(arg);
}

static void 
lineWidth(Widget w, int width)
{
    String lbl;
    XtVaGetValues(w, XtNlabel, &lbl, NULL);
    width = atoi(lbl);
    if (width <= 0) {
	static TextPromptInfo info;
	static struct textPromptInfo value[1];

	value[0].prompt = "Width:";
	value[0].str = currentLineWidth;
	value[0].len = 4;
	info.prompts = value;
	info.title = "Enter desired line width";
	info.nprompt = 1;

	TextPrompt(w, "linewidth", &info, okLineCallback, NULL, NULL);
    } else {
	Arg arg;

	if (width == 1)
	    width = 0;
	MenuCheckItem(w, True);
	GraphicAll(setWidth, (void *) width);

	XtSetArg(arg, XtNlineWidth, width);
	OperationAddArg(arg);
        printf("width of pencil family tools is now %d pixels\n", width); 
    }
}

/*
** Set brush parameters callbacks
 */
static char brushOpacityStr[10] = "2";
static void 
brushOkCallback(Widget w, XtPointer junk, XtPointer infoArg)
{
    TextPromptInfo *info = (TextPromptInfo *) infoArg;
    int opacity = atoi(info->prompts[0].rstr);

    if (opacity < 0 || opacity > 5) {
	Notice(w, "Opacity is an exponent between 0 and 5, ");
	return;
    }
    BrushSetParameters(opacity);

    sprintf(brushOpacityStr, "%d", opacity);
}

static void 
brushMenuCallback(Widget w)
{
    static TextPromptInfo info;
    static struct textPromptInfo value[1];

    value[0].prompt = "N, opaque/2^N+1, 0 thru 5 :";
    value[0].str = brushOpacityStr;
    value[0].len = 4;
    info.prompts = value;
    info.title = "0 is 50%, 5 is faintest";
    info.nprompt = 1;

    TextPrompt(w, "brushparams", &info, brushOkCallback, NULL, NULL);
}

/*
** Set dynamic pencil parameters callbacks
*/
static char dynPencilWidthStr[10] = "10";
static char dynPencilMassStr[10] = "600";
static char dynPencilDragStr[10] = "15";
static void dynPencilOkCallback(Widget w, XtPointer junk, XtPointer infoArg)
{
    void DynPencilSetParameters(float, float, float);
    TextPromptInfo *info = (TextPromptInfo*)infoArg;
    float width = atof(info->prompts[0].rstr);
    float mass = atof(info->prompts[1].rstr);
    float drag = atof(info->prompts[2].rstr);
    
    if (width < 1 || width > 100) {
	Notice(w, "Width should be between 1 and 100");
	return;
    }

    if (mass < 10 || mass > 2000) {
	Notice(w, "Mass should be between 10 and 2000");
	return;
    }

    if (drag < 0 || drag > 50) {
	Notice(w, "Drag should be between 0 and 50");
	return;
    }

    DynPencilSetParameters(width, mass, drag);
  
    sprintf(dynPencilWidthStr, "%0.4g", width);
    sprintf(dynPencilMassStr, "%0.4g", mass);
    sprintf(dynPencilDragStr, "%0.4g", drag);
}

static void dynPencilMenuCallback(Widget w)
{
    static TextPromptInfo info;
    static struct textPromptInfo value[3];

    value[0].prompt = "Width:";
    value[0].str = dynPencilWidthStr;
    value[0].len = 5;
    value[1].prompt = "Mass:";
    value[1].str = dynPencilMassStr;;
    value[1].len = 5;
    value[2].prompt = "Drag:";
    value[2].str = dynPencilDragStr;;
    value[2].len = 5;
    info.prompts = value;
    info.title = "Enter the desired dynamic pencil parameters";
    info.nprompt = 3;

    TextPrompt(w, "dynpencilparams", &info, dynPencilOkCallback, NULL, NULL);
}

/*
** Set spray parameters callbacks
 */
static char sprayDensityStr[10] = "10";
static char sprayRadiusStr[10] = "10";
static char sprayRateStr[10] = "10";
static void 
sprayOkCallback(Widget w, XtPointer junk, XtPointer infoArg)
{
    TextPromptInfo *info = (TextPromptInfo *) infoArg;
    int radius = atoi(info->prompts[0].rstr);
    int density = atoi(info->prompts[1].rstr);
    int rate = atoi(info->prompts[2].rstr);

    if (radius < 1 || radius > 100) {
	Notice(w, "Radius should be between 1 and 100");
	return;
    }
    if (density < 1 || density > 500) {
	Notice(w, "Density should be between 1 and 500");
	return;
    }
    if (rate < 1 || rate > 500) {
	Notice(w, "Rate should be between 1 and 500");
	return;
    }
    SpraySetParameters(radius, density, rate);

    sprintf(sprayDensityStr, "%d", density);
    sprintf(sprayRadiusStr, "%d", radius);
    sprintf(sprayRateStr, "%d", rate);
}

static void 
sprayMenuCallback(Widget w)
{
    static TextPromptInfo info;
    static struct textPromptInfo value[3];

    value[0].prompt = "Radius:";
    value[0].str = sprayRadiusStr;
    value[0].len = 4;
    value[1].prompt = "Density:";
    value[1].str = sprayDensityStr;
    value[1].len = 4;
    value[2].prompt = "Rate:";
    value[2].str = sprayRateStr;
    value[2].len = 4;
    info.prompts = value;
    info.title = "Enter the desired spray parameters";
    info.nprompt = 3;

    TextPrompt(w, "sprayparams", &info, sprayOkCallback, NULL, NULL);
}

/*
** Gradient fill set parameters callbacks
 */
static char tfillAngleStr[10] = "0";
static char tfillPadStr[10] = "0";
static char tfillHOffsetStr[10] = "0";
static char tfillVOffsetStr[10] = "0";
static char tfillStepsStr[10] = "250";

static void 
tfillOkCallback(Widget w, XtPointer junk, XtPointer infoArg)
{
    TextPromptInfo *info = (TextPromptInfo *) infoArg;
    int HOffset, VOffset, Pad, Angle, Steps;


    Angle = atoi(info->prompts[0].rstr);
    Pad = atoi(info->prompts[1].rstr);
    HOffset = atoi(info->prompts[2].rstr);
    VOffset = atoi(info->prompts[3].rstr);
    Steps = atoi(info->prompts[4].rstr);
    if (HOffset < -100 || HOffset > 100) {
	Notice(w, "Horizontal offset should be between -100 and 100 %");
	return;
    }
    if (VOffset < -100 || VOffset > 100) {
	Notice(w, "Vertical offset should be between -100 and 100 %");
	return;
    }
    if (Pad < -49 || Pad > 49) {
	Notice(w, "Pad should be between -49 and 49 %");
	return;
    }
    if (Angle < -360 || Angle > 360) {
	Notice(w, "Angle should be between -360 and 360 degrees");
	return;
    }
    if (Steps < 1 || Steps > 300) {
	Notice(w, "Number of steps should be between 1 and 300");
	return;
    }
    TfillSetParameters(VOffset/100.0, HOffset/100.0, Pad/100.0, Angle, Steps);

    sprintf(tfillVOffsetStr, "%3d", VOffset);
    sprintf(tfillHOffsetStr, "%3d", HOffset);
    sprintf(tfillPadStr, "%3d", Pad);
    sprintf(tfillAngleStr, "%3d", Angle);
    sprintf(tfillStepsStr, "%3d", Steps);
}

static void 
tfillMenuCallback(Widget w)
{
    static TextPromptInfo info;
    static struct textPromptInfo value[5];

    value[0].prompt = "Angle (degrees):";
    value[0].str = tfillAngleStr;
    value[0].len = 4;
    value[1].prompt = "Pad (%):";
    value[1].str = tfillPadStr;
    value[1].len = 4;
    value[2].prompt = "Horizontal offset (%):";
    value[2].str = tfillHOffsetStr;
    value[2].len = 4;
    value[3].prompt = "Vertical offset (%):";
    value[3].str = tfillVOffsetStr;
    value[3].len = 4;
    value[4].prompt = "Steps:";
    value[4].str = tfillStepsStr;
    value[4].len = 3;
    info.prompts = value;
    info.title = "Enter the desired gradient fill parameters";
    info.nprompt = 5;

    TextPrompt(w, "tfillparams", &info, tfillOkCallback, NULL, NULL);
}

/*
**  Font menu callbacks.
 */
static void 
fontSetCallback(Widget paint, void *info)
{
    XtVaSetValues(paint, XtNfont, (XFontStruct *) info, NULL);
    FontChanged(paint);
}
static void 
fontSet(Widget w, char *name)
{
    XFontStruct *info;
    Arg arg;

    if (name == NULL) {
	FontSelect(w, None);
    } else {
	if ((info = XLoadQueryFont(XtDisplay(GetShell(w)), name)) == NULL) {
	    XtVaSetValues(w, XtNsensitive, False, NULL);
	    Notice(w, "Unable to load requested font");
	    return;
	}
	GraphicAll(fontSetCallback, (void *) info);
	XtSetArg(arg, XtNfont, info);
	OperationAddArg(arg);
    }
    MenuCheckItem(w, True);
}

/*
**  Exit callback (simple)
 */
static void 
exitOkCallback(Widget w, XtPointer junk, XtPointer junk2)
{
#if 0
    XtDestroyWidget(GetToplevel(w));
    XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
    Global.timeToDie = True;
#else
    exit(0);
#endif
}
static void 
exitCancelCallback(Widget paint, XtPointer junk, XtPointer junk2)
{
}
static void 
exitPaintCheck(Widget paint, void *sumArg)
{
    int *sum = (int *) sumArg;
    Boolean flg;
    XtVaGetValues(paint, XtNdirty, &flg, NULL);
    *sum += flg ? 1 : 0;
}
static void 
exitPaint(Widget w, XtPointer junk, XtPointer junk2)
{
    int total = 0;

    GraphicAll(exitPaintCheck, (void *) &total);

    if (total == 0) {
	exitOkCallback(w, NULL, NULL);
	return;
    }
    AlertBox(w, "There are unsaved changes,\nare you sure you wish to quit?",
	     exitOkCallback, exitCancelCallback, NULL);
}

/*
**
 */
static void 
loadClipboardCB(Widget w, char *file, void *image)
{
    ClipboardSetImage(w, image);
}
static void 
loadClipboard(Widget w, XtPointer junk, XtPointer junk2)
{
    GetFileName(GetShell(w), 0, NULL, (XtCallbackProc) loadClipboardCB, NULL);
}


/*
**  Button popups        hook for quill callback?#############
 */
static void brushPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void erasePopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void fillPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void tfillPopupCB2(Widget w, XtPointer junk, XtPointer junk2);
#ifdef FEATURE_FRACTAL
static void ffillPopupCB2(Widget w, XtPointer junk, XtPointer junk2);
#endif
static void selectPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void dynPencilPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void selectShapePopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void sprayPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void ovalPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void boxPopupCB(Widget w, XtPointer junk, XtPointer junk2);
static void quillPopupCB(Widget w, int cbdata, XtPointer junk2);      /* ## */
/* ## we get the cbdata, a widget # and a 0 for XtPointer  ## */



#define GENERATE_HELP(name, hlpstr)				\
		static PaintMenuItem name [] = {		\
			MI_SEPERATOR(),				\
			MI_SIMPLECB("help", HelpDialog, hlpstr)	\
		};

static PaintMenuItem brushPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("opaque", MF_CHECKON | MF_GROUP1, brushPopupCB, 0),
    MI_FLAGCB("transparent", MF_CHECK | MF_GROUP1, brushPopupCB, 1),
    MI_SIMPLECB("select", BrushSelect, NULL),
    MI_SIMPLECB("opacity", changeBrushParmAction, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.brush"),
};
static PaintMenuItem erasePopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("original", MF_CHECKON, erasePopupCB, 0),
    MI_SIMPLECB("select", changeBrushAction, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.erase"),
};

static PaintMenuItem dynPencilPopup[] = 
{
    MI_SEPERATOR(),
    MI_FLAGCB("autofinish", MF_CHECK, dynPencilPopupCB, 0),
    MI_SIMPLECB("mass", changeDynPencilAction, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.dynpencil"),
};

static PaintMenuItem sprayPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("normal distribution", MF_CHECKON, sprayPopupCB, 0),
    MI_SIMPLECB("power", changeSprayAction, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.spray"),
};
                                        /*   we should have help at least....... */
static PaintMenuItem smearPopup[] =
{
    MI_SEPERATOR(),
    MI_SIMPLECB("select", BrushSelect, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.smear"),
};
                                                 /*   ... which would need this */      
GENERATE_HELP(pencilPopup, "toolbox.tools.pencil")
GENERATE_HELP(dotPencilPopup, "toolbox.tools.dotPencil")
GENERATE_HELP(linePopup, "toolbox.tools.line")
GENERATE_HELP(rayPopup, "toolbox.tools.ray")
GENERATE_HELP(arcPopup, "toolbox.tools.arc")
static PaintMenuItem fillPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("contiguous", MF_CHECKON | MF_GROUP1, fillPopupCB, 0),
    MI_FLAGCB("all of color clicked", MF_CHECK | MF_GROUP1, fillPopupCB, 1),
    MI_FLAGCB("all in color range", MF_CHECK | MF_GROUP1, fillPopupCB, 2),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.fill"),
};
static PaintMenuItem tfillPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("contiguous", MF_CHECKON | MF_GROUP1, fillPopupCB, 0),
    MI_FLAGCB("all of clicked color", MF_CHECK | MF_GROUP1, fillPopupCB, 1),
    MI_FLAGCB("all within variance", MF_CHECK | MF_GROUP1, fillPopupCB, 2),
    MI_SEPERATOR(),
    MI_FLAGCB("radial", MF_CHECKON | MF_GROUP2, tfillPopupCB2, TFILL_RADIAL),
    MI_FLAGCB("linear", MF_CHECK | MF_GROUP2, tfillPopupCB2, TFILL_LINEAR),
    MI_FLAGCB("conical", MF_CHECK | MF_GROUP2, tfillPopupCB2, TFILL_CONE),
    MI_FLAGCB("square", MF_CHECK | MF_GROUP2, tfillPopupCB2, TFILL_SQUARE),
    MI_SIMPLECB("parameters", changeTFillAction, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.tfill"),
};
#ifdef FEATURE_FRACTAL
static PaintMenuItem ffillPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("contiguous", MF_CHECKON | MF_GROUP1, fillPopupCB, 0),
    MI_FLAGCB("all of clicked color", MF_CHECK | MF_GROUP1, fillPopupCB, 1),
    MI_FLAGCB("all within variance", MF_CHECK | MF_GROUP1, fillPopupCB, 2),
    MI_SEPERATOR(),
    MI_FLAGCB("plasma", MF_CHECKON | MF_GROUP2, ffillPopupCB2, 0),
    MI_FLAGCB("clouds", MF_CHECK | MF_GROUP2, ffillPopupCB2, 1),
    MI_FLAGCB("landscape", MF_CHECK | MF_GROUP2, ffillPopupCB2, 2),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.ffill"),
};
#endif
static PaintMenuItem textPopup[] =
{
    MI_SEPERATOR(),
    MI_SIMPLECB("select", changeFontAction, NULL),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.text"),
};
GENERATE_HELP(polyPopup, "toolbox.tools.poly")
GENERATE_HELP(freehandPopup, "toolbox.tools.blob")
GENERATE_HELP(clinePopup, "toolbox.tools.cline")
static PaintMenuItem selectBPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("all", MF_CHECKON | MF_GROUP1, selectPopupCB, 0),
    MI_FLAGCB("not_color", MF_CHECK | MF_GROUP1, selectPopupCB, 1),
    MI_FLAGCB("only_color", MF_CHECK | MF_GROUP1, selectPopupCB, 2),
    MI_SEPERATOR(),
    MI_FLAGCB("rectangle", MF_CHECKON | MF_GROUP2, selectShapePopupCB, 0),
    MI_FLAGCB("ellipse", MF_CHECK | MF_GROUP2, selectShapePopupCB, 1),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.select"),
};
static PaintMenuItem lassoPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("all", MF_CHECKON | MF_GROUP1, selectPopupCB, 0),
    MI_FLAGCB("not_color", MF_CHECK | MF_GROUP1, selectPopupCB, 1),
    MI_FLAGCB("only_color", MF_CHECK | MF_GROUP1, selectPopupCB, 2),
    MI_SEPERATOR(),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.select"),
};
static PaintMenuItem selectAPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("shape", MF_CHECKON | MF_GROUP1, selectPopupCB, 0),
    MI_FLAGCB("not_color", MF_CHECK | MF_GROUP1, selectPopupCB, 1),
    MI_FLAGCB("only_color", MF_CHECK | MF_GROUP1, selectPopupCB, 2),
    MI_SEPERATOR(),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.select"),
};
static PaintMenuItem boxPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("pull from center", MF_CHECK, boxPopupCB, 0),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.box"),
};

static PaintMenuItem quillPopup[] =                        /* ## */
{
  MI_FLAGCB("vert",MF_CHECKON | MF_GROUP1,quillPopupCB,1),              	 /* ## */   
    MI_FLAGCB("60",MF_CHECKON | MF_GROUP1,quillPopupCB,2),
    MI_FLAGCB("45",MF_CHECKON | MF_GROUP1,quillPopupCB,3),              
    MI_FLAGCB("30",MF_CHECKON | MF_GROUP1,quillPopupCB,4),              
   MI_FLAGCB("horiz",MF_CHECKON | MF_GROUP1,quillPopupCB,5), 
   MI_FLAGCB("135",MF_CHECKON | MF_GROUP1,quillPopupCB,6),
   MI_FLAGCB("skippy",MF_CHECKON | MF_GROUP1,quillPopupCB,7),
 MI_SEPERATOR(),
 MI_FLAGCB("one pixel",MF_CHECKON | MF_GROUP2,quillPopupCB,8), 
 MI_FLAGCB("nib size 2",MF_CHECKON | MF_GROUP2,quillPopupCB,9),          
 MI_FLAGCB("         4",MF_CHECKON | MF_GROUP2,quillPopupCB,10),          
 MI_FLAGCB("         8",MF_CHECKON | MF_GROUP2,quillPopupCB,11),          
 MI_FLAGCB("         16",MF_CHECKON | MF_GROUP2,quillPopupCB,12),                                   
 MI_FLAGCB("         32",MF_CHECKON | MF_GROUP2,quillPopupCB,13),        
 MI_SIMPLECB("help", HelpDialog, "toolbox.tools.quill"), 

};

static PaintMenuItem fboxPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("pull from center", MF_CHECK, boxPopupCB, 0),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.box"),
};
static PaintMenuItem ovalPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("pull from center", MF_CHECK, ovalPopupCB, 0),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.oval"),
};
static PaintMenuItem fovalPopup[] =
{
    MI_SEPERATOR(),
    MI_FLAGCB("pull from center", MF_CHECK, ovalPopupCB, 1),
    MI_SIMPLECB("help", HelpDialog, "toolbox.tools.oval"),
};
								/* ## */
static void   /* get nib # or compute nibsize and update menu checkmark */
quillPopupCB(Widget w, int cbdata, XtPointer junk2)
{
int firstNibsizeCBnum = 8;
if(cbdata < firstNibsizeCBnum ){
	setNib(cbdata);        
	MenuCheckItem(quillPopup[cbdata-1].widget, True); 
				}
else{
	setNibsize(1 << (cbdata - firstNibsizeCBnum ));
	MenuCheckItem(quillPopup[cbdata].widget, True);
    }
}

static void 
brushPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    int nm = (int) junk;

    BrushSetMode(nm);
    MenuCheckItem(brushPopup[nm + 1].widget, True);
}

static void         /* ##  TODO   make the ovals default to pull-from-center */
ovalPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    Boolean m = !CircleGetStyle();

    CircleSetStyle(m);
    MenuCheckItem(ovalPopup[1].widget, m);
    MenuCheckItem(fovalPopup[1].widget, m);
}
static void 
boxPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    Boolean m = !BoxGetStyle();

    BoxSetStyle(m);
    MenuCheckItem(boxPopup[1].widget, m);
    MenuCheckItem(fboxPopup[1].widget, m);
}
static void 
fillPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    int nm = (int) junk;

    FillSetMode(nm);
    MenuCheckItem(w, True);
}
static void 
tfillPopupCB2(Widget w, XtPointer junk, XtPointer junk2)
{
    int nm = (int) junk;

    TFillSetMode(nm);
    MenuCheckItem(w, True);
}

#ifdef FEATURE_FRACTAL
static void 
ffillPopupCB2(Widget w, XtPointer junk, XtPointer junk2)
{
    int nm = (int) junk;

    FFillSetMode(nm);
    MenuCheckItem(w, True);
}

#endif
static void 
selectPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    int n = (int) junk;

    MenuCheckItem(selectAPopup[n + 1].widget, True);
    MenuCheckItem(selectBPopup[n + 1].widget, True);
    MenuCheckItem(lassoPopup[n + 1].widget, True);
    SelectSetCutMode(n);
}
static void 
selectShapePopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    int n = (int) junk;

    MenuCheckItem(selectBPopup[n + 1 + 4].widget, True);
    SelectSetShapeMode(n);
}

void 
OperationSelectCallAcross(int n)
{
    MenuCheckItem(selectAPopup[n + 1].widget, True);
    MenuCheckItem(selectBPopup[n + 1].widget, True);
    MenuCheckItem(lassoPopup[n + 1].widget, True);
}
static void
dynPencilPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    Boolean	m = !DynPencilGetFinish();

    DynPencilSetFinish(m);
    MenuCheckItem(w, m);
}
static void 
sprayPopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    Boolean m = !SprayGetStyle();

    SpraySetStyle(m);
    MenuCheckItem(w, m);
}
static void 
erasePopupCB(Widget w, XtPointer junk, XtPointer junk2)
{
    Boolean m = !EraseGetMode();

    EraseSetMode(m);
    MenuCheckItem(w, m);
}

/*
**  ## the following preprozzzezzor crap creates OperationPair items
of the add and remove functions for each tool. This gets put into 
iconlistitems for each tool and then put in the iconlist to follow.
 */

#define GENERATE_OP(name)				\
	static OperationPair  CONCAT(name,Op) = {	\
	  CONCAT(name,Add), CONCAT(name,Remove)		\
	};

GENERATE_OP(DotPencil)
GENERATE_OP(Pencil)
GENERATE_OP(DynPencil)
GENERATE_OP(Box)
GENERATE_OP(FBox)
GENERATE_OP(Line)
GENERATE_OP(Ray)
GENERATE_OP(Arc)
GENERATE_OP(Oval)
GENERATE_OP(FOval)
GENERATE_OP(Erase)
GENERATE_OP(Brush)
GENERATE_OP(Font)
GENERATE_OP(Smear)
GENERATE_OP(Spray)
GENERATE_OP(Poly)
GENERATE_OP(FPoly)
GENERATE_OP(Freehand)
GENERATE_OP(FFreehand)
GENERATE_OP(CLine)
GENERATE_OP(Fill)
GENERATE_OP(TFill)
GENERATE_OP(Quill)           /*   2.51 + quill */
#ifdef FEATURE_FRACTAL
GENERATE_OP(FFill)
#endif
GENERATE_OP(SelectBox)
GENERATE_OP(Lasso)
GENERATE_OP(SelectPoly)
#define	XPMMAP(name)	(char **) CONCAT(name,Op_xpm)
#define MENU(name)	XtNumber(CONCAT(name,Popup)), CONCAT(name,Popup)

typedef struct {
    char *name;
    char **xpmmap;
    OperationPair *data;
    char *translations;
    int nitems;
    PaintMenuItem *popupMenu;
    Pixmap icon;
} IconListItem;


/* ## this array determines the order of the tool icons in the tool box */
static Widget iconListWidget;
static IconListItem iconList[] =
{
   {"brush", XPMMAP(brush), &BrushOp,
     "<BtnDown>(2): changeBrush()", MENU(brush), None},
    {"erase", XPMMAP(erase), &EraseOp,
    "<BtnDown>(2): changeBrush()", MENU(erase), None},
    {"smear", XPMMAP(smear), &SmearOp,
     "<BtnDown>(2): changeBrush()", MENU(smear), None},         
    {"pencil", XPMMAP(pencil), &PencilOp,
     NULL, MENU(pencil), None},
    {"line", XPMMAP(line), &LineOp,
         NULL, MENU(line), None},               
    {"dotPencil", XPMMAP(dotPen), &DotPencilOp,
              NULL, MENU(dotPencil), None},                    
    {"ray", XPMMAP(ray), &RayOp,
     NULL, MENU(ray), None},
    {"arc", XPMMAP(arc), &ArcOp,
     NULL, MENU(arc), None},
    {"box", XPMMAP(box), &BoxOp,
     NULL, MENU(box), None},
    {"fBox", XPMMAP(fbox), &FBoxOp,
     NULL, MENU(fbox), None},
    {"oval", XPMMAP(oval), &OvalOp,
     NULL, MENU(oval), None},
    {"fOval", XPMMAP(foval), &FOvalOp,
     NULL, MENU(foval), None},
    {"polygon", XPMMAP(poly), &PolyOp,
     NULL, MENU(poly), None},
    {"fPolygon", XPMMAP(fpoly), &FPolyOp,
     NULL, MENU(poly), None},
    {"fFreehand", XPMMAP(ffreehand), &FFreehandOp,
     NULL, MENU(freehand), None},
    {"cLine", XPMMAP(cline), &CLineOp,           
              NULL, MENU(cline), None},
    {"freehand", XPMMAP(freehand), &FreehandOp,
       NULL, MENU(freehand), None},

    {"quill", XPMMAP(quill), &QuillOp,
     NULL, MENU(quill), None},       /* ##  change a NULL to menu(quill)*/
    {"selectBox", XPMMAP(select), &SelectBoxOp,
     NULL, MENU(selectB), None},
    {"lasso", XPMMAP(lasso), &LassoOp,
     NULL, MENU(poly), None},
    {"selectPoly", XPMMAP(selpoly), &SelectPolyOp,           

     NULL, MENU(lasso), None},
    {"spray", XPMMAP(spray), &SprayOp,
     "<BtnDown>(2): changeSpray()", MENU(spray), None},
    {"fill", XPMMAP(fill), &FillOp,
     NULL, MENU(fill), None},
    {"tfill", XPMMAP(tfill), &TFillOp,
     "<BtnDown>(2): changeTFillParms()", MENU(tfill), None},
#ifdef FEATURE_FRACTAL
    {"ffill", XPMMAP(ffill), &FFillOp,
     NULL, MENU(ffill), None},
#endif                                         
    {"text", XPMMAP(text), &FontOp,
     "<BtnDown>(2): changeFont()", MENU(text), None},                 
    {"dynpencil", XPMMAP(dynPen), &DynPencilOp, 	
     "<BtnDown>(2): changeDynPencil()", MENU(dynPencil), None},
};

void    /* ## this walks the above list and sets the matching item */ 
OperationSet(String names[], int num)
{
    IconListItem *match = NULL;
    int i, j;

    for (i = 0; i < XtNumber(iconList); i++) {
	for (j = 0; j < num; j++) {
	    if (strcmp(names[j], iconList[i].name) == 0) {
		if (match == NULL)
		    match = &iconList[i];
		if (CurrentOp == iconList[i].data)
		    return;
	    }
	}
    }
    if (match != NULL)
	XawToggleSetCurrent(iconListWidget, (XtPointer) match->name);
}

static PaintMenuItem lineMenu[] =
{
#if 0
    MI_FLAGCB("0", MF_CHECK | MF_GROUP1, lineWidth, NULL),
#endif
    MI_FLAGCB("1", MF_CHECK | MF_GROUP1, lineWidth, NULL),
    MI_FLAGCB("2", MF_CHECK | MF_GROUP1, lineWidth, NULL),
    MI_FLAGCB("4", MF_CHECK | MF_GROUP1, lineWidth, NULL),
    MI_FLAGCB("6", MF_CHECK | MF_GROUP1, lineWidth, NULL),
    MI_FLAGCB("8", MF_CHECK | MF_GROUP1, lineWidth, NULL),
#define LW_SELECT	5
    MI_FLAGCB("select", MF_CHECK | MF_GROUP1, lineWidth, NULL),
};

static PaintMenuItem fontMenu[] =
{
    MI_FLAGCB("fixed 12",  MF_CHECK | MF_GROUP1,  
            fontSet, "*-misc-fixed-medium-r-normal-*-*-120-*-*-c-*-iso8859-*"),
     MI_FLAGCB("Greek 18",   MF_CHECK | MF_GROUP1, 
            fontSet, "*-adobe-symbol-medium-r-normal-*-*-180-*-*-p-*-adobe-*"),
    MI_FLAGCB("Open Look Glyph",   MF_CHECK | MF_GROUP1,     
            fontSet, "*-sun-open look glyph----*-*-140-*-*-p-*-sunolglyph-*"),
    MI_FLAGCB("N.C.S. 24",   MF_CHECK | MF_GROUP1,         
            fontSet, "*-adobe-new century schoolbook-bold-r-normal-*-*-240-*-*-p-*-*"),
    MI_FLAGCB("Times 8", MF_CHECK | MF_GROUP1,
	      fontSet, "-*-times-medium-r-normal-*-*-80-*-*-p-*-*-*"),
    MI_FLAGCB("Times 18", MF_CHECK | MF_GROUP1,
	      fontSet, "-*-times-medium-r-normal-*-*-180-*-*-p-*-*-*"),
    MI_FLAGCB("Times Bold 12", MF_CHECK | MF_GROUP1,
	      fontSet, "-*-times-bold-r-normal-*-*-120-*-*-p-*-*-*"),
    MI_FLAGCB("Times Italic 12", MF_CHECK | MF_GROUP1,
	      fontSet, "-*-times-bold-i-normal-*-*-120-*-*-p-*-*-*"),
    MI_FLAGCB("Lucida 12", MF_CHECK | MF_GROUP1,
	      fontSet, "-*-lucida-medium-r-normal-*-*-120-*-*-p-*-*-*"),
    MI_FLAGCB("Helvetica 12", MF_CHECK | MF_GROUP1,
	    fontSet, "-*-helvetica-medium-r-normal-*-*-120-*-*-p-*-*-*"),
    MI_FLAGCB("X cursors", MF_CHECK | MF_GROUP1,
	      fontSet, "cursor"),
    MI_FLAGCB("xhextris", MF_CHECK | MF_GROUP1,
              fontSet, "xhextris"),              
    MI_FLAGCB("Courier 12", MF_CHECK | MF_GROUP1,
	      fontSet, "-*-courier-medium-r-normal-*-*-120-*-*-m-*-*-*"),
    MI_SEPERATOR(),
#define FM_SELECT	11
    MI_FLAGCB("select", MF_CHECK | MF_GROUP1, fontSet, NULL),
};

/* ## was commented-out OTHER menu */
static PaintMenuItem FnMenu[] =
{
    MI_SIMPLECB("NORMAL COPY",   setFunctionCopyCB,         NULL),     
    MI_SIMPLECB("black",         setFunctionBlackCB,        NULL),
    MI_SIMPLECB("AND",           setFunctionAndCB,          NULL),
    MI_SIMPLECB("AND Reverse",   setFunctionAndReverseCB,   NULL),     
    MI_SIMPLECB("AND Inverted",  setFunctionAndInvertedCB,  NULL),   
    MI_SIMPLECB("Excl. OR",      setFunctionXorCB,          NULL),       
    MI_SIMPLECB("OR",            setFunctionOrCB,           NULL),    
    MI_SIMPLECB("Not Or",        setFunctionNorCB,          NULL),     
    MI_SIMPLECB("Equiv",    	 setFunctionEquivCB,        NULL),      
    MI_SIMPLECB("Invert",        setFunctionInvertCB,       NULL),           
    MI_SIMPLECB("Reverse OR",    setFunctionOrReverseCB,    NULL),          
    MI_SIMPLECB("Invert Source", setFunctionCopyInvertedCB, NULL),              
    MI_SIMPLECB("OR Inverted",   setFunctionOrInvertedCB,   NULL),          
    MI_SIMPLECB("NOT AND",       setFunctionNandCB,         NULL),             
    MI_SIMPLECB("white",         setFunctionWhiteCB,        NULL),             
    MI_SIMPLECB("HELP", HelpDialog, "toolbox.functions"),
};


static PaintMenuItem fileMenu[] =
{
    MI_SIMPLECB("new", GraphicCreate, 0),
    MI_SIMPLECB("new-size", GraphicCreate, 2),
    MI_SIMPLECB("open", GraphicCreate, 1),
    MI_SIMPLECB("load-clip", loadClipboard, NULL),
    MI_SEPERATOR(),
    MI_SIMPLECB("*POOF*", exitPaint, NULL),
};

static PaintMenuItem helpMenu[] =
{
    MI_SIMPLECB("Whence xart", HelpDialog, "about"),
    MI_SEPERATOR(),
    MI_SIMPLECB("intro", HelpDialog, "toolbox.toolbox"),
};

static PaintMenuBar menuBar[] =
{
    {None, "canvas", XtNumber(fileMenu), fileMenu},

    {None, "Fn", XtNumber(FnMenu), FnMenu},

    {None, "line", XtNumber(lineMenu), lineMenu},
    {None, "font", XtNumber(fontMenu), fontMenu},
    {None, "help", XtNumber(helpMenu), helpMenu},
};

/*
**  Now for the callback functions
 */
static int argListLen = 0;
static Arg *argList;

void 
OperationSetPaint(Widget paint)
{
    XtSetValues(paint, argList, argListLen);
}

void 
/* appears to append an arg to argList */
OperationAddArg(Arg arg)
{
    int i;

    for (i = 0; i < argListLen; i++) {
	if (strcmp(argList[i].name, arg.name) == 0) {
	    argList[i].value = arg.value;
	    return;
	}
    }

    if (argListLen == 0)
	argList = (Arg *) XtMalloc(sizeof(Arg) * 2);
    else
	argList = (Arg *) XtRealloc((XtPointer) argList,
				    sizeof(Arg) * (argListLen + 2));

    argList[argListLen++] = arg;
}

/*
**  Double click action callback functions.
 */

static void 
changeLineAction(Widget w, XEvent * event)
{
    lineWidth(lineMenu[LW_SELECT].widget, (int) lineMenu[LW_SELECT].data);
}
static void
changeDynPencilAction(Widget w, XEvent *event)
{
    dynPencilMenuCallback(w);
}
static void 
changeSprayAction(Widget w, XEvent * event)
{
    sprayMenuCallback(w);
}
static void 
changeTFillAction(Widget w, XEvent * event)
{
    tfillMenuCallback(w);
}
static void 
changeBrushAction(Widget w, XEvent * event)
{
    BrushSelect(w);
}
static void 
changeBrushParmAction(Widget w, XEvent * event)
{
    brushMenuCallback(w);
}

static void 
changeFontAction(Widget w, XEvent * event)
{
    fontSet(fontMenu[FM_SELECT].widget, (char *) fontMenu[FM_SELECT].data);
}

/*
**  The real init function
 */
void 
OperationInit(Widget toplevel)
{
    static XtActionsRec acts[] =
    {
	{"changeLine", (XtActionProc) changeLineAction},
	{"changeBrush", (XtActionProc) changeBrushAction},
	{"changeFont", (XtActionProc) changeFontAction},
	{"changeDynPencil", (XtActionProc) changeDynPencilAction},
	{"changeSpray", (XtActionProc) changeSprayAction},
	{"changeTFillParms", (XtActionProc) changeTFillAction},
    };
    int i;
    Pixmap pix;
    Widget vport, form, box, icon, bar, firstIcon = None;
    char *defTrans = "<BtnDown>,<BtnUp>: set() notify()\n";
    XtTranslations trans = XtParseTranslationTable(defTrans);
    IconListItem *cur;
    XpmAttributes attributes;

    
    form = XtVaCreateManagedWidget("toolbox",
				   formWidgetClass, toplevel,
				   XtNborderWidth, 0,
				   XtNwidth, 300,
				   NULL);
    XtAppAddActions(XtWidgetToApplicationContext(toplevel),
		    acts, XtNumber(acts));

    /*
    **  Create the menu bar
     */
    bar = MenuBarCreate(form, XtNumber(menuBar), menuBar);

    /*
    **  Create the operation icon list
     */
    vport = XtVaCreateManagedWidget("vport",
				    viewportWidgetClass, form,
				    XtNallowVert, True,
				    XtNuseRight, True,
				    XtNfromVert, bar,
				    NULL);
    box = XtVaCreateManagedWidget("box",
				  boxWidgetClass, vport,
				  XtNwidth, 32 * 8,
				  XtNtop, XtChainTop,
				  NULL);

    for (i = 0; i < XtNumber(iconList); i++) {
	cur = &iconList[i];

	icon = XtVaCreateManagedWidget(cur->name,
				       toggleWidgetClass, box,
				       XtNtranslations, trans,
				       XtNradioGroup, firstIcon,
				       XtNradioData, cur->name,
				       NULL);

	if (cur->xpmmap != NULL) {
	    attributes.valuemask = XpmCloseness;
            attributes.closeness =  40000;
	    XpmCreatePixmapFromData(XtDisplay(box),
				    DefaultRootWindow(XtDisplay(box)),
				    cur->xpmmap,
				    &pix, NULL, &attributes);
	} else {
	    pix = None;
	}

	if (pix == None) {
	    printf("Unable to allocate sufficient color entries.\n");
	    printf("Try exiting other color intensive applications.\n");
	    exit(1);
	}
	
	cur->icon = pix;

	if (pix != None)
	    XtVaSetValues(icon, XtNbitmap, pix, NULL);
	if (cur->translations != NULL) {
	    XtTranslations moreTrans;

	    moreTrans = XtParseTranslationTable(cur->translations);
	    XtAugmentTranslations(icon, moreTrans);
	}
	if (firstIcon == NULL) {
	    XtVaSetValues(icon, XtNstate, True, NULL);
	    setOperation(icon, cur->data, NULL);

	    firstIcon = icon;
	    iconListWidget = icon;
	}
	XtAddCallback(icon, XtNcallback,
		      setOperation, cur->data);

	if (cur->nitems != 0 && cur->popupMenu != NULL)
	    MenuPopupCreate(icon, cur->nitems, cur->popupMenu);
    }

    lineWidth(lineMenu[0].widget, (int) lineMenu[0].data);
    fontSet(fontMenu[1].widget, fontMenu[1].data);

    AddDestroyCallback(toplevel, (DestroyCallbackFunc) exitPaint, NULL);
}

Image *
OperationIconImage(Widget w, char *name)
{
    int i;

    for (i = 0; i < XtNumber(iconList); i++)
	if (strcmp(name, iconList[i].name) == 0)
	    break;
    if (i == XtNumber(iconList) || iconList[i].icon == None)
	return NULL;

    return PixmapToImage(w, iconList[i].icon, None);
}
