/* my_malloc.h: memory allocation routines with error checking
//
// Written and Copyright (C) 1994-1997 by Michael J. Gourlay
//
// Provided as is.  No warrantees, express or implied.
*/

#ifndef _MY_MALLOC_H__INCLUDED_
#define _MY_MALLOC_H__INCLUDED_

#ifdef __cplusplus
extern "C" {
#endif




/* GNU C header file for string.h is broken. */
#ifdef __GNUC__
extern char *strdup (const char *s);
#endif




int listAppend(void ** root, int *nmemb, int size);
int listDelete(void ** root, int *nmemb, int size, int index) ;

#ifdef DEBUG
void memBlockInventory(const int all);
#endif

void * my_realloc(void * const ptr, const long nelem, const int elsize, const char * const file, const int line);

void my_free(void * const ptr, const char * const file, const int line);


#define CALLOC(nelem,elsize)  my_realloc(NULL,nelem,elsize,__FILE__,__LINE__)
#define MALLOC(size)          my_realloc(NULL,size,1,__FILE__,__LINE__)
#define MY_CALLOC(nelem,type) my_realloc(NULL,nelem,sizeof(type),__FILE__,__LINE__)
#define REALLOC(ptr,size)     my_realloc(ptr,(long)(size),1,__FILE__,__LINE__)
#define FREE(ptr)             my_free(ptr,__FILE__,__LINE__)




#ifdef __cplusplus
}
#endif




#endif
