/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Copyright (c) 1998, by Sun Microsystems, Inc.
 * All rights reserved.
 */
#pragma ident "@(#)LOdefs.H	1.11     99/11/19  SMI%"

#ifndef LODEF_H
#define LODEF_H

#include "layout.h"
#include "layout_int.h"
#ifndef bool_def
typedef int BOOL;
#define true 1
#define false 0
#define bool_def
#endif


/** a namespace for commonly used types.
    All classes are decendants of this class, so 
    they all share the same types. This class would
    probably be unnecessary if "namespace" was
    supported by both CC and g++.
*/
class LOdefs {
public:
  /// value type to use for internal representation of characters
  //typedef unsigned short val_t;
  typedef int val_t;
  /** enumeration of possible layout text descriptor values.
      The enumerated values receive exactly the same 
      values from the definitions in the layout.h PLS
      library header. The enum name is slightly modified 
      as not to clash with the def. The reason why enumerate in
      the first place is because it is cleaner, usefull during
      debugging and in switch statements (gcc, for example, warn you if
      you have not used all the enumerated types)
  */
  enum  text_descriptor_val_t {
    NUM_NOMINAL = NUMERALS_NOMINAL, 
    NUM_NATIONAL = NUMERALS_NATIONAL,
    NUM_CONTEXTUAL = NUMERALS_CONTEXTUAL,
    SHAPE_SHAPED = TEXT_SHAPED,
    SHAPE_BEGIN = TEXT_SHFORM1, 
    SHAPE_MIDDLE = TEXT_SHFORM2, 
    SHAPE_END = TEXT_SHFORM3, 
    SHAPE_INDEP = TEXT_SHFORM4,
    TXT_IMPLICIT = TEXT_IMPLICIT, 
    TXT_EXPLICIT = TEXT_EXPLICIT,
    TXT_VISUAL = TEXT_VISUAL,
    SWAP_YES = SWAPPING_YES, 
    SWAP_NO = SWAPPING_NO,
    ORIENT_LTR = ORIENTATION_LTR,
    ORIENT_RTL = ORIENTATION_RTL,
    ORIENT_CONTEXTUAL = ORIENTATION_CONTEXTUAL,
    ALG_IMPLICIT = ALGOR_IMPLICIT,
    ALG_BASIC = ALGOR_BASIC,
    CONTXT_LTR = CONTEXT_LTR,
    CONTXT_RTL = CONTEXT_RTL
  };
  /** enumeration of textDescriptor side.
      This flag is used in LOcontrol for getting
      PLS setting values/modifiers.
  */
  enum textDescriptor_side_t {
    INP,
    OUT
  };
  /// enumeration of text descriptor types
  enum textDescriptor_enum_t {
    orientation, 
    context,     
    type_of_text,
    implicit_alg,
    swapping,    
    numerals,    
    text_shaping
  };
  /// enumaration of resolved direction types
  enum direction_t {NONE, LTR, RTL, NUM};
};

#endif // LODEF_H
