/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
#ifdef	sccs
static char     sccsid[] = "@(#)cm_prc.c	1.3 00/09/13";
#endif
#endif


#pragma weak cm_open  = _cm_open
#pragma weak cm_put   = _cm_put
#pragma weak cm_close = _cm_close

#include	<stdio.h>
#include	<fcntl.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/stat.h>
#include	<sys/param.h>
#include	<sys/mman.h>
#include	<sys/file.h>
#include	<pwd.h>
#include	<grp.h>
#include	<string.h>
#include	<strings.h>

#ifdef V_SUNVIEW
#include	<suntool/sunview.h>
#include	<suntool/tty.h>
#include	<suntool/textsw.h>
#include	<suntool/panel.h>
#include	<sunwindow/defaults.h>
#endif

#include	"cm_prc.h"

extern void     phrase2_init();
extern void     phrase2();
extern e_char  *my_malloc();

#include <stdlib.h>
#include <strings.h>
#include <unistd.h>

/*
 * The following functions are declared that be used to make use of the
 * defaults database, they be defined in the sunwindow library.
 */
/*
 * The following functions are defined in libxview too, but different
 * from those in sunwindow. They shouldn't be used here.
 */
#ifdef V_SUNVIEW
extern char    *defaults_get_string();
extern int      defaults_get_integer();
extern int      defaults_get_integer_check();
#endif

extern struct cm_to_env *fullcode_CM_RESET();		/* in the full_code.c */

extern e_char  *ci_map();
extern struct cm_to_env *alloc_env();
extern int      map_dic();	/* In the DIC */
extern void	fullcode_switch_out();
extern unsigned int c_cm_scan_table[];
extern int	default_im;

struct cm_to_env cmtoenv[16];

#define MAX_SESSION 	512			/* OWN needs a lot */
#define	MAX_PHRASES	MAX_RC

#define	selections	(cmscreen[cms]->cm_s_r).choices

struct CM_screen *cmscreen[MAX_SESSION];

int             Maximum_Cans;
static e_char   c_string[MAX_STG_LEN];
int             c_c;
int             exter_code_count;	/* number of input key strokes */
static int	out_sun_ipy = 0;

int		root_window = 0;	/* new luc */
int		luc_label_type = 0;

static int	n_gold_phr_luc;

void		luc_negotiation();

static e_char	*interm_null = (e_char *)"";
/* It is used for a hack, committing a null string resets interm region. */

/* Define pinyin&stroke scan table entry structure */
#ifdef sparc
struct pinyin_stroke_entry {	/* Full int	 */
	int:            1;	/* NOT USED 		 */
	int             p3:5;	/* 3th pinyin input key */
	int             p2:5;	/* 2th pinyin input key */
	int             p1:5;	/* first pinyin input key */
	int:            6;	/* NOT USED 		 */
	int             s2:5;	/* 2th stroke key 	 */
	int             s1:5;	/* first stroke key 	 */
};
#endif

#ifdef i386
struct pinyin_stroke_entry {	/* Full int	 */
	int             s1:5;	/* first stroke key 	 */
	int             s2:5;	/* 2th stroke key 	 */
	int:            6;	/* NOT USED 		 */
	int             p1:5;	/* first pinyin input key */
	int             p2:5;	/* 2th pinyin input key */
	int             p3:5;	/* 3th pinyin input key */
	int:            1;	/* NOT USED 		 */
};
#endif

#ifdef linux
struct pinyin_stroke_entry {	/* Full int	 */
	int             s1:5;	/* first stroke key 	 */
	int             s2:5;	/* 2th stroke key 	 */
	int:            6;	/* NOT USED 		 */
	int             p1:5;	/* first pinyin input key */
	int             p2:5;	/* 2th pinyin input key */
	int             p3:5;	/* 3th pinyin input key */
	int:            1;	/* NOT USED 		 */
};
#endif

#ifdef ppc
struct pinyin_stroke_entry {	/* Full int	 */
	int             s1:5;	/* first stroke key 	 */
	int             s2:5;	/* 2th stroke key 	 */
	int:            6;	/* NOT USED 		 */
	int             p1:5;	/* first pinyin input key */
	int             p2:5;	/* 2th pinyin input key */
	int             p3:5;	/* 3th pinyin input key */
	int:            1;	/* NOT USED 		 */
};
#endif

static int	s_pointer;	/* searching pointer in the PY_SW */
static int	p_pointer;	/* the Prev searching pointer */
static int	s_end = S_NUMBER - 0x1;	/* the end pointer */
static int	s_direction = 0; /* 0/1 : forward/backward searching */

static e_char  *Misc_string = (e_char *) "MISC*** \\ ";
static char    alarm_string[] = {0x07, 0x07, 0x07, 0x07, 0x07, 0};

/* Cache table for HANZI searching in  Jinjian  */
extern u_short c_cm_tgzc[][10];

#define	VN_PAGE_F(c)			((c == ']') || (c == '}'))
#define	VN_PAGE_B(c)			((c == '[') || (c == '{'))
#define	LEGAL_VN_KEY(c)	 		((c >= 'a') && (c <= 'z'))
#define	FILE_BEGINING_POSITION		0
#define	FILE_CURRENT_POSITION		1
#define	TYRK_LINE_LEN	 		6
#define	QW_BM_LINE_LEN	 		5
#define	MAX_LX_LEN	 		150
#define	LX_DATA_LEN	 		2
#define	CI3_LINE_LEN	 		6
#define	CI4_LINE_LEN	 		8
#define	CI5_LINE_LEN	 		10
#define	CI6_LINE_LEN	 		12
#define	CIm_LINE_LEN	 		50

#define	CTL_SP_KEY			0	/* 0 == ^@ */
/*
#define	KEYBIND_COMMENT_CHAR		'#'
* not used -- roxon */

#define	SELECT				('Y'-0x40)

#define	ZHXX_INDEX_ENTERY_LEN		8
#define	ZHXX_INDEX_SIZE			3264
#define	ZHXX_INDEX_LENGTH		ZHXX_INDEX_SIZE
#define	LX_ARRAY_ENTERY_LEN		8
#define	CI2_DATA_ENTERY_LEN		8

/* some Variables for Jinjian_zhineng encode */
/* 1.  Zong He Xin xi index table:	 */
struct zhxx_index {		/* 2+2+4 bytes */
	char            pp[2];	/* external input code */
	e_char          hz[2];	/* Chinese Char code */
	u_int           zhxx_offset;	/* offset in the zhxx file */
};

/* 2. Zong He xin xi data table character entry:
struct zhxx_data_entry
* not used -- roxon */

/* 3. specifies first page state in selection region in JJ */
static int             vn_input_init = 0;

/* 4. tyrk table == { Chinese character + tyhz code + count +\n} */
/* NOT USED 	 */

/* 5. gbfl4.f.2 data table == { Chinese string}	 */
/* gbfl4.f.2 index table == { the level 2 code + offset in data table */
/* NOT USED */

/* 6. qw_bm  table == { Chinese character(2) + qw_bm code(2) + \n}
struct QW_BM_BUF {
};		* not used -- roxon */

/*
 * 7. Declare some open data files and buffer table
 */
static int             zhxx_file;
static int             zhxx_data_size;
static int             zhxx_index;
static e_char          zhxx_index_buf[ZHXX_INDEX_SIZE];
static int             zhxx_pointer_start = 0;
static int             zhxx_pointer_end = ZHXX_INDEX_SIZE;
static int             zhxx_pointer_tmp = 0;
static int             zhxx_direction = 0;
static u_short         zhxx_read_state = 0;	/* 1, 2, 3, 4 */
static u_int           zhxx_offset = 0;

/*
 * 8. Phrase files( Just 3,4,5,6, and more 6)
 */
static FILE           *ci3; 		/* table == { Three words's phrases } */
static FILE           *ci4; 		/* table == { Four words's phrases } */
static FILE           *ci5; 		/* table == { Five words's phrases } */
static FILE           *ci6; 		/* table == { Six words's phrases } */
static FILE           *cim; 		/* table == { > 6 words's phrases }*/

static int             ci3_b;		/* ci3	 exter code table fd */
static e_char         *ci3_b_buf;	/* ci3   exter code table self */
static int             ci3_b_size;
static int             ci4_b;		/* ci4	 exter code table fd */
static e_char         *ci4_b_buf;	/* ci4   exter code table self */
static int             ci4_b_size;
static int             ci5_b;		/* ci5	 exter code table fd */
static e_char         *ci5_b_buf;	/* ci5   exter code table self */
static int             ci5_b_size;
static int             ci6_b;		/* ci6	 exter code table fd */
static e_char         *ci6_b_buf;	/* ci6   exter code table self */
static int             ci6_b_size;
static int             cim_b;		/* cim	 exter code table fd */
static e_char         *cim_b_buf;	/* cim   exter code table self */
static int             cim_b_size;

/* 9.1 Association data array file and buffer pointer */
static int             lx_array_fd;	/* lx data array table file */
static e_char         *lx_array_buf;	/* lx data array table file's buffer */
static u_short         lx_mode = 0;

/* lianxiang input method, format of file ci2_array */
struct lx_array_entry {		/* 8 bytes */
	u_int           offset;	/* offset in the ci2_entry */
	u_int           count;	/* number of lx phrase  */
};

/* 9.2  Double words phrase file structure and so on */
struct ci2_entry {		/* 8 bytes */
	u_char          first11;/* First Chinese character */
	u_char          first12;
	u_char          sec21;	/* Second Chinese character */
	u_char          sec22;
	u_int           pointer;/* Not used in the release */
};

int             ci2_b;		/* ci2	 exter code table file  */
int             ci2_file;	/* ci2	 phrse code table file  */
int             ci2_size;
e_char         *ci2_buf;

/* 10. All phrases file's external file structure
struct ci_external_entry
* not used -- roxon */

/*
 * Conversion mode key in ENV <==> CM.
 */
/* The below structures are defined and allocated in keybind.c */
extern struct input_method *on_kb;			/* 1 */
extern struct input_method *conversion_off;		/* 2 */
extern struct input_method *location_kb;		/* 3 */
extern struct input_method *pinyin_kb;			/* 4 */
extern struct input_method *stroke_kb;			/* 5 */
/*
extern struct input_method *quick_kb;			/* 6 */
extern struct input_method *golden_kb;			/* 7 */
extern struct input_method *full_code_kb;		/* 8 */
/*
extern struct input_method *phrase_kb;			/* 9 */
extern struct input_method *ascii_kb;			/* 0 */
extern struct input_method *chnsym_kb;		/* new mode -- roxon */
extern struct input_method *mode_switch_kb;
extern struct input_method im[];

extern struct dictionary   dic[];

#define	CONV_ON_FUNCTION	on_kb->function_key
#define	CONV_OFF_CTL		conversion_off->ctl_key
#define	CONV_OFF_FUNCTION	conversion_off->function_key
#define	ASCII_FUNCTION		ascii_kb->function_key
#define	ASCII_CTL		ascii_kb->ctl_key
#define	QW_FUNCTION		location_kb->function_key
#define	QW_CTL			location_kb->ctl_key
#define	PY_FUNCTION		pinyin_kb->function_key
#define	PY_CTL			pinyin_kb->ctl_key
#define	SW_FUNCTION		stroke_kb->function_key
#define	SW_CTL			stroke_kb->ctl_key
/*
#define	QK_FUNCTION		quick_kb->function_key
#define	QK_CTL			quick_kb->ctl_key
#define	CZ_FUNCTION		phrase_kb->function_key
#define	CZ_CTL			phrase_kb->ctl_key
*/
#define	JJ_FUNCTION		golden_kb->function_key
#define	JJ_CTL			golden_kb->ctl_key
#define	SUN_FUNCTION		full_code_kb->function_key
#define	SUN_CTL			full_code_kb->ctl_key
#define SWITCH_MODE_FUNCTION	mode_switch_kb->function_key
#define SWITCH_MODE_CTL		mode_switch_kb->ctl_key
/* new mode -- roxon */
#define	CS_FUNCTION		chnsym_kb->function_key
#define	CS_CTL			chnsym_kb->ctl_key

#define	CMON_STRING		on_kb->message
#define	QW_STRING		location_kb->message
#define	PY_STRING		pinyin_kb->message
#define	SW_STRING		stroke_kb->message
/*
#define	QK_STRING		quick_kb->message
#define	CZ_STRING		phrase_kb->message
*/
#define	JJ_STRING		golden_kb->message
#define	SUN_STRING		full_code_kb->message
#define SWITCH_MODE_STRING	mode_switch_kb->message
#define	END_STRING		ascii_kb->message
#define	CMOFF_STRING		conversion_off->message
/* new mode -- roxon */
#define	CS_STRING		chnsym_kb->message

#define	HELP_KEY  	('Z' - 0x40)
#define LX_KEY  	('L' - 0x40)

/*
 * 12. The following constants are used for function E_to_Chinese.
 */
#define	RE_STRING	0xff
#define	RE_REPEAT	0xfe
#define	RE_INTERM	0x00


/* allocation of cm_to_env */
struct cm_to_env *
alloc_env(p)
struct cm_to_env *p;
{
	static	int  cc = 0;

	if (cc >= 16)
		cc = 0;
	if (p) {
		p->ce_next = &cmtoenv[cc];
	}
	return (struct cm_to_env *)&cmtoenv[cc++];
}


Cm_session
_cm_open(cm_id, cm_initvalue, se_initvalue)
	int             cm_id;
	struct cm_initstruct *cm_initvalue;
	struct cm_to_env **se_initvalue;
{

	char           *max_rc_string;
	int             max_rc_default;
	struct cm_to_env *ce_ptr;
	static Cm_session cms = 0;
	static int 	first_open = 0;
	static int      phrase_mode = 0;
	int i;
	struct cm_to_env *tp;

#ifdef DEBUG
	fprintf(stderr,"Chinese cm_open is called successfully\n");
#endif

	if (cm_id) {
		fprintf(stderr, " Used inconsistently CM ID.\n");
		return(-1);
	}

	/*
	 * new luc - env_value is a reserved field. It's used here
	 * as an indicator of ENV version. Old ENV's won't care about it,
	 * and new ENV's set it and will do negotiation if it's reset.
	 */
	if ( cm_initvalue->env_value ) {
		cm_initvalue->env_value = (e_char *)NULL;
	}
		

	if (first_open == 0) {
#ifdef V_SUNVIEW
		max_rc_string = getenv("MAX_CAN");
		max_rc_default = defaults_get_integer(
					      "/PrChina/Maximum_Cans",
					      26, 0);
#endif

		max_rc_string = NULL;
		max_rc_default = 0;

		max_rc_string = getenv("LUC_MAX");

		/*
		 * This is an XView func - should not be used here.
		max_rc_default = defaults_get_integer("luc.max", "Luc.Max", 26);
		*/

		/*
		 * Some default values should be passed from im server,
		 * such as luc.max, root window, etc.
		 */

		if ((max_rc_string == NULL) && (max_rc_default == 0)) {
			Maximum_Cans = MAX_RC;	/* Default  value */
		} else {
			if (max_rc_string == NULL)
				Maximum_Cans = max_rc_default;
			else
				Maximum_Cans = atoi(max_rc_string);
			if (Maximum_Cans > MAX_RC) {
				Maximum_Cans = MAX_RC;
			} else if (Maximum_Cans < MIN_RC) {
				Maximum_Cans = MIN_RC;
			}
		}

		if ( zhineng_init() == -1 ) {
		    perror("Can't initialize the dictionaries - Can't open.");
		    return(-1);
		}

		keybind_init();

		if (phrase_mode == 0) {
			phrase_mode = 1;
			phrase2_init();
		}
		first_open = 1;
		for (i=0; i<MAX_SESSION; i++)
			cmscreen[i] = (struct CM_screen *)NULL;
	}

	for (i=0; i < MAX_SESSION; i++) {
		if ( cmscreen[i] == (struct CM_screen *)NULL ) {
			cms = i;
			break;
		}
	}

	if ( cms == MAX_SESSION ) {
		perror(" Can't open so many subwindows");
		return(-1);
	}

	cmscreen[cms] = (struct CM_screen *)malloc(sizeof(struct CM_screen));
	if( cmscreen[cms] == (struct CM_screen *)NULL ) {
		perror(" Can't allocate memory for the subwindows");
		return(-1);
	}
	cmscreen[cms]->cm_conv_on = 0;
	IM = default_im;
	cms_init(cms);

	/* Setting switch CM_ON key code ,and telling ENV */
	if (se_initvalue) {
		*se_initvalue = alloc_env((struct cm_to_env *)NULL);
		ce_ptr = *se_initvalue;
		ce_ptr->ce_operation = ENV_SETKEY_CM_ON;
		ce_ptr->ce_rtn_value = on_kb->ctl_key;
		tp = alloc_env(ce_ptr);
		/*
		 * This is a hack for a xim server bug which assumes
		 * a initial default status drawing.
		 */
		tp->ce_string = (e_char *)" ";
		tp->ce_operation = ENV_SET_SIMPLE_MODE;
		tp->ce_next = (struct cm_to_env *) NULL;
	} else {
		perror("se_initvalue is a NULL pointer");
		return(-1);
	}
	return (cms++);

}

/*
 *	According to the global variable - IM - get a message
 *	string to be displayed in Mode_Region, when conversion is turned on.
 */
e_char *
get_mode_string(cms)
Cm_session cms;
{
	e_char         *re_string;

	switch (IM) {
	case QW_VALUE:
		re_string = (e_char *) QW_STRING;
		break;
	case PY_VALUE:
		re_string = (e_char *) PY_STRING;
		break;
	case SW_VALUE:
		re_string = (e_char *) SW_STRING;
		break;
/*
	case CZ_VALUE:
		re_string = (e_char *) CZ_STRING;
		break;
*/
	case CS_VALUE:					/* new mode -- roxon */
		re_string = (e_char *) CS_STRING;
		break;
	case JJ_VALUE:
		re_string = (e_char *) JJ_STRING;
		break;
	case SUN_VALUE:
		re_string = (e_char *) SUN_STRING;
		break;
	case SWITCH_MODE_VALUE:
		re_string = (e_char *) SWITCH_MODE_STRING;
		break;
	default:
		if (IM >= USER_IM_ST) {
			re_string = im[IM].message;
		} else {
			re_string = (e_char *) CMON_STRING;
		}
		break;
	}
	return (re_string);
}


struct cm_to_env *
_cm_put(cm_id, cms, inptr)
	int             cm_id;
	Cm_session      cms;
	register struct env_to_cm *inptr;
{
	struct cm_to_env *outptr, *tp;
	int		im_no, dic_no, sel_no;
	int		i, l, h;
	e_char		*s;

#ifdef DEBUG
	fprintf(stderr,"Chinese cm_put is called successfully\n");
#endif

	if (cm_id && cms) {
		fprintf(stderr, " Used inconsistently CM ID.\n");
		return(NULL);
	}

	exter_code_count = DISP_LEN;

	tp = outptr = alloc_env((struct cm_to_env *)NULL);
	outptr->ce_operation = ENV_NOP;

	while (inptr) {
		switch (inptr->ec_operation) {
		case CM_RESET:
			/*
			 * CM_RESET() requests CM to commit data, clear
			 * status and turn off the conversion.
			 */
			if ( IM == SUN_VALUE ) {
				tp = fullcode_CM_RESET(outptr, cms);
				break;
			}

			exter_code_count = 0;

                        tp = alloc_env(tp);
			tp->ce_operation = ENV_INTERM_RESET;

			if ( r_cc > 1 ) {
				tp = alloc_env(tp);
				tp->ce_operation = ENV_SELECT_END;
			}
 
			tp = alloc_env(tp);
			tp->ce_string = interm_null;
			tp->ce_operation = ENV_COMMIT;

                        tp = alloc_env(tp);
                        tp->ce_string = (e_char *) CMOFF_STRING;
                        tp->ce_operation = ENV_SET_SIMPLE_MODE;

			tp = alloc_env(tp);
			tp->ce_operation = ENV_CM_OFF;
			tp->ce_next = (struct cm_to_env *) NULL;
			break;
		case CM_SIMPLE_EVENT:
			/*
			 * CM_SIMPLE_EVENT((u_int)ec_key) passes a keyboard
			 * action to CM.
			 */
			if ( process_simple_event(outptr, inptr, cms) == -1 ) {
				perror("Something is wrong - doing RESET.");
				reset_on_error(outptr, cms);
				return(outptr);
			}
			if (IM < USER_IM_ST)
				DISP_LEN = exter_code_count;
			return (outptr);
		case CM_CMON:
			tp = alloc_env(tp);
			tp->ce_operation = ENV_SET_SIMPLE_MODE;
			tp->ce_string = (e_char *)get_mode_string(cms); 
			tp->ce_next = (struct cm_to_env *)NULL;
			S_ncandidate = 0;
			cms_init(cms);
			reset_range(cms);
			break;
		case CM_IMSERVER_NEGOTIATION:
			luc_negotiation(inptr);
			break;
		case CM_SELECT:
			sel_no = inptr->ec_select;
			outptr->ce_operation = ENV_COMMIT;
		    	outptr->ce_string = 
				(e_char *)cmscreen[cms]->cm_s_r.choices[sel_no];
			for (s = outptr->ce_string; *s != '\0'; s++) {
			    	if (*s == ' ') {
					*s = '\0';
					break;
			    	}
			}
			tp = alloc_env(outptr);
			tp->ce_operation = ENV_INTERM_RESET;
		    	tp = alloc_env(tp);
			tp->ce_operation = ENV_SELECT_END;
		    	tp->ce_next = (struct cm_to_env *)NULL;
			cms_init(cms);
			im_no = cmscreen[cms]->input_method;
			if ((dic_no = im[im_no].dic_no) >= 0) {
			    look_up_dict(dic_no, outptr->ce_string, &l, &h);
			    if (l == h) {
				strcpy((char *)outptr->ce_string, 
					dic[dic_no].word[l]);
				return (outptr);;
			    }
			    if (l > h)
				return (outptr);;
			    tp = alloc_env(tp);
			    for (i = 0; l <= h; i++, l++) {
				if (cmscreen[cms]->cm_s_r.choices[i] ==
				    cmscreen[cms]->cm_s_r.buf[i]) {
					cmscreen[cms]->cm_s_r.choices[i] =
					    cmscreen[cms]->cm_s_r.buf2[i];
				} else {
					cmscreen[cms]->cm_s_r.choices[i] =
					    cmscreen[cms]->cm_s_r.buf[i];
				}
                                strcpy((char *)cmscreen[cms]->cm_s_r.choices[i],
					(char *)(dic[dic_no].word[l]
					+strlen((char *)outptr->ce_string)) );
			    }
			    tp->ce_ncandidate = i;
			    tp->ce_candidate 
				= (e_char **) cmscreen[cms]->cm_s_r.choices;
			    tp->ce_operation = ENV_SELECT;
			    tp->ce_prevexist = NULL;
			    tp->ce_nextexist = NULL;
			    tp->ce_next = (struct cm_to_env *)NULL;
			    cmscreen[cms]->im_mode = LOOKUP_CHOICE;
			}
			return (outptr);
		case CM_SELECT_INVALID:
			do_nothing(outptr);
			return (outptr);;
		case CM_NEXT_CANDIDATE:
		case CM_PREV_CANDIDATE:
		default:
			/* just print Error message */
			env_to_cm_ERROR(inptr->ec_operation);
			break;
		}		/* End of switch(inptr->ec_operation	 */

		inptr = inptr->ec_next;
	}			/* End of while loop	 */
	tp->ce_next = (struct cm_to_env *) NULL;
	DISP_LEN = exter_code_count;
	return (outptr);
}				/* End of cm_put function	 */

do_nothing(outptr)
struct cm_to_env *outptr;
{
        outptr->ce_operation = ENV_NOP;
        outptr->ce_next = (struct cm_to_env *)NULL;
}


static int	mode_switching = 0;

/*
 * This is the main function for a keyboard action which is passed
 * to CM by ENV
 * Input parameter:	in_c is the key stroke passed from ENV.
 * Return value:	None.
 */
int
process_simple_event(outptr, inptr, cms)
	register struct cm_to_env *outptr;
	register struct env_to_cm *inptr;
	Cm_session	cms;
{
	u_int		in_c;

	in_c = inptr->ec_key;

	if (is_switch_key(in_c, cms)) {
		mode_switching = switch_mode(outptr, cms, in_c);
		return 0;
	} 

	in_c &= 0xff;

	if (!mode_switching && (IM == SUN_VALUE)) {
		/* Designed by Sun Microsystems Inc. */
		full_code_pinyin(in_c, outptr, cms);
		mode_switching = 0;
		return 0;
	}

	if (IM >= USER_IM_ST) {
		codetable_im_event_handler(cms, in_c, outptr);
		return 0;
	}
	return input_character(cms, in_c, inptr, outptr);
}


is_switch_key(in_c, cms)
u_int   in_c;
Cm_session cms;
{
        int     i;
 
	if (in_c == im[IM].next_choice || in_c == im[IM].prev_choice
	   	|| in_c == im[IM].commit_key || in_c == im[IM].disp_sel_key)
		return 0;

        for (i = 0; i < MAX_IM; i++) {
                if (in_c == im[i].function_key || in_c == im[i].ctl_key) {
                        return 1;
                }
        }
        return 0;
}

switch_mode(outptr, cms, in_c)
struct cm_to_env *outptr;
Cm_session       cms;
u_int            in_c;
{
	int		i;
	struct cm_to_env *tp;

	if (in_c == SWITCH_MODE_CTL || in_c == SWITCH_MODE_FUNCTION) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		mode_display(SWITCH_MODE_VALUE, outptr, cms);
		return 1;
	}

	/* the upper case id's are not constants, can't use switch stmt. */
	if (in_c == CONV_OFF_CTL || in_c == CONV_OFF_FUNCTION) {
		/*
		 * If we are doing Sun Pinyin we want to do auto-commit
		 * when conv is turned off.
		 */
		if (IM == SUN_VALUE)
			full_code_pinyin(CONV_OFF_CTL, outptr, cms);
		else {
			exter_code_count = 0;

			outptr->ce_operation = ENV_INTERM_RESET;

			tp = alloc_env(outptr);
			tp->ce_operation = ENV_SELECT_END;

			tp = alloc_env(tp);
			tp->ce_string = interm_null;
			tp->ce_operation = ENV_COMMIT;

			tp = alloc_env(tp);
			tp->ce_operation = ENV_SET_SIMPLE_MODE;
			tp->ce_string = (e_char *) CMOFF_STRING;

			tp = alloc_env(tp);
			tp->ce_operation = ENV_CM_OFF;
			tp->ce_next = (struct cm_to_env *) NULL;
		}
		return 0;
	}

	if (in_c == HELP_KEY) {
		/* Print some help message */
		display_help(outptr, cms);
		return 0;
	}
		
	if (in_c == SELECT) {
		/* For DEBUGGING or FUTURE USE	 */
		cm_to_env_NOP(outptr);
		return 0;
	}

	/*
 	 * process function keys, intelligent pinyin keys, and
 	 * control keys.
 	 */
	if (in_c == ASCII_FUNCTION || in_c == ASCII_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		exter_code_count = 0;
		IM = ASCII_VALUE;
		mode_display(ASCII_VALUE, outptr, cms);
		return 0;
	}

	if (in_c == SUN_FUNCTION || in_c == SUN_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		exter_code_count = 0;
		IM = SUN_VALUE;
		mode_display(SUN_VALUE, outptr, cms);
		return 0;
	}

	if (in_c == QW_FUNCTION || in_c == QW_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		IM = QW_VALUE;
		mode_display(QW_VALUE, outptr, cms);
		return 0;
	}

	if (in_c == PY_FUNCTION || in_c == PY_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		IM = PY_VALUE;
		mode_display(PY_VALUE, outptr, cms);
		return 0;
	}

	if (in_c == SW_FUNCTION || in_c == SW_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		IM = SW_VALUE;
		mode_display(SW_VALUE, outptr, cms);
		return 0;
	}

	if (in_c == CS_FUNCTION || in_c == CS_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		exter_code_count = 0;
		IM = CS_VALUE;
		mode_display(CS_VALUE, outptr, cms);
		return 0;
	}

	if (in_c == JJ_FUNCTION || in_c == JJ_CTL) {
		if (IM == SUN_VALUE ) {
			out_sun_ipy = 1;
			fullcode_switch_out(outptr, cms);
		}
		IM = JJ_VALUE;
		lx_mode = 1;
		mode_display(JJ_VALUE, outptr, cms);
		return 0;
	}

	if ((i = im_switch_no(in_c)) >= 0) {	/* User defined IM */
		if (i != IM) {
			IM = i;
			if (im[i].c_tab == NULL)
				read_code_table(i);
			mode_display(i, outptr, cms);
			cms_init(cms);
			reset_range(cms);
		}
/* Added by Brian.Yuan 98-05-08 
 * Fix  bug 4136348 : F5 doesn't work properly in chinese input mode of zh locale*/
		mode_display(i, outptr, cms);
		return 0;
	}

	if (in_c == LX_KEY) {
		/* Setting or Cancel Lian-Xian mode */
		if ((IM == JJ_VALUE) || (IM == PY_VALUE) || (IM == SW_VALUE)) {
			lx_mode = (lx_mode == 1) ? 0 : 1;
		};
		cm_to_env_NOP(outptr);
		return 0;
	}

	return 0;
}


input_character(cms, in_c, inptr, outptr)
        Cm_session      cms;
        u_int           in_c;
        struct env_to_cm *inptr;
        struct cm_to_env *outptr;
{
	int             illegal, abort, str_len;
	e_char          merg_str[8];
	u_short         Chinese_char;
	int		i;
	struct cm_to_env *tp;

	/* Input_enter: */
	if ((S_state) && (LEGAL_SELECTION(in_c))) {
		/* Selection State and Legal selection keys  */
		abort = ABORT_SELECTION(in_c);
		illegal = SELECTION_TO_INTEGER(in_c);
		/* new luc */
		if (root_window && IM == JJ_VALUE && exter_code_count > 2)
			illegal = n_gold_phr_luc;
		if (abort || (illegal >= r_cc) || (illegal < 0)) {
			fprintf(stderr, "%s", alarm_string);
			Init(cms);
			cm_to_env_NOP(outptr);
			return 0;
		}
		Init(cms);
		in_c = illegal;			/* legal selections */
		/*
		 * Reset preedit first, then do commit.
		 */
		outptr->ce_operation = ENV_INTERM_RESET;
		tp = alloc_env(outptr);

		if (lx_mode && (vn_input_init) && (is_dfhj_key(in_c))) {
			vn_input_init = 0;
			merg_str[0] = S_candidate[in_c - 1][0];
			merg_str[1] = S_candidate[in_c - 1][1];
			merg_str[2] = S_candidate[in_c][0];
			merg_str[3] = S_candidate[in_c][1];
			merg_str[4] = (e_char)NULL;
			tp->ce_string = merg_str;
			tp->ce_size = strlen((char *)merg_str);
		} else {
			tp->ce_string = S_candidate[in_c];
			abort = strlen((char *)S_candidate[in_c]);
			tp->ce_size = abort;
		}

		tp->ce_operation = ENV_COMMIT;
		tp = alloc_env(tp);

		/* Here,abort and illegal are tmp variables */
		if (lx_mode) {
			abort = strlen((char *)S_candidate[in_c]);
			illegal = (S_candidate[in_c][abort - 2]);
			in_c = (S_candidate[in_c][abort - 1]);
		} else {
			illegal = 0;
			in_c = 0;
		}
		if (vn_lx((u_char) illegal, (u_char) in_c, cms)) {
			/*
			 * At the present,Associated by a  Chinese
			 * character, Should associted by  a Chinese
			 * phrase after the release.
			 */
			vn_input_init = 0;
			tp->ce_operation = ENV_INTERM_RESET;
			tp = alloc_env(tp);
			S_state = 1;
			S_candidate = selections;
			tp->ce_operation = ENV_SELECT;
			tp->ce_ncandidate = S_ncandidate;
			tp->ce_candidate = S_candidate;
			tp->ce_nextexist = NULL;
			tp->ce_prevexist = NULL;
			tp->ce_next = (struct cm_to_env *) NULL;
		} else {
			tp->ce_operation = ENV_SELECT_END;
			tp->ce_next = (struct cm_to_env *) NULL;
		}
		return 0;
	}		/* End of if(S_state....)	 */

	/*  Enter_Chinese_process_point: */
	in_c = E_to_Chinese(inptr->ec_key, cms);
	if ( in_c == -1 )
		return(-1);

	/* Back_Chinese_process_point: */
	if (in_c == RE_STRING && !(root_window && IM == JJ_VALUE
			      && exter_code_count > 2) ) {
		/*
		 * CM commits a string to ENV, the string be pointed
		 * by c_string, as a result, the string will be sent
		 * to the AP by ENV.
		 */
		/* Commit_string: */
		outptr->ce_operation = ENV_INTERM_RESET;

		tp = alloc_env(outptr);
		tp->ce_operation = ENV_COMMIT;
		tp->ce_string = c_string;
		tp->ce_size = strlen((char *)c_string);

		tp = alloc_env(tp);

		c_c = 0;
		Init(cms);

		tp->ce_operation = ENV_SELECT_END;
		tp->ce_next = (struct cm_to_env *) NULL;
	} else if (in_c == RE_INTERM) {
		if (r_cc == 1) {
			/*
			 * only get one selection choice here,
			 * commit the string now.
			 */
			Init(cms);	/* Resetting... */

			outptr->ce_operation = ENV_INTERM_RESET;

			tp = alloc_env(outptr);
			tp->ce_operation = ENV_COMMIT;
			tp->ce_string = selections[0];
			str_len = strlen((char *)selections[0]);
			tp->ce_size = str_len;

			tp = alloc_env(tp);

			Chinese_char = (selections[0][str_len - 2]);
			in_c = (selections[0][str_len - 1]);
			if (lx_mode &&
			    vn_lx((u_char)Chinese_char, (u_char)in_c, cms)) {
				S_state = 1;
				S_candidate = selections;
				tp->ce_operation = ENV_SELECT;
				tp->ce_ncandidate = S_ncandidate;
				tp->ce_candidate = S_candidate;
				tp->ce_nextexist = NULL;
				tp->ce_prevexist = NULL;
			} else {
				tp->ce_operation = ENV_SELECT_END;
			}
			tp->ce_next = (struct cm_to_env *) NULL;
		} else if (r_cc > 1 ||
		    (r_cc == 1 && root_window && IM == JJ_VALUE)) {
			/* Collision codes  and interm_region */
			/* Collision_OR_interm_disp: */
			S_state = 1;
			S_candidate = selections;
			outptr->ce_operation = ENV_SELECT;
		    /* new luc */
		    if ( r_cc > 1
				&& root_window
				&& IM == JJ_VALUE
				&& exter_code_count > 2) {
			outptr->ce_ncandidate = 1;
			outptr->ce_candidate =
					selections + n_gold_phr_luc;
		    } else {
			outptr->ce_ncandidate = S_ncandidate;
			outptr->ce_candidate = S_candidate;
		    }
			outptr->ce_nextexist = NULL;
			outptr->ce_prevexist = NULL;
			tp = alloc_env(outptr);
			tp->ce_operation = ENV_INTERM;
			tp->ce_cursor_type = ATTR_BKGND_MASK;
			tp->ce_cursor = strlen((char *)DISP_BUF);
			tp->ce_text = &DISP_BUF[0];
			tp->ce_text_attr = &DISP_ATTR[0];
			tp->ce_v_pos = strlen((char *)DISP_BUF);
			tp->ce_v_type = POS_END;
			tp->ce_next = (struct cm_to_env *) NULL;
		} else if ((exter_code_count) && (r_cc == 0)) {
			/* No repeat_code ,just display interm_region */
			/* Only_interm_display: */
			outptr->ce_operation = ENV_INTERM;
			outptr->ce_cursor_type = ATTR_BKGND_MASK;
			outptr->ce_cursor = strlen((char *)DISP_BUF);
			outptr->ce_text = &DISP_BUF[0];
			outptr->ce_text_attr = &DISP_ATTR[0];
			outptr->ce_v_pos = 1 /* strlen(DISP_BUF) */ ;
			outptr->ce_v_type = POS_END;
			tp = alloc_env(outptr);
			tp->ce_operation = ENV_SELECT_END;
			tp->ce_next = (struct cm_to_env *) NULL;
		} else {
			/*
			 * Nothing will be committed.
			 */
			outptr->ce_operation = ENV_SELECT_END;
			tp = alloc_env(outptr);
			tp->ce_operation = ENV_INTERM_RESET;

			tp = alloc_env(tp);
			tp->ce_string = interm_null;
			tp->ce_operation = ENV_COMMIT;
			tp->ce_next = (struct cm_to_env *)NULL;
		}	/* End of r_cc */
	}		/* End of return's E_to_Chinese */
	mode_switching = 0;
	return 0;
}


_cm_close(cm_id, cms)
	int             cm_id;
	Cm_session      cms;
{
	int i, k;

#ifdef DEBUG
	fprintf(stderr,"Chinese cm_close is called successfully\n");
#endif

	if (cm_id) {
		fprintf(stderr, " Use inconsistently CM ID.\n");
		return(-1);
	}

	free( (char *)cmscreen[cms] );
	cmscreen[cms] = (struct CM_screen *)NULL;

	k = -1;
	for (i=0; i<MAX_SESSION; i++)
		if (cmscreen[i] != (struct CM_screen *)NULL )
			k = i;

	if( k < 0 ) {
		zhineng_close();
	}

	return 0;
}

/*
 * env_to_cm_ERROR(inptr->ec_operation):
 *		 Display some information indicating ERROR condition.
 */
env_to_cm_ERROR(operation_code)
	Operation_type  operation_code;
{
	fprintf(stderr, "ERROR condition in ec_operation: %d\n", operation_code);
	fprintf(stderr, "%s", alarm_string);
}

#ifdef	DEBUGGING
/*
 * Displaying some message for DEBUGGING.
 * B_trace(string) 	is to print a character string on  the  system console.
 * trace_I(integer) 	is to print an integer on the   system console
 * trace_C(char) 	is to print a character on  the  system console.
 * Those functions are very simple and neglectful.
 */

B_trace(s)
	char            s[];
{
	int             fd, count;
	fd = open("/dev/console", O_RDWR);
	if (fd == -1) {
		perror("an error occurs in B_trace()");
		return;
	}
	count = strlen(s);
	write(fd, s, count);
	close(fd);
}

trace_I(i)
i	int i;
{
	fprintf(stderr, "This is a INTEGER: %d\n", i);
}

trace_C(cc)
	e_char cc;
{
	e_char          str[2];
	B_trace(" This is a CHAR: ");
	str[0] = cc;
	str[1] = 0;
	B_trace(str);
	B_trace(" \n");
}
#endif				/* DEBUGGING */

/*
 * E_to_Chinese is a very important function, Each input method is only
 *		one of situations in the function E_to_Chinese.
 *
 * E_to_Chinese(string)'s feature:
 * Function:
 *		To translate a external input code(ascii key) string into
 *		Chinese internal code  string (EUC string) which represent
 *		Chinese characters inside computer systems,a Chinese character
 *		internal code shall be two bytes. The leading byte in a Chinese
 *		character internal code be called the  first  byte  and  the
 *		following byte be called the second byte.
 * Input parameter:
 *		a character which is a external input code(Ascii key) .
 * Return value:
 *		RE_INTERM	To display entire intermediate region and
 *				process repeat Chinese code according to globl
 *				variable r_cc;
 *		RE_STRING	Commiting Chinese string or English string to
 *				send to ENV.
 *		Non		NULL
 * Note:
 * 	Phrase "Input mode" is the same as Phrase "Input method".
 * 	Phrase "Internal code" is the same as "Internal Chinese code".
 * 	Phrase "External code" is the same as "External input code".
 * 	"EUC"  is  a short hand of  Extended Unix Code in the file.
 */
int
E_to_Chinese(str, cms)
	e_char          str;
	Cm_session	cms;
{
	unsigned int chinese_symbol;

	c_c = 0;

	switch (IM) {
	case QW_VALUE:		/* Location Input Mode process	 */
		location(str, cms);
		break;
	case SW_VALUE:
	case PY_VALUE:		/* pinyin and stroke mode processing	 */
		pinyin_shouwei(str, cms);
		break;
	case JJ_VALUE:		/* Jinjian code processing	 */
		if ( zhineng(cms, str) == -1 )
			return(-1);
		break;
/*
	case CZ_VALUE:		/* Phrase code processing. 	 */
/*
		phrase2(1, str, c_string, selections, cms);
		/* Searching for the phrase of 3,4,5,6,and more Chars */
/*
		call_3456m(cms);
		break;
*/
	case CS_VALUE:		/* new mode -- roxon */
		chinese_symbol = to_Chinese_symbols(str);
		if (chinese_symbol & 0xff00) {
			c_string[c_c++] = (chinese_symbol & 0xff00) >> 8;
			c_string[c_c++] = (chinese_symbol & 0xff);
		} else {
			c_string[c_c++] = str;
		}
		break;
	case ASCII_VALUE:	/* Ascii code	 */
	default:
		c_string[c_c++] = str;
		break;
	}
	c_string[c_c] = 0;
	if (c_c) {		/* Are there any string need to commit ? */
		return (RE_STRING);	/* Yes	 */
	} else {
		return (RE_INTERM);	/* No	 */
	}
}				/* End of E_to_Chinese */

/*
 * location()'s  feature:
 * Function:
 *		Translating external location code into Chinese internal code;
 *		the location code is represented by qu-wei number from 1 - 94,
 *		This combination is divided into 94 sections vertically
 *		(DISP_BUF[0],DISP_BUF[1]), and is  identified by the first byte; 
 *		it is  divided into 94 positions horizontally(DISP_BUF[2], 
 * 		DISP_BUF[3]) and is identified by the second byte.
 * Input parameter:
 *		str is an (e_char) character ;
 * Return value:
 *		NON( c_string in implied mode).
 * Phrase "qu-wei" is the same as "sections and positions".
 */
location(str, cms)
	e_char          str;
	Cm_session	cms;
{
	register e_char Chinese_char;

	if (IS_DELETE(str)) {
		if (exter_code_count) {
			exter_code_count--;
			DISP_BUF[exter_code_count] = 0x0;
		} else {
			c_string[c_c++] = str;
		}
		;
	} else if ((str >= 0x30) && (str <= 0x39)) {
		DISP_BUF[exter_code_count] = str;
		DISP_ATTR[exter_code_count] = ATTR_REVERSE;
		exter_code_count++;
		DISP_BUF[exter_code_count] = 0;	/* NULL terminated */
		if (exter_code_count == MAX_INPUT_CODE_LEN) {
			if (is_location_key(cms)) {
				/* First byte in a Chinese character */
				Chinese_char = (DISP_BUF[0] - 0x30) * 10;
				Chinese_char += DISP_BUF[1];
				Chinese_char += 0x70; /* 0x70==0x80+0x20-0x30 */
				c_string[c_c++] = Chinese_char;

				/* Second byte in a Chinese character */
				Chinese_char = (DISP_BUF[2] - 0x30) * 10;
				Chinese_char += DISP_BUF[3];
				Chinese_char += 0x70; /* 0x70==0x80+0x20-0x30 */
				c_string[c_c++] = Chinese_char;
			}
			exter_code_count = 0;
			DISP_BUF[0] = DISP_BUF[1] = DISP_BUF[2] = DISP_BUF[3] = 0;
			DISP_ATTR[0] = DISP_ATTR[1] = DISP_ATTR[2] = DISP_ATTR[3] = 0;
		};
	} else {
		if (exter_code_count == 0) {
			c_string[c_c++] = str;
		} else {
			printf("\007");
			fflush(stdout);
		}
	}
	DISP_LEN = exter_code_count;
	return;
}

is_location_key(cms)
Cm_session cms;
{
	register int    dim1, dim2;

	dim1 = (DISP_BUF[0] - 0x30) * 10;
	dim1 += (DISP_BUF[1] - 0x30);
	dim2 = (DISP_BUF[2] - 0x30) * 10;
	dim2 += (DISP_BUF[3] - 0x30);
	if ((dim1 < 1) || (dim2 < 1) || (dim1 > 94) || (dim2 > 94))
		return (0);
	else
		return (1);
}

/*
 * pinyin_shouwei()'s  feature:
 * Function:
 *		Translatting PY or SW external input code into internal code;
 * Input parameter:
 *		str is an (e_char) character ;
 * Return:
 *		None( c_string).
 * Note:	"shouwei" means stroke.
 */
pinyin_shouwei(str, cms)
	e_char          str;
	Cm_session	cms;
{
	register int    null_input = 1;

	if (IS_DELETE(str)) {
		if (process_delete(cms))
			null_input = 0;
	} else if (IS_PAGE_F(str)) {
		if (exter_code_count) {
			if (s_direction) {
				s_direction = 0;
				s_end = s_pointer;
				s_pointer = p_pointer + 1;
			}
			null_input = 0;
		}
	} else if (IS_PAGE_B(str)) {
		if (exter_code_count) {
			if (s_direction == 0) {
				s_direction = 1;
				s_end = s_pointer;
				s_pointer = p_pointer - 1;
			}
			null_input = 0;
		}
	} else if ((PS_LEGAL_INPUT_KEY(str)) ||
		   ((str == '[') && exter_code_count)) {

		if ((exter_code_count == MAX_INPUT_CODE_LEN)
		    || ((r_cc == 0) && exter_code_count)) {
			Init(cms);	/* Reset */
			return;
		}
		DISP_BUF[exter_code_count] = str;
		DISP_ATTR[exter_code_count++] = ATTR_REVERSE; /* ATTR_REVERS */ ;
		DISP_BUF[exter_code_count] = 0;
		s_pointer = 0;
		s_end = S_NUMBER - 1;
		s_direction = 0;
		null_input = 0;
	}

	if (null_input) {
		c_string[c_c++] = str;
		/*
		 * To set c_string string NULL, when E_to_Chinese() function
		 * return.
		 */
		Init(cms);
		return;
	}
	if (exter_code_count) {	/* There are external input code. */
		p_pointer = s_pointer;
		Search(cms);	/* Searching for scan-table */
		/*
		 * When searching backward, the order is opposite of forward,
		 * the easiest (but not best) way is to swap.
		 */
		if (s_direction)
			swap_array(selections, r_cc);
	}
}				/* End of pinyin_shouwei function	 */

swap_array(array, n)
	register e_char	**array;
	int		n;
{
	register int	head = 0, tail = n - 1;
	register e_char	*tmp;

	while (head < tail) {
		tmp = array[head];
		array[head++] = array[tail];
		array[tail--] = tmp;
	}
}

/*
 * Search()'feature:
 * Function:
 *		Searching  scan-table .
 * Common variable:
 *	DISP_BUF[],exter_code_count,c_cm_scan_table, s_pointer,s_end, p_pointer.
 * Input parameter:
 *		None( Common variables ).
 * Return:
 *		None.
 */
Search(cms)
Cm_session cms;
{
	register u_char c1, c2, c3, c4;
	struct pinyin_stroke_entry *scaner_code_ptr;
	r_cc = 0;		/* repeating_code  counter,extern integer
				 * variable */
	c1 = c2 = c3 = c4 = 0;
	vn_input_init = 0;
	switch (exter_code_count) {
	case 1:
		/*
		 * if(s_pointer == 0){ vn_input_init = 1; pick_up_tgzc();
		 * }else vn_input_init = 0;
		 */
		while (s_pointer != s_end) {	/* one key    searech  */
			scaner_code_ptr = (struct
			  pinyin_stroke_entry *) & c_cm_scan_table[s_pointer];
			if (IM == SW_VALUE) {
				c1 = (u_char) scaner_code_ptr->s1;
			} else {/* pin yin */
				c1 = (u_char) scaner_code_ptr->p1;
			}
			c1 |= 0x60;
			if (dec(c1, 0, 0, 0, cms)) {
				return;
			}
		}
		break;
	case 2:
		/* vn_input_init = 0; */
		while (s_pointer != s_end) {	/* Two key    searech  */
			scaner_code_ptr = (struct
			 pinyin_stroke_entry *) & c_cm_scan_table[s_pointer];
			if (IM == SW_VALUE) {
				c1 = (u_char) scaner_code_ptr->s1;
				c2 = (u_char) scaner_code_ptr->s2;
			} else {
				c1 = (u_char) scaner_code_ptr->p1;
				c2 = (u_char) scaner_code_ptr->p2;
			}
			c1 |= 0x60;
			c2 |= 0x60;
			if (c2 == 0x7b)
				c2 = 0x5b;	/* [ */
			if (dec(c1, c2, 0, 0, cms)) {
				return;
			}
		}
		break;
	case 3:
		/* vn_input_init = 0; */
		while (s_pointer != s_end) {	/* Three key searech  */
			scaner_code_ptr = (struct
			 pinyin_stroke_entry *) & c_cm_scan_table[s_pointer];
			if (IM == SW_VALUE) {
				/* (First + Last) Strike(2) + pinyin(1) */
				/* 5 bits + 5 bits + 5 bits */
				c1 = (u_char) scaner_code_ptr->s1;
				c2 = (u_char) scaner_code_ptr->s2;
				c3 = (u_char) scaner_code_ptr->p1;
			} else {
				c1 = (u_char) scaner_code_ptr->p1;
				c2 = (u_char) scaner_code_ptr->p2;
				c3 = (u_char) scaner_code_ptr->p3;
			}
			c1 |= 0x60;
			c2 |= 0x60;
			if (c2 == 0x7b)
				c2 = 0x5b;	/* [ */
			c3 |= 0x60;
			if (c3 == 0x7b)
				c3 = 0x5b;	/* [ */
			if (dec(c1, c2, c3, 0, cms)) {
				return;
			}
		}		/* End of while loop */
		break;
	case 4:
		/* vn_input_init = 0; */
		while (s_pointer != s_end) {	/* Three key searech  */
			scaner_code_ptr = (struct
			 pinyin_stroke_entry *) & c_cm_scan_table[s_pointer];
			if (IM == SW_VALUE) {
				/* (First + Last) Strike(2) + pinyin(2) */
				/* 5 bits + 5 bits + 10 bits */
				c1 = (u_char) scaner_code_ptr->s1;
				c2 = (u_char) scaner_code_ptr->s2;
				c3 = (u_char) scaner_code_ptr->p1;
				c4 = (u_char) scaner_code_ptr->p2;
			} else {
				/* 15 bits + 5 bits */
				c1 = (u_char) scaner_code_ptr->p1;
				c2 = (u_char) scaner_code_ptr->p2;
				c3 = (u_char) scaner_code_ptr->p3;
				c4 = (u_char) scaner_code_ptr->s1;
			}
			c1 |= 0x60;
			c2 |= 0x60;
			c3 |= 0x60;
			c4 |= 0x60;
			if (c2 == 0x7b)
				c2 = 0x5b;	/* [ */
			if (c3 == 0x7b)
				c3 = 0x5b;	/* [ */
			if (c4 == 0x7b)
				c4 = 0x5b;	/* [ */
			if (dec(c1, c2, c3, c4, cms)) {
				return;
			}
		}		/* End of while loop */
	}			/* End of switch	 */
	return;
}				/* End of Search	 */


/*
 * dec()'s feature:
 * Function:
 *		Translating s_pointer which is pointer in the scaner table into
 *		Chinese internal code. Similar with DEC in CCDOS.
 * Input parameter:
 *		cc is a  external inputing-combining code.
 *		ss is a  entry-content in scaner table.
 * Return:
 * 		if( rc==Maximum_Cans  )
 *			return(1)
 *		else
 *			return(0)
 */
dec(c1, c2, c3, c4, cms)
	u_char          c1, c2, c3, c4;
	Cm_session	cms;
{
	e_char          *ss1_tmp;
	u_short         x;
	if (compare3(c1, c2, c3, c4, cms)) {
		x = ((s_pointer / 0x5e + 0xb0) << 8) + s_pointer % 0x5e + 0xa1;
		ss1_tmp = (e_char *) my_malloc(4);
		ss1_tmp[0] = (x >> 8) & 0xff;
		ss1_tmp[1] = x & 0xff;
		ss1_tmp[2] = 0;
		ss1_tmp[3] = 0;
		selections[r_cc] = ss1_tmp;
		r_cc++;
	}
	if (s_direction == 0)
		s_pointer = (s_pointer + 1) % S_NUMBER;
	else
		s_pointer = ((s_pointer - 1) >= 0) ? (s_pointer - 1) : S_NUMBER;
	if (r_cc == Maximum_Cans)
		return (1);
	else
		return (0);
}

/*
 * Program_name:	process_delete.
 * Function:		processing delete key under the Chinese input mode.
 * Return:
 *			1  Deleting external input code(Intermediate region) .
 *			0  Deleting text character(Application Program).
 */

process_delete(cms)
Cm_session cms;
{
	if (exter_code_count) {
		exter_code_count--;
		DISP_BUF[exter_code_count] = 0x0;
		DISP_BUF[exter_code_count + 1] = 0;

		s_direction = s_pointer = r_cc = 0;
		s_end = S_NUMBER - 1;
		return (1);
	} else
		return (0);
}

/*
 	Reset all Chinese-translatting state.
 */
Init(cms)
Cm_session cms;
{
	S_state = 0;
	exter_code_count = 0;
	DISP_BUF[0] = 0;
	r_cc = 0;
	s_pointer = 0;
	s_end = S_NUMBER - 1;
	s_direction = 0;
}


pick_up_tgzc(cms)
Cm_session cms;
{
	e_char          *ss1_tmp;
	int             i, j;
	j = DISP_BUF[0] - 0x61;
	for (i = 0; i < 10; i++) {
		ss1_tmp = (e_char *) my_malloc(3);
		ss1_tmp[0] = (c_cm_tgzc[j][i] >> 8) & 0xff;
		ss1_tmp[1] = (c_cm_tgzc[j][i]) & 0xff;
		ss1_tmp[2] = 0;
		selections[r_cc] = ss1_tmp;
		r_cc++;
	}
}


/*
 * is_selections()
 * Input parameter:
 *		x : is a Chinese internal code , which has two bytes.
 * Return value:
 *		if(truth)
 *			return(1)
 *		else
 *			return(0);
 *
 */
is_selections(x, cms)
	u_short         x;
	Cm_session	cms;
{
	u_short         j = 0;
	u_short        jj;
	while (j != r_cc) {
     		/* modified to make the code work on both sparc and i386 
		 * jj = (u_short *) selections[j]; 
		 */
		jj = (u_short) ((selections[j][0] & 0xff) << 8);
		jj += (u_short) (selections[j][1] & 0xff);
		if (x == jj)
			return (1);
		j++;
	}
	return (0);
}

is_dfhj_key(ii)
	u_int           ii;
{
	ii &= 0xff;
	switch (ii) {
	case 3:
	case 5:
	case 7:
	case 9:
		return (1);
	default:
		return (0);
	}
}


/*
 * Function:
 *		Dispalying message on the Mode region .
 * Input parameter:
 *		value is a Chinese mode value.
 *		Outptr is a pointer to cm_to_env.
 * Return value:
 *		None.
 */
mode_display(value, outptr, cms)
	int             value;
	struct cm_to_env *outptr;
	Cm_session	cms;
{
	struct cm_to_env *eptr;
	struct cm_to_env *tp;

	exter_code_count = 0;	/* reset exter_code_count */
	S_state = 0;
	r_cc = 0;

	if (out_sun_ipy) {
		eptr = alloc_env(outptr);
	} else {
		eptr = outptr;
	}

	switch (value) {
	case QW_VALUE:
		eptr->ce_string = (e_char *) QW_STRING;
		break;
	case PY_VALUE:
		eptr->ce_string = (e_char *) PY_STRING;
		break;
	case SW_VALUE:
		eptr->ce_string = (e_char *) SW_STRING;
		break;
/*
	case QK_VALUE:
		eptr->ce_string = (e_char *) QK_STRING;
		break;
	case CZ_VALUE:
		eptr->ce_string = (e_char *) CZ_STRING;
		break;
*/
	case CS_VALUE:				/* new mode -- roxon */
		eptr->ce_string = (e_char *) CS_STRING;
		break;
	case JJ_VALUE:
		eptr->ce_string = (e_char *) JJ_STRING;
		break;
	case SUN_VALUE:
		eptr->ce_string = (e_char *) SUN_STRING;
		break;
	case SWITCH_MODE_VALUE:
		eptr->ce_string = (e_char *) SWITCH_MODE_STRING;
		break;
	case ASCII_VALUE:
		eptr->ce_string = (e_char *) END_STRING;
		break;
	default:
		if (value >= USER_IM_ST) {
			eptr->ce_string = im[value].message;
			break;
		} else {
			/* fprintf(stderr,"%s",alarm_string); */
			cm_to_env_NOP(eptr);
			return;
		}
	};

	if ( out_sun_ipy ) {
		eptr->ce_operation = ENV_SET_SIMPLE_MODE;
		eptr->ce_next = (struct cm_to_env *) NULL;
	} else {
		eptr->ce_operation = ENV_SET_SIMPLE_MODE;
		tp = alloc_env(eptr);
		tp->ce_operation = ENV_SELECT_END;

		tp = alloc_env(tp);
		tp->ce_operation = ENV_INTERM_RESET;

		tp = alloc_env(tp);
		tp->ce_string = interm_null;
		tp->ce_operation = ENV_COMMIT;
		tp->ce_next = (struct cm_to_env *) NULL;
	}

	out_sun_ipy = 0;

	return;
}

cm_to_env_NOP(env_ptr)
	struct cm_to_env *env_ptr;
{
	struct cm_to_env *tp;

	env_ptr->ce_operation = ENV_SELECT_END;

	tp = alloc_env(env_ptr);
	tp->ce_operation = ENV_INTERM_RESET;

	tp = alloc_env(tp);
	tp->ce_string = interm_null;
	tp->ce_operation = ENV_COMMIT;
	tp->ce_next = (struct cm_to_env *) NULL;
}


/*
 * zhineng() feature:
 * Functions:
 *	Explainning external input code into standard Chinese internal code .
 * Input Paramter:
 *		str is a char.
 * Return:
 *		common Variables the same as pinyin_souwei .
 */
int
zhineng(cms, str)
	Cm_session	cms;
	u_char          str;
{
	register int    tmp1 = 0;
	int             null_input = 1;

	/* Must reset the collision variable before looking up */
	if (IS_DELETE(str)) {
		if (process_delete(cms)) {
			null_input = 0;
			zhxx_pointer_start = 0;
			zhxx_pointer_tmp = 0;
			zhxx_pointer_end = ZHXX_INDEX_LENGTH;
		}
		/* forward or back page  function */
	} else if (VN_PAGE_F(str)) {
		if (exter_code_count) {
			/* new luc */
			if ( root_window && r_cc > 0 && exter_code_count > 2) {
				n_gold_phr_luc ++;
				if ( n_gold_phr_luc >= r_cc )
					n_gold_phr_luc = 0;
				return(0);
			}

			null_input = 0;
			r_cc = 0;
			if (zhxx_direction) {
				/* start looking up at the beginning */
				zhxx_direction = 0;
				zhxx_pointer_start = 0;
				zhxx_pointer_tmp = 0;
				zhxx_pointer_end = ZHXX_INDEX_LENGTH;
			} else {
				tmp1 = 0;
				if (zhxx_read_state != 4)
					tmp1 = to_c_selections(cms);
				if (tmp1 != 0)	/* r_cc == Maximum_Cans	 */
					return(tmp1);
			}	/* End of s_direction */
		}		/* End of exter_code_count */
	} else if (VN_PAGE_B(str)) {
		if (exter_code_count) {
			/* new luc */
			if ( root_window && r_cc > 0 && exter_code_count > 2) {
				n_gold_phr_luc --;
				if ( n_gold_phr_luc < 0 )
					n_gold_phr_luc = r_cc -1;
				return(0);
			}

			null_input = 0;
			r_cc = 0;
			if (zhxx_direction == 0) {
				/*
				 * Start looking up at the end of index data
				 * table.
				 */
				zhxx_direction = 1;
				zhxx_pointer_start = ZHXX_INDEX_LENGTH -
					ZHXX_INDEX_ENTERY_LEN;
				zhxx_pointer_end = 0;
				zhxx_pointer_tmp = ZHXX_INDEX_LENGTH;
			} else {
				tmp1 = 0;
				if (zhxx_read_state != 4) {
					tmp1 = to_c_selections(cms);
				}
				if (tmp1 != 0 ) { /* r_cc == Maximum_Cans  */
					return(tmp1);
				}
			}
		}
	} else if (LEGAL_VN_KEY(str)) {
		if (exter_code_count == MAX_INPUT_CODE_LEN) {
			DISP_BUF[0] = DISP_BUF[1] = 0;
			DISP_BUF[2] = DISP_BUF[3] = 0;
			exter_code_count = 0;
			S_state = 0;
		}
		DISP_BUF[exter_code_count] = str;
		DISP_ATTR[exter_code_count++] = ATTR_REVERSE;
		DISP_BUF[exter_code_count] = 0;
		zhxx_pointer_start = 0;
		zhxx_pointer_tmp = 0;
		zhxx_pointer_end = ZHXX_INDEX_SIZE;
		zhxx_direction = 0;
		r_cc = 0;
		null_input = 0;
	}
	if (null_input) {
		c_string[c_c++] = str;
		Init(cms);
		return(0);
	}
	vn_input_init = 0;
	switch (exter_code_count) {
	case 0:
		r_cc = 0;
		c_c = 0;
		break;
	case 1:
	case 2:
		/*
		 Looking up a Chinese character which is in the level 1 or 2
		 */
		zhxx_pointer_tmp = zhxx_pointer_start;
		if ( zhineng_char_search(cms) == -1 )
			return (-1);
		break;
		/* Looking up the phrase tables	 */
	case 3:
		/*
		 * Added  2 lines for constanting input key length. *
		 */
		r_cc = 0;
		c_c = 0;
		break;
	case 4:
		/* new luc */
		if (r_cc != MAX_PHRASES) {
			phrase2(0, 0, c_string, selections, cms);
		}
		if (r_cc != MAX_PHRASES) {
			/* Phrases which be consisted of three Chinese Chars */
			ci3456_search(3, cms);
		}
		if (r_cc != MAX_PHRASES) {
			/* Phrases which be consisted of four Chinese Chars */
			ci3456_search(4, cms);
		}
		if (r_cc != MAX_PHRASES) {
			/* Phrases which be consisted of five Chinese Chars */
			ci3456_search(5, cms);
		}
		if (r_cc != MAX_PHRASES) {
			/* Phrases which be consisted of six Chinese Chars */
			ci3456_search(6, cms);
		}
		if (r_cc != MAX_PHRASES) {
			/*
			 * Phrases which be consisted of more than six Chinese
			 * Chars
			 */
			cim_search(cms);
		}
		break;
	default:
		fprintf(stderr, "There are illegal external code input keys");
		fprintf(stderr, "%s", alarm_string);
		/* Sending a BELL code to ENV */
		r_cc = 0;
		c_string[c_c++] = 0x07;
		break;
	}

	if ( r_cc > 0 ) {
		n_gold_phr_luc = 0;
	}

	return(0);
}

/*
 * zhineng_char_search()
 * Function:
 *	 According to exter_code_count, searching by one-key or two-keys.
 * Common variables:
 *	 DISP_BUF, exter_code_count, vn_input_init
 * Return:	None.
 */
int
zhineng_char_search(cms)
Cm_session cms;
{
	int	i;

	switch (exter_code_count) {
	case 1:
		if (zhxx_pointer_start == 0) {
			vn_input_init = 1;
			pick_up_tgzc(cms);
		}
		if (r_cc < Maximum_Cans) {
			i = vn_lookup(cms);
			if ( i == -1 )
				return (-1);
		}
		break;
	case 2:
		i = vn_lookup(cms);
		if ( i == -1 )
			return (-1);
		break;
	default:
		fprintf(stderr, " exter_code_count !=1 and 2 \n");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}			/* End of switch */
}

/*
 * vn_lookup()
 * Function:
 *	 According to exter_code_count, searching by one-key or two-keys.
 * Common variables:
 *	 DISP_BUF, exter_code_count, s_pointer, p_pointer, s_end, s_direction,
 *
 * Return:	None.
 */
int
vn_lookup(cms)
Cm_session cms;
{
	register char   code1, code2;
	register e_char tmp_char1, tmp_char2;
	e_char	*tmp_string;
	struct zhxx_index *zhxx_index_tmp;
	int             vn_tmp_tmp = 0;

	while (zhxx_pointer_start != zhxx_pointer_end) {
		if ((zhxx_pointer_start > ZHXX_INDEX_SIZE) ||
		    (zhxx_pointer_start < 0)) {
#ifdef __STDC__ 
			fprintf(stderr, " Sorry, Your operation is Error\n");
#else
			fprintf(" Sorry, Your operation is Error\n");
#endif
			fprintf(stderr, "%s", alarm_string);
			return(-1);
		}
		zhxx_index_tmp = (struct zhxx_index *)
			& zhxx_index_buf[zhxx_pointer_start];
		switch (exter_code_count) {
		case 1:
			/* There is one external input key */
			code1 = zhxx_index_tmp->pp[0];
			code2 = 0;
			break;
		case 2:
			/* There are two external input keys	 */
			code1 = zhxx_index_tmp->pp[0];
			code2 = zhxx_index_tmp->pp[1];
			break;
		default:
			/* It is wrong ,be ignore! */
			return(-1);
		}		/* End of switch-case	 */
		if (compare3(code1, code2, 0, 0, cms)) { /* 1 means equals */
			tmp_char1 = zhxx_index_tmp->hz[0];
			tmp_char2 = zhxx_index_tmp->hz[1];
			if (!is_selections((tmp_char1 << 8) + tmp_char2, cms)) {
				tmp_string = (e_char *) my_malloc(4);
				tmp_string[0] = tmp_char1;
				tmp_string[1] = tmp_char2;
				tmp_string[2] = 0;
				selections[r_cc++] = tmp_string;
			}
			zhxx_offset = zhxx_index_tmp->zhxx_offset;
			zhxx_read_state = 0;
			vn_tmp_tmp = to_c_selections(cms);
			if ( vn_tmp_tmp == -1 )
				return(-1);
		}
		/* Adjusting searching pointer: zhxx_pointer_start */
		switch (zhxx_direction) {
		case 0:	/* forward searching operation */
			if (zhxx_pointer_start == ZHXX_INDEX_SIZE) {
				zhxx_pointer_start = 0;
			} else {
				zhxx_pointer_start += ZHXX_INDEX_ENTERY_LEN;
			}
			break;
		case 1:	/* Backward searching operation */
			if (zhxx_pointer_start) {
				zhxx_pointer_start -= ZHXX_INDEX_ENTERY_LEN;
			} else {
				zhxx_pointer_start = ZHXX_INDEX_SIZE;
			}
			break;
		default:
			fprintf(stderr, " Illegal searching in VN\n");
			fprintf(stderr, "%s", alarm_string);
			return(-1);
		}
		if (vn_tmp_tmp) {	/* repeat count == Maximum_Cans */
			break;
		}
	}			/* Loop of the while(s_pointer != s_end) */
	return(0);
}


/*
 *gbfl2_search():
 * 		Looking up GBFL4.F.2 data file table. Function gbfl2_search is
 *	for searching  the level 2 Chinese characters.
 *	********* Not Used in the release *********
*/

/*
 * level2_selections():
 *		Sending  a second level  Chinese code strings  to
 *	 selections .
 *	********* Not Used in the release *********
 */

/*
 * file_length():
 *		getting a (FILE *) file  length.
 *	********* Not Used in the release *********
 */
file_length(fd)
	FILE           *fd;
{
	int             fd1;
	struct stat     buf;
	fd1 = fileno(fd);
	fstat(fd1, &buf);
	return (buf.st_size);
}

/*
 * read_line():	Read into a line from (FILE *)fd file .
 */
read_line(fd, str)
	FILE           *fd;
	e_char         *str;
{
	register int    read_i;
	e_char          read_c;
	read_i = 0;

	while (((read_c = fgetc(fd)) != '\n') && (read_c != 0xff)) {
		str[read_i] = read_c;
		read_i++;
	}
	if (read_c == '\n') {
		if ((read_c = fgetc(fd)) == '\n') {
			str[read_i++] = '\n';
		} else {
			fseek(fd, -1, FILE_CURRENT_POSITION);
		}
	}
	if (read_i) {
		str[read_i++] = '\n';
		str[read_i] = 0;
		return (1);
	} else {
		return (0);
	}
}

/*
 * read_line_re():
 *		reading line ,which is  opposite direction with read_line.
 *
 *		********** Not Used int the release ***********
 */
read_line_re(fd, str)
	FILE           *fd;
	e_char         *str;
{
	fseek(fd, -TYRK_LINE_LEN, 1);
	read_line(fd, str);
}


/*
 * to_c_selections()
 * Functions:
 *		Tong yin zi ==> selections array
 * Input parameter:
 *		None.
 *		(zhxx_read_state,zhxx_offset)
 * Return:
 *		1 :	r_cc == Maximum_Cans.
 *		0 :     r_cc <  Maximum_Cans
 */

int
to_c_selections(cms)
Cm_session cms;
{
	e_char 		*ss1_tmp;
	e_char          buf2[10];
	unsigned short  xx, xx2;
	if (r_cc == Maximum_Cans)
		return (1);
	while (zhxx_read_state != 4) {
		if (lseek(zhxx_file, zhxx_offset, 0) == -1) {
			perror("Can not seek");
			fprintf(stderr, "%s", alarm_string);
			return(-1);
		}
		if (read(zhxx_file, buf2, 3) == -1) {
			perror(" Can not read any file ");
			fprintf(stderr, "%s", alarm_string);
			return(-1);
		}
		zhxx_read_state++;
		while (buf2[0]) {
			xx2 = ((buf2[0] & 0xff) << 8);
			xx2 += (buf2[1] & 0xff);
			xx = ((xx2 >> 2) & 0x7f) + 0x80;
			xx += (((xx2 >> 1) & 0x7f00) + 0x8000);
			if ((is_selections(xx, cms) == 0)) {
				ss1_tmp = (e_char *) my_malloc(4);
				ss1_tmp[0] = ((xx >> 8) & 0xff);
				ss1_tmp[1] = (xx & 0xff);
				ss1_tmp[2] = 0;
				ss1_tmp[3] = 0;
				selections[r_cc] = ss1_tmp;
				r_cc++;
			}
			zhxx_offset += 3;	/* zhxx entry length */
			if (zhxx_offset == zhxx_data_size)
				zhxx_offset = 0;
			if (r_cc == Maximum_Cans) {
				zhxx_read_state--;
				return (1);
			}
			if (lseek(zhxx_file, zhxx_offset, 0) == -1) {
				perror("Can not seek");
				fprintf(stderr, "%s", alarm_string);
				return(-1);
			}
			if (read(zhxx_file, buf2, 3) == -1) {
				perror(" Can not read any file ");
				fprintf(stderr, "%s", alarm_string);
				return(-1);
			}
		}
		zhxx_offset += 3;	/* zhxx entry length */
		if (zhxx_offset == zhxx_data_size)
			zhxx_offset = 0;
	};
	return (0);
}


/*
 * zhineng_init(): open all read-write FILE's.
 */
int
zhineng_init()
{
	struct stat     stat_buf;
	e_char         *path_name_ptr, path_name[256], path_tmp[256];
	e_char	       *get_cle_path();

	path_name_ptr = get_cle_path();
	strcpy((char *)path_name, (char *)path_name_ptr);
	strcpy((char *)path_tmp, (char *)path_name_ptr);

	strcat((char *)path_name, "/ci2");
	ci2_file = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci3");
	ci3 = fopen((char *)path_name, "r");

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci4");
	ci4 = fopen((char *)path_name, "r");

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci5");
	ci5 = fopen((char *)path_name, "r");

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci6");
	ci6 = fopen((char *)path_name, "r");

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/cim");
	cim = fopen((char *)path_name, "r");
	/* ci3,ci4,ci5,ci6,cim are chi zhu FILEs */

	/* lx : lian xian table FILE	 */

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci2_array");
	lx_array_fd = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci2_b");
	ci2_b = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci3_b");
	ci3_b = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci4_b");
	ci4_b = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci5_b");
	ci5_b = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/ci6_b");
	ci6_b = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/cim_b");
	cim_b = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/zhxx_index");
	zhxx_index = open((char *)path_name, O_RDONLY);

	strcpy((char *)path_name, (char *)path_tmp);
	strcat((char *)path_name, "/zhxx");
	zhxx_file = open((char *)path_name, O_RDONLY);
	if ((lx_array_fd == -1) ||
	    (ci2_b == -1) ||
	    (ci3_b == -1) ||
	    (ci4_b == -1) ||
	    (ci5_b == -1) ||
	    (ci6_b == -1) ||
	    (cim_b == -1) ||
	    (zhxx_file == -1) ||
	    (zhxx_index == -1)) {
		perror("Can not open some data file");
		fprintf(stderr, "%s", alarm_string);
		fprintf(stderr, "Check your environment variables,please!\n");
		return(-1);
	}
	if (fstat(lx_array_fd, &stat_buf)) {
		perror("Accessing lx_array_fd file state information:");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
	lx_array_buf = (e_char *) malloc(stat_buf.st_size + 1);
	if (lx_array_buf == 0) {
		perror("Can not allocate memory space");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
	if (stat_buf.st_size != read(lx_array_fd, lx_array_buf, stat_buf.st_size)) {
		printf("%d==%d==\n", lx_array_fd, stat_buf.st_size);
		perror("Reading lx_array_fd file data message:");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
	read(zhxx_index, zhxx_index_buf, ZHXX_INDEX_SIZE);
	if (fstat(zhxx_file, &stat_buf)) {
		perror("Accessing zhxx file state information:");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
	zhxx_data_size = stat_buf.st_size;

	if (fstat(ci2_file, &stat_buf)) {
		perror("Accessing phrase data file state information:");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
	ci2_size = stat_buf.st_size;
	ci2_buf = (e_char *) mmap((caddr_t) NULL, ci2_size,
				  PROT_READ, MAP_SHARED,
				  ci2_file, (off_t) 0);
	if ( (int) ci2_buf == -1 ) {
		perror(" Can't map phrase file into memory");
		return(-1);
	}
	ci3_b_size = ci_b_size(ci3_b, &stat_buf);
	ci3_b_buf = ci_map(ci3_b, ci3_b_size, ci2_buf, 0);

	ci4_b_size = ci_b_size(ci4_b, &stat_buf);
	ci4_b_buf = ci_map(ci4_b, ci4_b_size, ci3_b_buf, 0);

	ci5_b_size = ci_b_size(ci5_b, &stat_buf);
	ci5_b_buf = ci_map(ci5_b, ci5_b_size, ci4_b_buf, 0);

	ci6_b_size = ci_b_size(ci6_b, &stat_buf);
	ci6_b_buf = ci_map(ci6_b, ci6_b_size, ci5_b_buf, 0);

	if (ci3_b_buf == NULL || ci4_b_buf == NULL ||
			ci5_b_buf == NULL || ci6_b_buf == NULL ) {
		perror(" Can not map dictionary");
		return(-1);
	}

	cim_b_size = ci_b_size(cim_b, &stat_buf);
	cim_b_buf = ci_map(cim_b, cim_b_size, ci6_b_buf, 0);
	if (map_dic(cim_b_buf) == NULL) {
		perror(" Can not map dictionary");
		return(-1);
	}
	return 0;
}

/*
 * ci_b_size():
 *		Get  size of a file .
 * Input parameter:
 *		fd  is  a file descriptor.
 *		stat is a pointer to struct stat.
 * Return:
 *		Size of a file.
 */
int
ci_b_size(fd, stat)
	int             fd;
	struct stat    *stat;
{

	if (fstat(fd, stat)) {
		perror("Accessing phrase data file state information:");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
	return (stat->st_size);
}

/*
 * ci_map():
 *		map pages of memory for a file.
 * Input parameter:
 *		fd is a file describtor.
 *		fd_size is size of the fd file.
 *		paddr is the process's address.
 *		off_set is the offset in the fd file .
 * Return:
 *		the address at which the mapping was palced.
 *		When a failing, EXIT.
 */
e_char *
ci_map(fd, fd_size, paddr, off_set)
	int             fd, fd_size;
	e_char         *paddr;
	off_t           off_set;
{
	e_char         *re_map;

	if ( fd_size <= 0 ) {
		perror("Can not map");
		return(NULL);
	}

	re_map = (e_char *) mmap((caddr_t) paddr, fd_size,
				 PROT_READ, MAP_SHARED,
				 fd, (off_t) off_set);
	if ((int) re_map == -1) {
		perror("Can not map");
		return(NULL);
	}
	return (re_map);
}


/*
	Close all read-write  FILE's.
 */
zhineng_close()
{
	/* ci3, ci4, ci5, ci6, cim */
	fclose(ci3);
	fclose(ci4);
	fclose(ci5);
	fclose(ci6);
	fclose(cim);

	close(lx_array_fd);

	close(ci2_file);
	close(ci2_b);
	close(ci3_b);
	close(ci4_b);
	close(ci5_b);
	close(ci6_b);
	close(cim_b);
	munmap((caddr_t)ci2_buf, ci2_size);
	munmap((caddr_t)ci3_b_buf, ci3_b_size);
	munmap((caddr_t)ci4_b_buf, ci4_b_size);
	munmap((caddr_t)ci5_b_buf, ci5_b_size);
	munmap((caddr_t)ci6_b_buf, ci6_b_size);
	munmap((caddr_t)cim_b_buf, cim_b_size);
	close(zhxx_index);
	close(zhxx_file);
}

/*
 * vn_lx(xx)
 * Functions:	Index LX(Assocition) table by xx which is a Chinese char code,
 *		  then sending all double words==>selections array,and waitting
 *		  selected by a user.
 * Input parameter:
 *		xx1 is the first Chinese internal code.
 *		xx2 is the second Chinese internal code.
 * Return:
 *		if(r_cc == Maximum_Cans)
 *			return(1);
 *		else 	return(0);
 */
vn_lx(xx1, xx2, cms)
	e_char          xx1;	/* a Chinese character internal code */
	e_char          xx2;
	Cm_session 	cms;
{
	register struct lx_array_entry *lx_array_pointer;
	register struct ci2_entry *ci2_entry_tmp;
	u_int           ci2_offset, ci2_count;
	u_short         xx, tmp_offset;
	e_char          *trans_str;

	xx = (xx1 << 8) + xx2;
	xx &= 0xffff;
	if ((xx < FIRST_CHINESE_CODE_1) || (xx > LAST_CHINESE_CODE_1)) {
		/* Not in the first level Chinese Library  */
		return (0);
	}
	if (IM != JJ_VALUE)
		return (0);

	tmp_offset = code_to_offset(xx1, xx2);
	lx_array_pointer = (struct lx_array_entry *) lx_array_buf;
	lx_array_pointer = &lx_array_pointer[tmp_offset];
	ci2_offset = lx_array_pointer->offset * 2;
	ci2_count = lx_array_pointer->count;

	while (ci2_count) {
		ci2_entry_tmp = (struct ci2_entry *) & ci2_buf[ci2_offset];
		trans_str = (e_char *) my_malloc(4);
		trans_str[0] = ci2_entry_tmp->sec21;
		trans_str[1] = ci2_entry_tmp->sec22;
		trans_str[2] = 0;
		trans_str[3] = 0;
		selections[r_cc++] = trans_str;
		ci2_count--;
		ci2_offset += 8;
		if (r_cc == Maximum_Cans) {
			break;
		}
	};
	if (r_cc)		/* There are some assocition phrases */
		return (1);
	else
		return (0);
}

/*
 * code_to_offset:
 *		Chinese code(2 bytes) ==> offset in the location table.
 */
code_to_offset(c_code1, c_code2)
	e_char          c_code1;
	e_char          c_code2;
{
	register u_short l_offset;

	l_offset = (c_code1 - 0xb0) * 94 + (c_code2 - 0xa1);
	return (l_offset);
}

/*
 * ci3456_search:
 * Function:	Look up ci3_b, ci4_b, ci5_b, and ci6_b cache phrase data files
 *		by external input code .
 * Input parameter:
 *		word_count is a number of Chinese characters which be used to
 *		compose a Chinese phrase. Here, word_count={3,4,5,6}.
 * common varaibles:
 *		ci3_b, ci4_b, ci5_b, ci6_b and so on.
 */
ci3456_search(word_count, cms)
	short           word_count;
	Cm_session	cms;
{
	register e_char c11, c12, c21, c31;
	e_char         *three_words;
	register e_char *buf;
	register u_int  si_count, ci3456_offset;
	off_t           si_size, array[MAX_RC], array_count, l_tmp;
	FILE           *f_tmp;

	switch (word_count) {
	case 3:
		l_tmp = 8;
		f_tmp = ci3;
		si_size = ci3_b_size;
		buf = ci3_b_buf;
		break;
	case 4:
		l_tmp = 10;
		f_tmp = ci4;
		si_size = ci4_b_size;
		buf = ci4_b_buf;
		break;
	case 5:
		l_tmp = 12;
		f_tmp = ci5;
		si_size = ci5_b_size;
		buf = ci5_b_buf;
		break;
	case 6:
		l_tmp = 14;
		f_tmp = ci6;
		si_size = ci6_b_size;
		buf = ci6_b_buf;
		break;
	default:
		fprintf(stderr, "This is a illegal word count\n");
		fprintf(stderr, "%s", alarm_string);
		break;
	}
	si_count = 0;
	array_count = 0;
	while (si_count != si_size) {
		c11 = buf[si_count + 0];
		c12 = buf[si_count + 1];
		c21 = buf[si_count + 2];
		c31 = buf[si_count + 3];
		if (compare3(c11, c12, c21, c31, cms)) {
			ci3456_offset = (si_count / 4);
			ci3456_offset *= (l_tmp - 1);
			array[array_count++] = ci3456_offset;
			/* new luc */
			if (array_count == MAX_PHRASES) {
				break;
			};
		}
		si_count += 4;
	}
	si_size = 0;
	while (si_size != array_count) {
		three_words = (e_char *) my_malloc(l_tmp);
		fseek(f_tmp, array[si_size++], 0);
		read_line(f_tmp, three_words);
		three_words[l_tmp - 2] = 0;
		selections[r_cc++] = three_words;
		/* new luc */
		if (r_cc == MAX_PHRASES)
			return;
	}
}

/*
 *	It is similar with ci3456_search function, but it look up cim_b
 */

cim_search(cms)
Cm_session cms;
{
	e_char          m_c11, m_c21, m_c31, m_cl1;
	register e_char *m_buf;
	register off_t  m_si_size, si_count;
	off_t           m_array_count, m_array[MAX_RC];
	off_t           m_tmp_tmp;

	m_array_count = 0;
	si_count = 0;
	m_tmp_tmp = 0;
	/* .....	 */
	while (si_count != cim_b_size) {
		m_c11 = cim_b_buf[si_count + 0];
		m_c21 = cim_b_buf[si_count + 1];
		m_c31 = cim_b_buf[si_count + 2];
		m_cl1 = cim_b_buf[si_count + 3];
		if (compare3(m_c11, m_c21, m_c31, m_cl1, cms)) {
			if (cim_b_buf[si_count + 4] == 0x7f) {
				m_tmp_tmp = 0;
			} else {
				m_tmp_tmp = (int) cim_b_buf[si_count + 4];
			}
			m_tmp_tmp = (m_tmp_tmp << 8);
			m_tmp_tmp += (int) cim_b_buf[si_count + 5];
			m_tmp_tmp &= 0xffff;
			m_array[m_array_count++] = m_tmp_tmp;
			/* new luc */
			if (m_array_count == MAX_PHRASES) {
				break;
			}
		}
		si_count += 6;
		;
	}

	m_si_size = 0;
	while (m_si_size != m_array_count) {
		m_buf = (e_char *) my_malloc(CIm_LINE_LEN);
		fseek(cim, m_array[m_si_size++], 0);
		read_line(cim, m_buf);
		m_tmp_tmp = strlen((char *)m_buf);
		m_buf[m_tmp_tmp - 1] = 0;
		selections[r_cc++] = m_buf;
		/* new luc */
		if (r_cc == MAX_PHRASES)
			return;
	}
	return;
}

/*
 * compare3(c1,c2,c3,c4)
 * Function:	to compare external input code with input parameters.
 * Input parameter:
 *		c1, c2, c3, c4 are characters.
 * Output parameter(Return value):
 *		1:	is equal.
 *		0:	is not equal.
 */

compare3(c1, c2, c3, c4, cms)
	e_char          c1, c2, c3, c4;
	Cm_session	cms;
{
	switch (exter_code_count) {
	case 1:
		if (c1 == DISP_BUF[0])
			return (1);
		else
			return (0);
	case 2:
		if ((c1 == DISP_BUF[0]) &&
		    (c2 == DISP_BUF[1]))
			return (1);
		else
			return (0);
	case 3:
		if ((c1 == DISP_BUF[0]) &&
		    (c2 == DISP_BUF[1]) &&
		    (c3 == DISP_BUF[2]))
			return (1);
		else
			return (0);
	case 4:
		if ((c1 == DISP_BUF[0]) &&
		    (c2 == DISP_BUF[1]) &&
		    (c3 == DISP_BUF[2]) &&
		    (c4 == DISP_BUF[3]))
			return (1);
		else
			return (0);
	default:
		fprintf(stderr, "COMPARE3:cannot be compare.\n");
		fprintf(stderr, "%s", alarm_string);
		return(-1);
	}
}


/*
 * hanzi_double_pin(hh1,hh2)
 *	u_short		hh1,hh2;
 *	hh is a HanZi internal code(two bytes).
 *			********** Not used. *******
 */

/*
 * call_3456m():
 *	searching for the 3, 4, 5, 6, and more than 6 Chinese characters
 *	phrases. It call ci3456_search() and cim_search().
 * Common varaible:
 *		r_cc, exter_code_count.
 */
call_3456m(cms)
Cm_session cms;
{

	switch (exter_code_count) {
	case 0:
	case 1:
	case 2:
	case 3:
		break;
	case 4:
		/* new luc */
		if (r_cc != MAX_PHRASES) {
			ci3456_search(3, cms);
		}
		if (r_cc != MAX_PHRASES) {
			ci3456_search(4, cms);
		}
		if (r_cc != MAX_PHRASES) {
			ci3456_search(5, cms);
		}
		if (r_cc != MAX_PHRASES) {
			ci3456_search(6, cms);
		}
		if (r_cc != MAX_PHRASES) {
			cim_search(cms);
		}
		break;
	default:
		break;
	}
	return;
}

/*
	Convert ASCII symbols (digits, letters of upper and lower cases,
	punctuations and some special symbols) into GB-80's.
	Note: the symbols in GB-80 are two bytes, and ocupy two columns.
 * Input parameter:
 *		eng_c	is a English key (Ascii key).
 * Return:
 *		Chinese code or eng_c;
 */
to_Chinese_symbols(eng_c)
	char            eng_c;
{
	unsigned        symbol;
	symbol = 0;
	switch (eng_c) {
	case '.':
		symbol = PERIOD;
		break;
	case ',':
		symbol = COMMAM;
		break;
	case '!':
		symbol = EXCLMM;
		break;
	case ':':
		symbol = COLONM;
		break;
	case '-':
		symbol = HYPHEN;
		break;
	case '^':
		symbol = CARETM;
		break;
	case '(':
		symbol = LPARNT;
		break;
	case '{':
		symbol = LCUBRT;
		break;
	case '`':
		symbol = ACCENT;
		break;
	case '[':
		symbol = LSQBRT;
		break;
	case '<':
		symbol = LESSTH;
		break;
	case '@':
		symbol = COMMAT;
		break;

	case '/':
		symbol = SOLDUS;
		break;
	case ';':
		symbol = SEMCLN;
		break;
	case '?':
		symbol = QUESTM;
		break;
	case '&':
		symbol = AMPERS;
		break;
	case ')':
		symbol = RPARNT;
		break;
	case '}':
		symbol = RCUBRT;
		break;
	case '\'':
		symbol = SNGQUO;
		break;
	case '"':
		symbol = DBLQUO;
		break;
	case ']':
		symbol = RSQBRT;
		break;
	case '>':
		symbol = GREATH;
		break;
	case '|':
		symbol = VERBAR;
		break;
	case '=':
		symbol = EQUALS;
		break;
	case '#':
		symbol = SGNNUM;
		break;
	case '$':
		symbol = DALLAR;
		break;
	case '%':
		symbol = PERCNT;
		break;
	case '*':
		symbol = SGNSTR;
		break;
	case '_':
		symbol = UNDSCR;
		break;
	case '\\':
		symbol = BCKSLH;
		break;
	case '~':
		symbol = STILDE;
		break;
	case '+':
		symbol = SGNADD;
		break;
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
                symbol = DIGITS + eng_c - 0x30;
                break;
 
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
                symbol = UPPERS + eng_c - 0x41;
                break;
        case 'a':
        case 'b':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
                symbol = LOWERS + eng_c - 0x61;
                break;
	default:
		symbol = (eng_c & 0xff);
		break;
	}
	;
	return (symbol);
}

display_help(outptr, cms)
	struct cm_to_env *outptr;
	Cm_session	cms;
{
	struct cm_to_env *tp;

	switch (IM) {
	case QW_VALUE:		/* Location mode processing	 */
	case PY_VALUE:		/* Pinyin   mode processing	 */
	case SW_VALUE:		/* Stroke   mode processing	 */
	case JJ_VALUE:		/* Jinjian  mode processing	 */
	case SUN_VALUE:
	default:
		/*
		 * Here is the first step for display HELP message. 
		 * The detail message will be discussed
		 */
		outptr->ce_operation = ENV_M_LABEL;
		outptr->ce_misc_text = Misc_string;
		tp = alloc_env(outptr);
		tp->ce_operation = ENV_M_INTERACTIVE;
		tp->ce_cursor = 0xff;
		tp->ce_cursor_type = 0xff;
		tp->ce_text = (e_char *) "Misc*";
		tp->ce_text_attr = (e_char *) "aaaaa";
		tp->ce_v_pos = 0xff;
		tp->ce_v_type = 0xff;
		tp->ce_next = (struct cm_to_env *) NULL;
	}
	return;
}

reset_on_error(outptr, cms)
struct cm_to_env *outptr;
Cm_session	cms;
{
	struct cm_to_env *tp;

	outptr->ce_operation = ENV_INTERM_RESET;
	tp = alloc_env(outptr);
	tp->ce_operation = ENV_SELECT_END;

	tp = alloc_env(tp);
	tp->ce_string = interm_null;
	tp->ce_operation = ENV_COMMIT;
	tp->ce_next = (struct cm_to_env *) NULL;

	Init(cms);
}

/*
 * new luc - negotiation upon CM_IMSERVER_NEGOTIATION in cm_put()
 */
void
luc_negotiation(inptr)
struct env_to_cm	*inptr;
{
    ImsCmNegotiation *negop =
		(ImsCmNegotiation *)inptr->ec_parameter.ep_string.e_keyptr;
    LucNegotiation *luc_neg = negop->luc;

    negop->cm_interested |= IM_CM_LUC_NEGOTIATED;
    luc_neg->ims_takes_control = 0;

    if ( luc_neg->label_type == LUC_LABEL_NUMERIC ) {
	luc_label_type = LUC_LABEL_NUMERIC;
	if ( luc_neg->choice_per_window > 10 ) {
	    Maximum_Cans = luc_neg->choice_per_window = 10;
	} else {
	    Maximum_Cans = luc_neg->choice_per_window;
	}
    } else {
	luc_label_type = luc_neg->label_type = LUC_LABEL_ALPHA_UPPER;
	if ( luc_neg->choice_per_window > MAX_RC ) {
	    Maximum_Cans = luc_neg->choice_per_window = MAX_RC;
	} else {
	    Maximum_Cans = luc_neg->choice_per_window;
	}
    }

    if ( luc_neg->luc_is_rootwindow ) {
	root_window = 1;
    } else {
	root_window = 0;
    }
}

#define BUFSIZE	2048

e_char *
my_malloc(size)
int	size;
{
	static  e_char	e_c_buf[BUFSIZE];
	static	int	p = 0;

	if (p + size >= BUFSIZE) 
		p = 0;
	p += size;
	return (e_char *)&e_c_buf[p-size];
}

