/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
#ifdef  sccs
static char     sccsid[] = "@(#)keybind.c	1.2 00/08/19";
#endif
#endif

/* 	Copyright (c) 1989 by   Sun Microsystems, Inc.		*/

#include	<stdio.h>
#include	<fcntl.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/mman.h>
#include	"cm_prc.h"

#define MAX_DIC	8

struct input_method *on_kb;
struct input_method *conversion_off;
struct input_method *location_kb;
struct input_method *pinyin_kb;
struct input_method *stroke_kb;
struct input_method *golden_kb;
struct input_method *full_code_kb;
struct input_method *ascii_kb;
struct input_method *chnsym_kb;		/* for new mode -- roxon */
struct input_method *mode_switch_kb;

struct input_method im[MAX_IM];		/* input methods:
					 * #0 - #9: coded in system 
					 * >= #10 : code table
					 */

struct dictionary dic[MAX_DIC];		/* user defined dictionaries */

#define	F_KEY	CM_TF_START	/* defined in cmkeys.h */

int	total_im;
int	default_im = ASCII_VALUE;
int	total_dic;

e_char * get_cle_path();
e_char path_temp[40];
extern char *getenv();

void
keybind_init()
{
	int	fd;
	caddr_t	buf;
	char  	line[256];
	char  	*path_name, path_buf[256];
	int	im_no;

	if ((path_name = getenv("KEYBIND")) == NULL) {
		path_name = path_buf;
        	sprintf(path_name, "%s/keybind.dat", get_cle_path());
	}

        if ((fd = open((char *)path_name, O_RDONLY)) == -1) {
		perror("Can not open keybinding file");
		exit(1);
	}
	buf = mmap(0, 4096, PROT_READ, MAP_SHARED, fd, 0);

	init_im();

	getline(&buf, line);
	if (strncmp(line, "%%CLE_DEFAULT", 13)) {
		perror("Keybinding file format error");
		exit(1);
	}

	for (total_im = USER_IM_ST, total_dic = 0, getline(&buf, line);
	    	line[0] != '\0' && strncmp(line, "%%", 2);  ) {
		if (*line == '%') {
			im_no = put_im_string(line);
			read_im_spec(im_no, &buf, line);
		} else {
			perror("Keybinding file format error");
			getline(&buf, line);
		}
	}
	close(fd);

	return;
}


getline(buf, line)
caddr_t	*buf, line;
{
	while (isspace(**buf) || **buf == '#') {
		while (isspace(**buf))
			(*buf)++;
		while (**buf == '#') {
			while (**buf != '\n') 
				(*buf)++;
		}
	}

	while (**buf != '\n' && **buf != '\0') {
		if (**buf == '#') {
			while (**buf != '\n' && **buf != '\0')
				(*buf)++;
			break;
		}
		*line++ = **buf;
		(*buf)++;
	}
	(*buf)++;

	while (isspace(*(line-1)))
		line--;
	*line = '\0';
}

init_im()
{
	int	i;
	e_char  default_key[] = {'N' - 0x40, 'P' - 0x40,
				 'F' - 0x40, 'B' - 0x40,
				 'I' - 0x40, 'U' - 0x40,
				 'W' - 0x40, 'K' - 0x40,
				 0};

	/* At default, Initialization keybinding */
	for (i = 0; i < MAX_IM; i++) {
		memmove(&im[i].next_choice, default_key, 8);
		im[i].cmt_fst_sel_key = im[i].ctl_key 
			= im[i].function_key = im[i].wild_char = -1;
		im[i].dic_no = -1;
		im[i].c_tab = NULL;
		im[i].props = 0;
	}
	location_kb = &im[QW_VALUE];
	pinyin_kb = &im[PY_VALUE];
	stroke_kb = &im[SW_VALUE];
	golden_kb = &im[JJ_VALUE];
	full_code_kb = &im[SUN_VALUE];
	mode_switch_kb = &im[SWITCH_MODE_VALUE];
	chnsym_kb = &im[CS_VALUE];
	ascii_kb = &im[ASCII_VALUE];
	on_kb = &im[ON_VALUE];
	conversion_off = &im[OFF_VALUE];
}


/*
 * get the string on the right of "="
 */
char	*
assign_string(line)
char	*line;
{
	char	*s;

	for (s = line; *s != '='; s++)
		;
	for (s++; *s == '=' || isspace(*s); s++)
		;
	if ((*s == '\'' && s[strlen(s) - 1] == '\'') ||
	    (*s == '"' && s[strlen(s) - 1] == '"') ) {
		s[strlen(s) - 1] == '\0';
		s++;
	}
	return s;
}


get_key_code(line)
caddr_t line;
{
	char	*s = assign_string(line);
	if (*s == '^' && *(s+1) != '\0')
		return *(s+1) - 0x40;
	else	return *s;
}


/*
 * Read User-defined Input Method 
 */
read_im_spec(im_no, buf, line)
int	im_no;
caddr_t	*buf, line;
{
	int	i;
	char	*p, *str;

	for (getline(buf, line); *line != '%'; getline(buf, line)) {
	    	if (strncmp(line, "PG", 2) == 0) {
			im[im_no].prev_choice = get_key_code(line);
	    	} else if (strncmp(line, "NG", 2) == 0) {
			im[im_no].next_choice = get_key_code(line);
	    	} else if (strncmp(line, "WC", 2) == 0) {
			im[im_no].wild_char = get_key_code(line);
	    	} else if (strncmp(line, "DS", 2) == 0) {
			im[im_no].disp_sel_key = get_key_code(line);
	    	} else if (strncmp(line, "FC", 2) == 0) {
			im[im_no].cmt_fst_sel_key = get_key_code(line);
	    	} else if (strncmp(line, "ER", 2) == 0) {
			;
	    	} else if (strncmp(line, "CM", 2) == 0) {
			im[im_no].commit_key = get_key_code(line);
	    	} else if (strncmp(line, "FLON", 4) == 0) {
			im[im_no].focus_longer = get_key_code(line);
	    	} else if (strncmp(line, "FSHO", 4) == 0) {
			im[im_no].focus_shorter = get_key_code(line);
	    	} else if (strncmp(line, "FR", 2) == 0) {
			im[im_no].focus_right = get_key_code(line);
	    	} else if (strncmp(line, "FL", 2) == 0) {
			im[im_no].focus_left = get_key_code(line);
	    	} else if (strncmp(line, "CT", 2) == 0) {
			strcpy(im[im_no].ct_file, assign_string(line));
		} else if (strncmp(line, "DICT", 4) == 0) {
			str = assign_string(line);
			for (i = 0; i < total_dic; i++) {
				if (strcmp(str, dic[i].file) == 0) {
					break;
				}
			}
			if (i >= total_dic) {
				strcpy(dic[total_dic].file, str);
				dic[total_dic].word = NULL;
				i = total_dic;
				total_dic++;
			}
			im[im_no].dic_no = i;
		} else if (strncmp(line, "PROPS", 5) == 0) {
			str = assign_string(line);
			for (p = str; *p != '\0'; p++) {
			    if (isspace(*p)) {
				*p = '\0';
				get_prop(im_no, str);
				for (p++; *p && isspace(*p); p++)
				    ;
				str = p;
			    }
			}
			get_prop(im_no, str);
		}
	}
}

get_prop(im_no, str)
int	im_no;
char	*str;
{
	if (strcmp(str, "AUTO_POPUP") == 0)
	    im[im_no].props |= AUTO_POPUP;
	else if (strcmp(str, "AUTO_COMMIT") == 0)
	    im[im_no].props |= AUTO_COMMIT;
	else if (strcmp(str, "MATCH_ONLY") == 0)
	    im[im_no].props |= MATCH_ONLY;
}

put_im_string(line)
char	*line;
{
	int 	i, j, im_no;
	char	im_name[16];
	static	default_im_name[16];

	sscanf(line, "%[^:]:", im_name);

	if (strcmp(im_name, "%cm_on") == 0) {
		im_no = ON_VALUE;
		default_im_name[0] = '\0';
	} else if (strcmp(im_name, "%cm_off") == 0)
		im_no = OFF_VALUE;
	else if (strcmp(im_name, "%MODE_SW") == 0) 
		im_no = SWITCH_MODE_VALUE;
	else if (strcmp(im_name, "%location") == 0)
		im_no = QW_VALUE;
	else if (strcmp(im_name, "%stroke") == 0)
		im_no = SW_VALUE;
	else if (strcmp(im_name, "%pinyin") == 0)
		im_no = PY_VALUE;
	else if (strcmp(im_name, "%jinjiang") == 0)
		im_no = JJ_VALUE;
	else if (strcmp(im_name, "%intellpy") == 0)
		im_no = SUN_VALUE;
	else if (strcmp(im_name, "%ascii") == 0)
		im_no = ASCII_VALUE;
	else if (strcmp(im_name, "%chnsym") == 0)
		im_no = CS_VALUE;
	else im_no = total_im++;

	if (strcmp(default_im_name, im_name) == 0)
		default_im = im_no;

	for (i = 0; line[i] != '^'; i++)
		;
	i++;

	im[im_no].ctl_key = line[i] - 0x40;

	while (line[i] != 'F')
		i++;
	i++;

	for (j = i; line[j] != ':'; j++)
		;
	line[j] = '\0';

	im[im_no].function_key = atoi(&line[i]) + F_KEY;
	strcpy(im[im_no].message, &line[j + 1]);
	if (line[j + 1] == '%' && strcmp(im_name, "%cm_on") == 0)
		strcpy(default_im_name, &line[j + 1]);

	return im_no;
}


/*
 *      Get the directory used to put Chinese dictionary.
 */
e_char *
get_cle_path()
{
        e_char         *path_str1;

        path_str1 = (e_char *)getenv("CLE_PATH");
        if (path_str1 == NULL) {
#ifdef V_SUNVIEW
                path_str1 = (e_char *) defaults_get_string(
                                                "/PrChina/Cle_Path",
                                               "/usr/lib/mle/zh/data/",
                                                           0);
#endif
                strcpy((char *)path_temp, "/usr/lib/mle/zh/data/");
                path_str1 = (e_char *)path_temp;
        }
        return (path_str1);
}

