/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/* @(#)phrase_dic.h	1.2 00/08/19 */


/* The phrase_dic file has a header and six hash tables:
*
* _____________________________________________________________________
* |header |single word|Phrase1|phrase2|phrase3|phrase4|phrase5|phrase6 |
* ----------------------------------------------------------------------
*
* Each hash table contains following:
*
* ---------------------------------------
* |  sub_header       | hash link array |
*---------------------------------------
*
*/
#define PRIM			521
#define HASH_TSIZE  		512
#define	HASH(key,tsiz) 		key % tsiz
#define NULL_FLG 		-1
/* file header is a array of the struct sub_header with length 6. */

/*  struct sub_header 	*header[6];	*/

struct sub_header{
	short  table_len;
	short  extend_start_addr;
	short  hash_e[HASH_TSIZE];
};
/* hash link array's structure */

struct s_dic{
	u_char 		py_str[4];
	u_char		euc_code[2];
	u_short		flag:1;
	u_short		next:15;
};
struct s_dic_abbr {
	u_char 		euc_code[2];
	u_short		flag:1;
	u_short		next:15;
};

struct p2_dic {	
	u_char          py_str[6];
        u_char          euc_code[4];
        u_short         flag:1;
        u_short         next:15;
};

struct p2_dic_abbr{
	u_char          euc_code[4];
        u_short         flag:1;
        u_short         next:15;
};
struct p3_dic {        
        u_char          py_str[10];
        u_char          euc_code[6];
        u_short         flag:1;  
        u_short         next:15;
};

struct p3_dic_abbr{
        u_char          euc_code[6];
        u_short         flag:1;
        u_short         next:15;
};
struct p4_dic {        
        u_char          py_str[12];
        u_char          euc_code[8];
        u_short         flag:1;  
        u_short         next:15;
};

struct p4_dic_abbr{
        u_char          euc_code[8];
        u_short         flag:1;
        u_short         next:15;
};
struct p5_dic {        
        u_char          py_str[16];
        u_char          euc_code[10];
        u_short         flag:1;  
        u_short         next:15;
};

struct p5_dic_abbr{
        u_char          euc_code[10];
        u_short         flag:1;
        u_short         next:15;
};
struct p6_dic {        
        u_char          py_str[18];
        u_char          euc_code[12];
        u_short         flag:1;  
        u_short         next:15;
};

struct p6_dic_abbr{
        u_char          euc_code[12];
        u_short         flag:1;
        u_short         next:15;
};
