/*
 * Copyright (c) 1999 Sun Microsystems, Inc.
 * Copyright (c) 1999 Nihon Sun Microsystems K.K.
 * All rights reserved.
 */

#ifndef _CSCONV_HH
#define _CSCONV_HH

/*
 * "$Id: csconv.hh,v 1.2 1999/04/06 00:21:05 kasha Exp $"
 */

#pragma ident	"@(#)csconv.hh 1.2	99/04/06 SMI"


#include <sys/types.h>

#include "csconv.h"


class CodeSetConverter {
private:
	csconv_t	cd;

public:
	CodeSetConverter(const char * locale,
			 const char * cs_to, const char * cs_from) {
		cd = csconv_open_locale(locale, cs_to, cs_from);
	}

	CodeSetConverter(const char * cs_to, const char * cs_from) {
		cd = csconv_open(cs_to, cs_from);
	}

	~CodeSetConverter() {
		csconv_close(cd);
	}

    	int	valid() {
		return (((csconv_t)(-1) == cd) ? 0 : 1);
	}

	size_t	run(const char ** inbuf, size_t * inbytesleft, 
		    char ** outbuf, size_t * outbytesleft) {
		return csconv(cd, inbuf, inbytesleft, outbuf, outbytesleft);
	}
};


#endif // _CSCONV_HH
