/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import com.sun.mail.util.Parser;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class MailDateFormat
extends SimpleDateFormat {
    static boolean debug;
    private static TimeZone tz;
    private static Calendar cal;

    public MailDateFormat() {
        super("EEE, d MMM yyyy HH:mm:ss 'XXXXX' (z)", Locale.US);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = stringBuffer.length();
        super.format(date, stringBuffer, fieldPosition);
        int n2 = 0;
        n2 = n + 25;
        while (stringBuffer.charAt(n2) != 'X') {
            ++n2;
        }
        this.calendar.clear();
        this.calendar.setTime(date);
        int n3 = this.calendar.get(7);
        int n4 = this.calendar.get(5);
        int n5 = this.calendar.get(2);
        int n6 = this.calendar.get(1);
        this.calendar.get(11);
        this.calendar.get(12);
        this.calendar.get(13);
        TimeZone timeZone = this.calendar.getTimeZone();
        int n7 = timeZone.getOffset(this.calendar.get(0), n6, n5, n4, n3, this.calendar.get(14));
        if (n7 < 0) {
            stringBuffer.setCharAt(n2++, '-');
            n7 = -n7;
        } else {
            stringBuffer.setCharAt(n2++, '+');
        }
        int n8 = n7 / 60 / 1000;
        int n9 = n8 / 60;
        int n10 = n8 % 60;
        stringBuffer.setCharAt(n2++, Character.forDigit(n9 / 10, 10));
        stringBuffer.setCharAt(n2++, Character.forDigit(n9 % 10, 10));
        stringBuffer.setCharAt(n2++, Character.forDigit(n10 / 10, 10));
        stringBuffer.setCharAt(n2++, Character.forDigit(n10 % 10, 10));
        return stringBuffer;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        return MailDateFormat.parseDate(string.toCharArray(), parsePosition);
    }

    private static Date parseDate(char[] cArray, ParsePosition parsePosition) {
        try {
            Parser parser;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            block11: {
                n7 = -1;
                n6 = -1;
                n5 = -1;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
                parser = new Parser(cArray);
                parser.skipUntilNumber();
                n7 = parser.parseNumber();
                if (!parser.skipIfChar('-')) {
                    parser.skipWhiteSpace();
                }
                n6 = parser.parseMonth();
                if (!parser.skipIfChar('-')) {
                    parser.skipWhiteSpace();
                }
                if ((n5 = parser.parseNumber()) < 50) {
                    n5 += 2000;
                } else if (n5 < 100) {
                    n5 += 1900;
                }
                parser.skipWhiteSpace();
                n4 = parser.parseNumber();
                parser.skipChar(':');
                n3 = parser.parseNumber();
                if (parser.skipIfChar(':')) {
                    n2 = parser.parseNumber();
                }
                try {
                    parser.skipWhiteSpace();
                    n = parser.parseTimeZone();
                }
                catch (ParseException parseException) {
                    if (!debug) break block11;
                    System.out.println("No timezone? : '" + cArray + "'");
                }
            }
            parsePosition.setIndex(parser.getIndex());
            Date date = MailDateFormat.ourUTC(n5, n6, n7, n4, n3, n2, n);
            return date;
        }
        catch (ParseException parseException) {
            if (debug) {
                System.out.println("Bad date: '" + cArray + "'");
                parseException.printStackTrace();
            }
            parsePosition.setIndex(1);
            return null;
        }
    }

    private static synchronized Date ourUTC(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        cal.clear();
        cal.set(1, n);
        cal.set(2, n2);
        cal.set(5, n3);
        cal.set(11, n4);
        cal.set(12, n5 + n7);
        cal.set(13, n6);
        return cal.getTime();
    }

    public void setCalendar(Calendar calendar) {
        throw new RuntimeException("Method setCalendar() shouldn't be called");
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        throw new RuntimeException("Method setCalendar() shouldn't be called");
    }

    public static void main(String[] stringArray) {
        new MailDateFormat();
        new Date();
    }

    static {
        tz = TimeZone.getTimeZone("GMT");
        cal = new GregorianCalendar(tz);
    }
}

