/*
 * @(#)IIIMCommittedEvent.java	1.9 99/08/02
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;

/**
 * This class represents InputMethod's committed string.
 */
public class IIIMCommittedEvent extends IIIMEvent {

    private String committed;
    private AttributedCharacterIterator committedIterator;

    /**
     * Constructs a event with committed string. 
     * There is no sub type for committed event
     *
     * @param	committed string
     */
    public IIIMCommittedEvent(String committed) {
	super(COMMITTED);
	this.committed = committed;
    }

    /**
     * Constracts a event with committed string
     * which has attribute.
     *
     * @param   committed string
     */
    public IIIMCommittedEvent(AttributedCharacterIterator iterator) {
	super(COMMITTED);
	this.committedIterator = iterator;
    }

    public String getCommittedString() {
	if (committed == null) {
	    committed = iteratorToString(committedIterator);
	}
	return committed;
    }

    public AttributedCharacterIterator getCommittedIerator() {
	if (committedIterator == null) {
	    committedIterator = new AttributedString(committed).getIterator();
	}
	return committedIterator;
    }
}
