/*
 * @(#)IIIMLookupListener.java	1.7 99/05/07
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

/**
 * Lookup GUI object class must implements this interface.
 */
public interface IIIMLookupListener extends IIIMListener {

    /**
     * When lookup starts, this method is invoked.
     *
     * @param e <code>IIIMLookupEvent</code>
     */
    void lookupStart(IIIMLookupEvent e);

    /**
     * When lookup done, this method is invoked.
     *
     * @param e <code>IIIMLookupEvent</code>
     */
    void lookupDone(IIIMLookupEvent e);

    /**
     * When lookup draw, this method is invoked.
     *
     * @param e <code>IIIMLookupEvent</code>
     */
    void lookupDraw(IIIMLookupEvent e);

    /**
     * When lookup process, this method is invoked.
     *
     * @param e <code>IIIMLookupEvent</code>
     */
    void lookupProcess(IIIMLookupEvent e);
}
