/*
 * %W% %E%
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.font.*;
import com.sun.iiim.*;

// If the style for Window is mixture window
// Then we will mix StatusWindow with LookupChoiceWindow
class CompositeWindow extends IIIMWindow implements IIIMLookupListener , 
IIIMStatusListener {
    private String style;

    int columHeight, columWidth;
    FontMetrics fm;    
    
    LookupPane lookupPane;
    StatusPane statusPane;
    
    int offset = 24;
    
    // Default, no-arg constructor
    public CompositeWindow() {
       // Add the LookupChoiceWindow and StatusWindow
       style = Manager.getProperty("iiimf.preedit.style");
       
       init();
    }
    
    void init() {
        window = new Dialog(new Frame(""));
        ((Dialog)window).setResizable(true);
        ((Dialog)window).setTitle("Input Window");
        
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
	fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        window.setFont(font);
        
        lookupPane = new LookupPane();
        window.add(lookupPane);
        statusPane = new StatusPane();
        window.add(statusPane);
        
        window.pack();        
    }
    
    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getStyle() {
        return style;
    }
        
    public void setLocation(int x, int y) {
        window.setLocation(x,y);
    }
    
    public void calculatePosition() {
        Component component = getClientComponent();
        
        Component frame = component;
        Insets inset = window.getInsets();
        
        while(!(frame instanceof Frame)) frame = frame.getParent();
        
        if(style.equals("BELOWSPOT") 
            && component instanceof InputMethodRequests) {
                Rectangle rect = 
                    ((InputMethodRequests)component).getTextLocation(TextHitInfo.leading(0));
                Point point = new Point();
                point.x = rect.x;
                point.y = rect.x + (int)rect.getHeight() + offset;
                // Leave space for Preedit window
                point.y += (inset.top + inset.bottom + fm.getHeight());
                window.setLocation(point);                 
        }
        else {
            // For "ROOTWINDOW" style and component isn't InputMethodRequests
            // Place the window on the left-corner of client component
            
            Point point = frame.getLocation();
            Dimension size = frame.getSize();     

            double x = point.getX();
            // It must leave the position for PreeditWindow
            double y = point.getY() + size.getHeight() 
                + inset.top + inset.bottom + fm.getHeight();
            
            window.setLocation((int)x, (int)y);        
        }                
    }
    
    // Listener method
    public void lookupStart(IIIMLookupEvent e) {}
    public void lookupDone(IIIMLookupEvent e) {}
    public void lookupDraw(IIIMLookupEvent e) {}
    public void lookupProcess(IIIMLookupEvent e) {}

    public void dispatchEvent(IIIMLookupEvent e) {
        lookupPane.handleEvent(e);
        window.doLayout();
        window.show();
    }
    
    public void statusStart(IIIMStatusEvent e) {}
    public void statusDone(IIIMStatusEvent e) {}
    public void statusDraw(IIIMStatusEvent e) {}

    public void dispatchEvent(IIIMStatusEvent e) {
        statusPane.handleEvent(e);
        window.doLayout();
        window.show();
    }

}
