/*
 * @(#)IIIMPAdapter.java	1.19 99/05/31
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.util.Locale;
import java.lang.Character.Subset;
import java.awt.Component;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.text.AttributedString;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import sun.awt.im.InputMethodContext;
import com.sun.iiim.*;

public class IIIMPAdapter extends sun.awt.im.InputMethodAdapter
	implements IIIMListener, IIIMPreeditListener,
	           IIIMCommittedListener {

    // private variables
    private static Manager manager;
    private Component currentClient;

    protected Component getClientComponent() {
	return currentClient;
    }

    // --------------------------------------------------------	
    // sun.awt.im.InputMethodAdapter implementation
    // --------------------------------------------------------

    /**
     * This static method is invoked by sun.awt.im.InputMethodManager.
     */
    public static Locale[] getAvailableLocales() {
	if (manager == null) {
	    manager = Manager.getInstance();
	}
	Locale[] la = manager.getAvailableLocales();
	return la;
    }

    /**
     * Set the primily InputMethod by locale.
     */	
    public boolean setLocale(Locale locale) {
	return manager.setLocale(locale);
    } 

    /**
     * Set character subsets to the current active InputMethod.
     */
    public void setCharacterSubsets(Subset[] subsets) {
	manager.setCharacterSubsets(subsets);
    }

    /**
     * Receive AWTEvent throught this method.
     * Main interface from sun.awt.im.InputContext.
     */
    public synchronized void dispatchEvent(AWTEvent event) {
	if (event instanceof KeyEvent) {
	    IIIMEvent e = new IIIMEvent(event);
	    manager.dispatchEvent(e);
	}
    }

    private InputMethodContext imc;

    /**
     * Called when the input capable component receive a FOCUS_GAINED
     */
    public void activate() {
	currentClient = super.getClientComponent();
	manager.setIIIMPAdapter(this);
	manager.setIIIMCommittedListener(this);
	if (preeditListener == null) {
	    setPreeditListener(this);
	}
	if (statusListener == null) {
	    setStatusListener(new StatusWindow());
	}
	if (lookupListener == null) {
	    setLookupListener(new LookupWindow());
	}
	manager.setIIIMPreeditListener(preeditListener);
	manager.setIIIMStatusListener(statusListener);
	manager.setIIIMLookupListener(lookupListener);
	manager.activate();
    }

    /**
     * Called when the input capable component receive a FOCUS_LOST
     */
    public void deactivate(boolean isTemporary) {
	manager.deactivate(isTemporary);
    }

    /**
     *
     */
    public void removeNotify() {
	manager.removeNotify();
    }

    /**
     * The behavior depends on im or user's preferrence.
     */
    public void endComposition() {
	manager.endComposition();
    }

    /**
     * Dispose the input method.
     */
    public void dispose() {
	manager.dispose();
    }

    /**
     *
     */
    public Object getControlObject() {
	return manager.getControlObject();
    }

    private IIIMPreeditListener preeditListener;
    private static IIIMStatusListener statusListener;
    private IIIMLookupListener lookupListener;

    void setPreeditListener(IIIMPreeditListener l) {
	preeditListener = l;
    }

    void setStatusListener(IIIMStatusListener l) {
	statusListener = l;
    }

    void setLookupListener(IIIMLookupListener l) {
	lookupListener = l;
    }

    public IIIMPAdapter() {
	if (manager == null) {
	    // set static member manager
	    manager = Manager.getInstance();
	}
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputContext.
     * sun.awt.im.InputMethodContext inputContext variable is
     * inherited from sun.awt.im.InputMethod class.
     */
    public void dispatchEvent(IIIMEvent e) {
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMPreeditListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMPreeditEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputContext.
     */
    public void preeditStart(IIIMPreeditEvent e) {}
    public void preeditDone(IIIMPreeditEvent e) {}
    public synchronized void preeditDraw(IIIMPreeditEvent e) {
	AttributedCharacterIterator iterator = e.getIterator();
	int pos = iterator.getEndIndex(); 

	inputContext.dispatchInputMethodEvent(InputMethodEvent.
					      INPUT_METHOD_TEXT_CHANGED,
					      iterator,
					      0,
					      TextHitInfo.leading(pos),
					      null);
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMCommitedListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMCommittedEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputContext.
     */
    public void committedPerformed(IIIMCommittedEvent e) {
	String committed = e.getCommittedString();
	AttributedCharacterIterator iterator =
	    new AttributedString(committed).getIterator();

	inputContext.dispatchInputMethodEvent(InputMethodEvent.
					      INPUT_METHOD_TEXT_CHANGED,
					      iterator,
					      committed.length(),
					      null,
					      null);
    }
}
