/*
 * @(#)IIIMPObjectDescripter.java	1.1 99/03/31
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
 
package sun.awt.im.iiimp;

class IIIMPObjectDescripter implements IIIMProtocol {

    private int category;
    private int size;
    private int attribID;
    private int dattribID;
    private Integer dattribIDObj;
    private String name;
    private String hrn;
    private String signature;
    private String user;

    IIIMPObjectDescripter(int category, int size, int attribID, int dattribID,
			  String name, String hrn,
			  String signature, String user) {
	this.category = category;
	this.size = size;
	this.attribID = attribID;
	this.dattribID = dattribID;
	this.dattribIDObj = new Integer(dattribID);
	this.name = name;
	this.hrn = hrn;
	this.signature = signature;
	this.user =  user;
    }

    int getCategory() {
	return category;
    }

    int getSize() {
	return size;
    }

    int getAttribID() {
	return attribID;
    }

    int getDAttribID() {
	return dattribID;
    }

    Integer getDAttribIDObj() {
	return dattribIDObj;
    }

    String getName() {
	return name;
    }

    String getHRN() {
	return hrn;
    }

    String getUser() {
	return user;
    }

    // for debug
    public String toString() {
	String cr = System.getProperty("line.separator", "\n");

	return
	    " Category: 0x" + Integer.toHexString(category) + cr +
	    "     Size: 0x" + Integer.toHexString(size) + cr +
	    " AttribID: 0x" + Integer.toHexString(attribID) + cr +
	    "DAttribID: 0x" + Integer.toHexString(dattribID) + cr +
	    "     Name: " + name + cr +
	    "      NRN: " + hrn + cr +
	    "     User: " + user;
    }
}
