/*
 * @(#)ManageRule.java	1.10 99/07/13
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

import com.sun.iiim.*;

class ManageRule {

    private final static String PROTOCOL_DRIVER_NAME =
	"sun.awt.im.iiimp.ProtocolDriver";

    private final static String DEFAULT_PCE_RULE =
	"sun/awt/im/iiimp/sample.lwesyntax";

    private String ruleString = null;

    ManageRule(String rule) {
	ruleString = rule;
	parseRule(ruleString);
    }

    ManageRule(InputStreamReader reader) {
	StringBuffer sb = new StringBuffer();
	int ch;
	try {
	    for (; (ch = reader.read()) != -1;) {
		sb.append((char)ch);
	    }
	} catch(Exception e) {}
	ruleString = sb.toString();
	parseRule(ruleString);
    }

    public String toString() {
	return ruleString;
    }

    int size() {
	return imVector.size();
    }

    boolean contains(Object o) {
	Class c1 = o.getClass();
	for (int i = 0; i < imVector.size(); i++) {
	    Class c2 = imVector.get(i).getClass();
	    if (c1 == c2) {
		return true;
	    }
	}
	return false;
    }

    IIIMListener get(int i) {
	return (IIIMListener)imVector.get(i);
    }

    private Vector imVector;

    private PCE pce;
    private String ccdef;

    void setCCDEF(String ccdef) {
	this.ccdef = ccdef;
	if (pce != null) {
	    try {
		pce.pushSyntax(new LWESyntax(ccdef));
	    } catch(InvalidSyntaxException e) {
		debug(" err = " + e);
	    }
	}
    }

    private void parseRule(String ruleString) {
	imVector = new Vector();

	StringTokenizer st = new StringTokenizer(ruleString);
	imVector = new Vector();

	while(st.hasMoreTokens()) {
	    String className = st.nextToken();
	    Object obj;

	    try {
		if (className.equals(PROTOCOL_DRIVER_NAME)) {
		    obj = ProtocolDriver.getInstance();
		} else {
		    obj = Class.forName(className).newInstance();
		}
	    } catch(Exception e) {
		// ignore invalid entry in the rule
		continue;
	    }
	    if (obj == null) {
		continue;
	    }
	    if (obj instanceof IIIMListener) {
		if (obj instanceof PCE) {
		    // PCE setup
		    pce = (PCE)obj;
		    LWESyntax syntax = null;
		    if (ccdef == null) {
			ClassLoader loader = ClassLoader.getSystemClassLoader();
			InputStream is = loader.getResourceAsStream
			    (DEFAULT_PCE_RULE);
			InputStreamReader reader = new InputStreamReader(is);
			try {
			    syntax = new LWESyntax(reader);
			} catch(InvalidSyntaxException e) {
			    debug(" err : " + e);
			    continue;
			}
		    } else {
			try {
			    syntax = new LWESyntax(ccdef);
			} catch(InvalidSyntaxException e) {
			    debug(" err : " + e);
			    continue;
			}
		    }
		    ((PCE)obj).pushSyntax(syntax);
		} else if (obj instanceof ProtocolDriver) {
		    Manager.setPD((ProtocolDriver)obj);
		}
		imVector.add(obj);
	    }
	}
    }

    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}
