/*
 * %W% %E%
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.text.*;
import com.sun.iiim.*;

class PreeditPane extends Canvas {
    private String composedString;
    private int caret;
    private final static int TEXT_ORIGIN_X = 5;
    private final static int TEXT_ORIGIN_Y = 15;
    
    private int width, height;
    FontMetrics metrics;        
    
    /**
     * Default, no arg constructor
     */
    public PreeditPane() {
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        
        if(composedString.length() > 0) {
            g.setColor(getForeground());
            g.drawString(composedString, TEXT_ORIGIN_X, TEXT_ORIGIN_Y);
        }
        Rectangle rect = getCaretRectangle();
        
        g.fillRect(rect.x, rect.y, 1, rect.height);
    }

    private Rectangle getCaretRectangle() {
        int width = 0;
        
        if (caret > 0) {
            char chars[] = new char[caret];
            // can't call getChars() if composedText.length() == 0
            composedString.getChars(0, caret, chars, 0);
            width = metrics.charsWidth(chars, 0, caret);
        }
        return new Rectangle(TEXT_ORIGIN_X + width,
                             TEXT_ORIGIN_Y - metrics.getAscent(),
                             0, metrics.getAscent() + metrics.getDescent());    
    }
    
    void handleEvent(IIIMPreeditEvent e) {
        if(metrics == null) metrics = getGraphics().getFontMetrics();

        composedString = new String();
        AttributedCharacterIterator str = e.getIterator();
        for(char c = str.first(); c != CharacterIterator.DONE; 
            c = str.next()) {
            composedString += c;
        }

        width = metrics.stringWidth(composedString);
        height = metrics.getHeight();
        caret = e.getCaret();
        
        repaint();
    }
    
    int width() {
        return width;
    }
    
    int height() {
        return height;
    }
}
