/*
 * @(#)StatusPane.java	1.10 99/07/28
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.text.*;
import java.awt.event.*;
import com.sun.iiim.*;

class StatusPane extends Panel implements MouseMotionListener, MouseListener {
    // Status string
    private String text="";
    private AttributedCharacterIterator iterator;

    /*
     * Default, no arg constructor
     */
    public StatusPane() {
        addMouseMotionListener(this);
        addMouseListener(this);
    }
    
    void handleEvent(IIIMStatusEvent e) {
        text = "";
        setData(e.getIterator());
        
        repaint();
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        
        Rectangle rec = getBounds();
        
	//g.setColor(Color.darkGray);
	g.setColor(Color.black);
	g.fill3DRect(rec.width - 2, 0, 2, rec.height,true);
	g.fill3DRect(0, rec.height - 2, rec.width, 2,true);

        g.setColor(Color.white);
	g.fill3DRect(0, 0, 2, rec.height,true);
	g.fill3DRect(0, 0, rec.width, 2,true);
	//g.drawString(text,12,14);

	g.setColor(Color.black);

	if (Manager.COLOR_SUPPORT) {
	    g.drawString(iterator, 12, 14);
	} else {
	    g.drawString(text, 12, 14);
	}
    }
    
    void setData(AttributedCharacterIterator str) {
	iterator = str;
        for(char c = str.first(); c != CharacterIterator.DONE; 
            c = str.next()) {
            text += c;
        }
    }
    
    String getData()  {
        return text;
    }
    
    private boolean dragged = false;
    int x = 0, y = 0;
    int oldx = 0, oldy = 0;
    Cursor cursor = null;
    
    public void mouseDragged(MouseEvent e) {
        x = e.getX();
        y = e.getY();

        if(!dragged) {
            oldx = x;
            oldy = y;
            dragged = true;
            cursor = getCursor();
            setCursor(new Cursor(Cursor.MOVE_CURSOR));
            return;
        }
        Point point = getParent().getLocationOnScreen();
            
        point.x += (x-oldx); 
        point.y += (y-oldy); 
            
        getParent().setLocation(point);
    }
    
    public void mouseMoved(MouseEvent e) {
    }
    
    public void mouseClicked(MouseEvent e) {
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
        dragged = false;
        setCursor(cursor);
    }
}
