/*
 * @(#)NewPYPanel.java	1.5 99/04/21
 * Copyright 1998 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

package com.sun.iiim.sample.newpy;

import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.text.*;

import com.sun.iiim.*;

public class NewPYPanel extends IIIMComponent implements 
			MouseMotionListener,  MouseListener, IIIMAuxListener {

    JWindow mainWindow = null;
    JLabel  name;
    JButton punchmode, charset, help;
    JComboBox symmode;
    String punch_str1 = "\u5168\u89d2";
    String punch_str2 = "\u534a\u89d2";
    String charset_str1 = "\uff27\uff22\u3000";
    String charset_str2 = "\uff27\uff22\uff2b";
    String auxName;
    int auxIndex;

    int punc_mode = 0;
    int skb_mode = 13;
    int gbk_mode = 0;

    public void auxStart(IIIMAuxEvent e) {

	System.out.println("auxStart");

	String name_str = "\u65b0\u5168\u62fc";
	String symbol_str = "\u7b26\u53f7";
	auxName = e.getName();
	auxIndex = e.getIndex();

	String help_str = "\u5e2e\u52a9"; /*\u4fe1\u606f";*/

	Color color = new Color(204, 204, 204);

	mainWindow = new JWindow();
	mainWindow.setBackground(color);
	JRootPane pane = mainWindow.getRootPane();
	pane.setBackground(color);

	pane.addMouseMotionListener(this);
	pane.addMouseListener(this);

	symmode = new JComboBox();
	symmode.setBackground(color);
	symmode.setToolTipText(punch_str1 + "/" + punch_str2);
	//symmode.setBorderPainted(false);

	punchmode = new JButton(punch_str1, getImageIcon("images/full.gif"));
	punchmode.setBackground(color);
	punchmode.setToolTipText(punch_str1 + "/" + punch_str2);

	charset = new JButton(charset_str1, getImageIcon("images/gb.gif"));
	charset.setBackground(color);
	charset.setToolTipText(charset_str1 + "/" + charset_str2);

	help = new JButton(help_str, getImageIcon("images/help.gif"));
	help.setBackground(color);
	help.setToolTipText(help_str);

	punchmode.addActionListener(new ModeListener());
	//symmode.addItemListener(new SoftKeyboardListener());
	charset.addActionListener(new PropertiesListener());
	help.addActionListener(new HelpListener());
	
	pane.getContentPane().setLayout(new FlowLayout());

	pane.getContentPane().add(symmode);
	pane.getContentPane().add(punchmode);
	pane.getContentPane().add(charset);
	pane.getContentPane().add(help);

	pane.setBorder(BorderFactory.createBevelBorder
		       (BevelBorder.RAISED, Color.lightGray, Color.darkGray));

	mainWindow.pack();
	Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension wd = mainWindow.getSize();
	mainWindow.setLocation(sd.width - wd.width, sd.height - wd.height);
	mainWindow.setVisible(false);
    }

    public void auxDone(IIIMAuxEvent e) {
	System.out.println("auxDone");
    }

    public void auxDraw(IIIMAuxEvent e) {

	//System.out.println("auxDraw");
	String[] strs = e.getStringValues();
	if (strs != null && strs.length > 0) {
		String state = strs[0];
		//System.out.println(state);
		punc_mode = (int) state.charAt(1) - 'a';
		skb_mode = (int) state.charAt(2) - 'a';
		gbk_mode = (int) state.charAt(3) - 'a';
		if ((int)state.charAt(0) == 'a') mainWindow.setVisible(false);
		else mainWindow.setVisible(true);

		for(int i = 1; i < strs.length; i ++) {
			symmode.addItem(strs[i].substring(0, strs[i].length() - 1));
		}
		symmode.setSelectedIndex(skb_mode);
		if(strs.length > 1) symmode.addItemListener(new SoftKeyboardListener());
	}

	mainWindow.getContentPane().repaint();
    }

    void sendEvent(String[] strs, int[] ints) {
	dispatchAuxEvent(new IIIMAuxEvent(IIIMAuxEvent.SETVALUES,
					  auxIndex, auxName, ints, strs));
    }

    private int startX = 0;
    private int startY = 0;

    // MouseMotionListener implementation

    public void mouseDragged(MouseEvent e) {
	int x = e.getX();
	int y = e.getY();
	Point cp = mainWindow.getLocation();
	mainWindow.setLocation(cp.x + (x - startX), cp.y + (y - startY)); 
	mainWindow.getContentPane().repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    // MouseListener implementation

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
	startX = e.getX();
	startY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    class ModeListener implements ActionListener {

	public void actionPerformed(ActionEvent e) {
	    punc_mode = 1 - punc_mode;
	    if(punc_mode == 1) {
		((JButton)e.getSource()).setText(punch_str2);
		((JButton)e.getSource()).setIcon(getImageIcon("images/half.gif"));
	    } else {
		((JButton)e.getSource()).setText(punch_str1);
		((JButton)e.getSource()).setIcon(getImageIcon("images/full.gif"));
	    }

	    char[] mode = new char[4];
	    mode[0] = (char) (punc_mode + 'a');
	    mode[1] = (char) (skb_mode + 'a');
	    mode[2] = (char) (gbk_mode + 'a');
	    String state = new String(mode);
	    
	    String[] strs = new String[] { state };
	    int[] ints = new int[] {punc_mode, skb_mode, gbk_mode};	
	    sendEvent(strs, ints);
	}
    }

    class SoftKeyboardListener implements ItemListener {

	public void itemStateChanged(ItemEvent e) {
	    if(e.getStateChange() == ItemEvent.SELECTED) {
		skb_mode = ((JComboBox)e.getSource()).getSelectedIndex();

		char[] mode = new char[4];
		mode[0] = (char) (punc_mode + 'a');
		mode[1] = (char) (skb_mode + 'a');
		mode[2] = (char) (gbk_mode + 'a');
		String state = new String(mode);
		
		String[] strs = new String[] { state };
	        int[] ints = new int[] {punc_mode, skb_mode, gbk_mode};	
		sendEvent(strs, ints);

	        mainWindow.getContentPane().repaint();
	    }
	}
    }

    class PropertiesListener implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    gbk_mode = 1 - gbk_mode;
	    if(gbk_mode == 1) {
		((JButton)e.getSource()).setText(charset_str2);
		((JButton)e.getSource()).setIcon(getImageIcon("images/gbk.gif"));
	    } else {
		((JButton)e.getSource()).setText(charset_str1);
		((JButton)e.getSource()).setIcon(getImageIcon("images/gb.gif"));
	    }

	    char[] mode = new char[4];
	    mode[0] = (char) (punc_mode + 'a');
	    mode[1] = (char) (skb_mode + 'a');
	    mode[2] = (char) (gbk_mode + 'a');
	    String state = new String(mode);

	    String[] strs = new String[] { state };
	    int[] ints = new int[] {punc_mode, skb_mode, gbk_mode};	
	    sendEvent(strs, ints);
	}
    }

    class HelpListener implements ActionListener, HyperlinkListener {
	JDialog helpDialog = null;
	JEditorPane editorPane = null;

	public void actionPerformed(ActionEvent e) {
	    if (helpDialog != null) {
		helpDialog.setVisible(true);
		return;
	    }

	    helpDialog = new JDialog((Frame)null, "Help Window");
	    final JDialog dialog = helpDialog;
	    Container pane = helpDialog.getContentPane();
	    JPanel panel = new JPanel(new BorderLayout());

	    editorPane = new JEditorPane();
	    editorPane.setEditable(false);
	    editorPane.enableInputMethods(false);

	    try {
		URL html = getURL("html/sample.html");
		editorPane.setPage(html);
	    } catch(Exception ex) {
		ex.printStackTrace();
	    }

	    editorPane.addHyperlinkListener(this);
	    JScrollPane editorScrollPane = new JScrollPane(editorPane);
	    editorScrollPane.setVerticalScrollBarPolicy
		(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	    editorScrollPane.setPreferredSize(new Dimension(400, 300));

	    JPanel buttonPanel = new JPanel();
	    JButton closeButton = new JButton("Close");
	    closeButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    dialog.setVisible(false);
		}
	    });
	    buttonPanel.add(closeButton);

	    panel.add(editorScrollPane, BorderLayout.CENTER);
	    panel.add(buttonPanel, BorderLayout.SOUTH);
	    pane.add(panel);

	    helpDialog.pack();
	    helpDialog.setVisible(true);
	}

	public void hyperlinkUpdate(HyperlinkEvent e) {
	    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
		linkActivated(e.getURL());
	    }
	}

	void linkActivated(URL url) {
	    Cursor c = editorPane.getCursor();
	    Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
	    editorPane.setCursor(waitCursor);
	    SwingUtilities.invokeLater(new PageLoader(url, c));
	}

	class PageLoader implements Runnable {
	    URL url;
	    Cursor c;

	    PageLoader(URL url, Cursor c) {
		this.url = url;
		this.c = c;
	    }

	    public void run() {
		if (url == null) {
		    editorPane.setCursor(c);
		    Container parent = editorPane.getParent();
		    parent.repaint();
		} else {
		    Document doc = editorPane.getDocument();
		    try {
			editorPane.setPage(url);
		    } catch(IOException ex) {
			editorPane.setDocument(doc);
		    } finally {
			url = null;
			SwingUtilities.invokeLater(this);
		    }
		}
	    }
	}
    }

}
			 
