/*
 * @(#)SampleAux.java	1.9 99/04/21
 * Copyright 1998, 1999 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

package com.sun.iiim.sample.sampleja;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.sun.iiim.*;

public class SampleAux extends IIIMComponent implements IIIMAuxListener {

    public void auxDone(IIIMAuxEvent e) {
    }
    public void auxDraw(IIIMAuxEvent e) {
	mainFrame.setVisible(true);
    }

    JDialog mainFrame = null;
    JTextField textField = null;
    JTextField textField2= null;
    int index;
    String name;

    public void auxStart(IIIMAuxEvent e) {
	name = e.getName();
	index = e.getIndex();

	mainFrame = new JDialog(new Frame(), "Dict Edit Window", false);
	MyListener cl = new MyListener();
	mainFrame.addWindowListener(cl);

	JPanel panel = new JPanel(new BorderLayout());


	JPanel nPanel = new JPanel();
	JLabel yomiLabel = new JLabel("\u8aad\u307f: ");
	textField = new JTextField(20);
	nPanel.add(yomiLabel);
	nPanel.add(textField);

	JPanel cPanel = new JPanel();
	JLabel kekkaLabel = new JLabel("\u7d50\u679c: ");
	textField2 = new JTextField(20);
	cPanel.add(kekkaLabel);
	cPanel.add(textField2);

	JPanel sPanel = new JPanel();
	okButton = new JButton("OK");
	closeButton = new JButton("Close");
	okButton.addActionListener(cl);
	closeButton.addActionListener(cl);
	sPanel.add(okButton);
	sPanel.add(closeButton);

	panel.add(nPanel, BorderLayout.NORTH);
	panel.add(cPanel, BorderLayout.CENTER);
	panel.add(sPanel, BorderLayout.SOUTH);

	mainFrame.getContentPane().add(panel);
	mainFrame.setSize(300, 200);
	mainFrame.setVisible(true);
    }

    void sendEvent(String[] strs, int[] ints) {
	dispatchAuxEvent(new IIIMAuxEvent(IIIMAuxEvent.SETVALUES,
					  index, name, ints, strs));
    }

    private JButton okButton;
    private JButton closeButton;

    class MyListener extends WindowAdapter implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    // dosomething
	    Object source = e.getSource();

	    if (source.equals(okButton)) {
		String[] strs = new String[2];
		strs[0] = textField.getText();
		strs[1] = textField2.getText();
		sendEvent(strs, new int[] {3});
	    } else {
		mainFrame.setVisible(false);
		sendEvent(null, new int[] {0});
	    }
	}
	public void windowClosing(WindowEvent e) {
	    mainFrame.setVisible(false);
	    sendEvent(null, new int[] {0});
	}
    }
}

    
