/*
 * @(#)IIIMFAdapter.java	1.21 00/08/23
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.util.Locale;
import java.lang.Character.Subset;
import java.awt.Component;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextHitInfo;
import java.text.AttributedString;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;

import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;

import com.sun.iiim.*;

public class IIIMFAdapter extends sun.awt.im.InputMethodAdapter implements
	IIIMListener, IIIMPreeditListener, IIIMCommittedListener {

    // private variables
    private static Manager manager;
    private Component currentClient;
    private InputMethodContext inputMethodContext;
    private Locale locale;
    private IIIMPreeditListener preeditListener;
    private static IIIMStatusListener statusListener;
    private IIIMLookupListener lookupListener;

    public IIIMFAdapter() {
	manager = Manager.getInstance();
	locale = Locale.getDefault();
    }

    // --------------------------------------------------------
    // java.awt.im.spi.InputMethod implementation
    // --------------------------------------------------------

    /**
     * Called when the input capable component receive a FOCUS_GAINED
     */
    public void activate() {
	currentClient = super.getClientComponent();
	manager.setIIIMFAdapter(this);
	manager.setIIIMCommittedListener(this);
	if (preeditListener == null) {
	    setPreeditListener(this);
	}
	if (statusListener == null) {
	    setStatusListener(new StatusWindow());
	}
	if (lookupListener == null) {
	    setLookupListener(new LookupWindow());
	}
	manager.setIIIMPreeditListener(preeditListener);
	manager.setIIIMStatusListener(statusListener);
	manager.setIIIMLookupListener(lookupListener);
	manager.activate();
    }

    /**
     * Called when the input capable component receive a FOCUS_LOST
     */
    public void deactivate(boolean isTemporary) {
	manager.deactivate(isTemporary);
    }

    /**
     * Receive AWTEvent throught this method.
     */
    public synchronized void dispatchEvent(AWTEvent event) {
	if (event instanceof KeyEvent) {
	    IIIMEvent e = new IIIMEvent(event);
	    manager.dispatchEvent(e);
	}
    }

    /**
     * Dispose the input method.
     */
    public void dispose() {
	manager.dispose();
    }

    /**
     * The behavior depends on im or user's preferrence.
     */
    public void endComposition() {
	manager.endComposition();
    }

    /**
     *
     */
    public Object getControlObject() {
	return manager.getControlObject();
    }

    /**
     * return locale
     */
    public Locale getLocale() {
	return locale;
    }

    /**
     * Closes or hides all windows opened by this input method instance
     * or its class.
     */
    public void hideWindows() {
    }

    /**
     *  
     */
    public void removeNotify() {
	manager.removeNotify();
    }
    
    /**
     * Set character subsets to the current active InputMethod.
     */
    public void setCharacterSubsets(Subset[] subsets) {
	manager.setCharacterSubsets(subsets);
    }

    /**
     *
     */
    public void setInputMethodContext(InputMethodContext context) {
	inputMethodContext = context;
    }

    /**
     * Set the primily InputMethod by locale.
     */	
    public boolean setLocale(Locale locale) {
	boolean b = manager.setLocale(locale);
	if (b) {
	    this.locale = locale;
	}
	return b;
    }

    public void setCompositionEnabled(boolean enable) {
	throw new UnsupportedOperationException();
    }

    public boolean isCompositionEnabled() {
	throw new UnsupportedOperationException();
    }
	

    // -----------------------------------------------------------

    protected Component getClientComponent() {
	return currentClient;
    }

    void setPreeditListener(IIIMPreeditListener l) {
	preeditListener = l;
    }

    void setStatusListener(IIIMStatusListener l) {
	statusListener = l;
    }

    void setLookupListener(IIIMLookupListener l) {
	lookupListener = l;
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputMethodContext.
     * sun.awt.im.InputMethodContext inputMethodContext variable is
     * inherited from sun.awt.im.InputMethod class.
     */
    public void dispatchEvent(IIIMEvent e) {
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMPreeditListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMPreeditEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputMethodContext.
     */
    public void preeditStart(IIIMPreeditEvent e) {}
    public void preeditDone(IIIMPreeditEvent e) {}
    public synchronized void preeditDraw(IIIMPreeditEvent e) {
	AttributedCharacterIterator iterator = e.getIterator();
	int pos = iterator.getEndIndex(); 

	inputMethodContext.dispatchInputMethodEvent(InputMethodEvent.
					      INPUT_METHOD_TEXT_CHANGED,
					      iterator,
					      0,
					      TextHitInfo.leading(pos),
					      null);
    }

    // --------------------------------------------------------	
    // sun.awt.im.iiimp.IIIMCommitedListener implementation
    // --------------------------------------------------------

    /**
     * Receive the IIIMCommittedEvent from Manager through this method.
     * Then convert it to InputMethodEvent and dispatch to inputMethodContext.
     */
    public void committedPerformed(IIIMCommittedEvent e) {
	String committed = e.getCommittedString();
	AttributedCharacterIterator iterator =
	    new AttributedString(committed).getIterator();

	inputMethodContext.dispatchInputMethodEvent(InputMethodEvent.
					      INPUT_METHOD_TEXT_CHANGED,
					      iterator,
					      committed.length(),
					      null,
					      null);
    }
}
