/*
 * @(#)IIIMPURLConnection.java	1.6 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.net.MalformedURLException;
import sun.net.NetworkClient;

//public 
class IIIMPURLConnection extends URLConnection {

    NetworkClient nc = null;

    protected IIIMPURLConnection(URL url) {
	super(url);
	// This only creates an instance for NetworkClient.
	nc = new NetworkClient();
    }

    public void connect() throws IOException {
	if (connected == true) {
	    return;
	}
	nc.openServer(url.getHost(), url.getPort());
	connected = true;
    }

    public void disconnect() throws IOException {
	if (connected == false) {
	    return;
	}
	nc.closeServer();
    }

    public boolean isConnected() {
	return nc.serverIsOpen();
    }
    
    public InputStream getInputStream() throws IOException {
	try {
	    connect();
	    return nc.serverInput;
	} catch (RuntimeException e) {
	    disconnect();
	    throw e;
	} catch (IOException e) {
	    disconnect();
	    throw e;
	}
    }

    public OutputStream getOutputStream() throws IOException {
	try {
	    connect();
	    return nc.serverOutput;
	} catch (RuntimeException e) {
	    disconnect();
	    throw e;
	} catch (IOException e) {
	    disconnect();
	    throw e;
	}
    }
}
