/*
 * @(#)IIIMProtocol.java	1.11 99/09/08
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

interface IIIMProtocol {
    // Version of this protocol spec.
    final static int VERSION				= 1;
    
    // Packet size
    final static int FOURBYTES_PACKET 			= 0;
    final static int EIGHTBYTES_PACKET 			= 1;

    // Protocol values
    final static int IM_NO_PROTOCOL 			= 0;
    final static int IM_CONNECT 			= 1;
    final static int IM_CONNECT_REPLY			= 2;
    final static int IM_DISCONNECT			= 3;
    final static int IM_DISCONNECT_REPLY		= 4;
    final static int IM_REGISTER_TRIGGER_KEYS		= 5;
    final static int IM_TRIGGER_NOTIFY  		= 6;
    final static int IM_TRIGGER_NOTIFY_REPLY		= 7;
    final static int IM_SETIMVALUES			= 8;
    final static int IM_SETIMVALUES_REPLY		= 9;
    final static int IM_GETIMVALUES			= 10;
    final static int IM_GETIMVALUES_REPLY		= 11;
    final static int IM_FORWARD_EVENT			= 12;
    final static int IM_FORWARD_EVENT_REPLY		= 13;
    final static int IM_COMMIT_STRING			= 14;
    final static int IM_FORWARD_EVENT_WITH_OPERATIONS	= 15;
    final static int IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY		= 16;
    final static int IM_CREATEIC			= 20;
    final static int IM_CREATEIC_REPLY  		= 21;
    final static int IM_DESTROYIC			= 22;
    final static int IM_DESTROYIC_REPLY 		= 23;
    final static int IM_SETICVALUES			= 24;
    final static int IM_SETICVALUES_REPLY		= 25;
    final static int IM_GETICVALUES			= 26;
    final static int IM_GETICVALUES_REPLY		= 27;
    final static int IM_SETICFOCUS			= 28;
    final static int IM_SETICFOCUS_REPLY		= 29;
    final static int IM_UNSETICFOCUS			= 30;
    final static int IM_UNSETICFOCUS_REPLY		= 31;
    final static int IM_RESETIC				= 32;
    final static int IM_RESETIC_REPLY			= 33;
    final static int IM_PREEDIT_START			= 40;
    final static int IM_PREEDIT_START_REPLY		= 41;
    final static int IM_PREEDIT_DRAW			= 42;
    final static int IM_PREEDIT_DRAW_REPLY		= 43;
    final static int IM_PREEDIT_DONE			= 46;
    final static int IM_PREEDIT_DONE_REPLY		= 47;
    final static int IM_STATUS_START			= 50;
    final static int IM_STATUS_START_REPLY		= 51;
    final static int IM_STATUS_DRAW			= 52;
    final static int IM_STATUS_DRAW_REPLY		= 53;
    final static int IM_STATUS_DONE			= 54;
    final static int IM_STATUS_DONE_REPLY		= 55;
    final static int IM_LOOKUP_CHOICE_START		= 70;
    final static int IM_LOOKUP_CHOICE_START_REPLY	= 71;
    final static int IM_LOOKUP_CHOICE_DRAW		= 72;
    final static int IM_LOOKUP_CHOICE_DRAW_REPLY	= 73;
    final static int IM_LOOKUP_CHOICE_DONE		= 74;
    final static int IM_LOOKUP_CHOICE_DONE_REPLY	= 75;
    final static int IM_LOOKUP_CHOICE_PROCESS		= 76;
    final static int IM_LOOKUP_CHOICE_PROCESS_REPLY	= 77;
    final static int IM_AUX_START			= 90;
    final static int IM_AUX_START_REPLY 		= 91;
    final static int IM_AUX_DRAW			= 92;
    final static int IM_AUX_DRAW_REPLY  		= 93;
    final static int IM_AUX_DONE			= 94;
    final static int IM_AUX_DONE_REPLY  		= 95;
    final static int IM_AUX_SETVALUES			= 96;
    final static int IM_AUX_SETVALUES_REPLY  		= 97;

    // Encoding values
    final static int BIGENDIAN				= 0x42;
    final static int LITTLEENDIAN			= 0x6c;

    final static int LOOKUP_MAX_NUMBER			= 1;
    final static int LOOKUP_STYLE			= 2;
    final static int QUERY_LOOKUP_STYLE 		= 3;
    final static int INPUT_LANGUAGE			= 4;
    final static int PRIMARY_LANGUAGE			= 5;

    // CONTENTS type
    final static int STRING				= 0;
    final static int TEXT				= 1;
    final static int KEYEVENT				= 2;

    // ATTRIBID
    final static int INPUTMETHOD_LIST			= 0x1001;
    final static int OBJECT_DESCRIPTER_LIST		= 0x1010;
    final static int CLIENT_DESCRIPTER			= 0x1011;
    final static int CCDEF				= 0x1030;
    final static int GUI_OBJECT				= 0x1031;
    final static int LWE_OBJECT				= 0x1032;

    // IC ATTRIBID
    final static int IC_INPUT_LANGUAGE			= 1;
    final static int IC_CHARACTER_SUBSETS		= 2;
    final static int IC_INPUT_METHOD			= 3;

    // Object Category
    final static int NOID				= -1;
    final static int GUI_CATEGORY			= 0;
    final static int LWE_CATEGORY			= 1;
    final static int SYNTAX_RULE_CATEGORY		= 2;
    final static int MANAGE_RULE_CATEGORY		= 3;

    // Feedback ID
    final static int DECORATION_FEEDBACK		= 0;
    final static int FOREGROUND_RGB_FEEDBACK		= 1;
    final static int BACKGROUND_RGB_FEEDBACK		= 2;
    final static int UNDERLINE_RGB_FEEDBACK		= 3;

    // Annotation ID
    final static int INPUT_STRING			= 0;
    final static int READING				= 1;
    final static int PART_OF_SPEECH			= 2;
    final static int CLAUSE				= 3;
}

