/*
 * %W% %E%
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.text.*;
import com.sun.iiim.*;

class StatusWindow extends IIIMWindow implements IIIMStatusListener {
    static int xMargin;
    static int width;
    static int height;
    
    StatusPane pane;
    
    int columWidth, columHeight;
    FontMetrics fm;
    
    // Default, no arg constructor
    public StatusWindow() {
    }
    
    void init() {
        window = new Window(new Frame(""));
	window.enableInputMethods(false);        
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
        fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        pane = new StatusPane();
        pane.setFont(font);
        
        window.add(pane);
    }
    
    /* These code causes focus flashing problem with Solaris JVM
       
    public void activate() {
        if (window == null) {
            return;
	}
	window.setVisible(true);
    }

    public void deactivate(boolean isTemporary) {
	if (window == null) {
	    return;
	}
	window.setVisible(false);
    }
    */

    // StatusListener method
    public void statusStart(IIIMStatusEvent e) {
	if (window == null) {
	    init();
	}
    }

    public void statusDone(IIIMStatusEvent e) {
	if (window != null) { 
	    window.setVisible(false);
	}
    }

    public void statusDraw(IIIMStatusEvent e) {
	if (window == null) {
	    return;
	}
	pane.handleEvent(e);

	if(pane.getData().length()==0) return;
	// "15" is the drawString space
	int width = pane.getData().length() * columWidth + 15;
	Insets inset = window.getInsets();
	int height = columHeight + inset.top + inset.bottom ;
        
	window.setSize(width, height);
        
	calculatePosition();
        
	window.setVisible(true);
    }

    public void setLocation(int x, int y) {
    }
    
    void calculatePosition() {
        double width = window.getSize().getWidth();
        
        Component component = getClientComponent();

        Component f = component;
        while(!(f instanceof Frame) && !(f instanceof Dialog)) {
            f = f.getParent();
        }
        
        Point point = f.getLocation();
        
        Dimension size = f.getSize();     
        
        double x = point.getX() + size.getWidth() - width;
        double y = point.getY() + size.getHeight();
        window.setLocation((int)x, (int)y);    
        // If window is out of screen, adjust it
        Point location = window.getLocation();
        double xl = location.getX();
        double yl = location.getY();
        Dimension dm = window.getSize();
        if((xl + dm.getWidth()) > screenWidth) 
            xl = screenWidth - dm.getWidth();
        if((yl + dm.getHeight()) > screenHeight) 
            yl = screenHeight - dm.getHeight();
        window.setLocation((int)xl, (int)yl);        
    }
    
}
