/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef __XLIBINT_HH
#define __XLIBINT_HH
#include <X11/Xlibint.h>
#endif /* __XLIBINT_HH */
#include "Xlcint.h"
#include "XIM.h"
#include "switchIM.h"
#include "iiimpIM.h"

static int
getXIMArg(XIMArg *arg,
	  char *name, void *value) {
  XIMArg *p;
  char *return_name = (char*)0;

  for (p = arg; p->name != 0; p++) {
    if (!strcmp(p->name, XNMultiLingualInput)) {
      *((Bool*)value) = (Bool)p->value;
      return 0;
    }
  }
  return -1;
}

XIM
__XOpenIM(Display *display, XrmDatabase rdb,
	  char *res_name, char *res_class,
	  XIMArg *arg) {
  Bool isMultilingual = False;
  XIM xim = (XIM)0;
  XOpenIMProc open_im;
  XLCd lcd = _XOpenLC("en_US.UTF-8"); /* temporary */

  (void)getXIMArg(arg,
		  XNMultiLingualInput, &isMultilingual);
  open_im = isMultilingual? _SwitchOpenIM : _IIIMP_OpenIM ;
  
  if (isMultilingual)
    putenv("DISABLE_MULTI_SCRIPT_IM=false"); /* hidden feature */
  xim = open_im((XLCd)lcd, display, rdb, res_name, res_class);

  if (xim) ((XimCommon)xim)->isUnicode = isMultilingual;
  return xim;
}
