/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "iiimpIM.h"
#include "iiimp.h"
#include "guiIM.h"
#include "iiimpColor.h"

Bool
SameIMFeedbackList(IMFeedbackList *a, IMFeedbackList *b) {
  int i;
  if (a->count_feedbacks != b->count_feedbacks) return False;
  for (i = 0; i < a->count_feedbacks; i++) {
    if (a->feedbacks[i].type != b->feedbacks[i].type ||
	a->feedbacks[i].value != b->feedbacks[i].value)
      return False;
  }
  return True;
}

typedef enum {
  NO_COLOR = 0,
  FG_COLOR = (1L << 1),
  BG_COLOR = (1L << 2)
} IMSetColor;

int
SetIMColors(XicCommon ic,
	    Display *display, Window win, GC gc, GC rgc,
	    IMFeedbackList *flist, XIMFeedback unused) {
  XColor color;
  Colormap cmap;
  unsigned long r, g, b;
  char colorName[20];		/* enough */
  const char *formater = "#%2.2lX%2.2lX%2.2lX";
  XWindowAttributes attr;
  int i;
  IMSetColor flag = NO_COLOR;
  unsigned long fg = 0, bg = 0;

  cmap = DefaultColormap(display, XIC_GUI(ic, screen_number));
  for (i = 0; i < flist->count_feedbacks; i++) {
    r = (flist->feedbacks[i].value & 0x00ff0000) >> 16;
    g = (flist->feedbacks[i].value & 0x0000ff00) >> 8;
    b = flist->feedbacks[i].value & 0x000000ff;
    sprintf(colorName, formater, r, g, b);
    if (XParseColor(display, cmap, colorName, &color)) {
      XAllocColor(display, cmap, &color);

      switch (flist->feedbacks[i].type) {
      case IM_FOREGROUND_RGB_FEEDBACK:
	fg = color.pixel;
	flag |= FG_COLOR;
	break;
      case IM_BACKGROUND_RGB_FEEDBACK:
	bg = color.pixel;
	flag |= BG_COLOR;
	break;
      case IM_UNDERLINE_RGB_FEEDBACK:
	break;
      default:
	break;
      }
    }
  }
  if (((flag & FG_COLOR) && (flag & BG_COLOR)) ||
      !((flag & FG_COLOR) && !(flag & BG_COLOR))) {
    /* if both are set or none are sets */
    if (fg != bg) {
      XSetForeground(display, gc, fg);
      XSetBackground(display, gc, bg);
    }
    return 1;
  }
  return 0;
}

void
FreeFeedbackList(IMFeedbackList *feedback_list, int len) {
  if (feedback_list) {
    IMFeedbackList *p;
    for (p = feedback_list;
	 p < &feedback_list[len]; p++) {
      if (p->feedbacks) {
	Xfree(p->feedbacks);
	p->feedbacks = 0;
      }
    }
    Xfree(feedback_list);
  }
}
