/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#if !defined(USE_ICONV) && !defined(USE_CSCONV)
#if defined(sun)
#define USE_ICONV
#else
#define USE_CSCONV
#endif
#endif

#ifdef USE_ICONV
#include <iconv.h> 
#endif

#include <locale.h>
#include <langinfo.h>
#include <strings.h>
#if !defined(USE_CSCONV)
#include <errno.h>
#endif /* !USE_CSCONV */
#include "iiimpIM.h"
#include "iiimp.h"
#include "iiimpReq.h"

#define UTF16_STRLEN	4096

#ifdef USE_CSCONV
#include <dlfcn.h>
#include "csconv.h"
#define CSC_PATH	"/usr/lib/im/csconv/csconv.so"
#define CSC_OPEN_LOCALE	"csconv_open_locale"
#define CSC_OPEN	"csconv_open"
#define CSC_CONV	"csconv"
#define CSC_CLOSE	"csconv_close"

typedef csconv_t	(* csc_open_locale_t)(const char *,
					      const char *, const char *);
typedef csconv_t	(* csc_open_t)(const char *, const char *);
typedef size_t		(* csc_conv_t)(csconv_t, const char **, size_t *,
				       char **, size_t *);
typedef int		(* csc_close_t)(csconv_t);

static void *			csc_handle;	
static csc_open_locale_t	csc_open_locale;
static csc_open_t		csc_open;
static csc_conv_t		csc_conv;
static csc_close_t		csc_close;

static char *current_locale = 0;
#endif

#ifdef USE_ICONV
static iconv_t i_conv1 = NULL;
static iconv_t i_conv2 = NULL;
static Bool skip_native_to_utf8_conv = False;
#endif

#ifdef USE_CSCONV
static void
dlopen_csconv()
{
      csc_handle = dlopen(CSC_PATH, RTLD_LAZY);
      if (NULL == csc_handle) {
        csc_handle = (void *)(-1);
	return;
      }

      csc_open_locale = (csc_open_locale_t)dlsym(csc_handle, CSC_OPEN_LOCALE);
      csc_open = (csc_open_t)dlsym(csc_handle, CSC_OPEN);
      csc_conv = (csc_conv_t)dlsym(csc_handle, CSC_CONV);
      csc_close = (csc_close_t)dlsym(csc_handle, CSC_CLOSE);

      if ((NULL == csc_open_locale) || (NULL == csc_open) ||
	  (NULL == csc_conv) || (NULL == csc_close)) {
        dlclose(csc_handle);
	csc_handle = (void *)(-1);
	return;
      }
}
#endif

static int
ConvertToUTF16(char *current_encoding,
	       char *from_buf, size_t from_left,
	       char **to_buf, size_t *to_left) {
  size_t src_len, dst_len;
  char *src, *dst;
#ifndef USE_CSCONV
  const char *ip;
  size_t ileft;
  char *op;
  size_t oleft;
  char buffer[UTF16_STRLEN];		/* Fix me! */
#endif /* !USE_CSCONV */
  const size_t buf_len = UTF16_STRLEN;
  size_t ret = 0;
#ifdef USE_CSCONV
  static csconv_t csconv_cd = NULL;

#endif

  if (current_encoding == NULL) return 0;

#ifdef USE_CSCONV

  do {
    if (((void *)(-1) == csc_handle) ||
	((csconv_t)(-1) == csconv_cd)) {
      continue;
    }
    if (NULL == csc_handle) {
      dlopen_csconv();
      if ((void *)(-1) == csc_handle) {
	continue;
      }
    }
    if (NULL == csconv_cd) {

      csconv_cd = (csc_open_locale)(current_encoding,
				    "UTF-16", "MultiByte");
      
      if ((csconv_t)(-1) == csconv_cd) {
	continue;
      }
    }

    dst = *((char **)to_buf);

    ret = csc_conv(csconv_cd,
		   (const char **)&from_buf, &from_left,
		   &dst, to_left);
    return ret;
  } while (0);
#endif

#ifdef USE_ICONV
  if (i_conv1 == (iconv_t)-1 || i_conv2 == (iconv_t)-1){
    goto done;
  }

  if (i_conv1 == NULL && !skip_native_to_utf8_conv) {
    if (!strcmp(current_encoding, "UTF-8")) {
      skip_native_to_utf8_conv = True;
    } else {
      if ((i_conv1 = iconv_open("UTF-8", current_encoding))
	  == (iconv_t)-1) {
	goto done;
      }
    }
  }

  if (i_conv2 == NULL){
    if ((i_conv2 = iconv_open("UCS-2",
			      "UTF-8")) == (iconv_t)-1)
      goto done;
  }

  if (!skip_native_to_utf8_conv) {
    ip = (const char *)from_buf;
    ileft = from_left;

    op = *((char **)to_buf);
    oleft = *to_left;

    while ((0 < ileft) && (0 < oleft)) {
      dst = buffer;
      dst_len = buf_len;
      ret = iconv(i_conv1, &ip, &ileft, (char**)&dst, &dst_len);
      if ((ret != 0) && (E2BIG != errno)) {
	goto done;
      }

      src = buffer;
      src_len = buf_len - dst_len;

      ret = iconv(i_conv2, (const char**)&src, &src_len, &op, &oleft);
      if (ret != 0) goto done;
    }

    dst_len = oleft;

  } else {
    src = from_buf;
    src_len = from_left;
    dst = *to_buf;
    dst_len = *to_left;

    ret = iconv(i_conv2, (const char**)&src, &src_len, (char**)&dst, &dst_len);
  }

  if (0xFEFF == **((CARD16 **)to_buf)) {
    memmove(*to_buf, *to_buf + 2, *to_left - dst_len - 2);
    *to_left = (dst_len + 2);
  } else {
    *to_left = dst_len;
  }
done:
#endif /* USE_ICONV */
  return(ret);
}

int
IMConvertFromUTF8ToUTF16(char *from_buf, size_t from_left,
			 char **to_buf, size_t *to_left) {
  char *encoding;
#ifdef USE_CSCONV
  encoding = "en_US.UTF-8";
#else
  encoding = "UTF-8";
#endif
  return ConvertToUTF16(encoding,
			from_buf, from_left,
			to_buf, to_left);
}

int
IIimpConvertToUTF16(char *from_buf, size_t from_left,
		    char **to_buf, size_t *to_left) {
#ifdef USE_CSCONV
  if (current_locale == NULL){
    current_locale = (char*)strdup(setlocale(LC_CTYPE, NULL));
  }
  return ConvertToUTF16(current_locale,
			from_buf, from_left,
			to_buf, to_left);
#else
  char *encoding = nl_langinfo(CODESET);
  return ConvertToUTF16(encoding,
			from_buf, from_left,
			to_buf, to_left);
#endif
}

#ifdef USE_ICONV
static iconv_t i_conv1_FromUTF16 = NULL;
static iconv_t i_conv2_FromUTF16 = NULL;
#endif

/* Used when transfering data from AUX to IM,
   do data conversion from UCS2 to EUC */
int
IIimpConvertFromUTF16(char *from_buf, size_t from_left,
		      char **to_buf, size_t * to_left) {
  size_t src_len, dst_len;
  char *src, *dst;
#ifndef USE_CSCONV
  const char *ip;
  size_t ileft;
  char *op;
  size_t oleft;
  char buffer[UTF16_STRLEN];	/* Fix me! */
#endif /* !USE_CSCONV */
  const size_t buf_len = UTF16_STRLEN;
  size_t ret = 0;

#ifdef USE_CSCONV
  static csconv_t csconv_cd = NULL;
#endif

#ifdef USE_CSCONV
  if (current_locale == NULL){
    current_locale = (char*)strdup(setlocale(LC_CTYPE, NULL));
  }
  do {
    if (((void *)(-1) == csc_handle) ||
	((csconv_t)(-1) == csconv_cd)) {
      continue;
    }
    if (NULL == csc_handle) {
      dlopen_csconv();
      if ((void *)(-1) == csc_handle) {
	continue;
      }
    }
    if (NULL == csconv_cd) {

      csconv_cd = (csc_open_locale)(current_locale, "MultiByte", "UTF-16");
      
      if ((csconv_t)(-1) == csconv_cd) {
	continue;
      }
    }

    dst = *((char **)to_buf);

    ret = csc_conv(csconv_cd,
		   (const char **)&from_buf, &from_left, &dst, to_left);
    return ret;
  } while (0);
#endif

#ifdef USE_ICONV
  if (i_conv1_FromUTF16 == (iconv_t)-1 ||
      i_conv2_FromUTF16 == (iconv_t)-1) {
    goto done;
  }

  if (i_conv2_FromUTF16 == NULL && !skip_native_to_utf8_conv) {
    char *encoding = nl_langinfo(CODESET);
    if (!strcmp(encoding, "UTF-8")) {
      skip_native_to_utf8_conv = True;
    } else {
      if ((i_conv2_FromUTF16 = iconv_open(encoding, "UTF-8"))
	  == (iconv_t) - 1) {
	goto done;
      }
    }
  }
  if (i_conv1_FromUTF16 == NULL) {
    if ((i_conv1_FromUTF16 = iconv_open("UTF-8", "UCS-2"))
	== (iconv_t) - 1) {
      goto done;
    }
  }

  if (skip_native_to_utf8_conv) {
    src = from_buf;
    src_len = from_left;	/* don't stop at '\0' in case of ascii */
    dst = *((char **) to_buf);

    ret = iconv(i_conv1_FromUTF16, (const char**)&src, &src_len,
		(char**)&dst, to_left);
  } else {
    ip = (const char *)from_buf;
    ileft = from_left;

    op = *((char **)to_buf);
    oleft = *to_left;

    while ((0 < ileft) && (0 < oleft)) {
      dst = buffer;
      dst_len = buf_len;
      ret = iconv(i_conv1_FromUTF16, &ip, &ileft, (char**)&dst, &dst_len);
      if ((ret != 0) && (E2BIG != errno)) {
	goto done;
      }

      src = buffer;
      src_len = buf_len - dst_len;

      ret = iconv(i_conv2_FromUTF16, (const char**)&src, &src_len,
		  &op, &oleft);
      if (ret != 0) goto done;
    }

    *to_left = oleft;
  }
done:
#endif /* USE_ICONV */
  return(ret);
}

int
IMStringToXIMText(unsigned char *p, XIMText *text, Bool useUnicode) {
  char *ptr;
  CARD16 str_count = 0;
  int i;
  int read_len = 0;

  ptr = (char *)p;
  req_get16(ptr, str_count);
  read_len += 2;

  if (str_count < 0 || str_count > 65000) {
    /* something wrong */
    text->length = 0;
    text->feedback = NULL;
    text->encoding_is_wchar = 0;
    text->string.multi_byte = NULL;
  } else {
    char *string_value;
    int string_value_area_size;

    read_len += str_count;

    if (useUnicode) {
      string_value_area_size = str_count + 1;
      string_value = (char*)Xmalloc(string_value_area_size);
      memmove(string_value, ptr, str_count);
      *(string_value + str_count) = '\0';
    } else {
      CARD16 *utf16_str;
      char *src;
      size_t dst_len;

      string_value_area_size = (((str_count / 2) * MB_CUR_MAX) + 1);
      string_value = (char*)Xmalloc(string_value_area_size);
      dst_len = string_value_area_size;

      utf16_str = (CARD16 *)ptr;

      src = (char *)utf16_str;
      IIimpConvertFromUTF16(src, str_count, &string_value, &dst_len);
      *(string_value + (string_value_area_size - dst_len)) = '\0';
    }
    text->length = str_count/2; /* XIMText->length is character length */
    text->feedback = NULL;
    text->encoding_is_wchar = 0;
    text->string.multi_byte =string_value;
  }
  return read_len;
}

#define TEXT_LEN 64

static int
IMTextlen(unsigned char * p) {
  int len;
  char *ptr;
  int block_len;
  int fb_len;
  int i;

  len = 0;
  ptr = (char *)p;
  req_get32(ptr, block_len);
  for (i = 0; i < block_len; len += 1) {
    ptr += 2; /* skip UTF16 char */
    req_get16(ptr, fb_len);
    ptr += fb_len;
    i += (2 + 2 + fb_len);
  }

  return len;
}

int
IMTextToXIMText(unsigned char *p, XIMText *text,
		IMFeedbackList **feedback_list_ret,
		Bool useUnicode) {
  char *ptr;
  CARD32 byte_length = 0;
  int read_len = 0;
  IMFeedbackList *feedback_list;
  IMFeedbackList *pfeedback_list;
  Bool has_feedback_list = False;

  /* read byte length of list of char_with_feedback */
  ptr = (char *)p;
  req_get32(ptr, byte_length);
  read_len += 4;

  /* read list of char_with_feedback */
  if (byte_length > 0) {
    int feedback_id, feedback_value;
    CARD16 *utf16_str;
    XIMFeedback *feedback_attr;
    int str_len, feedback_len;
    int str_count, feedback_count;
    char *string_value;
    int fb_len;
    int fb_area_len;

    str_len = IMTextlen(p);
    utf16_str = Xmalloc(str_len * 2);

    feedback_len = str_len;
    feedback_attr = Xmalloc((sizeof (XIMFeedback)) * feedback_len);
    if (feedback_list_ret) {
      feedback_list = Xmalloc((sizeof (IMFeedbackList)) * feedback_len);
    } else {
      feedback_list = NULL;
    }

    if ((NULL == utf16_str) || (NULL == feedback_attr) ||
	((NULL != feedback_list_ret) && (NULL == feedback_list))) {
	    Xfree(utf16_str);
	    Xfree(feedback_attr);
	    Xfree(feedback_list);
	    return 0;
    }

    if (NULL != feedback_list) {
      memset(feedback_list, 0, ((sizeof (IMFeedbackList)) * feedback_len));
      pfeedback_list = feedback_list;
    } else {
      pfeedback_list = NULL;
    }

    str_count = 0;
    feedback_count = 0;

    while (byte_length > 0) {
      IMFeedback *pfeedbacks = NULL;

      /* utf16 char */
      req_get16(ptr, *(utf16_str + str_count));
      str_count++;
      read_len += 2;
      byte_length -= 2;

      /* feedback_attr */
      req_get16(ptr, fb_len);
      read_len += 2;
      byte_length -= 2;
      fb_area_len = fb_len;

      while (fb_len > 0) {
	req_get32(ptr, feedback_id);
	req_get32(ptr, feedback_value);
	read_len += 8;
	fb_len -= 8;
	byte_length -= 8;
	if (feedback_id == 0) { /* visual attributes */
	  feedback_attr[feedback_count++] = feedback_value;
	} else {
	  has_feedback_list = True;
	  if (pfeedback_list) {
	    if (!pfeedback_list->feedbacks) { /* first feedback */
	      pfeedback_list->count_feedbacks = 0;
	      pfeedback_list->feedbacks =
		      Xmalloc(sizeof(IMFeedback) * (fb_area_len / 8));
	      pfeedbacks = pfeedback_list->feedbacks;
	    }
	    if (pfeedbacks) {
	      pfeedbacks->type = feedback_id;
	      pfeedbacks->value = feedback_value;
	      pfeedbacks++;
	      pfeedback_list->count_feedbacks++;
	    }
	  }
	}
      }
      if (pfeedback_list) pfeedback_list++;
    }

    if (has_feedback_list && feedback_list_ret) {
      *feedback_list_ret = feedback_list;
    } else {
      Xfree(feedback_list);
    }

    if (useUnicode) {
      string_value = (char*)Xmalloc(str_len * 2 + 1);
      memmove(string_value, utf16_str, str_len * 2);
      *(string_value + str_len * 2) = '\0';
    } else {
      int bl;
      char *src;
      size_t dst_len;

      src = (char *)utf16_str;
      string_value = Xmalloc(str_len * MB_CUR_MAX + 1);
      dst_len = (str_len * MB_CUR_MAX);
      IIimpConvertFromUTF16(src, str_len * 2, &string_value, &dst_len);
      bl = ((str_len * MB_CUR_MAX) - dst_len);
      string_value[bl] = '\0';
    }
    text->length = str_len;
    text->encoding_is_wchar = 0;
    text->string.multi_byte = string_value;
    text->feedback = feedback_attr;

    Xfree(utf16_str);
  } else {
    text->length = 0;
    text->feedback = NULL;
    text->encoding_is_wchar = 0;
    text->string.multi_byte = NULL;
  }

  /* read byte length of list of annotation */
  req_get32(ptr, byte_length);
  read_len += 4;

  /* read list of annotation */
  if (byte_length > 0) {
    read_len += byte_length;
  }  
  return read_len;
}

int
IMTextListToXIMTextList(unsigned char *p, XIMText **text_list,
			IMFeedbackList ***feedback_array,
			int *number, Bool useUnicode) {
  CARD32 byte_length = 0;
  int read_len = 0;
  char *ptr;
  int len;
  XIMText *text_p = (XIMText*)NULL;
  IMFeedbackList **feedback_listp = (IMFeedbackList**)0;
  int count_list;
  int alloc_count;

  ptr = (char *)p;
  req_get32(ptr, byte_length);

  alloc_count = 26;		/* number of alphabet */
  text_p = (XIMText*)Xmalloc(sizeof(XIMText) * alloc_count);
  if (!text_p) return 0;

  feedback_listp = (IMFeedbackList**)Xmalloc(sizeof(IMFeedbackList*) *
					     alloc_count);
  if (!feedback_listp) return 0;

  count_list = 0;
  if (byte_length > 0) {
    XIMText text;
    IMFeedbackList *feedback_list = 0;
    p += 4;			/* 4(byte length of text list) */
    read_len += 4;
    while (byte_length > 0) {
      len = IMTextToXIMText(p, &text, &feedback_list, useUnicode);
      if (len == 0) {
	/* something wrong */
	return 0;
      }
      if (count_list == alloc_count) {
	alloc_count += 26;		/* number of alphabet */
	text_p = (XIMText*)Xrealloc(text_p,
				    sizeof(XIMText) * alloc_count);
	if (!text_p) return 0;
	feedback_listp = (IMFeedbackList**)Xrealloc(feedback_listp,
				    sizeof(IMFeedbackList*) * alloc_count);
	if (!feedback_listp) return 0;
      }
      text_p[count_list].length = text.length;
      text_p[count_list].encoding_is_wchar = text.encoding_is_wchar;
      text_p[count_list].string.multi_byte = text.string.multi_byte;
      text_p[count_list].feedback = text.feedback;

      feedback_listp[count_list] = feedback_list;

      count_list++;
      p += len;			/* 4(byte length of text list) */
      read_len += len;
      byte_length -= len;
    }
  }
  *number = count_list;
  *text_list = text_p;
  *feedback_array = feedback_listp;
  return read_len;
}

#ifndef MAXINT
#define MAXINT          (~((unsigned int)1 << (8 * sizeof(int)) - 1))
#endif /* !MAXINT */

int
IIimpWcstoMbs(XimCommon im, wchar_t *from, int from_len,
	      char *to, int to_len, Status *state) {
  XlcConv conv = im->wtom_conv;
  int from_left;
  int to_left;
  int from_savelen;
  int to_savelen;
  int from_cnvlen;
  int to_cnvlen;
  wchar_t *from_buf;
  char	*to_buf, *tmp_buf;
  Status tmp_state;

  if (!state)
    state = &tmp_state;

  if (!conv || !from || !from_len) {
    *state = XLookupNone;
    return 0;
  }

  if (*from == (wchar_t)0) {
    to[0] = (char)0;
    return 0;
  }
  if (to && to_len) {
    from_left = from_len;
    to_left = to_len;
    from_cnvlen = 0;
    to_cnvlen = 0;
    for (;;) {
      from_savelen = from_left;
      to_savelen = to_left;
      from_buf = &from[from_cnvlen];
      to_buf = &to[to_cnvlen];
      if (_XlcConvert(conv, (XPointer *)&from_buf, &from_left,
		      (XPointer *)&to_buf, &to_left, NULL, 0) < 0) {
	*state = XLookupNone;
	return 0;
      }
      from_cnvlen += (from_savelen - from_left);
      to_cnvlen += (to_savelen - to_left);
      if (from_left == 0) {
	if (to_cnvlen > 0) {
	  *state = XLookupChars;
	} else {
	  *state = XLookupNone;
	}
	return to_cnvlen;
      }
      if (to_left == 0)
	break;
      /* Overflow : the to_left length is so small that it cannot
         accomodate the first mb character in the next conversion block */
      if (to_left < MB_CUR_MAX)
         break;
    }
  }

  from_left = from_len;
  from_cnvlen = 0;
  to_cnvlen = 0;
  /* BugId : 4253988. In case the from_buf is bigger than the to_buffer,
       we need to return the required buffer size and status as XBufferOverflow.
       We create a tmp buffer equals 8 times the from_len and do conversion.
  */
  to_left = (sizeof(wchar_t) * from_len) ;
  tmp_buf = (char *)malloc(to_left);
  for (;;) {
    from_savelen = from_left;
    from_buf = &from[from_cnvlen];
    to_savelen = to_left;
    to_buf = &tmp_buf[to_cnvlen];
    if (_XlcConvert(conv, (XPointer *)&from_buf, &from_left,
		    (XPointer *)&to_buf, &to_left, NULL, 0) < 0) {
      *state = XLookupNone;
      return 0;
    }
    from_cnvlen += (from_savelen - from_left);
    to_cnvlen += (to_savelen - to_left);
    if (from_left == 0) {
      if (to_cnvlen > 0)
	*state = XBufferOverflow;
      else
	*state = XLookupNone;
      break;
    }
  }
  free(tmp_buf);
  return to_cnvlen;
}

int
IIimpMbstoWcs(XimCommon im, char *from, int from_len,
	      wchar_t *to, int to_len, Status *state) {
  XlcConv conv = im->mtow_conv;
  int from_left;
  int to_left;
  int from_savelen;
  int to_savelen;
  int from_cnvlen;
  int to_cnvlen;
  char *from_buf;
  wchar_t *to_buf, *tmp_buf;
  Status tmp_state;

  if (!state)
    state = &tmp_state;

  /* Change to_len as to_len * sizeof(wchar_t)  - byte length */
  to_len = to_len * sizeof(wchar_t); 
  if (!conv || !from || !from_len) {
    *state = XLookupNone;
    return 0;
  }

  if (to && to_len) {
    from_left = from_len;
    to_left = to_len;
    from_cnvlen = 0;
    to_cnvlen = 0;
    for (;;) {
      from_savelen = from_left;
      to_savelen = to_left;
      from_buf = &from[from_cnvlen];
      to_buf = &to[to_cnvlen];
      if (_XlcConvert(conv, (XPointer *)&from_buf, &from_left,
		      (XPointer *)&to_buf, &to_left, NULL, 0) < 0) {
	*state = XLookupNone;
	return 0;
      }
      from_cnvlen += (from_savelen - from_left);
      to_cnvlen += (to_savelen - to_left);
      if (from_left == 0) {
	if (to_cnvlen > 0) {
	  *state = XLookupChars;
	} else {
	  *state = XLookupNone;
	}
	return to_cnvlen;
      }
      if (to_left == 0)
	break;
      /* Overflow : the to_left length is so small that it cannot
         accomodate the first mb character in the next conversion block */
      if (to_left < sizeof(wchar_t)) {
         break;
      }
    }
  }
  from_left = from_len;
  from_cnvlen = 0;
  to_cnvlen = 0;
  /* BugId : 4253988. In case the from_buf is bigger than the to_buffer,
       we need to return the required buffer size and status as XBufferOverflow.
       We create a tmp buffer equals 8 times the from_len and do conversion.
  */
  to_left = from_len ;
  to_buf = (wchar_t *)malloc(to_left * sizeof(wchar_t));
  for (;;) {
    from_savelen = from_left;
    from_buf = &from[from_cnvlen];
    to_savelen = to_left;
    to_buf = &tmp_buf[to_cnvlen];
    from_buf = &from[from_cnvlen];
    if (_XlcConvert(conv, (XPointer *)&from_buf, &from_left,
		    (XPointer *)&to_buf, &to_left, NULL, 0) < 0) {
      *state = XLookupNone;
      return 0;
    }
    from_cnvlen += (from_savelen - from_left);
    to_cnvlen += (to_savelen - to_left);
    if (from_left == 0) {
      if (to_cnvlen > 0)
	*state = XBufferOverflow;
      else
	*state = XLookupNone;
      break;
    }
  }
  free(tmp_buf);
  return to_cnvlen;
}
