/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <dlfcn.h>
#include "iiimpDL.h"
#include "Xlcint.h"

#define	XIM_NAME		"xim"
#define	XIM_NAME_LEN		(sizeof(XIM_NAME) - 1)

#ifdef _LP64
#if defined(__sparcv9)
#define	_MACH64_NAME		"sparcv9"
#define	_MACH64_NAME_LEN	(sizeof (_MACH64_NAME) - 1)
#else  /* !defined(__sparcv9) */
#error "Unknown architecture"
#endif /* defined(__sparcv9) */
#endif /* _LP64 */

static XIMStyles *GetInputStyles(char*, void *);
static void* GetProc(void*, const char*);

static char*
lc_path(const char *dl_name, const char *lc_dir) {
  char *path;
  size_t len;

#ifdef _LP64
  len = (lc_dir ? strlen(lc_dir) : 0 ) +
    (dl_name ? strlen(dl_name) : 0) + _MACH64_NAME_LEN + XIM_NAME_LEN + 10;
  path = Xmalloc(len + 1);

  strcpy(path, lc_dir); strcat(path, "/");
  strcat(path, _MACH64_NAME); strcat(path, "/");
  strcpy(path, XIM_NAME); strcat(path, "/");
  strcat(path, dl_name); strcat(path, ".so");
#else
  len = (lc_dir ? strlen(lc_dir) : 0 ) +
    (dl_name ? strlen(dl_name) : 0) + XIM_NAME_LEN + 10;
  path = Xmalloc(len + 1);

  strcpy(path, lc_dir); strcat(path, "/");
  strcat(path, XIM_NAME); strcat(path, "/");
  strcat(path, dl_name); strcat(path, ".so");
#endif
  return path;
}

static XIMStyles*
GetInputStyles(char *lc_name, void *module) {
  XIMStyles* (*get_styles)() = (XIMStyles*(*)())NULL;
  XIMStyles *values = (XIMStyles*)NULL;

  get_styles = (XIMStyles*(*)())dlsym(module, "GetInputStyles");

  values = (*get_styles)(lc_name);

  return values;
}

static void*
GetProc(void *module, const char *name) {
  void *proc;

  proc = (void*)dlsym(module, name);
  return proc;
}

#ifndef XLOCALEDIR
#define XLOCALEDIR "/usr/lib/X11/locale"
#endif

/* Public functions */
XIMDLRec*
OpenDynamicObject(XLCd lcd) {
  void *module;
  char *path;
  char *lc_dir;
  char *lc_name;
  const char *dl_name = "input_styles";	/* better naming? */
  XIMDLRec *dl_object = (XIMDLRec*)NULL;
  char buf[BUFSIZE];

  dl_object = (XIMDLRec*)Xmalloc(sizeof(XIMDLRec));
  if (!dl_object) goto Error;

  lc_name = lcd->core->name;

  lc_dir = getenv("LDXDBPATH");
  if (lc_dir != NULL){
    strncpy(buf, lc_dir, BUFSIZE);
    buf[BUFSIZE-1] = '\0';
  } else{
    /* Resolve default path for database */
    strcpy(buf, XLOCALEDIR);
  }
  strcat(buf, "/"); strcat(buf, lc_name);
  lc_dir = buf;

  path = lc_path(dl_name, lc_dir);
  if (!path) goto Error;

  module = dlopen(path, RTLD_LAZY);
  if (!module) goto Error;

  dl_object->dl_module = module;
  dl_object->styles = GetInputStyles(lc_name, module);
  dl_object->change_status = (ChangeStatusProc)GetProc(module,
						       "ChangeStatus");
  dl_object->change_preedit = (ChangePreeditProc)GetProc(module,
							 "ChangePreedit");
  dl_object->change_lookup = (ChangeLookupProc)GetProc(module,
						       "ChangeLookup");
  dl_object->register_forwardevent =
    (RegisterForwardEventProc)GetProc(module,
				      "RegisterForwardEvent");
  Xfree(path);
  return dl_object;

 Error:
  if (dl_object) Xfree(dl_object);
  if (path) Xfree(path);
#if 0 /* lc_dir refers buf[] */
  if (lc_dir) Xfree(lc_dir);
#endif /* 0 */
  if (module) dlclose(module);

  return NULL;
}

void
CloseDynamicObject(XIMDLRec *dl_object) {
  if (dl_object->styles) Xfree(dl_object->styles);
  dlclose(dl_object->dl_module);
  return;
}
