/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "iiimpIM.h"
#include "switchIM.h"
#include "guiIM.h"
#include "XimpIm.h"
#include "iiimpIC.h"
#include "status.h"
#include <X11/keysym.h>		/* For IsModifierKey marco */
#include <X11/Xutil.h>		/* For IsModifierKey marco */

#include "status.h"

extern char *SetICValueData(XicCommon ic, XIMArg *values, XICSetMode mode,
			    XimpChangeaMask change_mask);
extern char *GetICValueData(XicCommon ic, XIMArg *values,
			    XimpChangeaMask change_mask);

static void IIIMP_DestroyIC(XIC);
static void IIIMP_SetFocus(XIC);
static void IIIMP_UnSetFocus(XIC);
static char *IIIMP_MbReset(XIC);
static wchar_t *IIIMP_WcReset(XIC);
extern char *IIIMP_SetICValues(XIC, XIMArg *);
extern char *IIIMP_GetICValues(XIC, XIMArg *);
static int IIIMP_MbLookupString(XIC, XKeyEvent*,
				char*, int,
				KeySym*, Status*);
static int IIIMP_WcLookupString(XIC, XKeyEvent*,
				wchar_t*, int,
				KeySym*, Status*);

static XICMethodsRec iiimp_ic_methods = {
  IIIMP_DestroyIC,		/* destroy */
  IIIMP_SetFocus,		/* set_focus */
  IIIMP_UnSetFocus,		/* unset_focus */
  IIIMP_SetICValues,		/* set_values */
  IIIMP_GetICValues,		/* get_values */
  IIIMP_MbReset,		/* mb_reset */
  IIIMP_WcReset,		/* wc_reset */
  IIIMP_MbLookupString,		/* mb_lookup_string */
  IIIMP_WcLookupString,		/* wc_lookup_string */
};

static void SWITCH_DestroyIC(XIC);

static XICMethodsRec switch_ic_methods = {
  SWITCH_DestroyIC,		/* destroy */
  IIIMP_SetFocus,		/* set_focus */
  IIIMP_UnSetFocus,		/* unset_focus */
  0,				/* set_values */
  0,				/* get_values */
  0,				/* mb_reset */
  0,				/* wc_reset */
  0,				/* mb_lookup_string */
  0				/* wc_lookup_string */
};

Bool IIIMP_Local_KeyFilter(Display *d /*unused*/,
			   Window w /* unused */,
			   XEvent *ev, XPointer client_data);

static Bool isConversionOnKey(XimCommon im, XEvent *ev);
static Bool isConversionOffKey(XimCommon im, XEvent *ev);


void
ChangePreeditState(XicCommon ic) {
  if (ic->core.preedit_attr.preedit_state == XIMPreeditEnable &&
      !IsConversionMode(ic)) {
    if (True == IMTriggerNotify(ic, CONV_ON)) {
      SetConversionMode(ic, True);
    }
  }
  if (ic->core.preedit_attr.preedit_state == XIMPreeditDisable &&
      IsConversionMode(ic)) {
    IMTriggerNotify(ic, CONV_OFF);
    SetConversionMode(ic, False);
  }
  return;
}

void
SetConversionMode(XicCommon ic, int mode) {
  XIC_IIIMP(ic, filtered) = mode;

  ic->core.preedit_attr.preedit_state = ((mode == True) ?
					 XIMPreeditEnable :
					 XIMPreeditDisable);
  if ((int)ic->core.preedit_attr.state_notify_callback.callback) {
    XIMPreeditStateNotifyCallbackStruct call_data;
    call_data.state = ic->core.preedit_attr.preedit_state;
    ic->core.preedit_attr.state_notify_callback.callback((XIC)ic,
		 ic->core.preedit_attr.state_notify_callback.client_data,
		 (XPointer)&call_data);
  }
  if (XIM_IS_SWITCH(ic->core.im)) {
    if (mode == False) {		/* CONV_OFF */
      ResetSwitchFilter(ic);
      Ximp_Local_Status_Set(ic);
      Ximp_Local_Status_Draw(ic);
    } else {
      ic->active_filter = IIIMP_Local_KeyFilter,
      ic->active_methods = &iiimp_ic_methods;
    }
  }
}

static Bool
isTriggerKey(XIMTriggerKeys *trigger_keys, XEvent *ev) {
  int i;
  KeySym keysym;
  char buf[20];
  int len = sizeof(buf);
  int count_keys = trigger_keys->count_keys;
  XIMTriggerKey *key_list = trigger_keys->keylist;

  (void) XLookupString((XKeyEvent *)ev, buf, len - 1, &keysym, NULL);

  if (ev->xkey.keycode == XIM_COMPOSE_KEYCODE) return False;
  if (IsModifierKey(keysym)) return False;

  for (i = 0; i < count_keys; i++) {
    if (((0 == key_list[i].modifier) ||
	 (ev->xkey.state & key_list[i].modifier)) &&
	keysym == key_list[i].keychar) {
      return True;
    }
  }
  return False;
}

static SwitchMode
SwitchFilter(XicCommon ic, XEvent *ev) {
  XimCommon im = (XimCommon)ic->core.im;
  if (IsConversionMode(ic)) {
    if (XIM_IIIMP(im, off_keys.count_keys) > 0 &&
	isConversionOffKey(im, ev)) {
      return Switch_OFF;
    }
  } else {
    if (isConversionOnKey(im, ev)) {
      return Switch_ON;
    }
  }
  return Switch_NOP;
}

static Bool
isConversionOnKey(XimCommon im, XEvent *ev) {
  return isTriggerKey(&XIM_IIIMP(im, on_keys), ev);
}

static Bool
isConversionOffKey(XimCommon im, XEvent *ev) {
  return isTriggerKey(&XIM_IIIMP(im, off_keys), ev);
}

Bool
IIIMP_Local_KeyFilter(Display *d /*unused*/,
		      Window w /* unused */,
		      XEvent *ev, XPointer client_data) {
  XicCommon ic = (XicCommon)client_data;
  XimCommon im = (XimCommon)ic->core.im;
  Bool b;

  if (ic->ximp_icpart == NULL) {
    /* most likely associated ic has been already destroyed */
    _XUnregisterFilter(d, w, IIIMP_Local_KeyFilter, (XPointer)ic);
    return False;
  }
  if (ev->xkey.keycode == XIM_COMPOSE_KEYCODE) {
    return False;
  }
  if (0 < XIC_IIIMP(ic, key_event_num)) {
    XIC_IIIMP(ic, key_event_num) -= 1;
    return False;
  }

  if (KeyRelease == ev->xkey.type) {
    XIMCallback *cb = &ic->forward_event_callback;
    if (NULL != cb->callback) {
      (*cb->callback)((XIC)ic, cb->client_data, (XPointer)ev);
      return True;
    } else {
      return False;
    }
  }

  if (XIM_IIIMP(im, on_keys.count_keys) == 0) {
    /* Static Event Flow */
    return IMForwardEvent((XIC)ic, ev);
  }

  /* Dynamic Event flow */
  if (IsConversionMode(ic)) {
    if (XIM_IIIMP(im, off_keys.count_keys) > 0 &&
	isConversionOffKey(im, ev)) {
      IMTriggerNotify(ic, CONV_OFF);
      SetConversionMode(ic, False);
      if (NULL != ic->local_icpart) {
        Ximp_Local_Status_Reset(ic);
      }
      return True;
    }
    b = IMForwardEvent((XIC)ic, ev);
    PutBackXKeyEvent(ic);
#ifdef FORWARD_EVENT_CB
    if (!b) {
      if (XIC_IIIMP(ic, forward_event_callback.callback)) {
	XIMCallback *cb = &XIC_IIIMP(ic, forward_event_callback);
	b = (*(int(*)())cb->callback)(ic, cb->client_data, (XPointer)ev);
      }
    }
#endif
    return b;
/*      return IMForwardEvent((XIC)ic, ev); */
  } else {
    if (isConversionOnKey(im, ev)) {
      if (True == IMTriggerNotify(ic, CONV_ON)) {
        SetConversionMode(ic, True);
	IIIMP_SetFocus((XIC)ic);
	return True;
      } else {
	return False;
      }
    }
  }
  return False;
}

/* Public functions */
XIC
CreateIC(XimCommon im, XIMArg *arg) {
  XicCommon ic = (XicCommon)NULL;

  ic = (XicCommon)Xmalloc(sizeof(XicCommonRec));
  if (ic == (XicCommon)NULL) goto Error;
  memset(ic, 0, sizeof(XicCommonRec));

  ic->core.im = (XIM)im;
  ic->methods = &iiimp_ic_methods;

  if (!CommonCreateIC((XIC)ic, arg)) goto Error;
    
  if (!IIIMP_CreateIC_SWITCH((XIC)ic, arg)) goto Error;

  _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			 KeyPress, KeyRelease,
			 IIIMP_Local_KeyFilter, (XPointer)ic);
  return (XIC)ic;
 Error:
  if (ic) Xfree(ic);
  return 0;
}

Status
IIIMP_CreateIC_SWITCH(XIC xic, XIMArg *arg) {
  XicCommon ic = (XicCommon)xic;
  XimCommon im = (XimCommon)ic->core.im;
  int icid;
  XimpChangeMaskRec dummy;

  if ((icid = IMCreateIC(im)) == -1) {
    goto Error;
  }

  ic->core.filter_events = KeyPressMask|ExposureMask|
    ButtonPressMask |PointerMotionMask;
  if (!(ic->iiimp_icpart = Xmalloc(sizeof(XICIIimpIMRec)))) {
    goto Error;
  }
  memset(ic->iiimp_icpart, 0, sizeof(XICIIimpIMRec));
  XIC_IIIMP(ic, icid) = icid;
  SetConversionMode(ic, False);

  XIC_IIIMP(ic, switch_methods) = &switch_ic_methods;

  memset(&dummy, 0, sizeof(dummy));
  if (SetICValueData(ic, arg, CREATE_IC, &dummy)) {
    goto Error;
  }

  /* switch */
  if (XIM_IS_SWITCH(im)) {
    RegisterSwitchFilter(ic, SwitchFilter,
			 IIIMP_Local_KeyFilter,
			 &iiimp_ic_methods);
  }
  return True;
 Error:
  if (ic->iiimp_icpart) Xfree(ic->iiimp_icpart);
  return False;
}

static void
IIIMP_DestroyIC(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		     IIIMP_Local_KeyFilter, (XPointer)ic);
  SWITCH_DestroyIC(xic);
  CommonDestroyIC(xic);
  return;
}

static void
IIIMP_SetFocus(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  XimCommon im = (XimCommon)ic->core.im;

  if (XIM_IIIMP(im, current_ic) == xic) {
    IIIMP_UnSetFocus(xic);
  }
  XIM_IIIMP(im, current_ic) = xic;

  XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_SETFOCUS, NULL);
  (void)IMSetFocus(ic);

  if (!XIM_IS_SWITCH(ic->core.im)) {
    _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			   KeyPress, KeyRelease,
			   IIIMP_Local_KeyFilter, (XPointer)ic);
  }
  return;
}

static void
IIIMP_UnSetFocus(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  XimCommon im = (XimCommon)ic->core.im;

  XIM_IIIMP(im, current_ic) = (XIC)NULL;

  (void)IMUnsetFocus(ic);

  _XUnregisterFilter(ic->core.im->core.display, ic->core.focus_window,
		     IIIMP_Local_KeyFilter, (XPointer)ic);

  if (ic->gui_icpart) {
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_HIDE, NULL);
  }

  return;
}

static char*
IIIMP_MbReset(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  (void)IMResetIC(ic);
  ic->core.preedit_attr.preedit_state = XIMPreeditDisable;
  ChangePreeditState(ic);
  return (char*)NULL;
}

static wchar_t*
IIIMP_WcReset(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  (void)IMResetIC(ic);
  ic->core.preedit_attr.preedit_state = XIMPreeditDisable;
  ChangePreeditState(ic);
  return (wchar_t*)NULL;
}

char*
IIIMP_SetICValues(XIC xic, XIMArg *arg) {
  XicCommon ic = (XicCommon)xic;
  XimpChangeMaskRec dummy;
  char *ret = NULL;

  memset(&dummy, 0, sizeof (dummy));

  ret = SetICValueData(ic, arg, SET_IC, &dummy);

  return ret;
}

char*
IIIMP_GetICValues(XIC xic, XIMArg *arg) {
  XicCommon ic = (XicCommon)xic;
  XimpChangeMaskRec dummy;
  char *ret = NULL;

  memset(&dummy, 0, sizeof (dummy));

  (void)IMGetICValues(ic, NULL, 0);

  ret = GetICValueData(ic, arg, &dummy);

  return ret;
}

int
IIIMP_MbLookupString_SWITCH(XIC xic, XKeyEvent *ev,
			    char *buffer, int len,
			    KeySym *keysym, Status *status) {
  if ((NULL != XIC_IIIMP((XicCommon)xic, mb)) &&
      (XIM_COMPOSE_KEYCODE == ev->keycode)) {
    return IIIMP_MbLookupString(xic, ev, buffer, len, keysym, status);
  } else {
    return 0;
  }
}

static int
IIIMP_MbLookupString(XIC xic, XKeyEvent *ev,
		     char *buffer, int len,
		     KeySym *keysym, Status *status) {
  XicCommon ic = (XicCommon)xic;
  int ret;
  XComposeStatus compose_status;

  if (ev->keycode == XIM_COMPOSE_KEYCODE) { /* Composed Event */
    char *mb;
    KeySym keysym_return;
    mb = XIC_IIIMP(ic, mb);
    keysym_return = XIC_IIIMP(ic, keysym_return);

    if (NULL == mb) {
      return 0;
    }

    ret = strlen(mb);
    if (ret > len) {
      if (status) *status = XBufferOverflow;
      return (ret);
    }
    memmove(buffer, mb, ret);
    if (keysym) {
      if (keysym_return)
	*keysym = keysym_return;
      else
	*keysym = NoSymbol;
    }
    if (status) {
      if (keysym_return)
	*status = XLookupBoth;
      else
	*status = XLookupChars;
    }
    Xfree(mb);
    XIC_IIIMP(ic, mb) = NULL;    
    return (ret);
  } else { /* Throughed Event */
    (void)memset((void *)&compose_status, 0, sizeof(XComposeStatus));
    ret = _Ximp_LookupMBText((Ximp_XIC)ic, ev,
			     (unsigned char *)buffer,
			     len, keysym, &compose_status);
    if (ret > 0) {
      if (keysym && *keysym != NoSymbol) {
	if (status) *status = XLookupBoth;
      } else {
	if (status) *status = XLookupChars;
      }
    } else {
      if (keysym && *keysym != NoSymbol) {
	if (status) *status = XLookupKeySym;
      } else {
	if (status) *status = XLookupNone;
      }
    }
  }
  return (ret);
}

int
IIIMP_WcLookupString_SWITCH(XIC xic, XKeyEvent *ev,
			    wchar_t *buffer, int len,
			    KeySym *keysym, Status *status) {
  if ((NULL != XIC_IIIMP((XicCommon)xic, mb)) &&
      (XIM_COMPOSE_KEYCODE == ev->keycode)) {
    return IIIMP_WcLookupString(xic, ev, buffer, len, keysym, status);
  } else {
    return 0;
  }
}

static int
IIIMP_WcLookupString(XIC xic, XKeyEvent *ev,
		     wchar_t *buffer, int len,
		     KeySym *keysym, Status *status) {
  XicCommon ic = (XicCommon)xic;
  XimCommon im = (XimCommon)ic->core.im;
  int ret;
  XComposeStatus compose_status;

  if (ev->keycode == XIM_COMPOSE_KEYCODE) { /* Composed Event */
    KeySym keysym_return;

    keysym_return = XIC_IIIMP(ic, keysym_return);

    ret = 0;
    if (XIC_IIIMP(ic, mb)) {
      int byte_len = strlen(XIC_IIIMP(ic, mb));
      Status sts;
      if ((ret = IIimpMbstoWcs(im, XIC_IIIMP(ic, mb), byte_len,
			       buffer, len, &sts)) < 0) {
	ret = 0;
	if(status) *status = XLookupNone;
      } else if (sts == XBufferOverflow) {
	*status = XBufferOverflow;
	return ret; /* Immidiately return */
      }
      if (keysym) {
	if (keysym_return)
	  *keysym = keysym_return;
	else
	  *keysym = NoSymbol;
      }
      if (status) {
	if (keysym_return)
	  *status = XLookupBoth;
	else
	  *status = XLookupChars;
      }
    }
    Xfree(XIC_IIIMP(ic, mb));
    XIC_IIIMP(ic, mb) = NULL;    
    return (ret);
  } else { /* Throughed Event */
    (void)memset((void *)&compose_status, 0, sizeof(XComposeStatus));
    ret = _Ximp_LookupWCText((Ximp_XIC)ic, ev, buffer,
			     len, keysym, &compose_status);
    if (ret > 0) {
      if (keysym && *keysym != NoSymbol) {
	if (status) *status = XLookupBoth;
      } else {
	if (status) *status = XLookupChars;
      }
    } else {
      if (keysym && *keysym != NoSymbol) {
	if (status) *status = XLookupKeySym;
      } else {
	if (status) *status = XLookupNone;
      }
    }
  }
  return (ret);
}

void
HoldXKeyEvent(XicCommon ic, XEvent * ev) {
  XICKeyEventListRec *	kel;

  kel = (XICKeyEventListRec *)Xmalloc(sizeof (XICKeyEventListRec));
  if (NULL == kel) {
    return;
  }

  memcpy(&(kel->key_event), ev, sizeof (XKeyEvent));
  kel->next = XIC_IIIMP(ic, key_event_list);
  XIC_IIIMP(ic, key_event_list) = kel;

  return;
}

void
PutBackXKeyEvent(XicCommon ic) {
  XICKeyEventListRec *	key_event_list;
  XICKeyEventListRec *	kel;
  int			key_event_num;

  key_event_list = XIC_IIIMP(ic, key_event_list);
  if (NULL == key_event_list) {
    return;
  }

  key_event_num = XIC_IIIMP(ic, key_event_num);
  if (key_event_num < 0) {
    key_event_num = 0;
  }

  while (NULL != key_event_list) {
    if (XIM_COMPOSE_KEYCODE != key_event_list->key_event.keycode) {
      key_event_num += 1;
    }
    XPutBackEvent(ic->core.im->core.display,
		  (XEvent *)(&key_event_list->key_event));
    kel = key_event_list->next;
    Xfree(key_event_list);
    key_event_list = kel;
  }

  XIC_IIIMP(ic, key_event_list) = NULL;
  XIC_IIIMP(ic, key_event_num) = key_event_num;

  return;
}

void
IIIMPKeyEventFilter(XicCommon ic, Window old_focus) {
  _XUnregisterFilter(ic->core.im->core.display, old_focus,
		     IIIMP_Local_KeyFilter, (XPointer)ic);
  _XRegisterFilterByType(ic->core.im->core.display, ic->core.focus_window,
			 KeyPress, KeyRelease,
			 IIIMP_Local_KeyFilter, (XPointer)ic);
  return;
}

/* Switching */
void
SWITCH_DestroyIC(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  XimCommon im = (XimCommon)ic->core.im;

  if (XIM_IIIMP(im, current_ic) == xic) {
    IIIMP_UnSetFocus(xic);
  }
  if (XIC_IIIMP(ic, mb)) {
    Xfree(XIC_IIIMP(ic, mb));
    XIC_IIIMP(ic, mb) = NULL;
  }

  (void)IMDestroyIC(ic);

  _XUnregisterFilter(ic->core.im->core.display,
		     ic->core.focus_window,
		     IIIMP_Local_KeyFilter, (XPointer)ic);

  if (ic->gui_icpart) {
    XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_DESTROY, NULL);
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DESTROY, NULL);
    XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_DESTROY, NULL);
  }
  return;
}
