/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "iiimpIM.h"
#include "switchIM.h"
#include "guiIM.h"
#include "guiIMPre.h"
#include "iiimpICG.h"
#include "XimpIm.h"
#include "trace_message.h"

extern int SelectCharacterSubset(XicCommon,
				 XIMUnicodeCharacterSubset *aSubset);

Bool
PreeditSetAttributes(XicCommon ic, Ximp_PreeditPropRec4 *attr,
		     XIMArg *vl, XICSetMode mode,
		     XimpChangeaMask change_mask,
		     char *return_name) {
  XIMArg *p;

  for (p = vl; p && p->name != NULL; p++) {
    TRACE_MESSAGE('a', ("iiimp_PreeditSetAttributes: %s\n", p->name));
    if (strcmp(p->name, XNArea)==0) {
      ic->core.preedit_attr.area.x = ((XRectangle *)p->value)->x;
      ic->core.preedit_attr.area.y = ((XRectangle *)p->value)->y;
      ic->core.preedit_attr.area.width = ((XRectangle *)p->value)->width;
      ic->core.preedit_attr.area.height = ((XRectangle *)p->value)->height;
      if (ic->core.preedit_attr.area.width == 0) {
	ic->core.preedit_attr.area.width = GetAreaNeededWidth(ic);
      }
      if (ic->core.preedit_attr.area.height == 0) {
	ic->core.preedit_attr.area.height = GetAreaNeededHeight(ic);
      }
      attr->Area.x      = ic->core.preedit_attr.area.x;
      attr->Area.y      = ic->core.preedit_attr.area.y;
      attr->Area.width  = ic->core.preedit_attr.area.width;
      attr->Area.height = ic->core.preedit_attr.area.height;
      XIMP_SET_PREAREAMASK(ic, change_mask);
      XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_WIN, NULL);

    } else if (strcmp(p->name, XNAreaNeeded)==0) {
      ic->core.preedit_attr.area_needed.width
	= ((XRectangle *)p->value)->width;
      ic->core.preedit_attr.area_needed.height
	= ((XRectangle *)p->value)->height;
      attr->AreaNeeded.width  = ic->core.preedit_attr.area_needed.width;
      attr->AreaNeeded.height = ic->core.preedit_attr.area_needed.height;
      XIMP_SET_PREAREANEEDMASK(ic, change_mask);

    } else if (strcmp(p->name, XNSpotLocation)==0) {
      ic->core.preedit_attr.spot_location.x = ((XPoint *)p->value)->x;
      ic->core.preedit_attr.spot_location.y = ((XPoint *)p->value)->y;
      attr->SpotLocation.x = ic->core.preedit_attr.spot_location.x;
      attr->SpotLocation.y = ic->core.preedit_attr.spot_location.y;
      XIMP_SET_PRESPOTLMASK(ic, change_mask);
      XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_MOVE, NULL);
      XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_MOVE, NULL);

    } else if (strcmp(p->name, XNColormap)==0) {
      ic->core.preedit_attr.colormap = (Colormap)p->value;
      attr->Colormap = ic->core.preedit_attr.colormap;
      XIMP_SET_PRECOLORMAPMASK(ic, change_mask);

    } else if (strcmp(p->name, XNStdColormap)==0) {
      XStandardColormap *colormap_ret;
      int count;
      if (XGetRGBColormaps(ic->core.im->core.display,
			   ic->core.focus_window, &colormap_ret,
			   &count, (Atom)p->value) != 0) {
	ic->core.preedit_attr.std_colormap = (Atom)p->value;
	attr->StdColormap = ic->core.preedit_attr.std_colormap;
	XIMP_SET_PRESTDCOLORMAPMASK(ic, change_mask);
      } else {
	return_name = p->name;
	return False;
      }

    } else if (strcmp(p->name, XNBackground)==0) {
      ic->core.preedit_attr.background = (unsigned long)p->value;
      attr->Background = ic->core.preedit_attr.background;
      XIMP_SET_PREBGMASK(ic, change_mask);
      XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_BG, NULL);

    } else if (strcmp(p->name, XNForeground)==0) {
      ic->core.preedit_attr.foreground = (unsigned long)p->value;
      attr->Foreground = ic->core.preedit_attr.foreground;
      XIMP_SET_PREFGMASK(ic, change_mask);
      XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_FG, NULL);

    } else if (strcmp(p->name, XNBackgroundPixmap)==0) {
      ic->core.preedit_attr.background_pixmap = (Pixmap)p->value;
      attr->Bg_Pixmap = ic->core.preedit_attr.background_pixmap;
      XIMP_SET_PREBGPIXMAPMASK(ic, change_mask);

    } else if (strcmp(p->name, XNFontSet)==0) {
      if (ic->core.preedit_attr.fontset == (XFontSet)p->value) {
	/* same font, no need to set again */
	continue;
      }
      ic->core.preedit_attr.fontset = (XFontSet)p->value;
      XIMP_SET_PREFONTMASK(ic, change_mask);
      XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_FONT, NULL);
#if 0
      if (p->value != NULL) {
	int list_ret;
	XFontStruct **struct_list;
	char **name_list;
	int i, len;
	char *tmp;

	if (ic->ximp_icpart->preedit_font)
	  Xfree(ic->ximp_icpart->preedit_font);
	list_ret = XFontsOfFontSet(ic->core.preedit_attr.fontset,
				   &struct_list, &name_list);
	for (i = 0, len = 0; i < list_ret; i++) {
	  len += (strlen(name_list[i]) + sizeof(char));
	}
	if ((tmp = Xmalloc(len + list_ret + sizeof(char))) == NULL) {
	  return_name = p->name;
	  return False;
	}
	tmp[0] = NULL;
	for (i = 0; i < list_ret; i++) {
	  strcat(tmp, name_list[i]);
	  strcat(tmp, ",");
	}
	tmp[len + i - 1] = NULL;
	ic->ximp_icpart->preedit_font = tmp;
      } else {
	return_name = p->name;
	return False;
      }
#endif
    } else if (strcmp(p->name, XNLineSpace)==0) {
      ic->core.preedit_attr.line_spacing = (long)p->value;
      attr->LineSpacing = ic->core.preedit_attr.line_spacing;
      XIMP_SET_PRELINESPMASK(ic, change_mask);

    } else if (strcmp(p->name, XNCursor)==0) {
      ic->core.preedit_attr.cursor = (Cursor)p->value;
      attr->Cursor = ic->core.preedit_attr.cursor;
      XIMP_SET_PRECURSORMASK(ic, change_mask);

    } else if (strcmp(p->name, XNPreeditStartCallback)==0) {
      ic->core.preedit_attr.start_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.preedit_attr.start_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_PRE_CALLBAK;

    } else if (strcmp(p->name, XNPreeditDoneCallback)==0) {
      ic->core.preedit_attr.done_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.preedit_attr.done_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_PRE_CALLBAK;
		    
    } else if (strcmp(p->name, XNPreeditDrawCallback)==0) {
      ic->core.preedit_attr.draw_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.preedit_attr.draw_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_PRE_CALLBAK;

    } else if (strcmp(p->name, XNPreeditCaretCallback)==0) {
      ic->core.preedit_attr.caret_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.preedit_attr.caret_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_PRE_CALLBAK;
/*
  4325454: XNPreeditState and XNPreeditStateNotifyCallback should be
	handled as PreeditAttribute
*/
    } else if (strcmp(p->name, XNPreeditState)==0) {
      ic->core.preedit_attr.preedit_state = (XIMPreeditState)p->value;
      ChangePreeditState(ic);
    } else if (strcmp(p->name, XNPreeditStateNotifyCallback)==0) {
      ic->core.preedit_attr.state_notify_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.preedit_attr.state_notify_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_PRE_CALLBAK;
    }
  }
  return True;
}

Bool
StatusSetAttributes(XicCommon ic, Ximp_StatusPropRec4 *attr,
		    XIMArg *vl, XICSetMode mode,
		    XimpChangeaMask change_mask, char *return_name) {
  XIMArg *p;

  for (p = vl; p && p->name != NULL; p++) {
    if (strcmp(p->name, XNArea)==0) {
      ic->core.status_attr.area.x = ((XRectangle *)p->value)->x;
      ic->core.status_attr.area.y = ((XRectangle *)p->value)->y;
      ic->core.status_attr.area.width = ((XRectangle *)p->value)->width;
      ic->core.status_attr.area.height = ((XRectangle *)p->value)->height;
      attr->Area.x      = ic->core.status_attr.area.x;
      attr->Area.y      = ic->core.status_attr.area.y;
      attr->Area.width  = ic->core.status_attr.area.width;
      attr->Area.height = ic->core.status_attr.area.height;
      XIMP_SET_STSAREAMASK(ic, change_mask);
      XIC_GUI(ic, change_status)((XIC)ic, STATUS_WIN, NULL);

    } else if (strcmp(p->name, XNAreaNeeded)==0) {
      ic->core.status_attr.area_needed.width
	= ((XRectangle *)p->value)->width;
      ic->core.status_attr.area_needed.height
	= ((XRectangle *)p->value)->height;
      attr->AreaNeeded.width  = ic->core.status_attr.area_needed.width;
      attr->AreaNeeded.height = ic->core.status_attr.area_needed.height;
      XIMP_SET_STSAREANEEDMASK(ic, change_mask);

    } else if (strcmp(p->name, XNColormap)==0) {
      ic->core.status_attr.colormap = (Colormap)p->value;
      attr->Colormap = ic->core.status_attr.colormap;
      XIMP_SET_STSCOLORMAPMASK(ic, change_mask);

    } else if (strcmp(p->name, XNStdColormap)==0) {
      XStandardColormap *colormap_ret;
      int count;
      if (XGetRGBColormaps(ic->core.im->core.display,
			   ic->core.focus_window, &colormap_ret,
			   &count, (Atom)p->value) !=0) {
	ic->core.status_attr.std_colormap = (Atom)p->value;
	attr->StdColormap = ic->core.status_attr.std_colormap;
	XIMP_SET_STSSTDCOLORMAPMASK(ic, change_mask);
      } else {
	return_name = p->name;
	return False;
      }

    } else if (strcmp(p->name, XNBackground)==0) {
      ic->core.status_attr.background = (unsigned long)p->value;
      attr->Background = ic->core.status_attr.background;
      XIMP_SET_STSBGMASK(ic, change_mask);
      XIC_GUI(ic, change_status)((XIC)ic, STATUS_BG, NULL);

    } else if (strcmp(p->name, XNForeground)==0) {
      ic->core.status_attr.foreground = (unsigned long)p->value;
      attr->Foreground = ic->core.status_attr.foreground;
      XIMP_SET_STSFGMASK(ic, change_mask);
      XIC_GUI(ic, change_status)((XIC)ic, STATUS_FG, NULL);

    } else if (strcmp(p->name, XNBackgroundPixmap)==0) {
      ic->core.status_attr.background_pixmap = (Pixmap)p->value;
      attr->Bg_Pixmap = ic->core.status_attr.background_pixmap;
      XIMP_SET_STSBGPIXMAPMASK(ic, change_mask);

    } else if (strcmp(p->name, XNFontSet)==0) {
      if (ic->core.status_attr.fontset == (XFontSet)p->value) {
	/* same font, no need to set again */
	continue;
      }
      ic->core.status_attr.fontset = (XFontSet)p->value;
      XIMP_SET_STSFONTMASK(ic, change_mask);
      XIC_GUI(ic, change_status)((XIC)ic, STATUS_FONT, NULL);

#if 0
      if (p->value != NULL) {
	int list_ret;
	XFontStruct **struct_list;
	char **name_list;
	int i, len;
	char *tmp;
	if (ic->ximp_icpart->status_font)
	  Xfree(ic->ximp_icpart->status_font);
	list_ret = XFontsOfFontSet(ic->core.status_attr.fontset,
				   &struct_list, &name_list);
	for(i = 0, len = 0; i < list_ret; i++) {
	  len += (strlen(name_list[i]) + sizeof(char));
	}
	if ((tmp = Xmalloc(len + list_ret + sizeof(char))) == NULL){
	  return_name = p->name;
	  return False;
	}
	tmp[0] = NULL;
	for(i = 0; i < list_ret; i++) {
	  strcat(tmp, name_list[i]);
	  strcat(tmp, ",");
	}
	tmp[len + i - 1] = NULL;
	ic->ximp_icpart->status_font = tmp;
      } else {
	return_name = p->name;
	return False;
      }
#endif
    } else if (strcmp(p->name, XNLineSpace)==0) {
      ic->core.status_attr.line_spacing = (long)p->value;
      attr->LineSpacing = ic->core.status_attr.line_spacing;
      XIMP_SET_STSLINESPMASK(ic, change_mask);

    } else if (strcmp(p->name, XNCursor)==0) {
      ic->core.status_attr.cursor = (Cursor)p->value;
      attr->Cursor = ic->core.status_attr.cursor;
      XIMP_SET_STSCURSORMASK(ic, change_mask);

    } else if (strcmp(p->name, XNStatusStartCallback)==0) {
      ic->core.status_attr.start_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.status_attr.start_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_STS_CALLBAK;

    } else if (strcmp(p->name, XNStatusDoneCallback)==0) {
      ic->core.status_attr.done_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.status_attr.done_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_STS_CALLBAK;

    } else if (strcmp(p->name, XNStatusDrawCallback)==0) {
      ic->core.status_attr.draw_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.status_attr.draw_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_STS_CALLBAK;
    }
  }
  return True;
}

char*
SetICValueData(XicCommon ic, XIMArg *values, XICSetMode mode,
	       XimpChangeaMask change_mask) {
  XIMArg *p;
  char *return_name = NULL;

  for (p = values; p->name != NULL; p++) {
    TRACE_MESSAGE('v', ("iiimp_SetICValueData: %s\n", p->name));
    if (strcmp(p->name, XNInputStyle) == 0) {
      if (mode == CREATE_IC) {
	/* already set */
	continue;
      } else if (mode == SET_IC) {
	return_name = p->name;
	break; /* Can't change this value */
      }
    } else if (strcmp(p->name, XNClientWindow)==0) {
      if (!(ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN)) {
	ic->core.client_window = (Window)p->value;
	ic->ximp_icpart->value_mask |= XIMP_CLIENT_WIN;
	if (!(XIMP_CHK_FOCUSWINMASK(ic))) {
	  ic->core.focus_window = ic->core.client_window;
	  XIMP_SET_FOCUSWINMASK2(ic, change_mask);
	}
	XIC_GUI(ic, change_status)((XIC)ic, STATUS_CREATE, NULL);
	XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_CREATE, NULL);
	XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_CREATE, NULL);

	SetScreenNumber(ic);
	FilterConfigureNotify(ic->core.im->core.display,
			      ic->core.focus_window,
			      NULL, (XPointer)ic);
      } else {
#ifdef NO_CLIENTWIN_CHANGE
	return_name = p->name;
	break; /* Can't change this value */
#else
	/* allow to change client window */
	/* destroy status/preedit/lookup */
	XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_DESTROY, NULL);
	XIC_GUI(ic, change_status)((XIC)ic, STATUS_DESTROY, NULL);
	XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_DESTROY, NULL);

	ic->core.client_window = (Window)p->value;
	if (!(XIMP_CHK_FOCUSWINMASK(ic))) {
	  ic->core.focus_window = ic->core.client_window;
	  XIMP_SET_FOCUSWINMASK2(ic, change_mask);
	}

	/* re-create status/preedit/lookup */
	XIC_GUI(ic, change_status)((XIC)ic, STATUS_CREATE, NULL);
	XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_CREATE, NULL);
	XIC_GUI(ic, change_lookup)((XIC)ic, LOOKUP_CREATE, NULL);

	SetScreenNumber(ic);
	FilterConfigureNotify(ic->core.im->core.display,
			      ic->core.focus_window,
			      NULL, (XPointer)ic);
#endif
      }
	    
    } else if (strcmp(p->name, XNFocusWindow)==0) {
      Window old_focus_window = 0;
      if ((Window)p->value != 0 &&
	  (Window)p->value == ic->core.focus_window) {
	continue;
      }
#if 0
      ic->ximp_icpart->back_focus_win = ic->core.focus_window;
#endif
      old_focus_window = ic->core.focus_window;
      ic->core.focus_window = (Window)p->value;
      XIMP_SET_FOCUSWINMASK2(ic, change_mask);
      XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_CREATE, NULL);

      SetScreenNumber(ic);
      FilterConfigureNotify(ic->core.im->core.display,
			    ic->core.focus_window,
			    NULL, (XPointer)ic);
      if (XIM_IS_SWITCH(ic->core.im)) {
	SwitchKeyEventFilter(ic, old_focus_window);
      } else if (XIM_IS_IIIMP(ic->core.im)) {
	IIIMPKeyEventFilter(ic, old_focus_window);
      }
    } else if (strcmp(p->name, XNResourceName)==0) {
      ic->core.im->core.res_name = (char *)p->value;
      ic->ximp_icpart->value_mask |= XIMP_RES_NAME;
	    
    } else if (strcmp(p->name, XNResourceClass)==0) {
      ic->core.im->core.res_class = (char *)p->value;
      ic->ximp_icpart->value_mask |= XIMP_RES_CLASS;
	    
    } else if (strcmp(p->name, XNGeometryCallback)==0) {
      ic->core.geometry_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.geometry_callback.callback =
	((XIMCallback *)p->value)->callback;
      ic->ximp_icpart->value_mask |= XIMP_GEOMETRY_CB;
	    
    } else if (strcmp(p->name, XNUnicodeCharacterSubset)==0) {
      /* select a input charset from the list */
      XIMUnicodeCharacterSubset *new_subset =
	(XIMUnicodeCharacterSubset*)p->value;
      if (!SelectCharacterSubset(ic, new_subset)) {
	break;			/* cannot set this value */
      }
    } else if (strcmp(p->name, XNPreeditAttributes)==0) {
      if (PreeditSetAttributes(ic,
			       &(ic->ximp_icpart->preedit_attr),
			       (XIMArg*)p->value, mode, change_mask,
			       return_name) == False )
	break;
	    
    } else if (strcmp(p->name, XNStatusAttributes)==0) {
      if (StatusSetAttributes(ic,
			      &(ic->ximp_icpart->status_attr),
			      (XIMArg*)p->value, mode, change_mask,
			      return_name) == False )
	break;

      SwitchUpdateStatus(ic);

    } else if (strcmp(p->name, XNPreeditState)==0) {
      ic->core.preedit_attr.preedit_state = (XIMPreeditState)p->value;
      ChangePreeditState(ic);
    } else if (strcmp(p->name, XNPreeditStateNotifyCallback)==0) {
      ic->core.preedit_attr.state_notify_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->core.preedit_attr.state_notify_callback.callback =
	((XIMCallback *)p->value)->callback;

 /* private XIC extention */
    } else if (strcmp(p->name, XNLookupStartCallback)==0) {
      ic->lookup_start_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->lookup_start_callback.callback =
	((XIMCallback *)p->value)->callback;
    } else if (strcmp(p->name, XNLookupDrawCallback)==0) {
      ic->lookup_draw_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->lookup_draw_callback.callback =
	((XIMCallback *)p->value)->callback;
    } else if (strcmp(p->name, XNLookupDoneCallback)==0) {
      ic->lookup_done_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->lookup_done_callback.callback =
	((XIMCallback *)p->value)->callback;

    } else if (strcmp(p->name, XNSwitchIMNotifyCallback)==0) {
      ic->switchim_notify_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->switchim_notify_callback.callback =
	((XIMCallback *)p->value)->callback;
    } else if (strcmp(p->name, XNCommitStringCallback)==0) {
      ic->commit_string_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->commit_string_callback.callback =
	((XIMCallback *)p->value)->callback;
    } else if (strcmp(p->name, XNForwardEventCallback)==0) {
      ic->forward_event_callback.client_data =
	((XIMCallback *)p->value)->client_data;
      ic->forward_event_callback.callback =
	((XIMCallback *)p->value)->callback;
    } else {
      return_name = p->name;
      break;
    }
  }
  return return_name;
}
