/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "iiimpIM.h"
#include "iiimpIC.h"
#include <unistd.h>
#include <pwd.h>
#include <ctype.h>
#include "trace_message.h"

#include "XIM.h"		/* for XNMultiLingualInput */

const char *IIIMP_DEFAULT_ADDRESS = "127.0.0.1:9010";

static XIMStyle im_styles[] = {
    XIMPreeditCallbacks |XIMStatusCallbacks,
    XIMPreeditCallbacks | XIMStatusArea,
    XIMPreeditCallbacks | XIMStatusNothing,
    XIMPreeditPosition  | XIMStatusCallbacks,
    XIMPreeditPosition  | XIMStatusArea,
    XIMPreeditPosition  | XIMStatusNothing,
    XIMPreeditArea      | XIMStatusCallbacks,
    XIMPreeditArea      | XIMStatusArea,
    XIMPreeditArea      | XIMStatusNothing,
    XIMPreeditNothing   | XIMStatusCallbacks,
    XIMPreeditNothing   | XIMStatusArea,
    XIMPreeditNothing   | XIMStatusNothing,
    XIMPreeditCallbacks | XIMStatusNone,
    XIMPreeditPosition  | XIMStatusNone,
    XIMPreeditArea      | XIMStatusNone,
    XIMPreeditNothing   | XIMStatusNone,
    XIMPreeditNone	| XIMStatusCallbacks,
    XIMPreeditNone      | XIMStatusArea,
    XIMPreeditNone      | XIMStatusNothing,
    XIMPreeditNone      | XIMStatusNone,
};

/* Internal functions */

/*
   It is our private extension to prepare for _IIIMP_Error_Handler
   as an error handler for the BadWindow error caused by XSendEvent().

   The BadWindow error may occur when the connection with the input
   method server is lost when XSendEvent() is called and failed to
   send a request to the input method server.
   We assume that this condition is not fatal and an application
   can survive after the error occurs. Therefore, _IIIMP_Error_Handler
   returns without calling exit system call.

   In addtion, when an application program sets its own error handler,
   we don't call _IIIMP_Error_Handler, but calls application's
   error handler. In this case, appl_error_handler is used to store the
   pointer of the application's error handler function.
*/
static XErrorHandler appl_error_handler = (XErrorHandler)NULL;
static int
_IIIMP_Error_Handler(Display *dpy, XErrorEvent *event) {
  extern int _XDefaultError();
  if (appl_error_handler &&
      appl_error_handler != _XDefaultError)
    return appl_error_handler(dpy, event);
  else {
    if (event->error_code == BadWindow) {
      char buffer[BUFSIZE];
      char number[32];
      if (event->request_code < 128) {
	sprintf(number, "%d", event->request_code);
	XGetErrorDatabaseText(dpy, "XRequest", number,
			      "", buffer, BUFSIZE);
	if (!strcmp(buffer, "X_SendEvent"))
	  return 0;
#ifdef linux
	/* 4357746: On Linux, X_ClearArea and X_DestroyWindow X error
	   occur at exiting emacs on VineLinux and LASER 5 */
        if (!strcmp(buffer, "X_ClearArea"))
          return 0;
        if (!strcmp(buffer, "X_ChangeWindowAttributes"))
          return 0;
        if (!strcmp(buffer, "X_GetWindowAttributes"))
          return 0;
        if (!strcmp(buffer, "X_DestroyWindow"))
          return 0;
#endif
      }
    }
  }
  return _XDefaultError(dpy, event);
}

/* For Interface for libX11 */
extern Status IIIMP_OpenIM_SWITCH(XIM xim, XLCd lcd);

static Status IIIMP_CloseIM(XIM);

extern char* IIIMP_SetIMValues(XIM, XIMArg*);
extern char* IIIMP_GetIMValues(XIM, XIMArg*);

static XIC IIIMP_CreateIC(XIM, XIMArg*);
extern int _Ximp_ctstombs(XIM, char*, int, char*, int, Status*);
extern int _Ximp_ctstowcs(XIM, char*, int, wchar_t*, int, Status*);

static XIMMethodsRec	 iiimp_im_methods = {
    IIIMP_CloseIM,		/* close */
    IIIMP_SetIMValues,		/* set_values */
    IIIMP_GetIMValues,		/* get_values */
    IIIMP_CreateIC,		/* create_ic */
    _Ximp_ctstombs,		/* ctstombs */
    _Ximp_ctstowcs		/* ctstowcs */
};

static Status SWITCH_CloseIM(XIM);

static XIMMethodsRec	 switch_im_methods = {
  SWITCH_CloseIM,		/* close */
  0,				/* set_values */
  0,				/* get_values */
  0,				/* create_ic */
  0,				/* ctstombs */
  0				/* ctstowcs */
};

static Status
IIIMP_CloseIM(XIM xim) {
  CommonCloseIM(xim);
  SWITCH_CloseIM(xim);
  return(True);
}

static XIC
IIIMP_CreateIC(XIM xim, XIMArg *arg) {
  return (XIC)CreateIC((XimCommon)xim, arg);
}

char*
IIIMP_SetIMValues(XIM xim, XIMArg *arg) {
  XIMArg *p;
  char *return_name = NULL;
  XimCommon im = (XimCommon)xim;
  IIIMObject io;

  if (!xim) return arg->name;	/* nothing to do */

  for (p = arg; p->name != NULL; p++) {
    if (!strcmp(p->name, "engineInterfaceName")) {
      XIM_IIIMP(im, engine_name) = (char*)p->value;
    } else if (!strcmp(p->name, "applicationType")) {
      XIM_IIIMP(im, client_type) = (char*)p->value;
      (void)IMSetIMValues(im);
    } else {
      return_name = arg->name;
      break;
    }
  }
  
  for (io = XIM_IIIMP(im, iiim_object); NULL != io; io = io->next) {
    switch (io->obj_cat) {
    case IM_GUI_OBJECT:
	    if (NULL == io->path) {
	      IMGetIMValue(im, io->id_dyn);
	    }
	    break;
    case IM_LWE_OBJECT:
    case IM_SYNTAX_RULE_OBJECT:
    case IM_MANAGER_RULE_OBJECT:
    case IM_PRELOADING_LWE_OBJECT:
    default:
	    break;
    }
  }

  return(return_name);
}

extern void UpdateIMCharacterSubset(XimCommon);

char*
IIIMP_GetIMValues(XIM xim, XIMArg *arg) {
  XIMArg *p;
  int i;
  XimCommon im = (XimCommon)xim;

  if (!xim) return arg->name;	/* nothing to do */

  for (p = arg; p->name != NULL; p++) {
    TRACE_MESSAGE('v', ("  %s\n", p->name));
    if (!strcmp(p->name, XNQueryInputStyle)) {
      XIMStyles **value;
      XIMStyles *styles;
      size_t count = sizeof(im_styles)/sizeof(im_styles[0]);
      if ((styles = (XIMStyles*)
	   Xmalloc(sizeof(XIMStyles) +
		   sizeof(XIMStyle) * count)) == NULL) {
	break;
      }
      styles->count_styles = count;
      styles->supported_styles = (XIMStyle *)(&styles[1]);

      for (i = 0; i < (int)(styles->count_styles); i++) {
	styles->supported_styles[i] = im_styles[i];
      }
      value = (XIMStyles **)p->value;
      *value = styles;
    } else if (!strcmp(p->name, XNMultiLingualInput)) {
      *((Bool*)(p->value)) = ((XimCommon)xim)->isUnicode;
    } else if (!strcmp(p->name, XNQueryUnicodeCharacterSubset)) {
      XIMUnicodeCharacterSubsets **value;
      XIMUnicodeCharacterSubsets *sub_sets;
      XIMUnicodeCharacterSubsets *im_subset;
      size_t count = 0;

      UpdateIMCharacterSubset(im);

      if (!im->unicode_char_subsets) break;

      im_subset = im->unicode_char_subsets;

      count = im_subset->count_subsets;

      if ((sub_sets = (XIMUnicodeCharacterSubsets*)
	   Xmalloc(sizeof(XIMUnicodeCharacterSubsets) +
		   sizeof(XIMUnicodeCharacterSubset) * count)) == NULL) {
	break;
      }
      sub_sets->count_subsets = count;
      sub_sets->supported_subsets =
	(XIMUnicodeCharacterSubset*)(&sub_sets[1]);

      for (i = 0; i < (int)(sub_sets->count_subsets); i++) {
	sub_sets->supported_subsets[i] = im_subset->supported_subsets[i];
      }
      value = (XIMUnicodeCharacterSubsets **)p->value;
      *value = sub_sets;
      
    } else {
      break;
    }
  }
  return (p->name);
}

#define _USER_IIIMP_FILE	"/.iiimp"
#define _USER_IIIMP_FILE_LEN	(sizeof(_USER_IIIMP_FILE) - 1)
#define _IIIMP_PROP_HEADER	"iiimp.server=iiimp://"
#define _IIIMP_PROP_HEADER_LEN	(sizeof(_IIIMP_PROP_HEADER) - 1)

#define	iscomment(ch)	((ch) == '\0' || (ch) == '#')

static int
parse_line(char *line, char **argv, int argsize) {
  int argc = 0;
  char *p = line;

  while (argc < argsize) {
    while (isspace(*p)) {
      ++p;
    }
    if (iscomment(*p)){
      break;
    }
    argv[argc++] = p;
    while (!isspace(*p)) {
      ++p;
    }
    if (iscomment(*p)) {
      break;
      }
    *p++ = '\0';
  }
  return argc;
}

/*
  The following function: getIMNameFromUserFile() extracts IIIMP Input
  Method Location, "servername:portid" from the ".iiimp" located in
  user's home directory.

  The ".iiimp" property file is provided by the user of IIIMP Client-Side
  Adapter of JDK1.2 with information about the IIIMP server location, which
  are servername and portid. The servername is the name of the host running
  the IIIMP server, and the portid is the port id on which the IIIMP server
  listens to clients to request TCP/IP connections.

  The ".iiimp" file has a one-line entry:

  	iiimp.server=iiimp://servername:portid

  The comment lines may be added, starting with "#".
 */
static char*
getIMNameFromUserFile(void) {
  /* get user's home directory */
  char *cp;
  struct passwd *pw;
  char *home_dir;
  char *path = (char*)NULL;
  int len;
  char *im_name = (char*)NULL;

  char buf[BUFSIZE];
  FILE *fp;

  if ((cp = getenv("LOGNAME")) == NULL) {
    cp = getenv("USER");
  } 

  if (cp != NULL && (pw = getpwnam(cp)) != NULL &&
      pw->pw_uid == getuid()) {
    ;			/* do nothing */
  } else if ((pw = getpwuid(getuid())) == NULL) {
    return NULL; /* No password entry. */
  }
  home_dir = pw->pw_dir;

  /* access check */
  if (access(home_dir, R_OK) < 0) return NULL;

  len = strlen(home_dir) + _USER_IIIMP_FILE_LEN + 10;

  path = Xmalloc(len + 1);
  if (!path) return NULL;

  strcpy(path, home_dir); strcat(path, "/.iiimp");

  /* access check */
  if (access(path, R_OK) < 0) goto Error;

  fp = fopen(path, "r");
  if (fp == (FILE *)NULL) goto Error;

  while (fgets(buf, BUFSIZE, fp) != NULL) {
    char *p = buf;
    int n;
    char *args[3];
    while (isspace(*p)){
      ++p;
    }
    if (iscomment(*p)){
      continue;
    }
    n = parse_line(p, args, 3);
    if (n == 1) {
      if (!strncmp(args[0], _IIIMP_PROP_HEADER, _IIIMP_PROP_HEADER_LEN)) {
	if (args[0] + _IIIMP_PROP_HEADER_LEN) {
	  im_name = (char*)strdup(args[0] + _IIIMP_PROP_HEADER_LEN);
	  break;
	}
      }
    }
  }
  fclose(fp);
 Error:
  if (path) Xfree(path);
  return im_name;
}

#ifndef XIM_CONNECTION_RETRIES
#define XIM_CONNECTION_RETRIES 2
#endif

XIM
_IIIMP_OpenIM(XLCd lcd, Display *dpy, XrmDatabase rdb,
	      char *res_name, char *res_class) {
  XimCommon im = 0;
  im = Xmalloc(sizeof(XimCommonRec));
  if (!im) goto Set_Error;
  memset(im, 0, sizeof(XimCommonRec));

  if (!CommonOpenIM((XIM)im, lcd, dpy, rdb, res_name, res_class))
    goto Set_Error;

  im->methods = &iiimp_im_methods;

  if (!IIIMP_OpenIM_SWITCH((XIM)im, lcd)) goto Set_Error;
  return (XIM)im;
 Set_Error:
  if (im) Xfree(im);
  return 0;
}

Status
IIIMP_OpenIM_SWITCH(XIM xim, XLCd lcd) {
  XimCommon im = (XimCommon)xim;
  XIMIIimpIM im_private = 0;
  char *mod, buf[BUFSIZE];
  int mod_len, i;

  im_private = Xmalloc(sizeof(XIMIIimpIMRec));
  if (!im_private) goto Set_Error;

  memset(im_private, 0, sizeof (XIMIIimpIMRec));

  im->iiimp_impart = im_private;

  XIM_IIIMP(im, switch_methods) = &switch_im_methods;

  buf[0] = '\0';
  mod_len = 0;

  im->core.im_name = 0;
  if ((lcd->core->modifiers) && (*lcd->core->modifiers)) {
#define	MODIFIER "@im="
    mod = strstr(lcd->core->modifiers, MODIFIER);
    if (mod) {
      mod += strlen(MODIFIER);

      if (!strncmp(mod, "iiimp/", 6) || !strncmp(mod, "IIIMP/", 6)) {
	mod += 6;

	if (index(mod, ':')) {
	  while (*mod && *mod != '@' && mod_len < BUFSIZE - 1) {
	    buf[mod_len++] = *mod++;
	  }
	  buf[mod_len] = '\0';
	  im->core.im_name = Xmalloc(mod_len+1);
	  if (!im->core.im_name) goto Set_Error;

	  strcpy(im->core.im_name, buf);
	}
      }
    }
#undef MODIFIER
  }
  if (!im->core.im_name) {
    /* Try to get user's configuration file first */
    im->core.im_name = getIMNameFromUserFile();

    if (!im->core.im_name || index(im->core.im_name, ':') == 0) {
      /* set the default */
      if ((im->core.im_name = Xmalloc(strlen(IIIMP_DEFAULT_ADDRESS) + 1))
	  == NULL)
	goto Set_Error;
      strcpy(im->core.im_name, IIIMP_DEFAULT_ADDRESS);
    }
  }

  /* Exchange IM_CONNECT & IM_CONNECT_REPLY with Input Method */
  if (!IMConnect(im, XIM_CONNECTION_RETRIES)) {
    goto Set_Error;
  }

  /* set error handler only once */
  if (appl_error_handler == (XErrorHandler)NULL)
    appl_error_handler = XSetErrorHandler(_IIIMP_Error_Handler);

  return True;

Set_Error:
  if (im_private) {
    Xfree(im_private);
    im->iiimp_impart = NULL;
  }
  IIIMP_CloseIM((XIM)im);
  return False;
}

/* Switching */
static Status
SWITCH_CloseIM(xim)
XIM xim;
{
  IIIMObject io, io_temp;
  XimCommon im = (XimCommon)xim;
  int i;

  if (im->core.im_name) Xfree(im->core.im_name);

  if (!im->iiimp_impart) return True;

  /* free IIIMP-dependent data */
  for (io = XIM_IIIMP(im, iiim_object); NULL != io;) {
    io_temp = io->next;
    if (io->name) Xfree(io->name);
    if (io->domain) Xfree(io->domain);
    if (io->signature) Xfree(io->signature);
    if (io->scope) Xfree(io->scope);
    Xfree(io);
    io = io_temp;
  }

  if (XIM_IIIMP(im, spec)) IMDisconnect(im);

  if (XIM_IIIMP(im, on_keys.keylist)) {
    Xfree(XIM_IIIMP(im, on_keys.keylist));
  }
  if (XIM_IIIMP(im, off_keys.keylist)) {
    Xfree(XIM_IIIMP(im, off_keys.keylist));
  }
  if (XIM_IIIMP(im, supported_languages)) {
    for (i = 0; i < XIM_IIIMP(im, count_languages); i++) {
      Xfree(XIM_IIIMP(im, supported_languages[i].string.multi_byte));
    }
    Xfree(XIM_IIIMP(im, supported_languages));
  }
  Xfree(im->iiimp_impart);
  im->iiimp_impart = 0;
  return(True);
}


/* only used for pluggin iiimp into
   X consortium based libX11
*/
Bool
_XInitIIIMP(lcd)
     XLCd lcd;
{
  if(lcd == (XLCd)NULL)
    return False;

  lcd->methods->open_im = _IIIMP_OpenIM;
  lcd->methods->register_callback = NULL;
  lcd->methods->unregister_callback = NULL;
  return True;
}
