/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "iiimpReq.h"
#include "iiimpIM.h"
#include "iiimpUtil.h"

/* Utility functions */
static char *
IMToString(CARD16 *chars, int char_length) {
  char *ptr;
  int i;
  int total_size;
  unsigned char *data;

  if (char_length & 0x01) {
    total_size = (2 + (2 * char_length));
  } else {
    total_size = (2 + (2 * char_length) + 2);	/* padding */
  }

  data = (unsigned char *)Xmalloc(total_size);
  if (!data) {
    return NULL;
  }

  ptr = (char *)data;
  req_put16(ptr, (2 * char_length));
  for (i = 0; i < char_length; i++) {
    req_put16(ptr, *(chars + i));
  }
  if (0x00 == (char_length & 0x01)) {
    req_put16(ptr, 0);
  }

  return (char*)data;
}

void
setICAttribute(char *value, XICAttribute *ic_attr,
	       int icid) {
  char *value_str = NULL;
  char *src = 0, *dst;
  size_t src_len, dst_len;
  int data_len;

  src = value;
  src_len = strlen(src);

  value_str = Xmalloc((src_len + 1) * 2);
  if (!value_str) {
    goto Error;
  }
  memset(value_str, 0, (src_len + 1) * 2);

  dst = value_str;
  dst_len = (src_len + 1) * 2;
  IIimpConvertToUTF16(src, src_len,
		      &dst, &dst_len);
  ic_attr->attribute_id = icid;
  data_len = (src_len + 1) * 2 - dst_len;
  ic_attr->value_length = 2 + data_len + PADDING(2 + data_len);
  ic_attr->value = IMToString((CARD16*)value_str, data_len/2);
  if (!ic_attr->value) {
    goto Error;
  }
Error:
  if (value_str) Xfree(value_str);
  return;
}

static unsigned int
str_to_mod(char *str) {
    if(!strcmp("Ctrl", str))
        return ControlMask;
    else if(!strcmp("Shift", str))
        return ShiftMask;
    else if(!strcmp("Meta", str))
        return Mod4Mask;
    else if(!strcmp("Alt", str))
        return Mod1Mask;
    else
        return 0;
}

void
AddConvKeysFromFile(XIMTriggerKeys* keys, char *localename) {
    char *buf = (char*)0;
    char *dummy = (char*)0;
    char *p;
    XIMTriggerKey     *key = 0;
    XIMTriggerKey     *this_key;
    Bool       is_modmask;
    unsigned int    mod, mod_mask, tmp_mask;
    char filename[256];
    XrmDatabase r_dbase;
    char *ret_type;
    XrmValue rmvalue;
    char *names = 0;

    /* Make sure to add to the existing key list */ 
    if (keys->count_keys > 0) {
       key = keys->keylist;
    }
 
    /* Get all the conversiononkeys specified in the file */
    sprintf(filename, "/usr/openwin/lib/locale/%s/app-defaults/Htt", localename);
    r_dbase = XrmGetFileDatabase(filename);
    if (XrmGetResource(r_dbase, "conversionOnKeys", "ConversionOnKeys",
				&ret_type, &rmvalue)) {
    names = (char *)malloc(rmvalue.size + 1);
    strncpy(names, rmvalue.addr, rmvalue.size);
    names[rmvalue.size] = '\0';
    } else {
	goto err;
    }

    if (!names)
        goto err;

    dummy = buf = (char *)malloc(strlen(names) + 1);
    if (!dummy)
        goto err;

    strcpy(buf, names);

    if (names) {
	free(names);
    }

    is_modmask = False;
    mod = 0;
    while (*buf) {
        switch(*buf) {
          case '~':
            if (is_modmask)
                goto err;
            is_modmask = True;
            buf += 1;
            break;
          case '<':
            p = strchr(buf+1, '>');
            if (!p)
                goto err;
            *p = 0;
            if ((tmp_mask = str_to_mod(buf + 1)) == 0)
                goto err;
	    if (is_modmask) {
                mod_mask |= tmp_mask;
		is_modmask = False;
	    } else {
                mod |= tmp_mask;
	    }
            buf = p + 1;
            if (!*buf)
                goto err;
            break;
          default:
            p = strchr(buf, ' ');
            if (p)
                *p = 0;
            keys->count_keys++;
            key = (keys->count_keys == 1) ?
                (XIMTriggerKey *)malloc(sizeof(XIMTriggerKey)) :
                    (XIMTriggerKey *)realloc(key,
                              sizeof(XIMTriggerKey) * keys->count_keys);
            this_key = key + (keys->count_keys - 1);
            this_key->keycode = XStringToKeysym(buf);
            this_key->keychar = this_key->keycode;
            this_key->time_stamp = 0;
            this_key->modifier = mod;
            mod = 0;
            if (p) {
                buf = p + 1;
                break;
            } else {
                goto done;
            }
        }
    }
done:
    keys->keylist = key;
err:
    if (dummy) free(dummy);
    XrmDestroyDatabase(r_dbase);
    return;
}

