/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _imlist_hh
#define _imlist_hh

template <class T>
class IMList { // append an item to list
 public:
  IMList();
  ~IMList() {
    delete list;
  }
  void addItem(T* );
  void addItemByKey(T*, int);
  T& getItem(unsigned int) const;
  T& getItemByKey(int) const;
  T& getItemMakeTop(unsigned int);
  T& getFirstItem(void);
  T& getNextItem(void);
  unsigned int getIndex(T*) const;
  int getSize() const {return nSize;}
  void remove(T*);
  void destroy() ;

  // don't re-order index of the list when an item is removed
  void disable_reordering();
 protected:
  typedef struct _Tnode {
    T* obj;
    int key;
    unsigned int index;
    struct _Tnode *next;
  } Tnode;
  Tnode *list;
  Tnode *next_node;
  Tnode null_obj;
  int nSize;
  unsigned int nIndex;
  int reorder;
 private:
  void *getNodeByKey(int) const;
};

template <class T>
IMList<T>::IMList() {
  nSize = nIndex = 0;
  list = (Tnode *)0;
  next_node = (Tnode *)0;
  null_obj.obj = (T*)0;
  null_obj.key = 0;
  null_obj.index = 0;
  null_obj.next = 0;
  reorder = 1;
}

template <class T>
void IMList<T>::disable_reordering() {
  reorder = 0;
}

template <class T>
void IMList<T>::addItem(T* item) {
  Tnode *node = new Tnode;
  node->obj  = item;
  nIndex++;
  node->index = nIndex;
  node->next = list;
  list = node;
  nSize++;
}

template <class T>
void IMList<T>::addItemByKey(T* item, int key) {
  Tnode *node = (Tnode*)getNodeByKey(key);
  if (!node) {
    node = new Tnode;
    node->obj  = item;
    node->key  = key;
    nIndex++;
    node->index = nIndex;
    node->next = list;
    list = node;
    nSize++;
  } else {
    node->obj = item;
  }
}

template <class T>
void IMList<T>::remove(T* item) {
  Tnode **prev, *tnode;
  int index=1;
  for (prev = &list; tnode = *prev;) {
    if (tnode->obj == item) {
      *prev = tnode->next;
      if (next_node == tnode) next_node = tnode->next;      
      delete tnode;
      nSize--;
      if (reorder == 0) break;
    } else {
      prev = &tnode->next;
      if (reorder == 1) tnode->index=index++;
    }
  }
  if (reorder == 1) nIndex=nSize;
  return;
}

template <class T>
T& IMList<T>::getItemMakeTop(unsigned int index) {
  Tnode * tnode = (Tnode *)list;
  Tnode * tnode_prev = NULL;

  if (index == 0 || index > nIndex)
    return *(null_obj.obj);

  if (tnode == 0 && nSize == 0 && reorder == 0)	// not error
    return *(null_obj.obj);

  while (tnode) {
    if (tnode->index == index) {
      if (NULL != tnode_prev) {
	tnode_prev->next = tnode->next;
	tnode->next = list;
	list = tnode;
      }
      return *(tnode->obj);
    }
    tnode_prev = tnode;
    tnode = tnode->next;
  }
  if (tnode == 0)	// should not be an error
    return *(null_obj.obj);

  return *(tnode->obj);
}

template <class T>
T& IMList<T>::getFirstItem(void) {
  Tnode * tnode = (Tnode *)list;
  if(tnode==0){
     return *(null_obj.obj);
  }
  next_node=tnode->next;
  return *(tnode->obj);
}

template <class T>
T& IMList<T>::getNextItem(void) {
  Tnode * tnode = (Tnode *)next_node;
  if(tnode==0){
     return *(null_obj.obj);
  }
  next_node=tnode->next;
  return *(tnode->obj);
}

template <class T>
unsigned int IMList<T>::getIndex(T *item) const {
  Tnode *tnode = (Tnode *)list;

  if (item == 0) return 0;
  while (tnode) {
    if (tnode->obj == item) return tnode->index;
    tnode = tnode->next;
  }
  return 0;
}

template <class T>
T& IMList<T>::getItem(unsigned int index) const {
  Tnode * tnode = (Tnode *)list;

  if (index == 0 || index > nIndex)
    return *(null_obj.obj);

  if (tnode == 0 && nSize == 0 && reorder == 0)	// not error
    return *(null_obj.obj);

  while (tnode) {
    if (tnode->index == index) return *(tnode->obj);
    tnode = tnode->next;
  }
  if (tnode == 0)	// should not be an error
    return *(null_obj.obj);

  return *(tnode->obj);
}

template <class T>
T& IMList<T>::getItemByKey(int key) const {
  Tnode *node = (Tnode*)getNodeByKey(key);
  if (!node) return *(null_obj.obj);
  return *(node->obj);
}

template <class T>
void* IMList<T>::getNodeByKey(int key) const {
  Tnode *tnode = (Tnode *)list;

  while (tnode) {
    if (tnode->key == key) return (void*)tnode;
    tnode = tnode->next;
  }
  return (void*)0;
}

template <class T>
void IMList<T>::destroy() {
  Tnode *tnode = (Tnode *)list;
  Tnode *del_node = (Tnode *)0;

  while (tnode) {
    del_node = tnode;
    tnode = tnode->next;
    //delete del_node->obj;
    delete del_node;
  }
  list = (Tnode *)0;
  nSize = 0;
  nIndex = 0;
}
  
#endif
