/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "IIIMPClient.hh"
#include "IIIMPInputContext.hh"
#include "IMProtocolStructP.hh"

IIIMPInputContext::IIIMPInputContext(IIIMPClient *cl) {
  client = cl;
  ic_state = is_being_created;
}

IIIMPInputContext::~IIIMPInputContext() {
}

void
IIIMPInputContext::realize() {
  ic_state = is_realized;
}

void
IIIMPInputContext::unrealize() {
  ic_state = is_destroyed;
}

const CompoundString&
IIIMPInputContext::getUser() const {return client->getUser();}

const CompoundString&
IIIMPInputContext::getApplicationName() const {
  return client->getApplicationName();
}

const CompoundString&
IIIMPInputContext::getOSName() const {
  return client->getOSName();
}

const CompoundString&
IIIMPInputContext::getOSArch() const {
  return client->getOSArch();
}

const CompoundString&
IIIMPInputContext::getOSVersion() const {
  return client->getOSVersion();
}

const CompoundString&
IIIMPInputContext::getXDisplayString() const {
  return client->getXDisplayString();
}

const CompoundString&
IIIMPInputContext::getXServerVendor() const {
  return client->getXServerVendor();
}

const CompoundString&
IIIMPInputContext::getLocaleName() const {return localename;}

const CompoundString&
IIIMPInputContext::getEngineName() const {return enginename;}

void
IIIMPInputContext::setLocaleName(char *name) {
  localename = name;
}

void
IIIMPInputContext::setEngineName(char *name) {
  enginename = name;
}

int
IIIMPInputContext::commit_string(IMText *text) {
  IMCommitCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.text = text;
  if (!is_active()) return 1;
  return client->commit_string(&call_data);
}

int
IIIMPInputContext::forward_event(IMKeyEventStruct *event) {
  IMForwardEventCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.event = event;
  if (!is_active()) return 1;
  return client->forward_event(&call_data);
}

int
IIIMPInputContext::preedit_start(IMPreeditStruct *preedit) {
  IMPreeditCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.preedit = preedit;
  if (!is_active()) return 1;
  return client->preedit_start(&call_data);
}
int
IIIMPInputContext::preedit_draw(IMPreeditStruct *preedit) {
  IMPreeditCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.preedit = preedit;
  if (!is_active()) return 1;
  return client->preedit_draw(&call_data);
}
int
IIIMPInputContext::preedit_caret(IMPreeditStruct *preedit) {
  IMPreeditCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.preedit = preedit;
  if (!is_active()) return 1;
  return client->preedit_caret(&call_data);
}
int
IIIMPInputContext::preedit_done(IMPreeditStruct *preedit) {
  IMPreeditCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.preedit = preedit;
  if (!is_active()) return 1;
  return client->preedit_done(&call_data);
}
int
IIIMPInputContext::status_start(IMStatusStruct *status) {
  IMStatusCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.status = status;
  if (!is_active()) return 1;
  return client->status_start(&call_data);
}
int
IIIMPInputContext::status_draw(IMStatusStruct *status) {
  IMStatusCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.status = status;
  if (!is_active()) return 1;
  return client->status_draw(&call_data);
}
int
IIIMPInputContext::status_done(IMStatusStruct *status) {
  IMStatusCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.status = status;
  if (!is_active()) return 1;
  return client->status_done(&call_data);
}
int
IIIMPInputContext::lookup_start(IMLookupStruct *lookup) {
  IMLookupCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.lookup = lookup;
  if (!is_active()) return 1;
  return client->lookup_start(&call_data);
}
int
IIIMPInputContext::lookup_draw(IMLookupStruct *lookup) {
  IMLookupCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.lookup = lookup;
  if (!is_active()) return 1;
  return client->lookup_draw(&call_data);
}
int
IIIMPInputContext::lookup_process(IMLookupStruct *lookup) {
  IMLookupCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.lookup = lookup;
  if (!is_active()) return 1;
  return client->lookup_process(&call_data);
}
int
IIIMPInputContext::lookup_done(IMLookupStruct *lookup) {
  IMLookupCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.lookup = lookup;
  if (!is_active()) return 1;
  return client->lookup_done(&call_data);
}

int
IIIMPInputContext::auxiliary_start(IMAuxStruct *auxiliary) {
  IMAuxCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.aux = auxiliary;
  if (!is_active()) return 1;
  return client->auxiliary_start(&call_data);
}
int
IIIMPInputContext::auxiliary_draw(IMAuxStruct *auxiliary) {
  IMAuxCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.aux = auxiliary;
  if (!is_active()) return 1;
  return client->auxiliary_draw(&call_data);
}
int
IIIMPInputContext::auxiliary_done(IMAuxStruct *auxiliary) {
  IMAuxCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.aux = auxiliary;
  if (!is_active()) return 1;
  return client->auxiliary_done(&call_data);
}

int
IIIMPInputContext::conversion_start() {
  IMConvStateCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.conv_state = 0;
  if (!is_active()) return 1;
  return client->conversion_start(&call_data);
}
int
IIIMPInputContext::conversion_end() {
  IMConvStateCBStruct call_data;
  call_data.icid = client->getICID(this);
  call_data.conv_state = 1;
  if (!is_active()) return 1;
  return client->conversion_end(&call_data);
}
