/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include "IIIMProtocol.hh"
#include "IIIMPClient.hh"
#include "IMTrans.hh"
#include "IMThread.hh"
#include "CompoundString.hh"
#include "SystemMessage.h"

static void
CountAttrList(const IMListOfAttr *attr, int *total_count) {
  *total_count = 0;

  while (attr->name != 0) {
    attr++;
    ++(*total_count);
  }
}

static IMAttr*
CreateAttrList(const IMListOfAttr *attr, int *total_count) {
  IMAttr *args, *p;
  unsigned int buf_size;

  CountAttrList(attr, total_count);

  buf_size = (unsigned)(*total_count + 1) * sizeof(IMAttr);
  args = new IMAttr[*total_count + 1];

  if (!args) return (IMAttr*)0;

  for (p = args; attr->name != 0; attr++, p++) {
    p->name = attr->name;
    p->length = CompoundString(attr->name).length();
    p->type = attr->type;
    p->attribute_id = attr->id;
  }
  p->name = (char*)0;

  return args;
}

int
IIIMProtocol::getICAttrIDFromName(const char *name) {
  IMAttr *args;
  int i;

  args = ic_attr;
  CompoundString cname(name);
  for (i = 0; i < ic_attr_num; i++) {
    if (cname == CompoundString(args[i].name))
      return args[i].attribute_id;
  }
  return (-1); /* not found */
}

void
IIIMProtocol::init_attrList() {
  IMAttr *args;
  int total_count;

  /* init IMAttr list */
  args = CreateAttrList(Default_IM, &total_count);

  im_attr_num = total_count;
  im_attr = (IMAttr *)args;

  /* init IMAttr list */
  args = CreateAttrList(Default_IC, &total_count);

  ic_attr_num = total_count;
  ic_attr = (IMAttr*)args;

  return;
}

IIIMProtocol::
IIIMProtocol(IMArg *args, int args_count) : IMProtocol(args, args_count) {
  protocol_name = "IIIMP";

  // ICATTRIBUTE names
  ICLocaleName = "localeName";
  ICCharSubsetsName = "characterSubsets";
  ICEngineName = "engineName";

  // IMATTRIBUTE names
  IMListName = "inputMethodList";
  IMClientName = "clientDescriptor";
  IMObjectListName = "objectDescriptorList";
  IMCCDEFName = "ccdef";
  IMGUIObjectName = "guiObject";
  IMLWEObjectName = "lweObject";

  int n = 0;
  Default_IM[n].name = (char*)IMListName;
  Default_IM[n].type = XimType_UTF16_STRING;
  Default_IM[n].id = INPUTMETHOD_LIST;
  n++;
  Default_IM[n].name = (char*)IMClientName;
  Default_IM[n].type = XimType_LISTOF_UTF16_STRING;
  Default_IM[n].id = CLIENT_DESCRIPTER;
  n++;
  Default_IM[n].name = (char*)IMObjectListName;
  Default_IM[n].type = XimType_UTF16_STRING;
  Default_IM[n].id = OBJECT_DESCRIPTER_LIST;
  n++;
  Default_IM[n].name = (char*)IMCCDEFName;
  Default_IM[n].type = XimType_UTF16_STRING;
  Default_IM[n].id = CCDEF;
  n++;
  Default_IM[n].name = (char*)IMGUIObjectName;
  Default_IM[n].type = XimType_UTF16_STRING;
  Default_IM[n].id = GUI_OBJECT;
  n++;
  Default_IM[n].name = (char*)IMLWEObjectName;
  Default_IM[n].type = XimType_UTF16_STRING;
  Default_IM[n].id = LWE_OBJECT;
  n++;
  Default_IM[n].name = 0;
  Default_IM[n].type = 0;
  Default_IM[n].id = 0;

  n = 0;
  Default_IC[n].name = (char*)ICLocaleName;
  Default_IC[n].type = XimType_UTF16_STRING;
  Default_IC[n].id = IC_INPUT_LANGUAGE;
  n++;
  Default_IC[n].name = (char*)ICEngineName;
  Default_IC[n].type = XimType_UTF16_STRING;
  Default_IC[n].id = IC_INPUT_METHOD;
  n++;
  Default_IC[n].name = (char*)ICCharSubsetsName;
  Default_IC[n].type = XimType_UTF16_STRING;
  Default_IC[n].id = IC_CHARACTER_SUBSETS;
  n++;
  Default_IC[n].name = 0;
  Default_IC[n].type = 0;
  Default_IC[n].id = 0;

  unsigned short endian = 1;
  if (*(char *)&endian) {
    im_byteOrder = 'l';
  } else {
    im_byteOrder = 'B';
  }
  /* install IM Attr and IC Attr list  */
  init_attrList();
}

IIIMProtocol::
~IIIMProtocol() {
  delete [] im_attr;
  delete [] ic_attr;
}

int
IIIMProtocol::run() {
  try {
     trans_listen = new IMTransListen(im_address, protocol_name, 1);
  } catch (char *err_msg) {
     system_message(MSG_ERROR, "Error : %s\n", err_msg);
//     fprintf(stderr, "Error : %s\n", err_msg);
     return -1;
  }	
#ifdef linux
  // 4354367: Linix Htt: htt_xbe can not start on standalone system
  try {
     trans_listen_local = new IMTransListen(im_address, protocol_name, 0);
  } catch (char *err_msg) {
     system_message(MSG_ERROR, "Error : %s\n", err_msg);
  }
#endif
  // open a new thread to accept connection request from IIIMP clients
  new IMThread(accept_loop, this);

#ifdef linux
  // 4354367: Linix Htt: htt_xbe can not start on standalone system
  new IMThread(accept_loop_local, this);
#endif

  return 0;
}

int
IIIMProtocol::set_values(IMArg *args, int n) {
  return IMProtocol::set_values(args, n);
}

void *
IIIMProtocol::accept_loop(void *client_data) {
  IIIMProtocol *iiimp_protocol = (IIIMProtocol*)client_data;
  IMTransListen *trans_listen = iiimp_protocol->trans_listen;
  while (1) {
    try {
      IMTransAccept *ss = trans_listen->accept();
      if (ss) {
	IIIMPClient *client = new IIIMPClient(iiimp_protocol, ss);
	iiimp_protocol->iiimp_client_list.addItem(client);
      }
    } catch(const char* p) {
      // cerr << p << endl;
      return 0;
    }
  }
  // unreachable
  return 0;
}

#ifdef linux
  // 4354367: Linix Htt: htt_xbe can not start on standalone system
void *
IIIMProtocol::accept_loop_local(void *client_data) {
  IIIMProtocol *iiimp_protocol = (IIIMProtocol*)client_data;
  IMTransListen *trans_listen = iiimp_protocol->trans_listen_local;
  while (1) {
    try {
      IMTransAccept *ss = trans_listen->accept();
      if (ss) {
	IIIMPClient *client = new IIIMPClient(iiimp_protocol, ss);
	iiimp_protocol->iiimp_client_list.addItem(client);
      }
    } catch(const char* p) {
      // cerr << p << endl;
      return 0;
    }
  }
  // unreachable
  return 0;
}
#endif
