/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _iiimprotocol_hh
#define _iiimprotocol_hh

#include "IMProtocol.hh"

class IMTransListen;
class IIIMPClient;

struct IMListOfAttr {
  char *name;
  unsigned int type;
  unsigned int id;
};

struct IMAttr {
  unsigned int attribute_id;
  unsigned int type;
  unsigned int length;
  char	*name;
};

class IIIMProtocol : public IMProtocol {
 public:

  // ICATTRIBUTE names
  const char *ICLocaleName;
  const char *ICCharSubsetsName;
  const char *ICEngineName;

  // IMATTRIBUTE names
  const char *IMListName;
  const char *IMClientName;
  const char *IMObjectListName;
  const char *IMCCDEFName;
  const char *IMGUIObjectName;
  const char *IMLWEObjectName;

  enum IIIMP_ATTRTYPE {
    XimType_CARD8 = 1, XimType_CARD16 = 2,
    XimType_CARD32 = 3, XimType_STRING8 = 4,
    XimType_XIMStyles = 10, XimType_UTF16_STRING = 18,
    XimType_LISTOF_UTF16_STRING = 20
  };

  IIIMProtocol(IMArg*, int);
  ~IIIMProtocol();

  int set_values(IMArg*, int);
  int get_values(IMArg*, int);

  int run();

  char byteOrder() {return im_byteOrder;};

  int count_imattr() {return im_attr_num;};
  IMAttr *get_imattr() {return im_attr;};
  int count_icattr() {return ic_attr_num;};
  IMAttr *get_icattr() {return ic_attr;};

  int getICAttrIDFromName(const char *);

  IMList<IIIMPClient>  iiimp_client_list;

 private:
  // transport specific connection address
  // TransSpecRec *connect_addr;
  char im_byteOrder;	// byte order 'B' or 'l'

  IMTransListen *trans_listen;
#ifdef linux
  /* 4354367: Linix Htt: htt_xbe can not start on standalone system */
  IMTransListen *trans_listen_local;
#endif

  /* IMAttr/ICAttr */
  int im_attr_num;
  IMAttr *im_attr;
  int ic_attr_num;
  IMAttr *ic_attr;

  void init_attrList();

  static void *accept_loop(void *client_data);
#ifdef linux
  /* 4354367: Linix Htt: htt_xbe can not start on standalone system */
  static void *accept_loop_local(void *client_data);
#endif

  IMListOfAttr Default_IM[10];	// see below in IM_ATTRIBID
  IMListOfAttr Default_IC[5];	// see below in IC_ATTRIBID

  enum IM_ATTRIBID {
    INPUTMETHOD_LIST = 0x1001,
    OBJECT_DESCRIPTER_LIST = 0x1010,
    CLIENT_DESCRIPTER = 0x1011,
    CCDEF = 0x1030,
    GUI_OBJECT = 0x1031,
    LWE_OBJECT = 0x1032
  };

  enum IC_ATTRIBID {
    IC_INPUT_LANGUAGE = 1,
    IC_CHARACTER_SUBSETS = 2,
    IC_INPUT_METHOD = 3
  };

};

#endif
