/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _XIMProtocol_hh
#define _XIMProtocol_hh

#include <X11/Xatom.h>
#include <X11/Xlibint.h>
#include "XIMPublic.hh"

struct XIMPTypeRec {
  int num_of_types;
  unsigned long *types;
};

struct XIMPAtoms {
  Atom selection_owner;
  Atom selection_owner2;
  Atom ctext_type;
  Atom version;
  Atom supported_styles;
  Atom supported_types;
  Atom server_name;
  Atom server_version;
  Atom vendor_name;
  Atom keys;
  Atom sproc_started_keys;
  Atom sproc_stopped_keys;
  Atom focus;
  Atom preedit;
  Atom status;
  Atom preedit_font;
  Atom status_font;
  /* for XIMP_EXTENSION */
  Atom extensions;
  Atom ext_statuswin;
  Atom ext_backfront;
  Atom ext_conversion;
  /* for Callbacks */
  Atom preedit_draw_data;
  Atom feedbacks;
};

// forward declaration. Actual definitions are in ximp40/XIMProto.hh
struct Ximp_PreeditPropRec4;
struct Ximp_PreeditPropRec3;
struct Ximp_StatusPropRec4;
struct Ximp_StatusPropRec3;

class XIMProtocol : public XIMPublic {
 public:
  XIMProtocol(IMArg*, int);
  ~XIMProtocol();

  int run();
  
  Bool get_protocol_version(Window, char*&);
  Bool get_focus_window(Window, Window&);
  Bool get_preedit_font(Window, char **);
  Bool get_status_font(Window, char **);
  Bool get_preedit4(Window, Ximp_PreeditPropRec4&);
  Bool get_status4(Window, Ximp_StatusPropRec4&);
  Bool get_preedit3(Window, Ximp_PreeditPropRec3&);
  Bool get_status3(Window, Ximp_StatusPropRec3&);
  Bool get_server_type4(Window, unsigned long&);

  Bool set_focus_window(Window, Window);
  Bool set_preedit_font(Window, char *);
  Bool set_status_font(Window, char *);
  Bool set_preedit4(Window, Ximp_PreeditPropRec4);
  Bool set_status4(Window, Ximp_StatusPropRec4);
  Bool set_preedit3(Window, Ximp_PreeditPropRec3);
  Bool set_status3(Window, Ximp_StatusPropRec3);
  Bool set_server_type4(Window, unsigned long);

  Bool read_property(Window, Atom, Atom, int,
		     unsigned char**, unsigned long*);

  Bool write_property(Window, Atom, Atom, int,
		      const unsigned char*, const unsigned long);

  enum XIMP_FE_BE_TYPE {
    XIMP_FRONTEND4 = (1L << 0), XIMP_BACKEND4 = (1L << 1), 
    XIMP_TYPE1 = (1L << 2), XIMP_TYPE2 = (1L << 3),
    XIMP_TYPE3 = (1L << 4), XIMP_SYNC = (1L << 5),
    XIMP_FE_TYPE1 = (XIMP_FRONTEND4 | XIMP_TYPE1),
    XIMP_FE_TYPE2 = (XIMP_FRONTEND4 | XIMP_TYPE2),
    XIMP_FE_TYPE3 = (XIMP_FRONTEND4 | XIMP_TYPE3),
    XIMP_BE_TYPE1 = (XIMP_BACKEND4  | XIMP_TYPE1),
    XIMP_BE_TYPE2 = (XIMP_BACKEND4  | XIMP_TYPE2),
    XIMP_SYNC_BE_TYPE1 = (XIMP_SYNC | XIMP_BE_TYPE1),
    XIMP_SYNC_BE_TYPE2 = (XIMP_SYNC | XIMP_BE_TYPE2)
  };

  enum XIMP_OLD_FE_BE_TYPE {
    XIMP_FRONTEND = 0, XIMP_BACKEND = 1
  };

  int getICID(InputContext *ic) {
    return input_context_list.getIndex(ic);
  }

  void send_client_message(Window, int,
			   unsigned long, unsigned long,
			   unsigned long, unsigned long);

  void commit_by_client_message(Window, int, const char*, int);

  Atom replace_prop_pool(const unsigned char *data, int len);
  
  Atom set_preedit_draw_data_property(const unsigned char *data , int len);
  Atom set_ctext_property(const unsigned char *data, int len,
			  int is_commit);
  Atom set_ctext_property(const unsigned char *data, int len);

  Atom set_feedback_property(const unsigned char *data, int len);

  enum XIM_PROTOCOL {
    /* client <=> frontend  */
    XIMP_KEYRELEASE4 = 100,
    XIMP_KEYPRESS4 = 101,
    /* client ==> frontend  * Base Protocol */
    XIMP_CREATE4 = 102,
    XIMP_DESTROY4 = 103,
    XIMP_REG_KEY_PRESSED4 = 104,
    XIMP_SETFOCUS4 = 105,
    XIMP_UNSETFOCUS4 = 106,
    XIMP_CLIENT_WINDOW4 = 107,
    XIMP_FOCUS_WINDOW4 = 108,
    XIMP_MOVE4 = 109,
    XIMP_RESET4 = 110,
    XIMP_SETVALUE4 = 111,
    XIMP_GETVALUE4 = 112,
    /* * Callback  Protocol */
    XIMP_PREEDITSTART_RETURN4 = 120,
    XIMP_PREEDITCARET_RETURN4 = 121,
    /* client <== frontend  * Base Protocol  */
    XIMP_SPROC_STARTED4 = 130,
    XIMP_SPROC_STOPPED4 = 131,
    XIMP_READPROP4 = 132,
    XIMP_CLIENT_WINDOW_RETURN4 = 133,
    XIMP_FOCUS_WINDOW_RETURN4 = 134,
    XIMP_GETVALUE_RETURN4 = 135,
    XIMP_RESET_RETURN4 = 136,
    XIMP_CREATE_RETURN4 = 137,
    XIMP_KEYPRESS_RETURN4 = 138,
    XIMP_KEYRELEASE_RETURN4 = 139,
    /* Callback  Protocol */
    XIMP_GEOMETRY4 = 140,
    XIMP_PREEDITSTART4 = 150,
    XIMP_PREEDITDONE4 = 151,
    XIMP_PREEDITDRAW4 = 152,
    XIMP_PREEDITDRAW_CM4 = 153,
    XIMP_PREEDITDRAW_CM_TINY4 = 154,
    XIMP_PREEDITDRAW_CM_FEEDBACK4 = 155,
    XIMP_PREEDITCARET4 = 156,
    XIMP_STATUSSTART4 = 160,
    XIMP_STATUSDONE4 = 161,
    XIMP_STATUSDRAW4 = 162,
    XIMP_STATUSDRAW_CM4 = 163,
    /* client => IM Server for frontend method */
    XIMP_EVENTMASK_NOTIFY4 = 200,
    /* client <= IM Server for frontend method */
    XIMP_EVENTMASK_NOTIFY_RETURN4 = 201,
    /* Extension Protocol */
    XIMP_EXTENSION4 = 500,
    /* client <== frontend  * Error Protocol */
    XIMP_ERROR4 = 999,

    /* ClientMessage No.  Ximp 3.5 */
    /* client <=> frontend  */
    XIMP_KEYPRESS3 = 1,
    /* client ==> frontend  * Base Protocol */
    XIMP_CREATE3 = 2,
    XIMP_DESTROY3 = 3,
    XIMP_BEGIN3 = 4,
    XIMP_END3 = 5,
    XIMP_SETFOCUS3 = 6,
    XIMP_UNSETFOCUS3 = 7,
    XIMP_CHANGE3 = 8,
    XIMP_MOVE3 = 9,
    XIMP_RESET3 = 10,
    XIMP_SETVALUE3 = 11,
    XIMP_GETVALUE3 = 12,
    /* Callback  Protocol */
    XIMP_PREEDITSTART_RETURN3 = 20,
    XIMP_PREEDITCARET_RETURN3 = 21,
    /* client <== frontend  * Base Protocol  */
    XIMP_CREATE_RETURN3 = 2,
    XIMP_CONVERSION_BEGIN3 = 30,
    XIMP_PROCESS_BEGIN3 = 30,
    XIMP_CONVERSION_END3 = 31,
    XIMP_PROCESS_END3 = 31, 
    XIMP_READPROP3 = 32,
    XIMP_GETVALUE_RETURN3 = 33,
    XIMP_RESET_RETURN3 = 34,
    /* Callback  Protocol */
    XIMP_GEOMETRY3 = 40,
    XIMP_PREEDITSTART3 = 41,
    XIMP_PREEDITDONE3 = 42,
    XIMP_PREEDITDRAW3 = 43,
    XIMP_PREEDITDRAW_CM3 = 44,
    XIMP_PREEDITCARET3 = 45,
    XIMP_STATUSSTART3 = 46,
    XIMP_STATUSDONE3 = 47,
    XIMP_STATUSDRAW3 = 48,
    XIMP_STATUSDRAW_CM3 = 49,
    XIMP_PREEDITDRAW_TINY3 = 50,
    /* Extension Protocol */
    XIMP_EXTENSION3 = 90,
    /* client <== frontend  * Error Protocol */
    XIMP_ERROR3 = 99
  };

 private:
  // XIMP specific connection address
  int screen;
  Atom	ximp_request;		// Ximp message type
  Window im_window;		// IMServerWindow
  XIMStyles styles;		// IMInputStyles
  const char *ximp_version;	// XIMPVersion
  XIMPTypeRec ximp_type;	// XIMPType
  const char *im_version;	// XIMPServerVersion

  /* Atoms */
  XIMPAtoms atoms;
  /* XIMPExtension */
  unsigned int ext_flag;	/* flag for supported_extensions */
  long ext_backfront; /* XGIMPExtBackFront value */

  enum XIMP_EXT {
    EXT_STATUS = (1L<<0), EXT_BACKFRONT = (1L<<1),
    EXT_CONV = (1L<<2)
  };

  enum XIMP_PROP_LEN {
    XIMP_PREEDIT_MAX_LONG3 = 14,
    XIMP_PREEDIT_MAX_LONG4 = 15,
    XIMP_STATUS_MAX_LONG3 = 13,
    XIMP_STATUS_MAX_LONG4 = 14
  };

  enum XIMP_CM_LEN {
    CM_DATA_ROOM = 15
  };

  int atom_sequence;
  char *MakeNewAtom(char*, int is_commit=0);

  static void *xevent_loop(void*);

  void setProps();

  InputContext * getInputContextByFocusWindow(Window ); 
  Bool key_press(XClientMessageEvent*);
  Bool key_release(XClientMessageEvent*);
  void create_ic(XClientMessageEvent *);
  void destroy_ic(XClientMessageEvent*);
  void destroy_window(XIMProtocol *, Window);
  void start(XClientMessageEvent*);
  void end(XClientMessageEvent*);
  void set_focus(XClientMessageEvent*);
  void unset_focus(XClientMessageEvent*);
  void set_clientwin(XClientMessageEvent *);
  void set_focuswin(XClientMessageEvent*);
  void move(XClientMessageEvent*);
  void set_icvalues(XClientMessageEvent*);
  void get_icvalues(XClientMessageEvent*);
  void reset(XClientMessageEvent*);
  void event_mask(XClientMessageEvent*);
  void extension(XClientMessageEvent*);
  void preedit_start_ret(XClientMessageEvent*);
  void preedit_caret_ret(XClientMessageEvent*);
};

#endif
