/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <pwd.h>
#include "XIMProtocol.hh"
#include "XIMPInputContext.hh"
#include "Xfactory.hh"

void
XIMPInputContext::set_status_area(long x, long y, unsigned long width,
				  unsigned long height) {
  // as XIM client
  XVaNestedList status_attr;
  XRectangle area;
  area.x = x; area.y = y; area.width = width; area.height = height;
  status_attr = XVaCreateNestedList(0,
				    XNArea, &area,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  return;
}
void
XIMPInputContext::set_status_area_needed(unsigned long width,
					  unsigned long height) {
  if (!xic) DelayBind();

  // as XIM client
  XVaNestedList status_attr;
  XRectangle area;
  area.x = 0; area.y = 0; area.width = width; area.height = height;
  status_attr = XVaCreateNestedList(0,
				    XNAreaNeeded, &area,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  if (width == 0 || height == 0) {
    // do geometry negotiation
    XRectangle *area2 = (XRectangle*)0;
    status_attr = XVaCreateNestedList(0,
				      XNAreaNeeded, &area2,
				      NULL);
    XGetICValues(xic,
		 XNStatusAttributes, status_attr,
		 0);
    XFree(status_attr);
    if (area2) {
      if (width == 0 ||
	  inputstyle & XIMPreeditArea) {
	status_attr4.area_needed.width = area2->width;
      }
      if (height == 0) {
	status_attr4.area_needed.height = area2->height;
      }
      XFree(area2);
    }
    // fallback to avoid setting 0
    if (status_attr4.area_needed.width == 0) {
      XFontSet font_set = XFactory::create_fontset(dpy, status_fontname);
      XFontSetExtents *fsx = XExtentsOfFontSet(font_set);
      status_attr4.area_needed.width = fsx->max_logical_extent.width *10;
      XFactory::free_fontset(dpy, font_set);
    }
    if (status_attr4.area_needed.height == 0) {
      XFontSet font_set = XFactory::create_fontset(dpy, status_fontname);
      XFontSetExtents *fsx = XExtentsOfFontSet(font_set);
      status_attr4.area_needed.height = fsx->max_logical_extent.height;
      XFactory::free_fontset(dpy, font_set);
    }
  }
  return;
}
void
XIMPInputContext::set_status_colormap(Colormap colormap) {
  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNColormap, colormap,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  return;
}
void
XIMPInputContext::set_status_bg(unsigned long bg) {
  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNBackground, bg,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XIMPInputContext::set_status_fg(unsigned long fg) {
  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNForeground, fg,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XIMPInputContext::set_status_bg_pixmap(Pixmap bg_pixmap) {
  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNBackgroundPixmap, bg_pixmap,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XIMPInputContext::set_status_line_spacing(long line_spacing) {
  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNLineSpace, line_spacing,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
void
XIMPInputContext::set_status_cursor(Cursor cursor) {
  // as XIM client
  XVaNestedList status_attr;
  status_attr = XVaCreateNestedList(0,
				    XNCursor, cursor,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
}
Bool
XIMPInputContext::get_status_font() {
  if (!ximp_protocol->get_status_font(client_win,
				      (char **)&status_fontname)) {
    return False;
  }
  // as XIM client
  XVaNestedList status_attr;
  XFontSet font_set = XFactory::create_fontset(dpy, status_fontname);
  status_attr = XVaCreateNestedList(0,
				    XNFontSet, font_set,
				    NULL);
  XSetICValues(xic,
	       XNStatusAttributes, status_attr,
	       0);
  XFree(status_attr);
  return True;
}


