/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <string.h>
#include <stdlib.h>

#include "util.hh"
#include "InterfaceModule.hh"

static int UTFCHAR_len(UTFCHAR *);
static UTFCHAR *UTFCHAR_cpy(UTFCHAR *, UTFCHAR *);

InterfaceModule::InterfaceModule(
    char *p_ifpath,
    char *p_module,
    LEInterface * If
)
{
    int i, j;
    
    lename = (IMLEName *) 0;
    itf = (LEInterface *) 0;

    if (p_ifpath) {
        ifpath = new char[strlen(p_ifpath) + 1];
        strcpy(ifpath, p_ifpath);
    }
    if (p_module) {
        module = new char[strlen(p_module) + 1];
        strcpy(module, p_module);
    }
#ifdef	notdef
    IMSetArg(p[0], IF_LE_NAME, NULL);
    IMSetArg(p[1], IF_SUPPORTED_LOCALES, NULL);
    IMSetArg(p[2], IF_SUPPORTED_OBJECTS, NULL);
    
    if (If->get_values(p, 3) == False) {
        return;
    }
    IMLEName *lename_ = (IMLEName *) p[0].value;
    IMLocale *locale_list_ = (IMLocale *) p[1].value;
    IMObjectDescriptorStruct *object_list_ = (IMObjectDescriptorStruct *) p[2].value;
#else
    IMLEName *lename_ = (IMLEName *) If->itf_t->lename;
    IMLocale *locale_list_ = (IMLocale *) If->itf_t->locale_list;
    IMObjectDescriptorStruct *object_list_ = If->itf_t->object_list;
#endif
    
    if (lename_) {
        lename = new IMLEName;
        lename->id = new char[strlen(lename_->id) + 1];
        strcpy(lename->id, lename_->id);
        if (lename_->name) {
            lename->name = new UTFCHAR[UTFCHAR_len(lename_->name) + 1];
            UTFCHAR_cpy(lename->name, lename_->name);
        }
    }
    if (locale_list_) {
        IMLocale *p = locale_list_;
        for (i = 0; p->id; i++, p++) {
            IMLocale *l = new IMLocale;
            l->id = new char[strlen(p->id) + 1];
            strcpy(l->id, p->id);
            l->name = new UTFCHAR[UTFCHAR_len(p->name) + 1];
            UTFCHAR_cpy(l->name, p->name);
            locale_list.addItem(l);
        }
    }
    if (object_list_) {
        IMObjectDescriptorStruct *o = object_list_;
        for (i = 0; o && o->leid; i++, o++) {
            
            if (o->leid == NULL || o->name == NULL ||
              o->domain == NULL || o->path == NULL || o->scope == NULL) {
                continue;
            }
            IMObjectDescriptorStruct *l = new IMObjectDescriptorStruct;
            memset(l, 0, sizeof(IMObjectDescriptorStruct));
            
            l->type = o->type;
            l->count_names = o->count_names;
            l->name_length = o->name_length;
            
            if (o->count_names) {
                l->class_names = new char *[o->count_names];
                for (j = 0; j < (int) o->count_names; j++) {
                    l->class_names[j] = new char[strlen(o->class_names[j]) + 1];
                    strcpy(l->class_names[j], o->class_names[j]);
                }
            }
            if (o->leid) {
                l->leid = new char[strlen(o->leid) + 1];
                strcpy(l->leid, o->leid);
            }
            if (o->name) {
                l->name = new UTFCHAR[UTFCHAR_len(o->name) + 1];
                UTFCHAR_cpy(l->name, o->name);
            }
            if (o->domain) {
                l->domain = new char[strlen(o->domain) + 1];
                strcpy(l->domain, o->domain);
            }
            if (o->path) {
                l->path = new char[strlen(o->path) + 1];
                strcpy(l->path, o->path);
            }
            if (o->scope) {
                l->scope = new char[strlen(o->scope) + 1];
                strcpy(l->scope, o->scope);
            }
            if (o->signature) {
                l->signature = new char[strlen(o->signature) + 1];
                strcpy(l->signature, o->signature);
            }
            if (o->basepath) {
                l->basepath = new char[strlen(o->basepath) + 1];
                strcpy(l->basepath, o->basepath);
            }
            if (o->encoding) {
                l->encoding = new char[strlen(o->encoding) + 1];
                strcpy(l->encoding, o->encoding);
            }
            object_list.add(l);
        }
    }
}

InterfaceModule::InterfaceModule(
    char *p_ifpath,
    UTFCHAR * le_nameline,
    char *if_nameline,
    char *loc_nameline
)
{
    lename = (IMLEName *) 0;
    itf = (LEInterface *) 0;
    
    lename = new IMLEName;
    
    if (le_nameline) {
        lename->name = new UTFCHAR[UTFCHAR_len(le_nameline) + 1];
        UTFCHAR_cpy(lename->name, le_nameline);
    }
    if (p_ifpath) {
        ifpath = new char[strlen(p_ifpath) + 1];
        strcpy(ifpath, p_ifpath);
    }
    if (if_nameline) {
        module = new char[strlen(if_nameline) + 1];
        strcpy(module, if_nameline);
    }
    if (if_nameline) {
        lename->id = new char[strlen(if_nameline) + 1];
        strcpy(lename->id, if_nameline);
    }
    if (loc_nameline) {
        IMLocale *locale = new IMLocale;
        locale->id = new char[strlen(loc_nameline) + 1];
        strcpy(locale->id, loc_nameline);
        
        int len = strlen(loc_nameline);
        locale->name = new UTFCHAR[len + 1];
        for (int i = 0; i < len; i++) {
            locale->name[i] = (UTFCHAR) loc_nameline[i];
        }
        locale->name[len] = (UTFCHAR) 0;
        locale_list.addItem(locale);
    }
}

InterfaceModule::~InterfaceModule()
{
    int i, j;
    if (ifpath) {
        delete [] ifpath;
    }
    if (lename) {
        delete [] lename->id;
        delete [] lename->name;
        delete lename;
    }
    while (locale_list.getSize()) {
        IMLocale *locale = &(locale_list.getItem(1));
        if (locale) {
            locale_list.remove(locale);
            delete [] locale->id;
            delete [] locale->name;
            delete locale;
        }
    }
    for (i = 1; i <= object_list.count(); i++) {
        IMObjectDescriptorStruct *object = &(object_list.getObjectDescriptor(i));
        if (object) {
            if (object->leid) {
                delete [] object->leid;
            }
            if (object->path) {
                delete [] object->path;
            }
            if (object->name) {
                delete [] object->name;
            }
            if (object->domain) {
                delete [] object->domain;
            }
            if (object->domain) {
                delete [] object->scope;
            }
            if (object->basepath) {
                delete [] object->basepath;
            }
            if (object->signature) {
                delete [] object->signature;
            }
            if (object->encoding) {
                delete [] object->encoding;
            }
            if (object->count_names) {
                for (j = 0; j < (int) object->count_names; j++) {
		    delete [] object->class_names[j];
                }
		delete [] object->class_names;
            }
            delete object;
        }
    }
    locale_list.destroy();
    if(itf != 0){
	delete itf;
    }
}

static int
UTFCHAR_len(
    UTFCHAR * p
)
{
    int i;
    for (i = 0; *p; i++)
    p++;
    return i;
}

static UTFCHAR *
UTFCHAR_cpy(
    UTFCHAR * to,
    UTFCHAR * from
)
{
    int i;
    UTFCHAR *to_ = to;
    for (i = 0; *from; i++) {
        *to++ = *from++;
    }
    *to = 0;
    return to_;
}
