/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


#define _POSIX_PTHREAD_SEMANTICS

#include <string.h>
#include <stdlib.h>
#ifdef WIN32
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#else
#include <dirent.h>
#include <unistd.h>
#endif
#include "util.hh"

#include "LELookup.hh"

static Bool IsNeeded(InterfaceModule *, char *, char *);

void
LELookup::freeListOfLEs(
    InterfaceModuleList * lestruct_list
)
{
    while (lestruct_list->getSize()) {
        InterfaceModule *p = &(lestruct_list->getItem(1));
        if (p) {
            delete p;
            lestruct_list->remove(p);
        }
    }
    lestruct_list->destroy();
    delete lestruct_list;
}

#ifdef	sun
extern "C" {
    Public int is_cm_available(char *);
    Public int is_engine_available(char *, char *);
}
#endif

InterfaceModuleList *
LELookup::getListOfLEs(
    char *ifpath,
    char *imconfigname,
    char *supported_locales,
    char *iflist
)
{
    InterfaceModuleList *lestruct_list = new InterfaceModuleList();
    
#ifdef	DEBUG
    if (ifpath) {
        printf("ifpath=[%s]\n", ifpath);
    }
    if (imconfigname) {
        printf("imconfigname=[%s]\n", imconfigname);
    }
    if (supported_locales) {
        printf("supported_locales=[%s]\n", supported_locales);
    }
    if (iflist) {
        printf("iflist=[%s]\n", iflist);
    }
#endif
    
    LELookup::getListOfLEsFromSystem(
        lestruct_list,
        ifpath,
        supported_locales,
        iflist);
    
#ifdef	sun
    /* add cm if iflist isn 't specified */
    if (!iflist || (*iflist) == 0) {
        UTFCHAR cm_name[] = {'c', 'm', 0};
        
        if (is_cm_available((char*) "ja")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char*) "ja"));
        }
        if (is_cm_available((char*) "ko.UTF-8")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char *) "ko.UTF-8"));
        } else if (is_cm_available((char*) "ko")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char*) "ko"));
        }

        if (is_engine_available((char*) "zh.UTF-8", (char*) "cm")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char *) "zh.UTF-8"));
        } else if (is_cm_available((char*) "zh")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char*) "zh"));
        }
#define	BETA_REFRESH
#ifndef	BETA_REFRESH
        if (is_engine_available((char*) "zh_TW.UTF-8", (char*) "cm")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char *) "zh_TW.UTF-8"));
            
        } else
#endif
	if (is_cm_available((char*)"zh_TW")) {
            lestruct_list->addItem(
                new InterfaceModule(ifpath,
                (UTFCHAR *) cm_name,
                (char *) "cm",
                (char *) "zh_TW"));
        }
    }
#endif
    
#ifdef	notdef
#ifdef	sun
    //for xsunim
    adapter
    LELookup::getListOfLEsFromFile(
        lestruct_list,
        ifpath,
        imconfigname,
        supported_locales,
        iflist);
#endif				/* sun */
#endif
    
    return lestruct_list;
}

#ifdef	notdef
#ifdef	sun
InterfaceModuleList *
LELookup::getListOfLEsFromFile(
    InterfaceModuleList * lestruct_list,
    char *ifpath,
    char *imconfigname,
    char *supported_locales,
    char *iflist
)
{
    if (imconfigname) {
        mergeFromConfigFile(lestruct_list,
            ifpath,
            imconfigname,
            supported_locales,
            iflist);
    }
    return (lestruct_list);
}
#endif				/* sun */
#endif				/* notdef */


#ifndef WIN32
InterfaceModuleList *
LELookup::getListOfLEsFromSystem(
    InterfaceModuleList * lestruct_list,
    char *pathname,
    char *supported_locales,
    char *iflist
)
{
    DIR *dir;
    struct dirent *result;
    struct dirent *entry;
    int ret_val;
    char *ext;
    char *base_name;
    char *base;
    int i;
    
    dir = opendir(pathname);
    if (!dir) {
        return lestruct_list;
    }
    entry = (struct dirent *) malloc(sizeof(struct dirent) + FILENAME_MAX);
    while ((ret_val = readdir_r(dir, entry, &result)) == 0) {
        if (!result)
            break;
        if (strcmp(result->d_name, "xsunimadapter.so") == 0) {
            continue;
        }
        if (strcmp(result->d_name, "sunimadapter.so") == 0) {
            continue;
        }
        ext = strrchr(result->d_name, (int) '.');
        if (ext) {
            if (!strcmp(".so", ext)) {
                i = 0;
                base = result->d_name;
                int base_len = (int) (ext - result->d_name);
                base_name = new char[base_len + 1];
                do {
                    base_name[i++] = *base++;
                } while (base != ext);
                base_name[i] = '\0';
                
                LEInterface *If = LEInterface::getLEInterfaceWithoutOpen(pathname, base_name, (char*)"");
                if (If) {
                    InterfaceModule *lestruct = new InterfaceModule(pathname, base_name, If);
                    
                    if (lestruct->lename && lestruct->locale_list.getSize()) {
                        if (IsNeeded(lestruct, supported_locales, iflist) == True) {
                            lestruct_list->addItem(lestruct);
                        } else {
                            delete lestruct;
                        }
                    }
                    delete If;
                }
                delete [] base_name;
            }
        }
    }
    free(entry);
    closedir(dir);
    return lestruct_list;
}

#else

InterfaceModuleList *
LELookup::getListOfLEsFromSystem(
    InterfaceModuleList * lestruct_list,
    char *pathname,
    char *supported_locales,
    char *iflist
)
{
    char *ext;
    char *compl_pathname;
    char *base_name;
    char *base;
    int i, ind = 0;
    char *name;
    BOOL hasMore;
    WIN32_FIND_DATA finddata;
    
    char *filter = "\\*.dll";
    compl_pathname = new char[strlen(pathname) + strlen(filter) + 1];
    sprintf(compl_pathname, "%s%s", pathname, filter);
    
    // Check if the path is valid
    DWORD dattrib = GetFileAttributes(pathname);
    if (dattrib == -1)
        return (InterfaceModuleList *) 0;
    if (!(dattrib & FILE_ATTRIBUTE_DIRECTORY))
        return (InterfaceModuleList *) 0;
    
    HANDLE dirhand = FindFirstFile(compl_pathname, &finddata);
    if (dirhand == (HANDLE) - 1)
        return (InterfaceModuleList *) 0;
    do {
        name = (LPSTR) & finddata.cFileName;
        ext = strrchr(name, (int) '.');
        if (ext) {
            if (!strcmp(".dll", ext)) {
                i = 0;
                base = name;
                int base_len = (int) (ext - name);
                base_name = new char[base_len + 1];
                do {
                    base_name[i++] = *base++;
                } while (base != ext);
                base_name[i] = '\0';
                
                LEInterface *If = LEInterface::getLEInterfaceWithoutOpen(pathname, base_name, "");
                if (If) {
                    InterfaceModule *lestruct = new InterfaceModule(pathname, base_name, If);
                    
                    if (lestruct->lename && lestruct->locale_list.getSize()) {
                        if (IsNeeded(lestruct, supported_locales, iflist) == True) {
                            lestruct_list->addItem(lestruct);
                        } else {
                            delete lestruct;
                        }
                    }
                    delete If;
                }
                delete [] base_name;
            }
        }
        hasMore = FindNextFile(dirhand, &finddata);
    } while (hasMore);
    return lestruct_list;
}
#endif

void
LELookup::showListOfLEs(
    InterfaceModuleList * lestruct_list
)
{
#ifdef	DEBUG
    int i, j, k;
    
    printf("\n\n#### LIST OF LEs START ####\n");
    for (i = 1; i <= lestruct_list->getSize(); i++) {
        InterfaceModule *m = &(lestruct_list->getItem(i));
        IMLEName *name = m->lename;
        IMLocaleList *locale_list_ = &(m->locale_list);
        IMObjectDescriptorList *object_list_ = &(m->object_list);
        
        printf("module [%d]\n", i);
        printf("	ifpath:[%s]\n", m->ifpath);
        printf("	name:id=[%s] name=[", name->id);
        for (k = 0; name->name[k]; k++) {
            printf("0x%x ", name->name[k]);
        }
        printf("]\n");
        
        for (j = 1; j <= locale_list_->getSize(); j++) {
            IMLocale *l = &(locale_list_->getItem(j));
            printf("	locale[%d]:id=[%s] name=[", j, l->id);
            for (k = 0; l->name[k]; k++) {
                printf("0x%x ", l->name[k]);
            }
            printf("]\n");
        }
        
        for (j = 1; j <= object_list_->count(); j++) {
            IMObjectDescriptorStruct *l = &(object_list_->getObjectDescriptor(j));
            printf("	object[%d]:leid=[%s]\n", j, l->leid);
            printf("	           type=[%d]\n", l->type);
            printf("	           did=[%d]\n", l->id);
            printf("	           domain=[%s]\n", l->domain);
            printf("	           path=[%s]\n", l->path);
            printf("	           scope=[%s]\n", l->scope);
            for (k = 0; k < (int) l->count_names; k++) {
                printf("	           class_names=[%d][%s]\n", k, l->class_names[k]);
            }
            if (l->basepath) {
                printf("	           basepath=[%s]\n", l->basepath);
            }
            if (l->encoding) {
                printf("	           encoding=[%s]\n", l->encoding);
            }
        }
    }
    printf("#### LIST OF LEs END ####\n\n");
#endif
}

#ifdef	notdef
#ifdef	sun

static char *getbasedir(char *);

void
LELookup::mergeFromConfigFile(
    InterfaceModuleList * lestruct_list,
    char *ifpath,
    char *compl_pathname,
    char *supported_locales,
    char *iflist
)
{
    FILE *fin = (FILE *) 0;
    const int LINE_SIZE = 256;
    char file_line[LINE_SIZE];
    char *loc_nameline;
    char *if_nameline;
    char *le_nameline;
    int i;
    
    if ((fin = fopen(compl_pathname, "r")) == NULL) {
#ifdef	DEBUG
        cerr << "Config File not found : " << compl_pathname << endl;
#endif
        return;
    }
    while (1) {
        memset(file_line, 0, LINE_SIZE);
        fgets(file_line, LINE_SIZE, fin);
        
        if (feof(fin)) {
            break;
        }
        if (strncmp(file_line, "#include", 8) == 0) {
            for (int i = 0; file_line[i]; i++) {
                if (file_line[i] == '"') {
                    file_line[i] = ' ';
                }
                if (file_line[i] == '\t') {
                    file_line[i] = ' ';
                }
            }
            char *incpath = Util::getSubString(file_line, " ", 2);
            if (incpath) {
                if (incpath[0] == '/') {
                    mergeFromConfigFile(lestruct_list, ifpath, incpath, supported_locales, iflist);
                    delete [] incpath;
                    continue;
                } else {
                    char *basedir = getbasedir(compl_pathname);
                    char *newincpath = new char[256];
                    sprintf(newincpath, "%s/%s", basedir, incpath);
                    mergeFromConfigFile(lestruct_list, ifpath, newincpath, supported_locales, iflist);
                    delete [] basedir;
                    delete [] newincpath;
                    delete [] incpath;
                    continue;
                }
            }
        }
        if (file_line[0] == ' ' || file_line[0] == '\t' || file_line[0] == '#') {
            continue;
        }
        le_nameline = Util::getSubString(file_line, "\t", 0);
        if_nameline = Util::getSubString(file_line, "\t", 1);
        loc_nameline = Util::getSubString(file_line, "\t", 2);
        
        if (le_nameline == 0 || if_nameline == 0 || loc_nameline == 0) {
            continue;
        }
        for (i = 0; loc_nameline[i]; i++) {
            if (loc_nameline[i] == '\n') {
                loc_nameline[i] = '\0';
                break;
            }
        }
        
        UTFCHAR *le_name_ = new UTFCHAR[strlen(le_nameline) + 1];
        memset(le_name_, 0, sizeof(UTFCHAR) * (strlen(le_nameline) + 1));
        
        for (i = 0; i < (int) strlen(le_nameline); i++) {
            le_name_[i] = le_nameline[i];
        }
        
        InterfaceModule *lestruct = new InterfaceModule(
            ifpath,
            le_name_,
            if_nameline,
            loc_nameline);
        
        if (IsNeeded(lestruct, supported_locales, iflist) == True) {
            lestruct_list->addItem(lestruct);
        } else {
            delete lestruct;
        }
        
        delete [] le_name_;
        delete [] le_nameline;
        delete [] if_nameline;
        delete [] loc_nameline;
    }
    
    if (fin) {
        fclose(fin);
    }
}

static char *
getbasedir(
    char *path
)
{
    char *p;
    char *m;
    int len;
    if ((p = strrchr(path, '/')) != NULL) {
        len = p - path;
        m = new char[len + 1];
        memset(m, 0, sizeof(char) * (len + 1));
        strncpy(m, path, len);
    } else {
        m = new char[2];
        strcpy(m, ".");
    }
    return m;
}
#endif	/* sun */
#endif	/* notdef */

static Bool
IsNeeded(
    InterfaceModule * Im,
    char *locale_list,
    char *if_list
)
{
    char *tmp;
    int ind;
    
    int if_matched = 0;
    if (if_list && strlen(if_list) > 0) {
        ind = 0;
        while ((tmp = Util::getSubString(if_list, (char*)":", ind++)) != (char *) 0) {
            if (strcmp(Im->lename->id, tmp) == 0) {
                if_matched++;
            }
            delete [] tmp;
            if (if_matched) {
                break;
            }
        }
    } else {
        if_matched++;
    }

    if (if_matched == 1) {
        return True;
    } else {
        return False;
    }
}
