/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "SunIM.h"

static Bool if_sunimdefault_OpenIF(iml_if_t *);
static Bool if_sunimdefault_CloseIF(iml_if_t *);
static Bool if_sunimdefault_GetIFValues(iml_if_t *, IMArgList, int);
static Bool if_sunimdefault_SetIFValues(iml_if_t *, IMArgList, int);
static Bool if_sunimdefault_OpenDesktop(iml_desktop_t *, IMArgList, int);
static Bool if_sunimdefault_CloseDesktop(iml_desktop_t *);
static Bool if_sunimdefault_CreateSC(iml_session_t *, IMArgList, int);
static Bool if_sunimdefault_DestroySC(iml_session_t *);
static Bool if_sunimdefault_GetSCValues(iml_session_t *, IMArgList, int);
static Bool if_sunimdefault_SetSCValues(iml_session_t *, IMArgList, int);
static IMText *if_sunimdefault_ResetSC(iml_session_t *);
static void if_sunimdefault_SetSCFocus(iml_session_t *);
static void if_sunimdefault_UnsetSCFocus(iml_session_t *);
static void if_sunimdefault_SendEvent(iml_session_t *, IMInputEvent * ev);

if_methods_t sunim_default_methods = {
    if_sunimdefault_OpenIF,
    if_sunimdefault_CloseIF,
    if_sunimdefault_GetIFValues,
    if_sunimdefault_SetIFValues,
    if_sunimdefault_OpenDesktop,
    if_sunimdefault_CloseDesktop,
    if_sunimdefault_CreateSC,
    if_sunimdefault_DestroySC,
    if_sunimdefault_GetSCValues,
    if_sunimdefault_SetSCValues,
    if_sunimdefault_ResetSC,
    if_sunimdefault_SetSCFocus,
    if_sunimdefault_UnsetSCFocus,
    if_sunimdefault_SendEvent
};

typedef struct {
    int status_start;
}   PerSessionStruct;

static UTFCHAR status_string[] =
{'[', 'N', 'o', ' ', 'I', 'M', ' ', 'c', 'o', 'n', 'n', 'e', 'c', 't', 'e', 'd', ']'};

#define	STATUS_LEN	17

static IMText *status_text = 0;

static void
turnoff_forwarding_event(
    iml_session_t * s
)
{
    iml_inst *lp;
    lp = s->If->m->iml_make_end_conversion_inst(s);
    s->If->m->iml_execute(s, &lp);
}

static void
turnon_forwarding_event(
    iml_session_t * s
)
{
    iml_inst *lp;
    lp = s->If->m->iml_make_start_conversion_inst(s);
    s->If->m->iml_execute(s, &lp);
}

static void
error_status_draw(
    iml_session_t * s
)
{
    PerSessionStruct *p = (PerSessionStruct *) s->specific_data;
    iml_inst *lp;
    if (!p) {
        return;
    }
    if (p->status_start == 0) {
        lp = s->If->m->iml_make_status_start_inst(s);
        s->If->m->iml_execute(s, &lp);
    }
    if (status_text) {
        lp = s->If->m->iml_make_status_draw_inst(s, status_text);
        s->If->m->iml_execute(s, &lp);
    }
}

static Bool
if_sunimdefault_OpenIF(
    iml_if_t * If
)
{
    int i;
    status_text = (IMText *) calloc(1, sizeof(IMText));
    status_text->text.utf_chars = (UTFCHAR *) & status_string;
    status_text->char_length = STATUS_LEN;
    status_text->feedback = (IMFeedbackList *) calloc(1, sizeof(IMFeedback) * STATUS_LEN);
    for (i=0;i<STATUS_LEN;i++) {
        IMFeedbackList *list=&status_text->feedback[i];
        IMFeedback *feedback;
        list->count_feedbacks=1;
        list->feedbacks = (IMFeedback *) calloc(1, sizeof(IMFeedback) * status_text->feedback->count_feedbacks);
        feedback=&list->feedbacks[0];
        feedback->type=IM_DECORATION_FEEDBACK;
        feedback->value=0;
    }
    return True;
}

static Bool
if_sunimdefault_CloseIF(
    iml_if_t * If
)
{
    free(status_text);
    return True;
}

static Bool
if_sunimdefault_GetIFValues(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
    return True;
}

static Bool
if_sunimdefault_SetIFValues(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
    return True;
}

static Bool
if_sunimdefault_OpenDesktop(
    iml_desktop_t * desktop,
    IMArgList args,
    int num_args
)
{
    return True;
}

static Bool
if_sunimdefault_CloseDesktop(
    iml_desktop_t * desktop
)
{
    return True;
}

static Bool
if_sunimdefault_CreateSC(
    iml_session_t *s,
    IMArgList args,
    int num_args
)
{
    PerSessionStruct *p = (PerSessionStruct*)calloc(1, sizeof(PerSessionStruct));
    p->status_start = 0;
    s->specific_data = (void*) p;
    return True;
}

static Bool
if_sunimdefault_DestroySC(
    iml_session_t * s
)
{
    PerSessionStruct *p = (PerSessionStruct *) s->specific_data;
    if (p) {
        free(p);
    }
    return True;
}

static Bool
if_sunimdefault_GetSCValues(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    return True;
}

static Bool
if_sunimdefault_SetSCValues(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    int i;
    IMArg *p=args;
    for (i = 0; i < num_args; i++, p++) {
        switch (p->id) {
            case SC_TRIGGER_ON_NOTIFY:
                turnon_forwarding_event(s);
            }
    }
    return True;
}

static IMText *
if_sunimdefault_ResetSC(
    iml_session_t * s
)
{
    turnoff_forwarding_event(s);
    return (IMText *) NULL;
}

static void
if_sunimdefault_SetSCFocus(
    iml_session_t * s
)
{
    error_status_draw(s);
    turnoff_forwarding_event(s);
}

static void
if_sunimdefault_UnsetSCFocus(
    iml_session_t * s
)
{
    error_status_draw(s);
    turnoff_forwarding_event(s);
}

static void
if_sunimdefault_SendEvent(
    iml_session_t * s,
    IMInputEvent * ev
)
{
    iml_inst *lp;
    IMKeyListEvent *keylist;
    
    if (ev->type == IM_EventKeyList) {
        keylist = (IMKeyListEvent *) ev;
        lp = s->If->m->iml_make_keypress_inst(s, (IMKeyEventStruct *) keylist->keylist);
        s->If->m->iml_execute(s, &lp);
    }
    
    turnoff_forwarding_event(s);
}
