/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef sunim_hh_
#define sunim_hh_ 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined(sun)
#include <thread.h>
#elif defined(WIN32)
#include <windows.h>
#else
#include <pthread.h>
#endif

#include "IMList.hh"

#include "SunIM.h"

class UserInfo {
  public:
    enum UserInfo_Attribute {
        UserName = UI_USER_NAME,
        HostName = UI_HOST_NAME,
        DisplayId = UI_DISPLAY_ID,
        ProtocolType = UI_PROTOCOL_TYPE,
        ClientType = UI_CLIENT_TYPE,
        XServerVendor= UI_XSERVER_VENDOR,
        OsName = UI_OS_NAME,
        OsArch = UI_OS_ARCH,
        OsVersion = UI_OS_VERSION
    };
    Bool set_values(IMArgList, int);
    Bool get_values(IMArgList, int);
    
    char *user_name;
    char *host_name;
    char *display_id;
    
    UserInfo(char *, char *, char *);
    UserInfo(IMArgList, int);
    ~UserInfo();
  private:
    IMList<char> uiargs;
};

class LEInterface {
  public:
    LEInterface(char *if_path, char *if_name, char *if_locale, Bool call_openif);
    ~LEInterface();
    
    static LEInterface *getLEInterfaceWithoutOpen(char *if_path, char *if_name, char *if_locale);
    static LEInterface *getLEInterface(char *if_path, char *if_name, char *if_locale);
    static LEInterface *getLEInterface(char *, char *);
    
    Bool set_values(IMArgList, int);
    Bool get_values(IMArgList, int);
    
    iml_if_t * itf_t;
    
    class LEInterface *next;
    char *interface_module;
    char *locale;
    
    static void initialize();
    void le_lock();
    void le_force_lock();
    void le_unlock();
    void le_force_unlock();
    static void BC_xsunim_filterevent(IMInputEvent *);

  private:
    if_methods_t *ifm;
    
    Bool call_openif;
    Bool need_thread_lock;
};

class LESessionContext {
  public:
    LESessionContext(LEInterface *, UserInfo *);
    ~LESessionContext();
    
    static LESessionContext *getLESessionContext(LEInterface *, UserInfo * user);
    
    Bool set_values(IMArgList, int);
    Bool get_values(IMArgList, int);
    
    void send_event(IMInputEvent *);
    
    IMText *reset();
    void set_focus();
    void unset_focus();
    
    void addIMLListener(iml_inst * (*iml_execute) (iml_inst **, void *), void *closure);
    
    void callIMLExecute(iml_inst **);
  private:
    Bool realize;
    iml_inst * (*iml_execute) (iml_inst **, void *);
    iml_desktop_t *desktop;
    iml_session_t *s;
    LEInterface *itf;
    void *closure;
};

#endif	/* sunim_hh_ */
