/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <X11/Xlib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <sys/socket.h>
#include <errno.h>

#ifdef	USE_DOOR
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <door.h>
#endif

#include <locale.h>
#include "VM_Driver.hh"
#include "VMAdapterStub.hh"

int VMAdapterStub::id = 0;

VMAdapterStub::VMAdapterStub(
    VMSharedMemory * shm
)
{
    sharedmemory = shm;
    datarep = (DataRep *) 0;
}

VMAdapterStub::~VMAdapterStub()
{
}

int
VMAdapterStub::getDriverId(char *locale, char *name)
{
    VMDriverStub *drv = (VMDriverStub *) 0;
    
    drv = SearchDriver(locale, name);
    if (drv) {
        return drv->id;
    }
    return 0;
}

DrvManager *
VMAdapterStub::getDrvManager(
    char *locale,
    char *name
)
{
    int i;
    for (i = 1; i <= drv_list.getSize(); i++) {
        VMDriverStub *p = &(drv_list.getItem(i));
        if ((!strcmp(p->name, name)) && (!strcmp(p->locale, locale))) {
            return p->drv_manager;
        }
    }
    return NULL;
}

int
VMAdapterStub::getDriverCount(void)
{
    return drv_list.getSize();
}

void
VMAdapterStub::DeleteDriver(
    char *locale,
    char *name
)
{
    VMDriverStub *p;
    int i;
    for (i = 1; i <= drv_list.getSize(); i++) {
        p = &(drv_list.getItem(i));
        if ((!strcmp(p->name, name)) && (!strcmp(p->locale, locale))) {
            drv_list.remove(p);
            if (p->vm_driver == NULL) {
#ifndef	USE_DOOR
                close(p->sockets[0]);
                close(p->sockets[1]);
#endif
#ifdef DEBUG
                printf("deleting Driver\n");
#endif
                kill(p->proc_id, SIGKILL);
#ifdef	notdef
                sharedmemory->ShmFree((char *) p->adp_session_data, sizeof(VMSharedSessionData));
#endif
                sharedmemory->ShmFree((char *) p->adp_request_args, ADP_REQ_LEN);
                sharedmemory->ShmFree((char *) p->adp_reply_args, ADP_REP_LEN);
            } else {
#ifdef	notdef
                free(p->adp_session_data);
#endif
                free(p->adp_request_args);
                free(p->adp_reply_args);
                delete p->vm_driver;
            }
            if (p->locale) {
                free(p->locale);
            }
            if (p->name) {
                free(p->name);
            }
            if (p->methods) {
                free(p->methods);
            }
            free(p);
            break;
        }
    }
}

VMDriverStub *
VMAdapterStub::SearchDriver(
    char *locale,
    char *name
)
{
    VMDriverStub *p;
    int i;
    for (i = 1; i <= drv_list.getSize(); i++) {
        p = &(drv_list.getItem(i));
        if ((!strcmp(p->name, name)) && (!strcmp(p->locale, locale))) {
            return p;
        }
    }
    return NULL;
}

VMDriverStub *
VMAdapterStub::SearchDriver(
    int driver_id
)
{
    VMDriverStub *p;
    int i;
    for (i = 1; i <= drv_list.getSize(); i++) {
        p = &(drv_list.getItem(i));
        if (p->id == driver_id) {
            return p;
        }
    }
    return NULL;
}

VMDriverStub *
VMAdapterStub::AddDriver(
    DrvManager * drv_man,
    char *locale,
    char *name,
    char *methods
)
{
    return AddDriverReal(drv_man, locale, name, methods, True);
}

VMDriverStub *
VMAdapterStub::AddDriverWithoutFork(
    DrvManager * drv_man,
    char *locale,
    char *name,
    char *methods
)
{
    return AddDriverReal(drv_man, locale, name, methods, False);
}

#ifdef	sun
#define	FORKFUNC	fork1()
#else	/* sun */
#define	FORKFUNC	fork()
#endif

VMDriverStub *
VMAdapterStub::AddDriverReal(
    DrvManager * drv_man,
    char *locale,
    char *name,
    char *methods_name,
    Bool need_fork
)
{
    VMDriverStub *drv;
    int child;
    VM_Driver *vm_driver;
    
    drv = SearchDriver(locale, name);
    if (drv) {
        return drv;
    }
    
    drv = (VMDriverStub *) calloc(1, sizeof(VMDriverStub));
    drv->drv_manager = drv_man;
    drv->vm_driver = NULL;
    drv->id = id++;
    drv->locale = (char *) strdup(locale);
    drv->name = (char *) strdup(name);
    
    if (methods_name) {
        drv->methods = (char *) strdup(methods_name);
    } else {
        drv->methods = (char *) 0;
    }
    
    drv_list.addItem(drv);
    
    if (need_fork == True) {
#ifdef	notdef
        drv->adp_session_data = (VMSharedSessionData *) sharedmemory->ShmAlloc(sizeof(VMSharedSessionData));
#endif
        drv->adp_request_args = (VMSharedArgumentsArea) sharedmemory->ShmAlloc(ADP_REQ_LEN);
        drv->adp_reply_args = (VMSharedArgumentsArea) sharedmemory->ShmAlloc(ADP_REP_LEN);
#ifndef	USE_DOOR
        if (socketpair(AF_UNIX, SOCK_STREAM, 0, drv->sockets) < 0) {
#ifdef DEBUG
            printf("error %d on socketpair\n", errno);
#endif
            free(drv);
            return NULL;
        }
#endif
        
        if ((child = FORKFUNC) == -1) {
#ifdef DEBUG
            printf("VMAdapterStub: fork error %d\n", errno);
#endif
            return NULL;
        }
        if (child != 0) {
#ifndef	USE_DOOR
            close(drv->sockets[0]);
#else
            if ((drv->door_id = open(DOOR_TMP_FILE, O_RDWR)) < 0) {
                sleep(3);
                if ((drv->door_id = open(DOOR_TMP_FILE, O_RDWR)) < 0) {
#ifdef DEBUG
                    perror("Can't open /tmp/.door");
#endif
                    kill(child, SIGTERM);
                    return NULL;
                }
            }
            unlink(DOOR_TMP_FILE);
#endif
            drv->proc_id = child;
        } else {
#ifdef DEBUG
            printf("VM_Driver locale=[%s] le=[%s] is started in child process\n", drv->locale, drv->name);
#endif
#ifndef	USE_DOOR
            close(drv->sockets[1]);
            vm_driver = new VM_Driver(drv_man, drv->locale, drv->name, drv->methods, drv->sockets[0]);
            vm_driver->TransService();
#else
            vm_driver = new VM_Driver(drv_man, drv->locale, drv->name, drv->methods, -1);
            pause();
#endif
        }
    } else {
#ifdef DEBUG
        printf("VM_Driver locale=[%s] le=[%s] is started in same process\n", drv->locale, drv->name);
#endif
#ifdef	notdef
        drv->adp_session_data = (VMSharedSessionData *) calloc(1, sizeof(VMSharedSessionData));
#endif
        drv->adp_request_args = (VMSharedArgumentsArea) calloc(1, ADP_REQ_LEN);
        drv->adp_reply_args = (VMSharedArgumentsArea) calloc(1, ADP_REP_LEN);
        drv->vm_driver = new VM_Driver(drv_man, drv->locale, drv->name, drv->methods, -2);
        if (drv->vm_driver->is_active() == False) {
            return (NULL);
        }
    }
    
    VMSignalData request, reply;
    memset(&request, 0, sizeof(VMSignalData));
    memset(&reply, 0, sizeof(VMSignalData));
    request.type = CONNECT_START;
#ifdef	notdef
    request.sh_session_addr = drv->adp_session_data;
#endif
    request.sh_request_args_addr = drv->adp_request_args;
    request.sh_reply_args_addr = drv->adp_reply_args;
    
    if (DataTrans(drv, &request, &reply) == -1) {
        if (drv->vm_driver) {
            kill(drv->proc_id, SIGKILL);
        }
        return (NULL);
    }
    return (drv);
}

int
VMAdapterStub::DataTrans(
    VMDriverStub * ds,
    VMSignalData * request,
    VMSignalData * reply
)
{
#ifdef	DEBUG
    printf("VMAdapterStub::DataTrans pid=%x locale = %s(%s), le = %s\n",
        getpid(),
    locale,
    setlocale(LC_CTYPE, 0),
    name);
#endif
    if (ds->vm_driver) {
        VM_Driver *vm_driver = (VM_Driver *) ds->vm_driver;
        vm_driver->TransService(request, reply);
    } else {
#ifdef	USE_DOOR
        door_arg_t *arg = (door_arg_t *) calloc(1, sizeof(door_arg_t));
        arg->data_ptr = (char *) request;
        arg->data_size = sizeof(VMSignalData);
        arg->rbuf = (char*)reply;
        arg->rsize = sizeof(VMSignalData);

        if (door_call(ds->door_id, arg) < 0) {
            memset(reply, 0, sizeof(VMSignalData));
	} else {
            if(arg->rsize > sizeof(VMSignalData)){
		munmap(arg->rbuf, arg->rsize);
                memset(reply, 0, sizeof(VMSignalData));
	    }
        }
        free(arg);
#else
        if (write(ds->sockets[1], request, sizeof(VMSignalData)) < 0) {
#ifdef DEBUG
            printf("Stub: error %d writing socket\n", errno);
#endif
            return -1;
        }
        if (read(ds->sockets[1], reply, sizeof(VMSignalData)) < 0) {
#ifdef DEBUG
            printf("Stub: error %d reading socket\n", errno);
#endif
            return -1;
        }
#endif
    }
    return 0;
}

int
VMAdapterStub::sendRequest(
    int driver_id,
    int session_id,
    int type,
    VMSignalData * reply
)
{
    VMSignalData request;
    VMDriverStub *ds;
    
    memset(&request, 0, sizeof(VMSignalData));
    memset(reply, 0, sizeof(VMSignalData));
    
    request.type = type;
    request.session_id = session_id;
    ds = (VMDriverStub *) SearchDriver(driver_id);
    if (ds == NULL) {
#ifdef DEBUG
        printf("Can not find driver\n");
#endif
        return -1;
    }
    DataTrans(ds, &request, reply);
    return 0;
}

void
VMAdapterStub::resetAddress(int driver_id)
{
    /* do not memset */
    VMDriverStub *ds = (VMDriverStub *)SearchDriver(driver_id);
    cur_put_area = ds->adp_request_args;
    cur_get_area = ds->adp_reply_args;
    datarep->setArgsArea(cur_put_area, cur_get_area);
    return;
}

void
VMAdapterStub::initAddress(int driver_id)
{
    VMDriverStub *ds = (VMDriverStub *)SearchDriver(driver_id);
    memset(ds->adp_request_args, 0, ADP_REQ_LEN);
    memset(ds->adp_reply_args, 0, ADP_REP_LEN);
    cur_put_area = ds->adp_request_args;
    cur_get_area = ds->adp_reply_args;
    if (datarep) {
        datarep->setArgsArea(cur_put_area, cur_get_area);
    } else {
        datarep = new DataRep(cur_put_area, cur_get_area);
    }
    return;
}

void
VMAdapterStub::putInt(int value)
{
    datarep->putInt(value);
}

void
VMAdapterStub::putLong(long value)
{
    datarep->putLong(value);
}

void
VMAdapterStub::putString(char *str, int len)
{
    datarep->putString(str, len);
}

void
VMAdapterStub::putShort(short value)
{
    datarep->putShort(value);
}

void
VMAdapterStub::putChar(char value)
{
    datarep->putChar(value);
}

void
VMAdapterStub::putWChar(wchar_t value)
{
    datarep->putWChar(value);
}

void
VMAdapterStub::putArgs(IMArg * args, int num_args, int set_mode)
{
    datarep->putArgs(args, num_args, set_mode);
}

void
VMAdapterStub::putAny(void *val, int len)
{
    datarep->putAny(val, len);
}

void
VMAdapterStub::putUTFString(UTFCHAR * s, int len)
{
    datarep->putUTFString(s, len);
}

void
VMAdapterStub::putXIMText(XIMText * text)
{
    datarep->putXIMText(text);
}

void
VMAdapterStub::getInt(int *val)
{
    datarep->getInt(val);
}

void
VMAdapterStub::getLong(long *val)
{
    datarep->getLong(val);
}

void
VMAdapterStub::getChar(char *val)
{
    datarep->getChar(val);
}

void
VMAdapterStub::getString(char *str, int len)
{
    datarep->getString(str, len);
}

void
VMAdapterStub::getWChar(wchar_t * wc)
{
    datarep->getWChar(wc);
}

void
VMAdapterStub::getArgs(IMArg * args, int num_args, int set_mode)
{
    datarep->getArgs(args, num_args, set_mode);
}

void
VMAdapterStub::getAny(void *any, int len)
{
    datarep->getAny(any, len);
}

void
VMAdapterStub::getXIMText(XIMText * text)
{
#ifdef	notdef
    datarep->getXIMText(text);
#endif
}
