/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef ADAPTERSTUB_HH
#define ADAPTERSTUB_HH 1

#include "IMArg.h"
#include "IMList.hh"

#include "VMSharedMemory.hh"
#include "DataRep.hh"
#include "VM_Driver.hh"

typedef struct _VMDriverStub {
    char *name;
    char *locale;
    char *methods;
    int id;
#ifdef  USE_DOOR
    int door_id;
#endif
    int sockets[2];
    int proc_id;
    DrvManager *drv_manager;
    VM_Driver *vm_driver;
#ifdef	notdef
    VMSharedSessionData *adp_session_data;
#endif
    VMSharedArgumentsArea adp_request_args;
    VMSharedArgumentsArea adp_reply_args;
}   VMDriverStub;

class VMAdapterStub {
  public:
    VMAdapterStub(VMSharedMemory * sharedmemory);
    ~VMAdapterStub();
    VMDriverStub *AddDriverWithoutFork(DrvManager * drv_man,
        char *locale,
        char *le_name, char *methods);
    VMDriverStub *AddDriver(DrvManager * drv_man,
        char *name, char *locale, char *methods);
    VMDriverStub *SearchDriver(char *name, char *locale);
    VMDriverStub *SearchDriver(int driver_id);
    void DeleteDriver(char *name, char *locale);
    DrvManager *getDrvManager(char *name, char *locale);
    int DataTrans(VMDriverStub * ds, VMSignalData * request, VMSignalData * reply);
    int sendRequest(int driver_id, int gcontext_id, int type, VMSignalData * reply);
    int getDriverId(char *name, char *locale);
int VMAdapterStub::getDriverCount(void);
    void initAddress(int);
    void resetAddress(int);
    void putInt(int);
    void putLong(long);
    void putString(char *, int);
    void putShort(short);
    void putChar(char);
    void putWChar(wchar_t);
    void putArgs(IMArg * args, int num_args, int set_mode);
    void putAny(void *, int);
    void putXIMText(XIMText *);
    void putUTFString(UTFCHAR * s, int len);
    void getInt(int *);
    void getLong(long *);
    void getString(char *, int);
    void getShort(short *);
    void getChar(char *);
    void getWChar(wchar_t *);
    void getArgs(IMArg * args, int num_args, int set_mode);
    void getAny(void *, int);
    void getXIMText(XIMText *);
    static int id;
  private:
    DataRep * datarep;
    VMSharedMemory *sharedmemory;
    VMSharedArgumentsArea cur_put_area;
    VMSharedArgumentsArea cur_get_area;
    IMList<VMDriverStub> drv_list;
    VMDriverStub *AddDriverReal(DrvManager * drv_man,
        char *locale, char *le_name,
        char *methods, Bool need_fork);
};

#endif
