/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <locale.h>
#include <pwd.h>
#include "XSunIMAdapter.hh"
#include "LEHandler.hh"
#include "XSunIMLookup.h"
#include "KeyConverter.hh"
#include "Utility.hh"
#include "HotKey.hh"
#include "SystemMessage.h"

Private char *OWHOME = "/usr/openwin";
extern old_iml_methods_t x_iml_methods;

#define ENABLE_SWITCHING 1

extern "C" {
    extern void *_iml_new(old_iml_session_t *, int);
    extern void *_iml_new2(old_iml_session_t *, int);
    extern void *_iml_delete(old_iml_session_t *);
    extern void *_iml_delete2(old_iml_session_t *);
}

#ifdef _POSIX_PATH_MAX
#define PATHNAME_MAX _POSIX_PATH_MAX
#else
#define PATHNAME_MAX 1024
#endif

#ifdef	notdef
static HttRec *htt = (HttRec *) 0;
static ImChain im = (ImChain) 0;
static ImChain getImChain();
#endif

static IMLGlue imlg = (IMLGlue) 0;

#ifdef	notdef	/* for Xci */
static ImChain
getImChain()
{
    XrmDatabase cmd_db = (XrmDatabase) 0;
    if (htt == 0) {
        htt = new HttRec;
        memset((void *) htt, 0, sizeof(HttRec));
        htt->im = new ImChainRec;
        memset((void *) (htt->im), 0, sizeof(ImChainRec));
        htt->im->htt = htt;
        htt->app_defaults = 0;
        htt->special = 0;
        htt->dot_rc = 0;
        htt->command_name = strdup("htt");
        htt->class_name = strdup("Htt");
    }
    htt->rdb = htt->cmdlines = cmd_db;
    return htt->im;
}
#endif

LE_Info * LEHandler::LoadLE(
    char *locale,
    char *p_ifname
)
{
    char if_path[PATHNAME_MAX];
    char method_name[PATHNAME_MAX];
    char * le_name;
    LE_Info * le;

    le = (LE_Info *) new LE_Info;
    memset(le, 0, sizeof(LE_Info));
    le->next = NULL;

    le_name = new char[strlen(p_ifname) + 1];
    strcpy(le_name, p_ifname);

    sprintf(if_path, "%s/lib/locale/%s/xim/%s.so", OWHOME, locale, le_name);

    le->so_handler = NULL;
    if (!access(if_path, F_OK))
      le->so_handler = (void *) dlopen(if_path, RTLD_LAZY);
    if (le->so_handler == NULL) {
        sprintf(if_path, "%s/lib/locale/common/xim/%s.so", OWHOME, le_name);
	if (!access(if_path, F_OK))
	  le->so_handler = (void *) dlopen(if_path, RTLD_LAZY);
        if (le->so_handler == NULL) {
            system_message(MSG_ERROR, "can't find le %s\n", if_path);
	    delete le_name;
	    delete le;
	    return NULL;
        }
    }

    sprintf(method_name, "%s_methods", le_name);
    le->if_methods = (old_if_methods_t *) dlsym(le->so_handler, method_name);
    if (le->if_methods == NULL) {
	sprintf(method_name, "%s_methods", HotKey::getMethodsName(locale, le_name));
        le->if_methods = (old_if_methods_t *) dlsym(le->so_handler, method_name);
        if (le->if_methods == NULL) {
            le->if_methods = (old_if_methods_t *) dlsym(le->so_handler, "cm_methods");
            if (le->if_methods == NULL) {
                system_message(MSG_ERROR, "can't find symbol %s\n", le_name);
	        delete le_name;
		delete le;
	        return NULL;
            }
	}
    }

    le->If = (old_iml_if_t *) new old_iml_if_t;
    memset(le->If, 0, sizeof(old_iml_if_t));
    le->If->m = (old_iml_methods_t *) & x_iml_methods;

#ifdef	notdef
    if (im == 0) {
        im = getImChain();
    }
    le->If->im = im;
#endif

    le->If->if_spec = NULL;
    le->If->locale = locale;
    le->If->if_name = le_name;
    
#ifdef	notdef
    if (imlg == 0) {
        imlg = (IMLGlueRec *) new IMLGlueRec;
        memset(imlg, 0, sizeof(IMLGlueRec));
        imlg->cell_link = (XSFrrvCell) 0;
        imlg->session = (void *) this;
        imlg->window = 0;
        imlg->screen = 0;
    }
#endif

    return le;
}

Bool LEHandler::SwitchLE(
    IC_Info * ic,
    XKeyEvent *ev
)
{
    LE_Info *le = les ;
    LE_Info *ple = les ;
    LE_Info *tmp_le;
    char * if_name;
    LevelTag tag;
    Bool le_loaded = False;
    Bool If_opened = False;
    old_iml_session_t * s;
    unsigned long keysym_bak = ev->keycode;
    unsigned int modifier_bak = ev->state;
    LevelTag tag_tmp;

    if_name = HotKey::getLanguageEngineFromHotKey((XKeyEvent *)ev, &tag);
    if(!if_name) return(False);

    s = (old_iml_session_t *) findSession(ic->icid);

    /* reset the session */
    tag_tmp = HotKey::getHotKeyLevel(locale, ic->ifname);
    if(tag_tmp == UserLevel) {
	if_methods->if_ResetSC(s);
    }
    else if(tag_tmp == SystemLevel) {
	ev->keycode = HotKey::getHotKeyKeysym(locale, ic->ifname);
	ev->state = HotKey::getHotKeyModifier(locale, ic->ifname);
	if_methods->if_SendEvent(s, ev);
    } 

    /* restore key event */
    ev->keycode = keysym_bak;
    ev->state = modifier_bak;

    tmp_le = current_le;

    for(;le;ple=le,le=le->next){
	if(!strcmp(le->If->if_name, if_name)) {
	    le_loaded = True;
	    current_le = le;
	    break;
	}
    }

    if(!le_loaded) {
	le = (LE_Info *) LoadLE(locale, if_name);
	if(!le) return False;

    	If_opened = le->if_methods->if_OpenIF(le->If);
	if(!If_opened) {
	    /* need to dlclose this le */
	    return False;
	}
	ple->next = le;
	current_le = le;
    }

    strcpy(ic->ifname, if_name);
    if_methods = (old_if_methods_t *) current_le->if_methods;
    If = (old_iml_if_t *) current_le->If;

    s = (old_iml_session_t *) findSession(ic->icid);
    if(!s) {
	s = (old_iml_session_t *)CreateSCLocal((IC_Info *) ic);
	if(!s) {
	    current_le = tmp_le;
	    if_methods = (old_if_methods_t *) current_le->if_methods;
	    If = (old_iml_if_t *) current_le->If;
	    return False;
	}
    }

    if_methods->if_SetSCValue(s, SC_Henkan_Mode, (caddr_t)True);
    if(tag == SystemLevel) if_methods->if_SendEvent(s, ev); 

    return True;
}

LEHandler::LEHandler(
    char *p_locale,
    char *p_ifname
)
{
    locale = new char[strlen(p_locale) + 1];
    strcpy(locale, p_locale);
    prime_ifname = new char[strlen(p_ifname) + 1];
    strcpy(prime_ifname, p_ifname);
    sessions = NULL;

    HotKey::buildHotKeyTable(locale);

    les = current_le = (LE_Info *) LoadLE(locale, p_ifname);
    if(!current_le) return;
  
    if_methods = (old_if_methods_t *) current_le->if_methods;
    If = (old_iml_if_t *) current_le->If;

    nrows = 0;
    ncols = 0;
    label_type = IM_LUC_LABEL_ALPHABETIC;
}

LEHandler::~LEHandler()
{
    LE_Info *le = les ;
    LE_Info *ple = les ;

    delete locale;
    for(;le;ple=le,le=le->next){
	delete le->If->if_name;
	delete le->If;
	dlclose(le->so_handler);
    }
    HotKey::deleteHotKeyTable();
}

Bool
LEHandler::OpenIF()
{
    return if_methods->if_OpenIF(If);
}

void
LEHandler::CloseIF()
{
    if_methods->if_CloseIF(If);
}

void
LEHandler::OpenDesktop()
{
}

void
LEHandler::CloseDesktop()
{
}

old_iml_session_t *
LEHandler::CreateSCLocal(
IC_Info *public_ic
)
{
    old_iml_session_t *tmp_session=(old_iml_session_t*)0;
    IMLookupCallback luc;

    tmp_session = (old_iml_session_t *) 
	if_methods->if_CreateSC(If, public_ic, current_le->If->if_name);

    if(tmp_session == 0){
	return NULL;
    }
  
    luc = luc_create((void *) tmp_session, label_type);
    add_luccallback(tmp_session, luc);
    
    if (ncols == 0 || ncols > 30) {
        ncols = 6;
    }
    if (nrows == 0 || nrows > 30) {
        nrows = 6;
    }

    if_methods->if_SetSCValue(tmp_session, SC_user_name, (void *) public_ic->username);
    if_methods->if_SetSCValue(tmp_session, SC_protocol_name, (void *) "IIIMP");
    if_methods->if_SetSCValue(tmp_session, SC_lookup_root, (void *) False);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_cwidth, (void *) 16);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_ewidth, (void *) 16);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_rootwidth, (void *) 0);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_lines, (void *) 0);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_imscontrol, (void *) True);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_ncols, (void *) ncols);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_nrows, (void *) nrows);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_direction, (void *) 0);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_whoownslabel, (void *) 1);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_nchoices, (void *) luc->num_of_labels);
    if_methods->if_SetSCValue(tmp_session, SC_lookup_labeltype, (void *) label_type);
    if_methods->if_SetSCValue(tmp_session, SC_nego_flush, (void *) True);

    if (sessions == NULL)  sessions = tmp_session;

    return tmp_session;
}

void
LEHandler::CreateSC(
    VMSignalData * reply,
    char *username
)
{
    static int icid = -1;
    IC_Info * public_ic;
    old_iml_session_t * tmp_session;

    public_ic = (IC_Info *) new IC_Info;
    icid ++;
    public_ic->icid = icid;
    public_ic->username = (char*) new char[strlen(username) + 1];
    strcpy(public_ic->username, username);
    strcpy(public_ic->ifname, prime_ifname);

    current_le = (LE_Info *)findLE(public_ic->ifname);
    if_methods = (old_if_methods_t *) current_le->if_methods;
    If = (old_iml_if_t *) current_le->If;

    tmp_session = (old_iml_session_t *) CreateSCLocal(public_ic);

    if(tmp_session == 0){
	reply->type = XSUNIM_REPLY_FAIL;
	return;
    }

    /* call SC_Henkan_Mode False once for zh locale*/
    if(!strncmp(If->locale, "zh", 2)){
       tmp_session->public_status |= IMLSTATUS_Henkan_Mode;
       if_methods->if_SetSCValue(tmp_session, SC_Henkan_Mode, (void *) 0);
    }

    reply->session_id = public_ic->icid;
}

void
LEHandler::DestroySC(
    VMSignalData * reply,
    int sid
)
{
    old_iml_session_t *s;
    IC_Info *ic;

    s = (old_iml_session_t *) sessions;

    while (s) {
	ic = (IC_Info *) s->ic;
        if (ic->icid == sid) {
	    current_le = (LE_Info *)findLE(ic->ifname);
	    if_methods = (old_if_methods_t *) current_le->if_methods;
	    If = (old_iml_if_t *) current_le->If;
	    _iml_delete(s);
	    if_methods->if_DestroySC(s);
	    return;
        } 
        s = s->next;
    }
}

void
LEHandler::PostDestroySC(
    VMSignalData * reply,
    int sid
)
{
    old_iml_session_t *s;
    IC_Info *ic;

    s = (old_iml_session_t *) sessions;

    while (s) {
	ic = (IC_Info *) s->ic;
        if (ic->icid == sid) {
	    current_le = (LE_Info *)findLE(ic->ifname);
	    if_methods = (old_if_methods_t *) current_le->if_methods;
	    If = (old_iml_if_t *) current_le->If;
	    _iml_delete(s);
	    _iml_delete2(s);
	    remove_luccallback_by_session((void *) s);
	    s->session_id = IML_SESSION_RECYCLE;
    	    delete ic->username;
            delete ic;
	    return;
        }
        s = s->next;
    }
}

void
LEHandler::ResetSC(
    VMSignalData * reply,
    int sid
)
{
    old_iml_session_t *s = findSession(sid);
    if (!s) {
        return;
    }
    _iml_delete(s);
    s->private_status |= BEING_RESET;
    if_methods->if_ResetSC(s);
    s->private_status &= ~BEING_RESET ;
    if(s->private_status & RESET_DATA_EXIST){
            s->private_status &= ~RESET_DATA_EXIST ;
    }
}

void
LEHandler::SetSCFocus(
    VMSignalData * reply,
    int sid
)
{
    old_iml_session_t *s = findSession(sid);
    LE_Info *le = les ;
    LE_Info *ple = les ;

    if (!s) {
        return;
    }
    _iml_delete(s);

    for(;le;ple=le,le=le->next){
	if(!strcmp(le->If->if_name, s->If->if_name)) {
	    current_le = le;
	    break;
	}
    }

    if_methods = (old_if_methods_t *) current_le->if_methods;
    If = (old_iml_if_t *) current_le->If;

    s->private_status |= BEING_FOCUSED ;
    if_methods->if_SetSCFocus(s);
}

void
LEHandler::UnsetSCFocus(
    VMSignalData * reply,
    int sid
)
{
    old_iml_session_t *s = findSession(sid);
    if (!s) {
        return;
    }
    _iml_delete(s);
    s->private_status &= ~BEING_FOCUSED ;
    if_methods->if_UnsetSCFocus(s);
}

void
LEHandler::SendEvent(
    VMSignalData * reply,
    int sid,
    int keycode,
    int keychar,
    int modifier
)
{
    old_iml_session_t *s = findSession(sid);
    if (!s) {
        return;
    }
    _iml_delete(s);
    
    XKeyEvent *xkey = (XKeyEvent *) Utility::getXKeyEvent(keycode, keychar, modifier);
    s->event = xkey;

#ifdef ENABLE_SWITCHING
    if( !SwitchLE((IC_Info*) s->ic, (XKeyEvent *) xkey) )
	if_methods->if_SendEvent(s, (XKeyEvent *) xkey);
#else
    if_methods->if_SendEvent(s, (XKeyEvent *) xkey);
#endif

}

void
LEHandler::FilterEvent(
    VMSignalData * reply,
    int sid,
    XEvent * xev
)
{
#ifdef	notdef	/* for xjsi */
    old_iml_session_t *s = findSession(sid);
    if (!s) {
        return;
    }
    if_methods->if_FilterEvent(xev);
#endif
}

void
LEHandler::SetAuxValues(
    VMSignalData * reply,
    int sid,
    char *engine_name,
    int engine_class_index,
    int count_integer_values,
    int *integer_values,
    int count_string_values,
    char **string_values
)
{
    int i;
    old_iml_session_t *s = findSession(sid);
    if (!s) {
        return;
    }
    _iml_delete(s);

    XIMAuxDrawCallbackStruct *aux = (XIMAuxDrawCallbackStruct *) _iml_new(s, sizeof(XIMAuxDrawCallbackStruct));
    memset(aux, 0, sizeof(XIMAuxDrawCallbackStruct));
    aux->engine_class_index = engine_class_index;
    aux->engine_name = (char *) _iml_new(s, strlen(engine_name) + 1);
    strcpy(aux->engine_name, engine_name);
    aux->count_integer_values = count_integer_values;
    aux->count_string_values = count_string_values;
    
    if (count_integer_values) {
        aux->integer_values = (int *) _iml_new(s, sizeof(int) * count_integer_values);
        for (i = 0; i < count_integer_values; i++) {
            aux->integer_values[i] = integer_values[i];
        }
    }
    if (count_string_values) {
        XIMText *lt;
        aux->string_values = (XIMText *) _iml_new(s, sizeof(XIMText) * count_string_values);
        for (i = 0; i < count_string_values; i++) {
            lt = &aux->string_values[i];
            lt->encoding_is_wchar = False;
            lt->length = strlen(string_values[i]);
            lt->string.multi_byte = (char *) _iml_new(s, lt->length + 1);
            memset(lt->string.multi_byte, 0, lt->length + 1);
            strcpy(lt->string.multi_byte, string_values[i]);
            lt->feedback = (XIMFeedback *) _iml_new(s, sizeof(XIMFeedback) * lt->length);
            memset(lt->feedback, 0, sizeof(XIMFeedback) * lt->length);
        }
    }
    // some interface modules don't use if_SetAuxValues, so check
    // before calling it.
    if (if_methods->if_SetAuxValues) if_methods->if_SetAuxValues(s, aux);
}

void
LEHandler::SetSCValue(
    VMSignalData * reply,
    int sid,
    int argid,
    void *value
)
{
    old_iml_session_t *s = findSession(sid);
    if (s) {
        _iml_delete(s);
        switch (argid) {
            case _SC_HENKAN_MODE_ON:
                if_methods->if_SetSCValue(s, SC_Henkan_Mode, (void *) 1);
                break;
            case _SC_HENKAN_MODE_OFF:
                if_methods->if_SetSCValue(s, SC_Henkan_Mode, (void *) 0);
                break;
            }
    } else {
        switch (argid) {
            case _SC_LOOKUP_NROWS:
                nrows = (int) value;
                break;
            case _SC_LOOKUP_LABELTYPE:
                label_type = IM_LUC_LABEL_ALPHABETIC;
                if ((int) value == RmUpper) {
                    label_type = IM_LUC_LABEL_ALPHA_UPPER;
                } else if ((int) value == RmNumeric) {
                    label_type = IM_LUC_LABEL_NUMERIC;
                }
                break;
            case _SC_LOOKUP_NCOLS:
                ncols = (int) value;
                break;
            }
    }
}

LE_Info *
LEHandler::findLE(
char * if_name
)
{
    LE_Info *le = les ;
    LE_Info *ple = les ;

    for(;le;ple=le,le=le->next){
	if(!strcmp(le->If->if_name, if_name)) {
	    return le;
	}
    }
    return NULL;
}

old_iml_session_t *
LEHandler::findSession(
    int session_id
)
{
    old_iml_session_t *p;
    IC_Info * ic;

    p = (old_iml_session_t *) sessions;
    while (p) {
	ic = (IC_Info *) p->ic;
        if ((!strcmp(p->If->if_name, ic->ifname)) && (ic->icid == session_id)) {
            break;
        } else {
            p = p->next;
        }
    }
    if(p) {
	current_le = (LE_Info *)findLE(ic->ifname);
	if_methods = (old_if_methods_t *) current_le->if_methods;
	If = (old_iml_if_t *) current_le->If;
	return p;
    }
    return NULL;
}
