/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef	LEHANDLER_HH
#define	LEHANDLER_HH

#include "Old_Interface.h"
#include "HotKey.hh"

typedef struct _LE_Info {
	void *so_handler;
	old_iml_if_t *If;
	old_if_methods_t *if_methods;
	_LE_Info *next;
}LE_Info;

typedef struct _IC_Info {
	int icid;
	char *username;
	char ifname[20];
}IC_Info;

class LEHandler {
  public:
    LEHandler(char *locale, char *ifname);
    ~LEHandler();

    LE_Info * LoadLE(char *locale, char *ifname);
    Bool SwitchLE(IC_Info *, XKeyEvent *);
    old_iml_session_t * CreateSCLocal(IC_Info *);

    Bool OpenIF();
    void CloseIF();

    void OpenDesktop();
    void CloseDesktop();

    void CreateSC(VMSignalData *, char *);
    void DestroySC(VMSignalData *, int);
    void PostDestroySC(VMSignalData *, int);
    void ResetSC(VMSignalData *, int);

    void SetSCFocus(VMSignalData *, int);
    void UnsetSCFocus(VMSignalData *, int);

    void SetSCValue(VMSignalData *, int, int, void *);
    void SendEvent(VMSignalData *, int, int, int, int);
    void FilterEvent(VMSignalData *, int, XEvent *);

    void SetAuxValues(VMSignalData *, int,
        char *engine_name,
        int engine_class_index,
        int count_integer_values,
        int *integer_values,
        int count_string_values,
        char **string_values);

    Bool is_active() { return (If != 0);}

  private:
    int nrows;
    int ncols;
    int label_type;
    
    char *locale;
    char *prime_ifname;
    old_if_methods_t *if_methods;
    old_iml_if_t *If;
    old_iml_session_t *sessions;

/*
    char *le_name;
    void *so_handler;
*/

    LE_Info * les;
    LE_Info * current_le;
    
    old_iml_session_t *findSession(int);
    LE_Info *findLE(char *);
};

#endif
