/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef OLD_INTERFACE_H
#define OLD_INTERFACE_H

#if XlibSpecificationRelease != 5
#ifdef notdef		/* Moved to XlibR5.h */
typedef enum {
    XIMVisiblePosMid = 1,/* Put visible_pos to the middle of the display. */
    XIMVisiblePosEnd = 2,/* Display the string including & before visible_pos*/
    XIMVisiblePosStart = 3,/* Display the string starting at visible_pos */
 } XIMTextVisiblePosType;
 
typedef struct _XIMText {
    unsigned short length;
    XIMFeedback *feedback;
    Bool encoding_is_wchar; 
    union {
	char *multi_byte;
	wchar_t *wide_char;
    } string; 
    XIMTextVisiblePosType	visible_type;  
    int 			visible_pos;
} XIMText;

#endif
#endif /* XlibSpecificationRelease */

/*
 * Sun's Aux Callback extension decalarations for future.
 */
#ifdef	NEW_JLE

/*
 *	Flag to specify the type of a field in Aux region.
 */
typedef	enum {
	AUX_FIELD_UNUSED  = 0,
	AUX_FIELD_INTERM  = 1,
	AUX_FIELD_DISPLAY = 2,
	AUX_FIELD_SELECT  = 3,
}  AuxFieldType;

/*
 *	Next structure is not attached to an actual callback.
 *	But NEW_JLE requires Display-Only field in Aux , to keep
 *	consistency we call it "DisplayCallback " for now.
 */
typedef struct _XIMDisplayStartCallbackStruct {
	int	flags;
	int	width;
	int	height;
	int	spos_x;
	int	spos_y;
} XIMDisplayStartCallbackStruct;

/* 
 *	Aux start must be called with enough information that determines
 *	the layout of aux-window and its fine-structure.
 *	Aux is actually a combination of pre-edit, lookup and display callbacks.
 */	
typedef struct _AuxStartFieid {
	AuxFieldType	ftyp;
	union {
		XIMValue			preedit; /* may not be used */
		XIMDisplayStartCallbackStruct	display;
		XIMLookupStartCallbackStruct	lookupchoice;
 	} field;
} AuxStartField;

typedef struct _XIMAuxStartCallbackStruct {
        XKeyEvent          *event;
	int		focus;	/* default focus field */
	int		count;  /* number of fields    */
	AuxStartFieid	*field;
}  XIMAuxStartCallbackStruct;

/*
 *	AuxDraw callback is invoked once per field.
 */
typedef struct _AuxDrawField {
	int             fnum;
	union {
		XIMText				preedit;  /* only for label */
		XIMText				display;
		XIMLookupDrawCallbackStruct	lookupchoice;
	}
} AuxDrawField;

typedef struct _XIMAuxDrawCallbackStruct {
	AuxDrawField	field;
} XIMAuxDrawCallbackStruct;

typedef struct _AuxProcessField {
	int		fnum;  /*?? This must be set in CB side ??*/
	union {
		XIMPreEditDrawStruct		preedit;
		XIMText				display;
			/* This field(display) may not have sense,
			   but we should keep for the sake of consistency */
		XIMLookupProcessCallbackStruct	lookupchoice;
	}
} AuxProcessField;
			
typedef	struct _XIMAuxProcessCallbackStruct {
	XKeyEvent          *event;
/*  not defined yet
	AuxOpCode	opcode; 
*/
	AuxProcessField	field;
}	

#else	/* NEW_JLE */
 
typedef struct _XIMAuxStartCallbackStruct {
    char *engine_name;
    int engine_class_index;
}  XIMAuxStartCallbackStruct;

typedef struct _XIMAuxDrawtCallbackStruct {
    char *engine_name;
    int engine_class_index;
    int	 count_integer_values;
    int	 *integer_values;
    int	 count_string_values;
    XIMText *string_values;
}  XIMAuxDrawCallbackStruct;

typedef XIMAuxStartCallbackStruct XIMAuxDoneCallbackStruct;

typedef XIMAuxDrawCallbackStruct XIMAuxSetValuesCallbackStruct;

#endif	/* NEW_JLE */
 

/*
 * LookupChoice Region
 */


#ifdef OLD_LOOKUP
typedef struct  {
    XIMText        *value;
}  ChoiceObject;

typedef struct {
    ChoiceObject    choices;
    int             max_len;
    int             n_choices;
    int             choice_per_window;
}  XIMChoices;
#endif /* OLD_LOOKUP */

typedef enum {
    XIMCB_Success,
    XIMCB_FatalError
}  XIMCBResult;
 
#define	IM_LUC_LABEL_NONE		0
#define IM_LUC_LABEL_NUMERIC		1
#define	IM_LUC_LABEL_ALPHABETIC		2
#define	IM_LUC_LABEL_ALPHA_UPPER	3

typedef struct _XIMLookupStartCallbackStruct {
    XKeyEvent      *event ;
    WhoIsMaster     whoIsMaster ; /* For callback to tell whether
				   * is going to be a master
				   */
    LayoutInfo      *XIMPreference ;
    LayoutInfo      *CBPreference ;
} XIMLookupStartCallbackStruct;

typedef struct _XIMLookupStartCallbackStruct2 {
    XKeyEvent      *event ;
    WhoIsMaster     whoIsMaster ; /* For callback to tell whether
				   * is going to be a master
				   */
    LayoutInfo      *layout;
} XIMLookupStartCallbackStruct2;

typedef struct _XIMChoiceObject{
    XIMText         *label;
    XIMText         *value;
} XIMChoiceObject;

typedef struct _XIMLookupDrawCallbackStruct{
    XIMChoiceObject *choices;       /* the lookup choices */
    int              n_choices;      /* Total number of lookup choices */
    int              max_len;        /* Max number of characters per
				      * choice item
				      */
    int              index_of_first_candidate ;
    int              index_of_last_candidate ;
    XIMText	    *title;
} XIMLookupDrawCallbackStruct;

/* new XIMLookupDrawCallback for IIIMP */
typedef struct _XIMLookupDrawCallbackStruct2 {
    XIMChoiceObject *choices;       /* the lookup choices */
    int              n_choices;      /* Total number of lookup choices */
    int              max_len;        /* Max number of characters per
				      * choice item
				      */
    int              index_of_first_candidate ;
    int              index_of_last_candidate ;
    int              index_of_current_candidate ;
    XIMText	    *title;
} XIMLookupDrawCallbackStruct2;

typedef struct _XIMLookupProcessCallbackStruct {
    XKeyEvent       *event;
    int              index_of_choice_selected;/* Set by callback for the
					       * selected choice.
					       * XIM_UNKNOW_KEYSYM and
					       * XIM_UNDETERMINED are
					       * also possible value.
					       */
} XIMLookupProcessCallbackStruct;
/*
 * Values for XIMLookupProcessCallbackStruct.index_of_choice_selected
 */
#define		XIM_UNKNOWN_KEYSYM	0x77777777
#define		XIM_UNDETERMINED	0x77777776
#define		XIM_UNKNOWN_CONTROL	0x77777775

/*
 * Sun's extensions to IMValues
 */
#define XIMLookupCallbacks	0x4000000L
#define XIMAuxCallbacks		0x8000000L     

/*
 * Ximp extentions to XIC attributes
 */
/*
 * Ximp extentions to XIC attributes
 */
#define XNExtXimp_Backfront             "XNExtXimp_Backfront"
#define XNExtXimp_Statuswindow          "XNExtXimp_Statuswindow"
#define XNExtXimp_Conversion	        "XNExtXimp_Conversion"
#define XNExtXimp_Error		        "XNExtXimp_Error"
#define XNExtXimp_LookupStartCallback   "XNExtXimp_LookupStartCallback"
#define XNExtXimp_LookupDrawCallback    "XNExtXimp_LookupDrawCallback"
#define XNExtXimp_LookupDoneCallback    "XNExtXimp_LookupDoneCallback"
#define XNExtXimp_LookupProcessCallback "XNExtXimp_LookupProcessCallback"
#define XNExtXimp_LookupAttributes      "XNExtXimp_LookupAttributes"
#define XNExtXimp_AuxStartCallback      "XNExtXimp_AuxStartCallback"
#define XNExtXimp_AuxDrawCallback       "XNExtXimp_AuxDrawCallback"
#define XNExtXimp_AuxProcessCallback    "XNExtXimp_AuxProcessCallback"
#define XNExtXimp_AuxDoneCallback       "XNExtXimp_AuxDoneCallback"
#define XNExtXimp_AuxAttributes         "XNExtXimp_AuxAttributes"


/*
 * Ximp properties for extented XIC attribute
 */
#define XIMP_EXT_XIMP_CONVERSION           "_XIMP_EXT_XIMP_CONVERSION"
#define XIMP_EXT_XIMP_BACKFRONT            "_XIMP_EXT_XIMP_BACKFRONT"
#define XIMP_EXT_XIMP_STATUSWINDOW         "_XIMP_EXT_XIMP_STATUSWINDOW"
#define XIMP_EXT_XIMP_CONVERSION	   "_XIMP_EXT_XIMP_CONVERSION"
#define XIMP_EXT_XIMP_ERROR		   "_XIMP_EXT_XIMP_ERROR"
#define XIMP_EXT_XIMP_AUXSTARTCALLBACK     "_XIMP_EXT_XIMP_AUXSTARTCALLBACK"
#define XIMP_EXT_XIMP_AUXDRAWCALLBACK      "_XIMP_EXT_XIMP_AUXDRAWCALLBACK"
#define XIMP_EXT_XIMP_AUXPROCESSCALLBACK   "_XIMP_EXT_XIMP_AUXPROCESSCALLBACK"
#define XIMP_EXT_XIMP_AUXDONECALLBACK      "_XIMP_EXT_XIMP_AUXDONECALLBACK"
#define XIMP_EXT_XIMP_LOOKUPSTARTCALLBACK  "_XIMP_EXT_XIMP_LOOKUPSTARTCALLBACK"
#define XIMP_EXT_XIMP_LOOKUPDRAWCALLBACK   "_XIMP_EXT_XIMP_LOOKUPDRAWCALLBACK"
#define XIMP_EXT_XIMP_LOOKUPDONECALLBACK   "_XIMP_EXT_XIMP_LOOKUPDONECALLBACK"
#define XIMP_EXT_XIMP_LOOKUPPROCESSCALLBACK "_XIMP_EXT_XIMP_LOOKUPPROCESSCALLBACK"

/*
 * Possible values of XSetICValues(XNExtXimp_Conversion, XXX );
 */
#define	XIMEnable	1
#define	XIMDisable	0

/*
 * Possible values of XSetICValues(XNExtXimp_Backfront, XXX );
 */
#define	IMServBackend	1
#define	IMServFrontend  0

#if !defined(NO_COLOR_FEEDBACK) && !defined(NO_CARET_NEGO)
#include "XSunExt2.h"
#endif  /* !defined(NO_COLOR_FEEDBACK) && !defined(NO_CARET_NEGO) */

#endif /* XSunExtentions_DEFINED */

/*
 * Temporary solution
 */
#define XIMValue XPointer
#define XNConversion XNExtXimp_Conversion
#define XSetICValue XSetICValues
#define XGetICValue XGetICValues
#define XIMPlain 0L
#define XNLookupStartCallback   "XNExtXimp_LookupStartCallback"
#define XNLookupDrawCallback    "XNExtXimp_LookupDrawCallback"
#define XNLookupDoneCallback    "XNExtXimp_LookupDoneCallback"
#define XNLookupProcessCallback "XNExtXimp_LookupProcessCallback"
#define XNAuxStartCallback      "XNExtXimp_AuxStartCallback"
#define XNAuxDrawCallback       "XNExtXimp_AuxDrawCallback"
#define XNAuxProcessCallback    "XNExtXimp_AuxProcessCallback"
#define XNAuxDoneCallback       "XNExtXimp_AuxDoneCallback"
#define BitmapType	XIMBitmapType
#ifndef xim_im_DEFINED
#define xim_im_DEFINED
#endif  /* ~xim_im_DEFINED */
#ifndef immgr_cb_DEFINED
#define immgr_cb_DEFINED
#endif /* immgr_cb_DEFINED */
#ifndef xim_ic_DEFINED
#define xim_ic_DEFINED
#endif  /* ~xim_ic_DEFINED */

typedef struct _old_iml_session *old_iml_session;
typedef struct _old_iml_if_t *old_iml_if;
typedef struct _old_iml_aux_t *old_iml_aux;
typedef struct _IMBindTableRec *IMBindTable;
typedef int IMTMid;

typedef struct _old_iml_methods {
    /*
     * drawing methods
     */
    iml_inst *	   (*iml_make_preedit_start_inst)(iml_session);
    iml_inst *	   (*iml_make_preedit_draw_inst)(
#ifndef NO_COLOR_FEEDBACK
						 iml_session,
						 wchar_t*,
						 XIMFeedback*,
						 XIMTextColorFeedback*,
						 XIMTextColorFeedback*
#else
						 iml_session,
						 wchar_t*,
						 XIMFeedback*
#endif
						 );
    iml_inst *	   (*iml_make_preedit_erase_inst)(iml_session);
    iml_inst *	   (*iml_make_preedit_caret_inst)(iml_session);
    iml_inst *	   (*iml_make_preedit_done_inst)(iml_session);
    iml_inst *	   (*iml_make_status_start_inst)(iml_session);
    iml_inst *	   (*iml_make_status_draw_inst)(
#ifndef NO_COLOR_FEEDBACK
						iml_session
						wchar_t*,
						XIMFeedback*,
						XIMTextColorFeedback*,
						XIMTextColorFeedback*
#else
						iml_session,
						wchar_t*,
						XIMFeedback*
#endif
						);
    iml_inst *	   (*iml_make_status_done_inst)(iml_session);
    iml_inst *	   (*iml_make_lookup_start_inst)(iml_session);
    iml_inst *	   (*iml_make_lookup_draw_inst)(iml_session,
						unsigned char**,
						int);
    iml_inst *	   (*iml_make_lookup_process_inst)(iml_session,
						   Bool, int);
    iml_inst *	   (*iml_make_lookup_done_inst)(iml_session);
    /*
     * 
     */
    iml_inst *	   (*iml_make_status_notify_inst)(iml_session);
    iml_inst *	   (*iml_make_nop_inst)(iml_session);
    iml_inst *	   (*iml_make_commit_inst)(iml_session,
					   int, unsigned char*);
    iml_inst *     (*iml_make_keypress_inst)(iml_session, char*);
    iml_inst *     (*iml_make_reset_return_inst)(iml_session,
						 int, unsigned char *);
    iml_inst *     (*iml_execute)(iml_session, iml_inst**);
    /*
     * convenient methods
     */
    int		   (*iml_lookupString)(XKeyEvent*, char*, int, KeySym*);
    iml_inst  	  *(*iml_link_inst_tail)(iml_inst**, iml_inst*);
    void	   (*iml_destruct_session)(iml_session,
					   int(*)(iml_session));
    void          *(*iml_construct_session)(iml_if, void*, int, int,
					    int (*)(int,iml_session,Bool));
    		/* actual return value is iml_session */
    /*
     * Translation Manager
     */
    Bool           (*iml_tm_init_translation_manager)(void);
    Bool           (*iml_tm_init_binding_table)(iml_session,
						IMBindTable*);
    void           (*iml_tm_destroy_binding_table)(iml_session,
						   IMBindTable,
						   Bool);
    Bool           (*iml_tm_parse_translation)(iml_session,
					       IMBindTable,
					       char*,
					       IMTMid*);
    Bool           (*iml_tm_parse_id_translation)(iml_session,
						  IMBindTable,
						  IMTMid, IMTMid*);
    void           (*iml_tm_destroy_translation)(iml_session,
						 IMBindTable,
						 IMTMid);
    Bool           (*iml_tm_add_action_table)();
    void           (*iml_tm_destroy_action_table)();
    int            (*iml_tm_lookup_binding)();
    void           (*iml_tm_destroy_binding_result)();
    void           (*iml_tm_reset_binding_state)();

    /* AUX */
    iml_inst *	   (*iml_make_aux_start_inst)(iml_session, iml_aux);
    iml_inst *	   (*iml_make_aux_draw_inst)(iml_session, iml_aux);
    iml_inst *	   (*iml_make_aux_done_inst)(iml_session, iml_aux);
} old_iml_methods_t ;
/*
 * NOTE:
 * iml_methods $B$O!"(Bs->If->m $B$GD>@\;2>H$G$-$k$N$G(B override $B$O!"(B
 * register $B4X?t$r;H$o$:!"D>@\$*$3$J$&!#(B
 */

typedef struct _old_if_methods {
    Bool                (*if_OpenIF)(old_iml_if);
    Bool                (*if_CloseIF)(old_iml_if);
    Bool                (*if_GetIFValue)(old_iml_if, char*, caddr_t);
    Bool                (*if_SetIFValue)(old_iml_if, char*, caddr_t);
    void               *(*if_CreateSC)(old_iml_if, void*, char*);
    Bool                (*if_DestroySC)(old_iml_session);
    Bool                (*if_SetSCValue)(old_iml_session, char*, void *);
    Bool                (*if_GetSCValue)(old_iml_session, char*, caddr_t);
    char               *(*if_ResetSC)(old_iml_session);
    void                (*if_SetSCFocus)(old_iml_session);
    void                (*if_UnsetSCFocus)(old_iml_session);
    void                (*if_SendEvent)(old_iml_session, XKeyEvent*);
    Bool                (*if_FilterEvent)(XEvent*);
    void                (*if_SetAuxValues)(old_iml_session,
					   XIMAuxDrawCallbackStruct*);
} old_if_methods_t ;
/*
 * NOTE:
 * if_*Value() $B4X?t$O!"$=$NL>$NDL$j!"0l2s$K0l$D$N(B value $B$7$+(B
 * get/set $B$G$-$J$$(B
 */

typedef struct _old_extended_if {
    if_methods_t   *pre;
    if_methods_t   *post;
    char 	    *if_name;
} old_if_ext;

/*
 * Per interface data structure
 */
typedef struct _old_iml_if_t {
    int               ref_count ; 
    struct _old_iml_if_t *next ;
    void             *im ; /* should be casted to im_t */
    char             *if_name ;
    char             *if_version ;
    char             *locale ;
    old_if_methods_t     *ifm ;
    old_iml_methods_t    *m ;
    void             *if_spec ; /* pointer to the interface specific data */
    old_if_ext	     *ext;
} old_iml_if_t ;

/*
#define IS_PRE_FUNC_VALID(If, method) (If->ext && If->ext->pre && If->ext->pre->method)
#define IS_POST_FUNC_VALID(If, method) (If->ext && If->ext->post && If->ext->post->method)
*/

/*
 * if_GetIFValue()/if_SetIFValue() attributes
 */
#define IF_VERSION		"if_version"
#define IF_LE_NAME		"if_le_name"
#define IF_STATUS_CALLBACK	"if_status_callback"
#define IF_LE_NENGINES          "if_le_nengines"
#define IF_LE_LIST              "if_le_list"
#define IF_LE_CURRENT           "if_le_current"
#define IF_QUERY_VAR_LIST       "if_query_var_list"
#define IF_IMS_RDB              "if_ims_rdb"
#define IF_IMS_APP_DEFAULTS     "if_ims_app_defaults"
#define IF_IMS_COMMAND_NAME     "if_ims_command_name"
#define IF_IMS_COMMAND_CLASS    "if_ims_command_class"
/*
 * if_GetSCValue()/if_SetSCValue() attributes
 */
#define SC_STATUS		"sc_status"
#define SC_Henkan_Mode		"sc_henkan_mode"
#define SC_MODIFIER_MASK	"modifier_mask"
#define SC_QUERY_VAR_LIST       "sc_query_var_list"
#define SC_IC_SCREEN_NUMBER     "sc_ic_screen_number"

#define	SC_Lookup_info		"sc_lookup_info"
#define SC_lookup_imscontrol	"sc_lookup_imscontrol"
#define	SC_lookup_root		"sc_lookup_root"
#define SC_lookup_whoownslabel	"sc_lookup_whoownslabel"
#define	SC_lookup_labeltype	"sc_lookup_labeltype"
#define	SC_lookup_nchoices	"sc_lookup_nchoices"
#define	SC_lookup_rootwidth	"sc_lookup_rootwidth"
#define	SC_lookup_lines		"sc_lookup_nlines"
#define	SC_lookup_ewidth	"sc_lookup_ewidth"
#define	SC_lookup_cwidth	"sc_lookup_cwidth"
#define	SC_lookup_ncols		"sc_lookup_ncols"
#define	SC_lookup_nrows		"sc_lookup_nrows"
#define SC_lookup_direction	"sc_lookup_direction"
#define	SC_nego_flush		"sc_nego_flush"
#define SC_nego_data		"sc_nego_data"
#define SC_user_name		"userName"
#define SC_protocol_name	"sc_protocol_name"

#ifndef xim_iml_session_DEFIND
#define xim_iml_session_DEFIND
#ifndef xim_iml_inheritance_DEFIND
typedef struct _old_iml_session {
#endif /* xim_iml_inheritance_DEFIND */

    struct _old_iml_session *next ;
    unsigned char *classname ; 
    unsigned char *enginename ;
    unsigned char *locale ;    /* locale for this IC */
    int language_engine ;/* ENGINE ID: to support multiple language engine */
    int session_id ;	/* to keep self identification. */
    int public_status ; /* This status can be set/got by IML_SET/GET_STATUS */
    int initial_public_status ;/* will be copied from public status per call */
    int private_status ;
    iml_inst        *remainder ; /* awaiting event put back returning */
    iml_inst        *remainder2 ;/* awaiting recall by RESULTS_REQUIRED */
    iml_inst       **rrv ;
    iml_inst_slot_t *short_term_slot; /* for new/delete */
    iml_inst_slot_t *long_term_slot;  /* for new2/delete2 */
    int active_regions ; /* used only for double check in post_proc */
    int current_active_region ; /* used during building iml_inst */

    XKeyEvent *event;
    KeySym     keysym;
    unsigned char      *XLookupBuf ;
    int        XLookupBuflen ;
    Status     status;
    void      *ic ;
    old_iml_if_t  *If ;
/*
 * Region Specific data
 *
 * Preedit region
 */
    int PreEditTextBufferSize ;
    int PreEditAttrBufferSize ;
    XIMPreeditDrawCallbackStruct PreEditTextInfo ; /* allocate once */
    int PreEditBufferSizeInCallback ;
/*
 * Status region
 */

    status_cache_t status_cache ;

/*
 * Lookup Choice region
 */

    WhoIsMaster 	whoIsMaster ;
    LayoutInfo		XIMPreference ;
    LayoutInfo		CBPreference ;
    XIMLookupDrawCallbackStruct *ld ; /* As a terminal */

/*
 * Caret negotiation. 
 */
#ifndef NO_CARET_NEGO
#define IM_CARET_NOT_NEGOTIATED			0x00
#define IM_CARET_SHAPE_NEGOTIATED		0x01
#define IM_CARET_COLOR_NEGOTIATED		0x02
#define IM_CARET_SHAPE_AND_COLOR_NEGOTIATED	0x03

#define IM_CARET_I_BEAM_STYLE			0
#define IM_CARET_TRIANGLE_STYLE			1
#define IM_CARET_SOLID_BLOCK_STYLE		2
#define IM_CARET_CLOSED_FIGURE_OF_ENGINE	3
#define IM_CARET_BITMAP_OF_ENGINE		4
#define IM_CARET_EMPTY				5

    unsigned char	caret_negotiated;
    unsigned char	caret_style;
    XPoint		*caret_figure_points;
    int			caret_figure_points_num;
    int			caret_figure_hotspot_index;
    char		*caret_bitmap_data;
    int			caret_bitmap_x_hot, caret_bitmap_y_hot;
    unsigned int	caret_bitmap_width, caret_bitmap_height;
    XIMTextColorBits	caret_color;
#endif /* NO_CARET_NEGO */

#ifndef xim_iml_inheritance_DEFIND
} old_iml_session_t;

/* for XCI support */
#include <X11/Xresource.h>

typedef struct _ImChainRec *ImChain;

typedef struct _ImChainRec {
    ImChain     next;
    ImChain     prev;
    void       *htt;            /* should be used with cast (ImChain) */
} ImChainRec;

typedef struct _HttRec {
  ImChain im;
  XrmDatabase   app_defaults;
  XrmDatabase   special;
  XrmDatabase   cmdlines;
  XrmDatabase   rdb;
  XrmDatabase   dot_rc;
  void          *ic_list;
  void          *free_ic_list;
  char          *command_name;
  char          *class_name;
  char          *dot_httrc;
  void    *core;
  unsigned long biff;
} HttRec;

typedef struct _XSFrrvCellRec *XSFrrvCell;

typedef struct _XSFrrvCellRec {
    XSFrrvCell     nlink;
    iml_inst       *called_rv;
    iml_inst       *rv;
} XSFrrvCellRec;

typedef struct _IMLGlueRec {
    /* Do not move the first 2 members */
    unsigned long window;                /* for xci */
    int         screen;          /* for xci */
    XSFrrvCell     cell_link;
    int            callback_flg;
    void           *session;   /* Session object */
} IMLGlueRec, *IMLGlue;

#define IML_SESSION_RECYCLE (-2)

/*
 * for the private_status
 */
#define CB_PARTIAL_UPDATE       0x00000002
#define LE_PARTIAL_UPDATE       0x00000004
#define IMPLICIT_CONVERSION_ON  0x00000008
#define BEING_RESET             0x00000010
#define RESET_DATA_EXIST        0x00000020
#define BEING_FOCUSED           0x00000040

#endif /* xim_iml_inheritance_DEFIND */
#endif /* xim_iml_session_DEFIND */
