/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef UTILITY_HH
#define UTILITY_HH

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <wchar.h>
#include <X11/Xlib.h>
#include "SunIM.h"

#include "IMList.hh"

#include "csconv.hh"

#include "KeyConverter.hh"

class XSunIMConv {
    public:
    CodeSetConverter * conv;
    char *locale;
    char *from;
    char *to;
    XSunIMConv(
        CodeSetConverter * p_conv,
        char *p_locale, char *p_from, char *p_to) {
        conv = p_conv;
        locale = strdup(p_locale);
        from = strdup(p_from);
        to = strdup(p_to);
    }
    ~XSunIMConv() {
        free(locale);
        free(from);
        free(to);
    }
};

typedef IMList<XSunIMConv> ConvList;

class Utility {
    public:
    static XSunIMConv *getConv(
        char *locale,
        char *from,
        char *to
        );
    static IMText *CreateIMTextFromWCS(
        iml_session_t * s,
        wchar_t * cws,
        XIMFeedback * feedback,
        int length,
        char *locale);
    static IMText *CreateIMTextFromMBS(
        iml_session_t * s,
        unsigned char *mbs,
        int length,
        char *locale
        );
    
    static IMText *CreateIMTextFromBuf(
        iml_session_t * s,
        char *buf,
        XIMFeedback * feedback,
        int length,
        CodeSetConverter * conv
        );
    
    static IMText *CreateIMText(
        iml_session_t * s,
        IMEncoding encoding,
        char *buf,
        XIMFeedback * feedback,
        int length,
        int char_length
        );
    
    static XEvent *getXKeyEvent(
        int keycode,
        int keychar,
        int state
        );
    
    static KeySym getX11Keysym(long keycode);
    
    static void getIMKey(
        IMKeyEventStruct & imkey,
        int keycode,
        int state
        );
    
    static char *CreateMBSFromUTF16(
	iml_session_t *,
        char *,
        UTFCHAR *,
        int);
    
#ifdef	notdef
    /* workaround */
    static char *convfromutf(
        UTFCHAR *,
        int
        );
    static IMText *convtoutf(
        char *,
        XIMFeedback *,
        int);
#endif
    
    private:
    static KeyConverter *keyconv;
    static ConvList convlist;
};

#endif
