/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "XSunIMAdapter.hh"
#include "Utility.hh"
#include "SystemMessage.h"

void
XSunIMAdapter::decode_iml(
    iml_session_t * s_
)
{
    int type;
    int session_id;
    iml_session_t *s = NULL;
    iml_inst *lp = NULL, *rv = NULL;
    VMSessionPrivate *sp = (VMSessionPrivate *) s_->specific_data;
    int session_id_at_createsc = sp->session_id;
    
    stub->getInt(&type);
    
    if (type == 0) {
        return;
    }
    while (type != XSUNIM_END_IML) {
        stub->getInt(&session_id);
#ifdef	DEBUG
        printf(" XSunIMAdapter::decode_iml=%d type=%d\n", session_id, type);
#endif
        s = findSession(s_, session_id);
	if(!s){
	    if(session_id_at_createsc){
        	s = findSession(s_, session_id_at_createsc);
	    }
	}
	if(!s){
		return;
	}

        sp = (VMSessionPrivate *) s->specific_data;
        switch (type) {
            
            case XSUNIM_AUX_START: lp = make_aux_start_inst(s); break;
            case XSUNIM_AUX_DRAW: lp = make_aux_draw_inst(s); break;
            case XSUNIM_AUX_DONE: lp = make_aux_done_inst(s); break;
            case XSUNIM_COMMIT: lp = make_commit_inst(s); break;
            case XSUNIM_KEYPRESS: lp = make_keypress_inst(s); break;
            case XSUNIM_PREEDIT_START: lp = make_preedit_start_inst(s); break;
            case XSUNIM_PREEDIT_DRAW: lp = make_preedit_draw_inst(s); break;
            case XSUNIM_PREEDIT_DONE: lp = make_preedit_done_inst(s); break;
            case XSUNIM_STATUS_START: lp = make_status_start_inst(s); break;
            case XSUNIM_STATUS_DRAW: lp = make_status_draw_inst(s); break;
            case XSUNIM_STATUS_DONE: lp = make_status_done_inst(s); break;
            case XSUNIM_LOOKUP_START: lp = make_lookup_start_inst(s); break;
            case XSUNIM_LOOKUP_DRAW: lp = make_lookup_draw_inst(s); break;
            case XSUNIM_LOOKUP_DONE: lp = make_lookup_done_inst(s); break;
            case XSUNIM_STATUS_NOTIFY: lp = make_status_notify_inst(s); break;
                
            case XSUNIM_EXECUTE:
                if (rv != NULL) {
#ifdef	DEBUG
                    printf(" XSunIMAdapter::iml_execute() sid=%d\n", sp->session_id);
#endif
                    s->If->m->iml_execute(s, &rv);
                    rv = NULL;
                } else if (lp != NULL) {
#ifdef	DEBUG
                    printf(" XSunIMAdapter::iml_execute() sid=%d\n", sp->session_id);
#endif
                    s->If->m->iml_execute(s, &lp);
                    lp = NULL;
                }
                break;
                
            case XSUNIM_LINK_INST_TAIL:
                if (lp) {
#ifdef	DEBUG
                    printf(" XSunIMAdapter::iml_link_inst_tail() sid=%d\n", sp->session_id);
#endif
                    s->If->m->iml_link_inst_tail(&rv, lp);
                    lp = NULL;
                }
                break;
                
            default:
                system_message(MSG_ERROR, "Unknown type");
/*                printf("Unknown type"); */
                break;
            }
        stub->getInt(&type);
    }
}

#ifdef	notdef
#define getmbs()        \
{       \
stub->getInt(&mbs_len);	\
mbs_str = (char *) s->If->m->iml_new(s, (mbs_len + 1) * sizeof(char));  \
memset(mbs_str, 0, mbs_len + 1);       \
stub->getString(mbs_str, mbs_len);       \
}
#endif

iml_inst *
XSunIMAdapter::make_keypress_inst(
    iml_session_t * s
)
{
    int keycode = 0;
    int keystate = 0;
    IMKeyEventStruct imkey;
    
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_keypress_inst() sid=%d\n", sp->session_id);
#endif
    
    stub->getInt(&keycode);
    stub->getInt(&keystate);
    Utility::getIMKey(imkey, keycode, keystate);
    return s->If->m->iml_make_keypress_inst(s, (IMKeyEventStruct *) & imkey);
}

iml_inst *
XSunIMAdapter::make_commit_inst(
    iml_session_t * s
)
{
#ifdef	notdef
    int wcs_len;
    wchar_t *wcs_str;
#else
    int mbs_len;
    char *mbs_str;
#endif
    IMText *text;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    
#ifdef	DEBUG
    printf(" XSunIMAdapter::make_commit_inst() sid=%d\n", sp->session_id);
#endif
    
#ifdef	notdef
    stub->getInt(&wcs_len);
    wcs_str = (wchar_t *) s->If->m->iml_new(s, sizeof(wchar_t) * (wcs_len + 1));
    memset(wcs_str, 0, sizeof(wchar_t) * (wcs_len + 1));
    stub->getAny((void *) wcs_str, wcs_len * sizeof(wchar_t));
#endif
    
    stub->getInt(&mbs_len);
    mbs_str = (char *) s->If->m->iml_new(s, sizeof(char) * (mbs_len + 1));
    memset(mbs_str, 0, sizeof(char) * (mbs_len + 1));
    stub->getString(mbs_str, mbs_len);
    
#ifdef	notdef
    text = (IMText *) Utility::CreateIMText(s, sp->encoding, mbs_str, 0, mbs_len, wcs_len);
#else
    text = (IMText *) Utility::CreateIMTextFromMBS(s, (unsigned char *) mbs_str, mbs_len, sp->locale);
#endif
    
    return s->If->m->iml_make_commit_inst(s, text);
}

iml_inst *
XSunIMAdapter::make_aux_start_inst(
    iml_session_t * s
)
{
    char *aux_name;
    int aux_name_len;
    int aux_index;

#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_aux_start_inst() sid=%d %s\n", sp->session_id, sp->locale);
#endif

    stub->getInt(&aux_index);
    stub->getInt(&aux_name_len);
    aux_name = (char *) s->If->m->iml_new(s, aux_name_len + 1);
    memset(aux_name, 0, aux_name_len + 1);
    stub->getString(aux_name, aux_name_len);
    
#ifdef	DEBUG
    printf("aux_name_len=%d\n", aux_name_len);
    printf("aux_name=[%s]\n", aux_name);
    printf("aux_index=[%d]\n", aux_index);
#endif
    
    IMAuxStartCallbackStruct *aux = (IMAuxStartCallbackStruct *) s->If->m->iml_new(s, sizeof(IMAuxStartCallbackStruct));
    /* Give a default engine name if the LE doesn't provide the name. */
    if(aux_name_len == 0) {
	aux->aux_name = (char *) s->If->m->iml_new(s, sizeof(char) * (strlen("aux_obj") + 1));
	strcpy(aux->aux_name, "aux_obj");
    } else {
	aux->aux_name = (char *) s->If->m->iml_new(s, sizeof(char) * (aux_name_len + 1));
	strcpy(aux->aux_name, aux_name);
    }
    aux->aux_index = aux_index;
    return s->If->m->iml_make_aux_start_inst(s, aux);
}

iml_inst *
XSunIMAdapter::make_aux_done_inst(
    iml_session_t * s
)
{
    char *aux_name;
    int aux_name_len;
    int aux_index;
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_aux_done_inst() sid=%d\n", sp->session_id);
#endif
    
    stub->getInt(&aux_index);
    stub->getInt(&aux_name_len);
    aux_name = (char *) s->If->m->iml_new(s, aux_name_len + 1);
    memset(aux_name, 0, aux_name_len + 1);
    stub->getString(aux_name, aux_name_len);
    
    IMAuxDoneCallbackStruct *aux = (IMAuxDoneCallbackStruct *) s->If->m->iml_new(s, sizeof(IMAuxDoneCallbackStruct));
    /* Give a default engine name if the LE doesn't provide the name. */
    if(aux_name_len == 0) {
	aux->aux_name = (char *) s->If->m->iml_new(s, sizeof(char) * (strlen("aux_obj") + 1));
	strcpy(aux->aux_name, "aux_obj");
    } else {
	aux->aux_name = (char *) s->If->m->iml_new(s, sizeof(char) * (aux_name_len + 1));
	strcpy(aux->aux_name, aux_name);
    }
    aux->aux_index = aux_index;
    return s->If->m->iml_make_aux_done_inst(s, aux);
}

iml_inst *
XSunIMAdapter::make_lookup_start_inst(
    iml_session_t * s
)
{
    int choice_per_window;
    int nrows;
    int ncolumns;
    int drawupdirection;

#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_lookup_start_inst() sid=%d\n", sp->session_id);
#endif
    
    stub->getInt(&choice_per_window);
    stub->getInt(&nrows);
    stub->getInt(&ncolumns);
    stub->getInt(&drawupdirection);
    
    IMLookupStartCallbackStruct *ls = (IMLookupStartCallbackStruct *)
    s->If->m->iml_new(s, sizeof(IMLookupStartCallbackStruct));
    
    memset(ls, 0, sizeof(IMLookupStartCallbackStruct));
    ls->whoIsMaster = IMIsMaster;
    ls->IMPreference = (LayoutInfo *) s->If->m->iml_new(s, sizeof(LayoutInfo));
    memset(ls->IMPreference, 0, sizeof(LayoutInfo));
    ls->IMPreference->choice_per_window = choice_per_window;
    ls->IMPreference->nrows = nrows;
    ls->IMPreference->ncolumns = ncolumns;
    ls->IMPreference->drawUpDirection = (DrawUpDirection) drawupdirection;
    ls->IMPreference->whoOwnsLabel = IMOwnsLabel;
    ls->CBPreference = NULL;
    
    return s->If->m->iml_make_lookup_start_inst(s, ls);
}

iml_inst *
XSunIMAdapter::make_lookup_done_inst(
    iml_session_t * s
)
{
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_lookup_done_inst() sid=%d\n", sp->session_id);
#endif
    return s->If->m->iml_make_lookup_done_inst(s);
}

iml_inst *
XSunIMAdapter::make_status_start_inst(
    iml_session_t * s
)
{
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_status_start_inst() sid=%d\n", sp->session_id);
#endif
    return s->If->m->iml_make_status_start_inst(s);
}

iml_inst *
XSunIMAdapter::make_status_done_inst(
    iml_session_t * s
)
{
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_status_done_inst() sid=%d\n", sp->session_id);
#endif
    return s->If->m->iml_make_status_done_inst(s);
}


iml_inst *
XSunIMAdapter::make_preedit_start_inst(
    iml_session_t * s
)
{
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_preedit_start_inst() sid=%d\n", sp->session_id);
#endif
    return s->If->m->iml_make_preedit_start_inst(s);
}

iml_inst *
XSunIMAdapter::make_preedit_done_inst(
    iml_session_t * s
)
{
#ifdef	DEBUG
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    printf(" XSunIMAdapter::make_preedit_done_inst() sid=%d\n", sp->session_id);
#endif
    return s->If->m->iml_make_preedit_done_inst(s);
}

iml_inst *
XSunIMAdapter::make_status_notify_inst(
    iml_session_t * s
)
{
    int status;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
#ifdef	DEBUG
    printf(" XSunIMAdapter::make_status_notify_inst() sid=%d\n", sp->session_id);
#endif
    stub->getInt(&status);
    if (sp->trigger_on && (status & IMLSTATUS_Henkan_Mode) != IMLSTATUS_Henkan_Mode) {
        sp->trigger_on = 0;
        return s->If->m->iml_make_end_conversion_inst(s);
    } else if (sp->trigger_on == 0 && (status & IMLSTATUS_Henkan_Mode) == IMLSTATUS_Henkan_Mode) {
        sp->trigger_on = 1;
        return s->If->m->iml_make_start_conversion_inst(s);
    }
    return (iml_inst*) NULL;
}

iml_inst *
XSunIMAdapter::make_preedit_draw_inst(
    iml_session_t * s
)
{
    int chg_first;
    int chg_length;
    int caret;
    int len;
    wchar_t *wcs = NULL;
    XIMFeedback *fbs = NULL;
    IMText *text;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
#ifdef	DEBUG
    printf(" XSunIMAdapter::make_preedit_draw_inst() sid=%d\n", sp->session_id);
#endif
    
    stub->getInt(&chg_first);
    stub->getInt(&chg_length);
    stub->getInt(&caret);
    stub->getInt(&len);
    
    if (len) {
        wcs = (wchar_t *) s->If->m->iml_new(s, (len + 1) * sizeof(wchar_t));
        fbs = (XIMFeedback *) s->If->m->iml_new(s, (len + 1) * sizeof(XIMFeedback));
        memset(wcs, 0, (len + 1) * sizeof(wchar_t));
        memset(fbs, 0, (len + 1) * sizeof(XIMFeedback));
        
        stub->getAny((void *) wcs, sizeof(wchar_t) * len);
        
#ifdef	notdef
        getmbs();
#endif
        
        stub->getAny((void *) fbs, sizeof(XIMFeedback) * len);
        
#ifdef	DEBUG
        printf("PREEDIT_DRAW [%ws] vs [%s]\n", wcs, mbs_str);
#endif
        
#ifdef  notdef
        text = (IMText *) Utility::CreateIMText(s, sp->encoding, mbs_str, fbs, mbs_len, len);
#else
        text = (IMText *) Utility::CreateIMTextFromWCS(s, wcs, fbs, len, sp->locale);
#endif
        return s->If->m->iml_make_preedit_draw_with_chgpos_inst(s, text, chg_first, chg_length, caret);
    } else if (chg_first || chg_length || caret) {
        return s->If->m->iml_make_preedit_draw_with_chgpos_inst(s, NULL, chg_first, chg_length, caret);
    }
    return NULL;
}

iml_inst *
XSunIMAdapter::make_status_draw_inst(
    iml_session_t * s
)
{
    IMText *text;
    int status_len;
    wchar_t *cws;
    iml_inst *lp = NULL;
    iml_inst *rv = NULL;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    
#ifdef	DEBUG
    printf(" XSunIMAdapter::make_status_draw_inst() sid=%d\n", sp->session_id);
#endif
    
    lp = s->If->m->iml_make_status_start_inst(s);
    s->If->m->iml_link_inst_tail(&rv, lp);
    
    stub->getInt(&status_len);
    cws = (wchar_t *) s->If->m->iml_new(s, (status_len + 1) * sizeof(wchar_t));
    memset(cws, 0, (status_len + 1) * sizeof(wchar_t));
    stub->getAny((void *) cws, sizeof(wchar_t) * status_len);
    
#ifdef	notdef
    getmbs();
#endif
    
#ifdef	DEBUG
    printf("STATUS_DRAW [%ws] vs [%s]\n", cws, mbs_str);
#endif
    
#ifdef  notdef
    text = (IMText *) Utility::CreateIMText(s, sp->encoding, mbs_str, 0, mbs_len, status_len);
#else
    text = (IMText *) Utility::CreateIMTextFromWCS(s, cws, NULL, status_len, sp->locale);
#endif
    
    if (text == NULL) {
        return NULL;
    }
    lp = s->If->m->iml_make_status_draw_inst(s, text);
    s->If->m->iml_link_inst_tail(&rv, lp);
    
    return rv;
}

iml_inst *
XSunIMAdapter::make_lookup_draw_inst(
    iml_session_t * s
)
{
    int i;
    int n_choices;
    int max_len;
    int index_of_first_candidate;
    int index_of_last_candidate;
    int labellen;
    int valuelen;
    int cur_index = 0;

    wchar_t **values;
    int *value_lens;
    int *label_lens;
    wchar_t **labels;

    wchar_t *title = 0;
    int titlelen;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    
#ifdef	DEBUG
    printf(" XSunIMAdapter::make_lookup_draw_inst() sid=%d\n", sp->session_id);
#endif
    
    stub->getInt(&n_choices);
    stub->getInt(&max_len);
    stub->getInt(&index_of_first_candidate);
    stub->getInt(&index_of_last_candidate);
    
    n_choices = index_of_last_candidate - index_of_first_candidate + 1;
    
#ifdef	DEBUG
    printf("n_choices=%d\n", n_choices);
    printf("max_len=%d\n", max_len);
    printf("index_of_first_candidate=%d\n", index_of_first_candidate);
    printf("index_of_last_candidate=%d\n", index_of_last_candidate);
#endif

    labels = (wchar_t**) s->If->m->iml_new(s, sizeof(wchar_t*) * n_choices);
    label_lens = (int *) s->If->m->iml_new(s, sizeof(int) * n_choices);
    values = (wchar_t**) s->If->m->iml_new(s, sizeof(wchar_t*) * n_choices);
    value_lens = (int *) s->If->m->iml_new(s, sizeof(int) * n_choices);
    
    for (i = 0; i < n_choices; i++) {
        wchar_t *label, *value;
        
        stub->getInt(&labellen);
        
        label = (wchar_t *) s->If->m->iml_new(s, sizeof(wchar_t) * (labellen + 1));
        memset(label, 0, sizeof(wchar_t) * (labellen + 1));
        stub->getAny((void *) label, sizeof(wchar_t) * labellen);
        label_lens[i] = labellen;
        labels[i] = label;
        
        stub->getInt(&valuelen);
        value = (wchar_t *) s->If->m->iml_new(s, sizeof(wchar_t) * (valuelen + 1));
        memset(value, 0, sizeof(wchar_t) * (valuelen + 1));
        stub->getAny((void *) value, sizeof(wchar_t) * valuelen);
        value_lens[i] = valuelen;
        values[i] = value;
    }
    
    stub->getInt(&titlelen);
    if (titlelen) {
        title = (wchar_t *) s->If->m->iml_new(s, sizeof(wchar_t) * (titlelen + 1));
        memset(title, 0, sizeof(wchar_t) * (titlelen + 1));
        stub->getAny((void *) title, sizeof(wchar_t) * titlelen);
    }

    stub->getInt(&cur_index);
    
    IMLookupDrawCallbackStruct *draw = (IMLookupDrawCallbackStruct *) s->If->m->iml_new(s, sizeof(IMLookupDrawCallbackStruct));
    draw->index_of_first_candidate = index_of_first_candidate;
    draw->index_of_last_candidate = index_of_last_candidate;
    draw->n_choices = n_choices;
    draw->max_len = max_len;
    draw->index_of_current_candidate = 0;
    draw->title = 0;
    
    draw->choices = (IMChoiceObject *) s->If->m->iml_new(s, draw->n_choices * sizeof(IMChoiceObject));
    
    for (i = 0; i < n_choices; i++) {
        draw->choices[i].value = (IMText *) Utility::CreateIMTextFromWCS(s, values[i], NULL, value_lens[i], sp->locale);
        draw->choices[i].label = (IMText *) Utility::CreateIMTextFromWCS(s, labels[i], NULL, label_lens[i], sp->locale);
    }
    
    if (titlelen) {
        draw->title = (IMText *) Utility::CreateIMTextFromWCS(s, title, NULL, titlelen, sp->locale);
    }
    draw->index_of_current_candidate = cur_index;
    
    return s->If->m->iml_make_lookup_draw_inst(s, draw);
}

iml_inst *
XSunIMAdapter::make_aux_draw_inst(
    iml_session_t * s
)
{
    int i;
    char *aux_name;
    int aux_name_len;
    int aux_index;
    int count_integer_values;
    int count_string_values;
    int *integer_values;
    VMSessionPrivate *sp = (VMSessionPrivate *) s->specific_data;
    
#ifdef	DEBUG
    printf(" XSunIMAdapter::make_aux_draw_inst() sid=%d\n", sp->session_id);
#endif
    
    stub->getInt(&aux_index);
    stub->getInt(&aux_name_len);
    
    aux_name = (char *) s->If->m->iml_new(s, aux_name_len + 1);
    memset(aux_name, 0, aux_name_len + 1);
    stub->getString(aux_name, aux_name_len);
    
    stub->getInt(&count_integer_values);
    if (count_integer_values) {
        integer_values = (int *) s->If->m->iml_new(s, sizeof(int) * (count_integer_values));
        stub->getAny(integer_values, sizeof(int) * count_integer_values);
    }
    stub->getInt(&count_string_values);
    
#ifdef	DEBUG
    printf("aux_name=[%s]\n", aux_name);
    printf("aux_name_len=%d\n", aux_name_len);
    printf("aux_index=[%d]\n", aux_index);
    printf("count_integer_values=[%d]\n", count_integer_values);
    for (i = 0; i < count_integer_values; i++) {
        printf("	integer_values[%d]=%d\n", i, integer_values[i]);
    }
    printf("count_string_values=[%d]\n", count_string_values);
#endif
    
    IMAuxDrawCallbackStruct *aux = (IMAuxDrawCallbackStruct *) s->If->m->iml_new(s, sizeof(IMAuxDrawCallbackStruct));

    /* Give a default engine name if the LE doesn't provide the name. */
    if(aux_name_len == 0) {
	aux->aux_name = (char *) s->If->m->iml_new(s, sizeof(char) * (strlen("aux_obj") + 1));
	strcpy(aux->aux_name, "aux_obj");
    } else {
	aux->aux_name = (char *) s->If->m->iml_new(s, sizeof(char) * (aux_name_len + 1));
	strcpy(aux->aux_name, aux_name);
    }
    aux->aux_index = aux_index;
    
    aux->count_integer_values = count_integer_values;
    aux->count_string_values = count_string_values;
    
    if (count_integer_values) {
        aux->integer_values = (int *) s->If->m->iml_new(s, sizeof(int) * count_integer_values);
        memset(aux->integer_values, 0, sizeof(int) * count_integer_values);
        for (i = 0; i < count_integer_values; i++) {
            aux->integer_values[i] = integer_values[i];
            
        }
    }
    if (count_string_values) {
        aux->string_values = (IMText *) s->If->m->iml_new(s, sizeof(IMText) * count_string_values);
        memset(aux->string_values, 0, sizeof(IMText) * count_string_values);
        
        for (i = 0; i < count_string_values; i++) {
            int len;
            IMText *lt = &aux->string_values[i];
            IMText *lts;
            wchar_t *wcs;
            
            stub->getInt(&len);
            
            wcs = (wchar_t *) s->If->m->iml_new(s, sizeof(wchar_t) * (len + 1));
            memset(wcs, 0, sizeof(wchar_t) * (len + 1));
            
            stub->getAny(wcs, sizeof(wchar_t) * len);
            
#ifdef	notdef
            getmbs();
#endif
            
#ifdef	DEBUG
            printf("AUX_DRAW [%ws] vs [%s]\n", wcs, mbs_str);
#endif
            
            XIMFeedback *cfb = (XIMFeedback *) s->If->m->iml_new(s, sizeof(XIMFeedback) * len);
            memset(cfb, 0, sizeof(XIMFeedback) * len);
            
#ifdef  notdef
            lts = (IMText *) Utility::CreateIMText(s, sp->encoding, mbs_str, cfb, mbs_len, len);
#else				/* notdef */
            lts = (IMText *) Utility::CreateIMTextFromWCS(s, wcs, cfb, len, sp->locale);
#endif				/* notdef */
            
            if (lts == NULL) {
                lts = (IMText *) s->If->m->iml_new(s, sizeof(IMText));
                memset(lts, 0, sizeof(IMText));
                lt->text.utf_chars = (UTFCHAR *) s->If->m->iml_new(s, sizeof(UTFCHAR) * 1);
                lt->text.utf_chars[0] = 0;
                lt->char_length = 0;
                lt->feedback = 0;
            } else {
                lt->text.utf_chars = lts->text.utf_chars;
                lt->char_length = lts->char_length;
                lt->feedback = lts->feedback;
            }
        }
    }
    return s->If->m->iml_make_aux_draw_inst(s, aux);
}

iml_session_t *
XSunIMAdapter::findSession(
    iml_session_t * s,
    int session_id
)
{
    iml_session_t *p = s->desktop->session_list;
    while (p) {
        VMSessionPrivate *sp = (VMSessionPrivate *) p->specific_data;
        if (sp->session_id == session_id) {
            return p;
        }
        if (p->next) {
            p = p->next;
        } else {
            break;
        }
    }
    return (iml_session_t *) 0;
}
