/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <X11/Intrinsic.h>
#include "XSunIMAdapter.hh"
#include "XSunIMManager.hh"

#include "LEHandler.hh"

#include "SystemMessage.h"

unsigned char *iml_args_addr;

XSUNIMManager::XSUNIMManager(Bool p_datarep_used_in_child)
{
    datarep_used_in_child=p_datarep_used_in_child;
}

void
XSUNIMManager::addRequestData(VMSignalData * request)
{
    drv_request_args = (VMSharedArgumentsArea) request->sh_request_args_addr;
    drv_reply_args = (VMSharedArgumentsArea) request->sh_reply_args_addr;
    datarep = new DataRep(drv_reply_args, drv_request_args);
    initAddress();
}

XSUNIMManager::~XSUNIMManager()
{
    /* if datarep is newed in parent process */
    if(datarep_used_in_child == False){
        delete datarep;
    }
}

void
XSUNIMManager::initAddress()
{
    memset(drv_reply_args, 0, ADP_REP_LEN);
    iml_args_addr = (unsigned char *) drv_reply_args;
    if (datarep) {
        datarep->setArgsArea(drv_reply_args, drv_request_args);
    } else {
        datarep = new DataRep(drv_reply_args, drv_request_args);
    }
}

int
XSUNIMManager::handleRequest(
    VMSignalData * request,
    VMSignalData * reply
)
{
    int sid = request->session_id;
    reply->type = XSUNIM_REPLY_NONE;
#ifdef	DEBUG
    printf("XSUNIMManager::handleRequest %d\n", sid);
#endif
    
    if (request->type == XSUNIM_OTEHR) {
        if (iml_args_addr - drv_reply_args > 0) {
            reply->type = XSUNIM_REPLY_EXECUTE;
        }
        return 0;
    }
    initAddress();
    switch (request->type) {
        case XSUNIM_OPEN_IF: OpenIF(reply); break;
        case XSUNIM_CLOSE_IF: CloseIF(reply); break;
        case XSUNIM_GET_IF_VALUE: GetIFValue(reply); break;
        case XSUNIM_SET_IF_VALUE: SetIFValue(reply); break;
        case XSUNIM_OPEN_DESKTOP: OpenDesktop(reply); break;
        case XSUNIM_CLOSE_DESKTOP: CloseDesktop(reply); break;
        case XSUNIM_CREATE_SC: CreateSC(reply); break;
        case XSUNIM_DESTROY_SC: DestroySC(sid, reply); break;
        case XSUNIM_POST_DESTROY_SC: PostDestroySC(sid, reply); break;
        case XSUNIM_SET_SC_VALUE: SetSCValue(sid, reply); break;
        case XSUNIM_GET_SC_VALUE: GetSCValue(sid, reply); break;
        case XSUNIM_RESET_SC: ResetSC(sid, reply); break;
        case XSUNIM_SET_SC_FOCUS: SetSCFocus(sid, reply); break;
        case XSUNIM_UNSET_SC_FOCUS: UnsetSCFocus(sid, reply); break;
        case XSUNIM_SEND_EVENT: SendEvent(sid, reply); break;
        case XSUNIM_FILTER_EVENT: FilterEvent(sid, reply); break;
        case XSUNIM_SET_AUX_VALUE: SetAuxValues(sid, reply); break;
        default:
            system_message(MSG_ERROR, "sid = %d invalid type = %d\n", sid, request->type);
/*            fprintf(stderr, "sid = %d invalid type = %d\n", sid, request->type); */
            break;
        }
    
    /* any iml_inst to execute ? */
    if (iml_args_addr - drv_reply_args > 0) {
        reply->type = XSUNIM_REPLY_EXECUTE;
        putEnd();
    }
    return 0;
}

void
XSUNIMManager::OpenIF(
    VMSignalData * reply
)
{
    int len;
    char *locale;
    char *ifname;
    
    datarep->getInt(&len);
    locale = new char[len + 1];
    datarep->getString(locale, len);
    locale[len] = '\0';
    
    datarep->getInt(&len);
    ifname = new char[len + 1];
    datarep->getString(ifname, len);
    ifname[len] = '\0';
    
    lehandler = (LEHandler *) new LEHandler(locale, ifname);

    delete [] locale;
    delete [] ifname;

    if(lehandler->is_active() == False){
	reply->type = XSUNIM_REPLY_FAIL;
    }
    
    if(lehandler->OpenIF() == False){
	reply->type = XSUNIM_REPLY_FAIL;
    }
}

void
XSUNIMManager::CloseIF(
    VMSignalData * reply
)
{
    lehandler->CloseIF();
    delete lehandler;
}

void
XSUNIMManager::GetIFValue(
    VMSignalData * reply
)
{
}

void
XSUNIMManager::SetIFValue(
    VMSignalData * reply
)
{
}

void
XSUNIMManager::OpenDesktop(
    VMSignalData * reply
)
{
    lehandler->OpenDesktop();
}

void
XSUNIMManager::CloseDesktop(
    VMSignalData * reply
)
{
    lehandler->CloseDesktop();
}

void
XSUNIMManager::CreateSC(
    VMSignalData * reply
)
{
    int len;
    char *username;
    
    datarep->getInt(&len);
    username = new char[len + 1];
    datarep->getString(username, len);
    username[len] = '\0';
    
    lehandler->CreateSC(reply, username);
    
    delete [] username;
}

void
XSUNIMManager::DestroySC(
    int sid,
    VMSignalData * reply
)
{
    lehandler->DestroySC(reply, sid);
}

void
XSUNIMManager::PostDestroySC(
    int sid,
    VMSignalData * reply
)
{
    lehandler->PostDestroySC(reply, sid);
}

void
XSUNIMManager::SetSCValue(
    int sid,
    VMSignalData * reply
)
{
    int argid, value;
    
    datarep->getInt(&argid);
    datarep->getInt(&value);
    
    lehandler->SetSCValue(reply, sid, argid, (void *) value);
}

void
XSUNIMManager::GetSCValue(
    int sid,
    VMSignalData * reply
)
{
}

void
XSUNIMManager::ResetSC(
    int sid,
    VMSignalData * reply
)
{
    lehandler->ResetSC(reply, sid);
}

void
XSUNIMManager::SetSCFocus(
    int sid,
    VMSignalData * reply
)
{
    lehandler->SetSCFocus(reply, sid);
}

void
XSUNIMManager::UnsetSCFocus(
    int sid,
    VMSignalData * reply
)
{
    lehandler->UnsetSCFocus(reply, sid);
}

void
XSUNIMManager::SendEvent(
    int sid,
    VMSignalData * reply
)
{
    int modifier, keycode, keychar;
    
    datarep->getInt(&modifier);
    datarep->getInt(&keycode);
    datarep->getInt(&keychar);
    
    lehandler->SendEvent(reply, sid, keycode, keychar, modifier);
}

void
XSUNIMManager::FilterEvent(
    int sid,
    VMSignalData * reply
)
{
    XEvent xev;
    datarep->getAny(&xev, sizeof(XEvent));
    lehandler->FilterEvent(reply, sid, &xev);
}

void
XSUNIMManager::SetAuxValues(
    int sid,
    VMSignalData * reply
)
{
    int i, len;
    int engine_name_len;
    int engine_class_index;
    int count_integer_values;
    int count_string_values;
    int *integer_values = (int *) 0;
    char *engine_name = (char *) 0;
    char **string_values;
    
    datarep->getInt(&engine_name_len);
    engine_name = new char[engine_name_len + 1];
    datarep->getString(engine_name, engine_name_len);
    engine_name[engine_name_len] = '\0';
    
    datarep->getInt(&engine_class_index);
    datarep->getInt(&count_integer_values);
    if (count_integer_values) {
        integer_values = new int[count_integer_values];
        datarep->getAny((void *) integer_values, sizeof(int) * count_integer_values);
    }
    datarep->getInt(&count_string_values);
    if (count_string_values) {
        string_values = new char *[count_string_values];
        for (i = 0; i < count_string_values; i++) {
            datarep->getInt(&len);
            string_values[i] = new char[len + 1];
            memset(string_values[i], 0, len + 1);
            if (len == 0) {
                strcpy(string_values[i], "");
            } else {
                datarep->getString(string_values[i], len);
            }
        }
    }
    lehandler->SetAuxValues(reply, sid,
        engine_name,
        engine_class_index,
        count_integer_values,
        integer_values,
        count_string_values,
        string_values);
    
    delete [] engine_name;
    delete [] integer_values;
    
    for (i = 0; i < count_string_values; i++) {
        delete [] string_values[i];
    }
    
    delete [] string_values;
}

void
XSUNIMManager::putEnd()
{
    int end_flag = XSUNIM_END_IML;
    bcopy(&end_flag, iml_args_addr, sizeof(int));
    
    iml_args_addr = (unsigned char *) drv_reply_args;
}
