/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdio.h>
#include "XSunIMAdapter.hh"

static Bool if_xadp_OpenIF(iml_if_t *);
static Bool if_xadp_CloseIF(iml_if_t *);
static Bool if_xadp_GetIFValue(iml_if_t *, IMArgList, int);
static Bool if_xadp_SetIFValue(iml_if_t *, IMArgList, int);
static Bool if_xadp_OpenDesktop(iml_desktop_t *, IMArgList, int);
static Bool if_xadp_CloseDesktop(iml_desktop_t *);
static Bool if_xadp_CreateSC(iml_session_t *, IMArgList, int);
static Bool if_xadp_DestroySC(iml_session_t *);
static Bool if_xadp_GetSCValue(iml_session_t *, IMArgList, int);
static Bool if_xadp_SetSCValue(iml_session_t *, IMArgList, int);
static IMText *if_xadp_ResetSC(iml_session_t *);
static void if_xadp_SetSCFocus(iml_session_t *);
static void if_xadp_UnsetSCFocus(iml_session_t *);
static void if_xadp_SendEvent(iml_session_t *, IMInputEvent * ev);

static XSunIMAdapter *adapter = NULL;

extern "C" {
if_methods_t xsunim_methods = {
    if_xadp_OpenIF,
    if_xadp_CloseIF,
    if_xadp_GetIFValue,
    if_xadp_SetIFValue,
    if_xadp_OpenDesktop,
    if_xadp_CloseDesktop,
    if_xadp_CreateSC,
    if_xadp_DestroySC,
    if_xadp_GetSCValue,
    if_xadp_SetSCValue,
    if_xadp_ResetSC,
    if_xadp_SetSCFocus,
    if_xadp_UnsetSCFocus,
    if_xadp_SendEvent,
};
}

static Bool
if_xadp_OpenIF(
    iml_if_t * If
)
{
#ifdef	DEBUG
    printf("if_xadp_OpenIF\n");
#endif
    if (!adapter) {
        adapter = new XSunIMAdapter();
    }
    if ((adapter->OpenIF(If)) == False) {
        return False;
    }
    return True;
}

static Bool
if_xadp_CloseIF(
    iml_if_t * If
)
{
    if (!adapter) {
	return True;
    }
    if (adapter->CloseIF(If) == 0) {
	if(adapter) {
	    delete adapter;
	}
	adapter = 0;
    }
    return True;
}

static Bool
if_xadp_GetIFValue(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf(" if_xadp_GetIFValue. \n");
    adapter->GetIFValue(If, args, num_args);
#endif
    return True;
}

static Bool
if_xadp_SetIFValue(
    iml_if_t * If,
    IMArgList arg,
    int n_args
)
{
#ifdef	DEBUG
    printf(" if_xadp_SetIFValue. \n");
#endif
    return True;
}

static Bool
if_xadp_OpenDesktop(
    iml_desktop_t * desktop,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf(" if_xadp_OpenDesktop. \n");
#endif
    if (!adapter) {
	return True;
    }
    adapter->OpenDesktop(desktop);
    return True;
}

static Bool
if_xadp_CloseDesktop(
    iml_desktop_t * desktop
)
{
#ifdef	DEBUG
    printf(" if_xadp_CloseDesktop. \n");
#endif
    if (!adapter) {
	return True;
    }
    adapter->CloseDesktop(desktop);
    return True;
}

static Bool
if_xadp_CreateSC(
    iml_session_t *session,
    IMArgList args,
    int n_args
)
{
#ifdef	DEBUG
    printf(" if_xadp_CreateSC. \n");
#endif
    if (!adapter) {
	return 0;
    }
    return adapter->CreateSC(session, args, n_args);
}

static Bool
if_xadp_DestroySC(
    iml_session_t * session
)
{
#ifdef	DEBUG
    printf(" if_xadp_DestroySC. \n");
#endif
    if (!adapter) {
	return 0;
    }
    adapter->DestroySC(session);
    return True;
}

static Bool
if_xadp_SetSCValue(
    iml_session_t * session,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf(" if_xadp_SetSCValue. \n");
#endif
    if (!adapter) {
	return True;
    }
    adapter->SetSCValue(session, args, num_args);
    return True;
}

static Bool
if_xadp_GetSCValue(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
#ifdef	DEBUG
    printf(" if_xadp_GetSCValue. \n");
#endif
    return True;
}

static IMText *
if_xadp_ResetSC(
    iml_session_t * session
)
{
#ifdef	DEBUG
    printf(" if_xadp_ResetSC. \n");
#endif
    if (!adapter) {
	return NULL;
    }
    adapter->ResetSC(session);
    return NULL;
}

static void
if_xadp_SetSCFocus(
    iml_session_t * session
)
{
#ifdef	DEBUG
    printf(" if_xadp_SetSCFocus. \n");
#endif
    if (!adapter) {
	return;
    }

    /* if False, call OpenIF() and CreateSC() again here */
    if (adapter->SetSCFocus(session) == False) {
      adapter->CloseIF(session->If);
      if ((adapter->OpenIF(session->If)) == True) {
         if (adapter->CreateSC(session, 0, 0) == True) {
            IMArg args[1];
            IMSetArg(args[0], SC_REALIZE, 0);
            adapter->SetSCValue(session, args, 1);
            adapter->SetSCFocus(session);
         }
      }
    }
}

static void
if_xadp_UnsetSCFocus(
    iml_session_t * session
)
{
#ifdef	DEBUG
    printf(" if_xadp_UnsetSCFocus. \n");
#endif
    if (!adapter) {
	return;
    }

    /* if False, call OpenIF() and CreateSC() again here */
    if (adapter->SetSCFocus(session) == False) {
      adapter->CloseIF(session->If);
      if ((adapter->OpenIF(session->If)) == True) {
         if (adapter->CreateSC(session, 0, 0) == True) {
            IMArg args[1];
            IMSetArg(args[0], SC_REALIZE, 0);
            adapter->SetSCValue(session, args, 1);
            adapter->UnsetSCFocus(session);
         }
      }
    }
}

static void
if_xadp_SendEvent(
    iml_session_t * session,
    IMInputEvent * event
)
{
#ifdef	DEBUG
    printf(" if_xadp_SendEvent. \n");
#endif
    if (!adapter) {
	return;
    }

    /* if False, call OpenIF() and CreateSC() again here */
    if (adapter->SendEvent(session, event) == False) {
      adapter->CloseIF(session->If);
      if ((adapter->OpenIF(session->If)) == True) {
         if (adapter->CreateSC(session, 0, 0) == True) {
            IMArg args[1];
            IMSetArg(args[0], SC_REALIZE, 0);
            adapter->SetSCValue(session, args, 1);
            adapter->SetSCFocus(session);
         }
      }
    }
}
