/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <libintl.h>
#include <locale.h>
#include <unistd.h>
#include <pwd.h>
#include <syslog.h>
#include "SystemMessage.h"

#define HTT_TEXT_DOMAIN	"SUNW_HTT_MSG"


static void	use_syslog_setup(int);
static void	msg_locale_setup(const char *);
static char *	locale_change();
static void	locale_unchange(char *);

static char *	my_name;
static int	use_syslog;
static char *	msg_locale;


#if defined(sun)

#define WEAK_SYMBOL	static
#pragma weak system_message_init	= _system_message_init
#pragma weak system_message_destroy	= _system_message_destroy
#pragma weak system_message		= _system_message
#pragma weak system_message_error	= _system_message_error

#else /* !sun */

#define WEAK_SYMBOL
#define _system_message_init		system_message_init
#define _system_message_destroy		system_message_destroy
#define _system_message			system_message
#define _system_message_error		system_message_error

#endif /* !sun */


WEAK_SYMBOL void
_system_message_init(
	const char *	name,
	int		opt_syslog,
	const char *	opt_locale) {

	system_message_destroy();

	my_name = strdup(name);

	use_syslog = 0;
	use_syslog_setup(opt_syslog);

	msg_locale = NULL;
	msg_locale_setup(opt_locale);

	return;
}


WEAK_SYMBOL void
_system_message_destroy(void) {
	free(my_name);
	free(msg_locale);

	return;
}


static void
use_syslog_setup(int b) {
	uid_t		uid;
	struct passwd	pwd;
	struct passwd *	ppwd;
	char		buffer[4096];

	use_syslog = ((0 == b) ? 0 : 1);

	if (0 == use_syslog) {
		return;
	}

	uid = getuid();

	if ((0 != uid) && (1 != uid)) {
		ppwd = getpwuid_r(uid, &pwd, buffer, sizeof (buffer));
		endpwent();

		if ((NULL == ppwd) || (0 != strcmp(ppwd->pw_name, "nobody"))) {
			use_syslog = 0;
		}
	}

	return;
}


static void
msg_locale_setup(const char * lc) {
	char *	p;
	if ((0 != use_syslog) && ((NULL == lc) || ('\0' == *lc))) {
		return;
	}

	if (NULL == lc) {
		lc = setlocale(LC_MESSAGES, NULL);
		if (NULL == lc) {
			return;
		}
	}

	if (NULL != msg_locale) {
		if (0 == strcmp(msg_locale, lc)) {
			return;
		}
	}

	if (NULL == (p = strdup(lc))) {
		return;
	}

	free(msg_locale);
	msg_locale = p;
	return;
}


static char *
locale_change() {
	char *	locale_cur;
	if (NULL == msg_locale) {
		locale_cur = NULL;
	} else {
		locale_cur = setlocale(LC_MESSAGES, NULL);

		if (NULL == locale_cur) {
			;
		} else if (0 == strcmp(msg_locale, locale_cur)) {
			locale_cur = NULL;
		} else {
			locale_cur = strdup(locale_cur);
			setlocale(LC_MESSAGES, msg_locale);
		}
	}
	return locale_cur;
}


static void
locale_unchange(char * lc) {
	if (NULL != lc) {
		setlocale(LC_MESSAGES, lc);
		free(lc);
	}
	return;
}


WEAK_SYMBOL void
_system_message(int log_priority, const char * msgid, ...) {
	int	priority;
	char *	format;
	char *	locale_cur;

	va_list		ap;
	va_start(ap, msgid);

	locale_cur = locale_change();

	format = dgettext(HTT_TEXT_DOMAIN, msgid);

	if (0 == use_syslog) {
		(void)vfprintf(stderr, format, ap);
	} else {
		char	buffer[BUFSIZ];
		buffer[0] = '\0';
		vsnprintf(buffer, sizeof (buffer), format, ap);
		buffer[(sizeof (buffer)) - 1] = '\0';

		switch (log_priority) {
		case MSG_EMERGENCY:
			priority = LOG_EMERG;
			break;
		case MSG_ALERT:
			priority = LOG_ALERT;
			break;
		case MSG_CRITICAL:
			priority = LOG_CRIT;
			break;
		case MSG_ERROR:
			priority = LOG_ERR;
			break;
		case MSG_WARNING:
			priority = LOG_WARNING;
			break;
		case MSG_NOTICE:
			priority = LOG_NOTICE;
			break;
		case MSG_INFORMATIONAL:
			priority = LOG_INFO;
			break;
		case MSG_DEBUG:
			priority = LOG_DEBUG;
			break;
		default:
			priority = log_priority;
			break;
		}

		openlog(my_name, (LOG_PID | LOG_CONS | LOG_NOWAIT), LOG_DAEMON);
		syslog(priority, buffer);
		closelog();
	}

	locale_unchange(locale_cur);

	va_end(ap);

	return;
}

WEAK_SYMBOL void
_system_message_error(int log_priority, const char * msgid, int en) {
	char *	lc;
	char *	mi;
	char *	me;

	lc = locale_change();
	mi = dgettext(HTT_TEXT_DOMAIN, msgid);
	me = strerror(en);
	locale_unchange(lc);

	system_message(log_priority, "%s: %s\n", mi, me);

	return;
}
